/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.functions;

import de.gsi.math.TMath;
import de.gsi.math.functions.AbstractFunction1D;
import de.gsi.math.functions.Function1D;

public class TruncatedGaussianFunction
extends AbstractFunction1D
implements Function1D {
    public TruncatedGaussianFunction(String name, double[] parameter) {
        super(name, new double[4]);
        this.setParameterName(0, "mean");
        this.setParameterValue(0, 0.0);
        this.setParameterName(1, "sigma");
        this.setParameterValue(1, 1.0);
        this.setParameterName(2, "scaling");
        this.setParameterValue(2, 1.0);
        this.setParameterName(3, "truncation");
        this.setParameterValue(3, 2.0);
        if (parameter == null) {
            return;
        }
        for (int i = 0; i < Math.min(parameter.length, 4); ++i) {
            this.setParameterValue(i, parameter[0]);
        }
    }

    public TruncatedGaussianFunction(String name) {
        this(name, null);
    }

    @Override
    public double getValue(double x) {
        if (Math.abs(x - this.fparameter[0]) < this.fparameter[3] * this.fparameter[1]) {
            return this.fparameter[2] * TMath.Gauss(x, this.fparameter[0], this.fparameter[1], true);
        }
        return 0.0;
    }
}

