/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.functions;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.spi.DefaultErrorDataSet;
import de.gsi.math.functions.Function;
import java.security.InvalidParameterException;

public interface Function1D
extends Function {
    public double getValue(double var1);

    default public double[] getValues(double[] x) {
        if (x == null) {
            throw new IllegalArgumentException("x array argument is null");
        }
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = this.getValue(x[i]);
        }
        return y;
    }

    default public DataSet getDataSetEstimate(double[] xValues) {
        return new DefaultErrorDataSet(this.getName(), xValues, this.getValues(xValues), new double[xValues.length], new double[xValues.length], xValues.length, true);
    }

    default public DataSet getDataSetEstimate(double xmin, double xmax, int nsamples) {
        if (xmin > xmax || nsamples <= 0) {
            throw new InvalidParameterException("AbstractFunciton1D::getDataSetEstimate(" + xmin + "," + xmax + "," + nsamples + ") - invalid range");
        }
        double[] xValues = new double[nsamples];
        double step = (xmax - xmin) / (double)nsamples;
        for (int i = 0; i < nsamples; ++i) {
            xValues[i] = xmin + (double)i * step;
        }
        return this.getDataSetEstimate(xValues);
    }
}

