/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.functions;

import de.gsi.dataset.spi.utils.DoublePoint;
import de.gsi.math.functions.AbstractFunction;
import de.gsi.math.functions.FunctionND;
import java.util.ArrayList;
import java.util.List;

public class EllipseFunction
extends AbstractFunction
implements FunctionND {
    public EllipseFunction(String name, int nparm) {
        super(name, nparm);
    }

    @Override
    public double getValue(double[] x, int i) {
        return 0.0;
    }

    @Override
    public double[] getValue(double[] x) {
        throw new IllegalArgumentException("not implemented");
    }

    @Override
    public int getInputDimension() {
        return 1;
    }

    @Override
    public int getOutputDimension() {
        return 2;
    }

    @Override
    public String getID() {
        return "EllipseFunction@+" + System.currentTimeMillis();
    }

    public static List<DoublePoint> calculateEllipse(double centerX, double centerY, double halfAxisA, double halfAxisB, double angle, double steps) {
        int dsteps = steps == 0.0 ? 11 : (int)(360.0 / steps);
        ArrayList<DoublePoint> points = new ArrayList<DoublePoint>();
        double beta = -angle * (Math.PI / 180);
        double sinbeta = Math.sin(beta);
        double cosbeta = Math.cos(beta);
        for (int i = 0; i < 360; i += dsteps) {
            double alpha = (double)i * (Math.PI / 180);
            double sinalpha = Math.sin(alpha);
            double cosalpha = Math.cos(alpha);
            double posX = centerX + (halfAxisA * cosalpha * cosbeta - halfAxisB * sinalpha * sinbeta);
            double posY = centerY + (halfAxisA * cosalpha * sinbeta + halfAxisB * sinalpha * cosbeta);
            points.add(new DoublePoint(Double.valueOf(posX), Double.valueOf(posY)));
        }
        return points;
    }
}

