/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.functions;

import de.gsi.math.functions.AbstractFunction;
import de.gsi.math.functions.FunctionND;
import java.security.InvalidParameterException;

public abstract class AbstractFunctionND
extends AbstractFunction
implements FunctionND {
    private boolean computeErrorEstimate = false;

    public AbstractFunctionND(String name, int nparm) {
        this(name, new double[nparm], new String[nparm]);
    }

    public AbstractFunctionND(String name, double[] parameter) {
        this(name, parameter, new String[parameter.length]);
    }

    public AbstractFunctionND(String name, double[] parameters, String[] parameterNames) {
        super(name, parameters, parameterNames);
    }

    public void setErrorEstimateComputation(boolean state) {
        this.computeErrorEstimate = true;
    }

    public boolean isErrorEstimateComputed() {
        return this.computeErrorEstimate;
    }

    @Override
    public double[] getValue(double[] x) {
        if (x == null) {
            throw new InvalidParameterException("getValue(double[], null, int) - input vector is null");
        }
        if (x.length == this.getInputDimension()) {
            throw new InvalidParameterException("getValue(double[], double[][], int) - input vector dimension mismatch " + x.length + " vs. " + this.getInputDimension());
        }
        int dim = this.getOutputDimension();
        double[] ret = new double[dim];
        for (int k = 0; k < dim; ++k) {
            ret[k] = this.getValue(x, k);
        }
        return ret;
    }
}

