/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.functions;

import de.gsi.math.functions.Function;
import de.gsi.math.utils.UpdateListener;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Vector;

public abstract class AbstractFunction
implements Function {
    private String funcName = "none";
    private int fnbOfParameter = -1;
    protected double[] fparameter = null;
    protected double[] fparameterMin = null;
    protected double[] fparameterMax = null;
    protected double[] fparameterCopy = null;
    protected boolean[] fparameterFixed = null;
    protected String[] fparameterName = null;
    protected boolean isFitterMode = false;
    private final Vector<UpdateListener> flistener = new Vector();
    private static Vector<Function> fallFunctions = new Vector();
    private final long fcreationTime = System.currentTimeMillis();

    public AbstractFunction(String name, int nparm) {
        this(name, new double[nparm], new String[nparm]);
    }

    public AbstractFunction(String name, double[] parameter) {
        this(name, parameter, new String[parameter.length]);
    }

    public AbstractFunction(String name, double[] parameters, String[] parameterNames) {
        if (name == null) {
            throw new InvalidParameterException("AbstractFunction(String, double[], double[]) - function name is null");
        }
        if (parameters == null) {
            throw new InvalidParameterException("AbstractFunction(" + name + ", double[], String[]) - parameter array is null");
        }
        if (parameterNames == null) {
            throw new InvalidParameterException("AbstractFunction(" + name + ", double[], String[]) - parameter name array is null");
        }
        if (parameterNames.length != parameters.length) {
            throw new InvalidParameterException("AbstractFunction(" + name + ", double[], String[]) - parameter vs. name array dimension mismatch ( " + parameters.length + " vs. " + this.fparameterName.length + ")");
        }
        this.fnbOfParameter = parameters.length;
        this.funcName = name;
        this.reinitialise();
        this.fparameter = parameters;
        this.fparameterName = parameterNames;
        this.addFunction(this);
    }

    private void reinitialise() {
        if (this.fparameter != null && this.fnbOfParameter == this.fparameter.length) {
            return;
        }
        if (this.fparameter != null) {
            this.fparameter = Arrays.copyOf(this.fparameter, this.fnbOfParameter);
            this.fparameterMin = Arrays.copyOf(this.fparameterMin, this.fnbOfParameter);
            this.fparameterMax = Arrays.copyOf(this.fparameterMax, this.fnbOfParameter);
            this.fparameterCopy = Arrays.copyOf(this.fparameterCopy, this.fnbOfParameter);
            this.fparameterFixed = Arrays.copyOf(this.fparameterFixed, this.fnbOfParameter);
            String[] oldParmeterNames = this.fparameterName;
            this.fparameterName = new String[this.fnbOfParameter];
            for (int i = 0; i < this.fnbOfParameter; ++i) {
                this.fparameterName[i] = i < oldParmeterNames.length ? oldParmeterNames[i] : "arg" + i;
            }
        } else {
            this.fparameter = new double[this.fnbOfParameter];
            this.fparameterMin = new double[this.fnbOfParameter];
            this.fparameterMax = new double[this.fnbOfParameter];
            this.fparameterCopy = new double[this.fnbOfParameter];
            this.fparameterName = new String[this.fnbOfParameter];
            this.fparameterFixed = new boolean[this.fnbOfParameter];
            for (int i = 0; i < this.fnbOfParameter; ++i) {
                this.fparameterName[i] = "arg" + i;
            }
        }
    }

    @Override
    public String getName() {
        return this.funcName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunction(Function object) {
        Vector<Function> vector = fallFunctions;
        synchronized (vector) {
            if (fallFunctions.indexOf(object) < 0) {
                fallFunctions.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunction(Function object) {
        Vector<Function> vector = fallFunctions;
        synchronized (vector) {
            if (fallFunctions.indexOf(object) >= 0) {
                fallFunctions.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function[] getFunctions() {
        Vector<Function> vector = fallFunctions;
        synchronized (vector) {
            if (!fallFunctions.isEmpty()) {
                return fallFunctions.toArray(new Function[0]);
            }
        }
        return new Function[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UpdateListener object) {
        Vector<UpdateListener> vector = this.flistener;
        synchronized (vector) {
            if (this.flistener.indexOf(object) < 0) {
                this.flistener.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(UpdateListener object) {
        Vector<UpdateListener> vector = this.flistener;
        synchronized (vector) {
            if (this.flistener.indexOf(object) >= 0) {
                this.flistener.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeListener() {
        Vector<UpdateListener> vector = this.flistener;
        synchronized (vector) {
            ListIterator<UpdateListener> flist = this.flistener.listIterator();
            while (flist.hasNext()) {
                ((UpdateListener)flist.next()).Update(this);
            }
        }
    }

    @Override
    public void setParameterCount(int count) {
        if (this.fnbOfParameter == count || count < 0) {
            return;
        }
        this.fnbOfParameter = count;
        this.reinitialise();
    }

    @Override
    public int getParameterCount() {
        return this.fnbOfParameter;
    }

    @Override
    public int getFreeParameterCount() {
        int nDim = 0;
        for (int i = 0; i < this.fnbOfParameter; ++i) {
            if (this.isParameterFixed(i)) continue;
            ++nDim;
        }
        return nDim;
    }

    @Override
    public boolean isParameterFixed(int id) {
        if (id >= 0 || id <= this.fnbOfParameter) {
            return this.fparameterFixed[id];
        }
        throw new InvalidParameterException("AbstractFunction::isParameterFixed(" + id + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
    }

    @Override
    public void fixParameter(int id, boolean state) {
        if (id < 0 && id > this.fnbOfParameter) {
            throw new InvalidParameterException("AbstractFunction::fixParameter(" + id + "," + state + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
        }
        this.fparameterFixed[id] = state;
    }

    @Override
    public String getParameterName(int id) {
        if (id >= 0 || id <= this.fnbOfParameter) {
            return this.fparameterName[id];
        }
        throw new InvalidParameterException("AbstractFunction::GetParameterName(" + id + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
    }

    @Override
    public void setParameterRange(int id, double minRange, double maxRange) {
        if (id < 0 || id >= this.fnbOfParameter) {
            throw new InvalidParameterException("AbstractFunction::setParameterRangeMaximum(" + id + "," + minRange + "," + maxRange + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
        }
        this.fparameterMin[id] = minRange;
        this.fparameterMax[id] = maxRange;
    }

    @Override
    public double getParameterRangeMaximum(int id) {
        if (id < 0 || id >= this.fnbOfParameter) {
            throw new InvalidParameterException("AbstractFunction::getParameterRangeMaximum(" + id + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
        }
        return this.fparameterMax[id];
    }

    @Override
    public double getParameterRangeMinimum(int id) {
        if (id < 0 || id >= this.fnbOfParameter) {
            throw new InvalidParameterException("AbstractFunction::getParameterRangeMinimum(" + id + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
        }
        return this.fparameterMin[id];
    }

    @Override
    public void setParameterValue(int id, double value) {
        if (id < 0 && id > this.fnbOfParameter) {
            throw new InvalidParameterException("AbstractFunction::setParameterValue(" + id + "," + value + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
        }
        this.fparameter[id] = value;
    }

    @Override
    public void setParameterValues(double[] value) {
        if (value.length <= this.fnbOfParameter) {
            for (int i = 0; i < Math.min(value.length, this.fnbOfParameter); ++i) {
                this.fparameter[i] = value[i];
            }
        } else {
            throw new InvalidParameterException("AbstractFunction::setParameterValue(" + value.length + "," + Arrays.toString(value) + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
        }
    }

    @Override
    public void clearParameterValues() {
        for (int i = 0; i < this.fparameter.length; ++i) {
            if (this.isParameterFixed(i)) continue;
            this.fparameter[i] = 0.0;
        }
    }

    @Override
    public double getParameterValue(int id) {
        if (id >= 0 || id <= this.fnbOfParameter) {
            return this.fparameter[id];
        }
        throw new InvalidParameterException("AbstractFunction::getParameterValue(" + id + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
    }

    public double[] getParameterValues() {
        return this.fparameter;
    }

    @Override
    public boolean isFitterMode() {
        return this.isFitterMode;
    }

    @Override
    public void setFitterMode(boolean state) {
        if (this.isFitterMode == state) {
            throw new InvalidParameterException("AbstractFunction::setFitterMode(" + state + ") - funciton is already in this mode");
        }
        this.isFitterMode = state;
        if (this.isFitterMode) {
            this.fparameterCopy = Arrays.copyOf(this.fparameter, this.fparameter.length);
        } else {
            this.fparameter = Arrays.copyOf(this.fparameterCopy, this.fparameterCopy.length);
        }
    }

    @Override
    public void setParameterName(int id, String paramName) {
        if (id < 0 && id > this.fnbOfParameter) {
            throw new InvalidParameterException("AbstractFunction::setParameterName(" + id + "," + paramName + "): invalid parameter index [0," + (this.fnbOfParameter - 1) + "}");
        }
        this.fparameterName[id] = paramName;
    }

    public void printParameters() {
        this.printParameters(false);
    }

    public void printParameters(boolean fullDebug) {
        System.out.printf("AbstractFunction - function name: %s\n", this.getName());
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (!fullDebug) {
                System.out.printf("Parameter %2d: %-20s = %f\n", i, this.getParameterName(i), this.getParameterValue(i));
                continue;
            }
            System.out.printf("Parameter %2d: %-20s = %f \t [%f, %f]\n", i, this.getParameterName(i), this.getParameterValue(i), this.getParameterRangeMinimum(i), this.getParameterRangeMaximum(i));
        }
    }

    @Override
    public String getID() {
        return this.getName() + this.fcreationTime;
    }
}

