/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.filter.iir;

import de.gsi.math.filter.iir.LayoutBase;
import de.gsi.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public class HighPassTransform {
    double f;

    public HighPassTransform(double fc, LayoutBase digital, LayoutBase analog) {
        digital.reset();
        this.f = 1.0 / Math.tan(Math.PI * fc);
        int numPoles = analog.getNumPoles();
        int pairs = numPoles / 2;
        for (int i = 0; i < pairs; ++i) {
            PoleZeroPair pair = analog.getPair(i);
            digital.addPoleZeroConjugatePairs(this.transform(pair.poles.first), this.transform(pair.zeros.first));
        }
        if ((numPoles & 1) == 1) {
            PoleZeroPair pair = analog.getPair(pairs);
            digital.add(this.transform(pair.poles.first), this.transform(pair.zeros.first));
        }
        digital.setNormal(Math.PI - analog.getNormalW(), analog.getNormalGain());
    }

    private Complex transform(Complex c) {
        if (c.isInfinite()) {
            return new Complex(1.0, 0.0);
        }
        c = c.multiply(this.f);
        return new Complex(-1.0).multiply(new Complex(1.0).add(c)).divide(new Complex(1.0).subtract(c));
    }
}

