/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.filter.iir;

import de.gsi.math.filter.iir.ComplexPair;
import de.gsi.math.filter.iir.LayoutBase;
import de.gsi.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public class BandStopTransform {
    private double wc;
    private double wc2;
    private final double a;
    private final double b;

    public BandStopTransform(double fc, double fw, LayoutBase digital, LayoutBase analog) {
        digital.reset();
        double ww = Math.PI * 2 * fw;
        this.wc2 = Math.PI * 2 * fc - ww / 2.0;
        this.wc = this.wc2 + ww;
        if (this.wc2 < 1.0E-8) {
            this.wc2 = 1.0E-8;
        }
        if (this.wc > 3.141592643589793) {
            this.wc = 3.141592643589793;
        }
        this.a = Math.cos((this.wc + this.wc2) * 0.5) / Math.cos((this.wc - this.wc2) * 0.5);
        this.b = Math.tan((this.wc - this.wc2) * 0.5);
        int numPoles = analog.getNumPoles();
        int pairs = numPoles / 2;
        for (int i = 0; i < pairs; ++i) {
            PoleZeroPair pair = analog.getPair(i);
            ComplexPair p = this.transform(pair.poles.first);
            ComplexPair z = this.transform(pair.zeros.first);
            digital.addPoleZeroConjugatePairs(p.first, z.first);
            digital.addPoleZeroConjugatePairs(p.second, z.second);
        }
        if ((numPoles & 1) == 1) {
            ComplexPair poles = this.transform(analog.getPair((int)pairs).poles.first);
            ComplexPair zeros = this.transform(analog.getPair((int)pairs).zeros.first);
            digital.add(poles, zeros);
        }
        if (fc < 0.25) {
            digital.setNormal(Math.PI, analog.getNormalGain());
        } else {
            digital.setNormal(0.0, analog.getNormalGain());
        }
    }

    private ComplexPair transform(Complex c) {
        c = c.isInfinite() ? new Complex(-1.0) : new Complex(1.0).add(c).divide(new Complex(1.0).subtract(c));
        double a2 = this.a * this.a;
        double b2 = this.b * this.b;
        Complex u = new Complex(0.0);
        u = u.add(c.multiply(4.0 * (b2 + a2 - 1.0)));
        u = u.add(8.0 * (b2 - a2 + 1.0));
        u = u.multiply(c);
        u = u.add(4.0 * (a2 + b2 - 1.0));
        u = u.sqrt();
        Complex v = u.multiply(-0.5).add(this.a);
        v = v.add(c.multiply(-this.a));
        u = u.multiply(0.5);
        u = u.add(this.a);
        u = u.add(c.multiply(-this.a));
        Complex d = new Complex(this.b + 1.0);
        d = d.add(c.multiply(this.b - 1.0));
        return new ComplexPair(u.divide(d), v.divide(d));
    }
}

