/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

public class Spline {
    private int fsrcPos = 0;
    private int fnPoints = 0;
    private double[] fx;
    private double[] fy;
    private double[] fA;
    private double[] fB;
    private double[] fC;
    private double[] fboundCond1 = new double[2];
    private double[] fboundCondN = new double[2];

    public Spline(double[] x, double[] y) {
        this(x, y, x.length, 0);
    }

    public Spline(double[] x, double[] y, int length, int scrPos) {
        this.fsrcPos = scrPos;
        this.fnPoints = length;
        this.fx = new double[length];
        this.fy = new double[length];
        this.fA = new double[length - 1];
        this.fB = new double[length - 1];
        this.fC = new double[length - 1];
        System.arraycopy(x, this.fsrcPos, this.fx, 0, length);
        System.arraycopy(y, this.fsrcPos, this.fy, 0, length);
        this.SetupBoundaryConditions();
        this.CalcCoefficients();
    }

    private void SetupBoundaryConditions() {
        this.fboundCond1[0] = 0.0;
        this.fboundCond1[1] = 0.0;
        this.fboundCondN[0] = 0.0;
        this.fboundCondN[1] = 0.0;
    }

    private void CalcCoefficients() {
        double dy2;
        int i;
        double dx1 = this.fx[1] - this.fx[0];
        double dy1 = this.fy[1] - this.fy[0];
        for (i = 1; i < this.fnPoints - 1; ++i) {
            double dx2 = this.fx[i + 1] - this.fx[i];
            dy2 = this.fy[i + 1] - this.fy[i];
            this.fC[i] = dx2 / (dx1 + dx2);
            this.fB[i] = 1.0 - this.fC[i];
            this.fA[i] = 6.0 * (dy2 / dx2 - dy1 / dx1) / (dx1 + dx2);
            dx1 = dx2;
            dy1 = dy2;
        }
        this.fC[0] = -this.fboundCond1[0] / 2.0;
        this.fB[0] = this.fboundCond1[1] / 2.0;
        this.fA[0] = 0.0;
        for (i = 1; i < this.fnPoints - 1; ++i) {
            double p = this.fB[i] * this.fC[i - 1] + 2.0;
            this.fC[i] = -this.fC[i] / p;
            this.fB[i] = (this.fA[i] - this.fB[i] * this.fB[i - 1]) / p;
        }
        dy1 = (this.fboundCondN[1] - this.fboundCondN[0] * this.fB[this.fnPoints - 2]) / (this.fboundCondN[0] * this.fC[this.fnPoints - 2] + 2.0);
        for (i = this.fnPoints - 2; i >= 0; --i) {
            dx1 = this.fx[i + 1] - this.fx[i];
            dy2 = this.fC[i] * dy1 + this.fB[i];
            this.fA[i] = (dy1 - dy2) / (6.0 * dx1);
            this.fB[i] = dy2 / 2.0;
            this.fC[i] = (this.fy[i + 1] - this.fy[i]) / dx1 - dx1 * (this.fB[i] + dx1 * this.fA[i]);
            dy1 = dy2;
        }
    }

    public double getValue(double x) {
        if (this.fnPoints < 2) {
            return 0.0;
        }
        int left = 0;
        int right = this.fnPoints - 1;
        while (left + 1 < right) {
            int middle = left + right >> 1;
            if (this.fx[middle] <= x) {
                left = middle;
                continue;
            }
            right = middle;
        }
        int i = left;
        double t = x - this.fx[i];
        double t2 = t * t;
        double t3 = t2 * t;
        return this.fy[i] + this.fA[i] * t3 + this.fB[i] * t2 + this.fC[i] * t;
    }

    public void printCoefficients() {
        for (int i = 0; i < this.fnPoints - 1; ++i) {
            System.out.println("(x,y)[" + i + "] = (" + this.fx[i] + "," + this.fy[i] + ")");
            System.out.println("(a,b,c) = (" + this.fA[i] + "," + this.fB[i] + "," + this.fC[i] + ")");
        }
    }

    public String toString() {
        return "Spline-" + this.fnPoints + "-points";
    }
}

