/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

import de.gsi.math.TMathConstants;

public final class ArrayMath {
    public static double[] multiply(double[] in, double multiplicator) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i] * multiplicator;
        }
        return ret;
    }

    public static double[] multiplyInPlace(double[] in, double multiplicator) {
        int i = 0;
        while (i < in.length) {
            int n = i++;
            in[n] = in[n] * multiplicator;
        }
        return in;
    }

    public static double[] multiply(double[] in, double[] multiplicator) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i] * multiplicator[i];
        }
        return ret;
    }

    public static double[] multiplyInPlace(double[] in, double[] multiplicator) {
        for (int i = 0; i < in.length; ++i) {
            int n = i;
            in[n] = in[n] * multiplicator[i];
        }
        return in;
    }

    public static double[] divide(double[] in, double divisor) {
        return ArrayMath.multiply(in, 1.0 / divisor);
    }

    public static double[] divideInPlace(double[] in, double divisor) {
        return ArrayMath.multiplyInPlace(in, 1.0 / divisor);
    }

    public static double[] divide(double[] in, double[] divisor) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i] / divisor[i];
        }
        return ret;
    }

    public static double[] divideInPlace(double[] in, double[] divisor) {
        for (int i = 0; i < in.length; ++i) {
            int n = i;
            in[n] = in[n] / divisor[i];
        }
        return in;
    }

    public static double[] add(double[] in, double add) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i] + add;
        }
        return ret;
    }

    public static double[] addInPlace(double[] in, double value) {
        int i = 0;
        while (i < in.length) {
            int n = i++;
            in[n] = in[n] + value;
        }
        return in;
    }

    public static double[] add(double[] in, double[] add) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i] + add[i];
        }
        return ret;
    }

    public static double[] addInPlace(double[] in, double[] value) {
        for (int i = 0; i < in.length; ++i) {
            int n = i;
            in[n] = in[n] + value[i];
        }
        return in;
    }

    public static double[] subtract(double[] in, double value) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i] - value;
        }
        return ret;
    }

    public static double[] subtractInPlace(double[] in, double value) {
        int i = 0;
        while (i < in.length) {
            int n = i++;
            in[n] = in[n] - value;
        }
        return in;
    }

    public static double[] subtract(double[] in, double[] value) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i] + value[i];
        }
        return ret;
    }

    public static double[] subtractInPlace(double[] in, double[] value) {
        for (int i = 0; i < in.length; ++i) {
            int n = i;
            in[n] = in[n] - value[i];
        }
        return in;
    }

    public static double[] sqr(double[] in) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = TMathConstants.Sqr(in[i]);
        }
        return ret;
    }

    public static double[] sqrInPlace(double[] in) {
        for (int i = 0; i < in.length; ++i) {
            in[i] = TMathConstants.Sqr(in[i]);
        }
        return in;
    }

    public static double[] sqrt(double[] in) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = TMathConstants.Sqrt(in[i]);
        }
        return ret;
    }

    public static double[] sqrtInPlace(double[] in) {
        for (int i = 0; i < in.length; ++i) {
            in[i] = TMathConstants.Sqrt(in[i]);
        }
        return in;
    }

    public static double[] tenLog10(double[] in) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = 10.0 * TMathConstants.Log10(in[i]);
        }
        return ret;
    }

    public static double[] tenLog10InPlace(double[] in) {
        for (int i = 0; i < in.length; ++i) {
            in[i] = 10.0 * TMathConstants.Log10(in[i]);
        }
        return in;
    }

    public static double[] decibel(double[] in) {
        if (in == null) {
            return new double[0];
        }
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = 20.0 * TMathConstants.Log10(in[i]);
        }
        return ret;
    }

    public static double[] decibelInPlace(double[] in) {
        for (int i = 0; i < in.length; ++i) {
            in[i] = 20.0 * TMathConstants.Log10(in[i]);
        }
        return in;
    }

    public static double[] filterSignal(double[] signal, double cutoffFraction, double filterOrder, FilterType filterType, double ripplePercent) {
        int i;
        double[][] recursionCoefficients = new double[22][2];
        double[] coeffA = new double[22];
        double[] coeffB = new double[22];
        double[] tA = new double[22];
        double[] tB = new double[22];
        coeffA[2] = 1.0;
        coeffB[2] = 1.0;
        int i2 = 1;
        while ((double)i2 < filterOrder / 2.0) {
            int j;
            double[] filterParameters = ArrayMath.calculateFilterParameters(cutoffFraction, filterType, ripplePercent, filterOrder, i2);
            for (j = 0; j < coeffA.length; ++j) {
                tA[j] = coeffA[j];
                tB[j] = coeffB[j];
            }
            for (j = 2; j < coeffA.length; ++j) {
                coeffA[j] = filterParameters[0] * tA[j] + filterParameters[1] * tA[j - 1] + filterParameters[2] * tA[j - 2];
                coeffB[j] = tB[j] - filterParameters[3] * tB[j - 1] - filterParameters[4] * tB[j - 2];
            }
            ++i2;
        }
        coeffB[2] = 0.0;
        for (i2 = 0; i2 < 20; ++i2) {
            coeffA[i2] = coeffA[i2 + 2];
            coeffB[i2] = -coeffB[i2 + 2];
        }
        double sA = 0.0;
        double sB = 0.0;
        block7: for (int i3 = 0; i3 < 20; ++i3) {
            switch (filterType) {
                case HIGH_PASS: {
                    sA += coeffA[i3] * Math.pow(-1.0, i3);
                    sB += coeffA[i3] * Math.pow(-1.0, i3);
                    continue block7;
                }
                default: {
                    sA += coeffA[i3];
                    sB += coeffB[i3];
                }
            }
        }
        double gain = sA / (1.0 - sB);
        for (i = 0; i < 20; ++i) {
            coeffA[i] = coeffA[i] / gain;
        }
        for (i = 0; i < 22; ++i) {
            recursionCoefficients[i][0] = coeffA[i];
            recursionCoefficients[i][1] = coeffB[i];
        }
        double[] filteredSignal = new double[signal.length];
        double filterSampleA = 0.0;
        double filterSampleB = 0.0;
        for (int i4 = (int)Math.round(filterOrder); i4 < signal.length; ++i4) {
            int j = 0;
            while ((double)j < filterOrder + 1.0) {
                filterSampleA += coeffA[j] * signal[i4 - j];
                ++j;
            }
            j = 1;
            while ((double)j < filterOrder + 1.0) {
                filterSampleB += coeffB[j] * filteredSignal[i4 - j];
                ++j;
            }
            filteredSignal[i4] = filterSampleA + filterSampleB;
            filterSampleA = 0.0;
            filterSampleB = 0.0;
        }
        return filteredSignal;
    }

    public static double[] calculateFilterParameters(double cutoffFraction, FilterType filterType, double rippleP, double numberOfPoles, int iteration) {
        double rp = -Math.cos(Math.PI / (numberOfPoles * 2.0) + (double)(iteration - 1) * (Math.PI / numberOfPoles));
        double ip = Math.sin(Math.PI / (numberOfPoles * 2.0) + (double)(iteration - 1) * Math.PI / numberOfPoles);
        if (rippleP != 0.0) {
            double es = Math.sqrt(Math.pow(100.0 / (100.0 - rippleP), 2.0) - 1.0);
            double vx = 1.0 / numberOfPoles * Math.log(1.0 / es + Math.sqrt(1.0 / Math.pow(es, 2.0) + 1.0));
            double kx = 1.0 / numberOfPoles * Math.log(1.0 / es + Math.sqrt(1.0 / Math.pow(es, 2.0) - 1.0));
            kx = (Math.exp(kx) + Math.exp(-kx)) / 2.0;
            rp = rp * ((Math.exp(vx) - Math.exp(-vx)) / 2.0) / kx;
            ip = ip * ((Math.exp(vx) + Math.exp(-vx)) / 2.0) / kx;
        }
        double t = 2.0 * Math.tan(0.5);
        double w = Math.PI * 2 * cutoffFraction;
        double m = Math.pow(rp, 2.0) + Math.pow(ip, 2.0);
        double d = 4.0 - 4.0 * rp * t + m * Math.pow(t, 2.0);
        double x0 = Math.pow(t, 2.0) / d;
        double x1 = 2.0 * Math.pow(t, 2.0) / d;
        double x2 = Math.pow(t, 2.0) / d;
        double y1 = (8.0 - 2.0 * m * Math.pow(t, 2.0)) / d;
        double y2 = (-4.0 - 4.0 * rp * t - m * Math.pow(t, 2.0)) / d;
        double k = 0.0;
        switch (filterType) {
            case HIGH_PASS: {
                k = -Math.cos(0.5 * w + 0.5) / Math.cos(0.5 * w - 0.5);
                break;
            }
            default: {
                k = Math.sin(0.5 - 0.5 * w) / Math.sin(0.5 * w + 0.5);
            }
        }
        d = 1.0 + y1 * k - y2 * Math.pow(k, 2.0);
        double[] filterParameters = new double[5];
        double A0 = (x0 - x1 * k + x2 * Math.pow(k, 2.0)) / d;
        double A1 = (-2.0 * x0 * k + x1 + x1 * Math.pow(k, 2.0) - 2.0 * x2 * k) / d;
        double A2 = (x0 * Math.pow(k, 2.0) - x1 * k + x2) / d;
        double B1 = (2.0 * k + y1 + y1 * Math.pow(k, 2.0) - 2.0 * y2 * k) / d;
        double B2 = (-Math.pow(k, 2.0) - y1 * k + y2) / d;
        if (filterType == FilterType.HIGH_PASS) {
            A1 = -A1;
            B1 = -B1;
        }
        filterParameters[0] = A0;
        filterParameters[1] = A1;
        filterParameters[2] = A2;
        filterParameters[3] = B1;
        filterParameters[4] = B2;
        return filterParameters;
    }

    public static enum FilterType {
        LOW_PASS,
        HIGH_PASS;

    }
}

