/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.filter.iir;

import de.gsi.math.filter.iir.BandPassTransform;
import de.gsi.math.filter.iir.BandStopTransform;
import de.gsi.math.filter.iir.Cascade;
import de.gsi.math.filter.iir.HighPassTransform;
import de.gsi.math.filter.iir.LayoutBase;
import de.gsi.math.filter.iir.LowPassTransform;
import org.apache.commons.math3.analysis.solvers.LaguerreSolver;
import org.apache.commons.math3.complex.Complex;

public class Bessel
extends Cascade {
    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, 1);
    }

    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, directFormType);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, 1);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, directFormType);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, 1);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, directFormType);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, 1);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, directFormType);
    }

    private void setupBandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        AnalogLowPass analogProtoFilter = new AnalogLowPass(order);
        analogProtoFilter.design();
        LayoutBase digitalProtoFilter = new LayoutBase(order * 2);
        BandPassTransform.transform(centerFrequency / sampleRate, widthFrequency / sampleRate, digitalProtoFilter, analogProtoFilter);
        this.setLayout(digitalProtoFilter, directFormType);
    }

    private void setupBandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        AnalogLowPass analogProtoFilter = new AnalogLowPass(order);
        analogProtoFilter.design();
        LayoutBase digitalProtoFilter = new LayoutBase(order * 2);
        BandStopTransform.transform(centerFrequency / sampleRate, widthFrequency / sampleRate, digitalProtoFilter, analogProtoFilter);
        this.setLayout(digitalProtoFilter, directFormType);
    }

    private void setupHighPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        AnalogLowPass analogProtoFilter = new AnalogLowPass(order);
        analogProtoFilter.design();
        LayoutBase digitalProtoFilter = new LayoutBase(order);
        HighPassTransform.transform(cutoffFrequency / sampleRate, digitalProtoFilter, analogProtoFilter);
        this.setLayout(digitalProtoFilter, directFormType);
    }

    private void setupLowPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design();
        LayoutBase digitalProto = new LayoutBase(order);
        LowPassTransform.transform(cutoffFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private static class AnalogLowPass
    extends LayoutBase {
        private final int degree;
        private final double[] mA;
        private Complex[] mRoot;

        public AnalogLowPass(int degree) {
            super(degree);
            this.degree = degree;
            this.mA = new double[this.degree + 1];
            this.mRoot = new Complex[this.degree];
            this.setNormal(0.0, 1.0);
        }

        public void design() {
            this.reset();
            for (int i = 0; i < this.degree + 1; ++i) {
                this.mA[i] = this.reversebessel(i, this.degree);
            }
            LaguerreSolver laguerreSolver = new LaguerreSolver();
            this.mRoot = laguerreSolver.solveAllComplex(this.mA, 0.0);
            Complex inf = Complex.INF;
            int pairs = this.degree / 2;
            for (int i = 0; i < pairs; ++i) {
                Complex c = this.mRoot[i];
                this.addPoleZeroConjugatePairs(c, inf);
            }
            if ((this.degree & 1) == 1) {
                this.add(new Complex(this.mRoot[pairs].getReal()), inf);
            }
        }

        private double factorial(int n) {
            if (n == 0) {
                return 1.0;
            }
            double y = n;
            for (double m = (double)n - 1.0; m > 0.0; m -= 1.0) {
                y *= m;
            }
            return y;
        }

        private double reversebessel(int k, int n) {
            int diff = n - k;
            return this.factorial(2 * n - k) / (this.factorial(diff) * this.factorial(k) * Math.pow(2.0, diff));
        }
    }
}

