/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class ConcurrencyUtils {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool(new CustomThreadFactory(new CustomExceptionHandler()));
    private static boolean forceThreads = false;
    private static int forceNThreads = 1;

    private ConcurrencyUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static int extendDimension(int x) {
        if (x < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        int nextExp = ConcurrencyUtils.nextExp2(x);
        int nextPow = nextExp + 1;
        return (int)Math.round(Math.pow(2.0, nextPow));
    }

    public static int getNumberOfProcessors() {
        return forceThreads ? forceNThreads : Runtime.getRuntime().availableProcessors();
    }

    public static int getNumberOfThreads() {
        return ConcurrencyUtils.getNumberOfProcessors();
    }

    public static boolean isForceThreads() {
        return forceThreads;
    }

    public static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    public static int nextExp2(int n) {
        double e = Math.log(n) / Math.log(2.0);
        int p = (int)Math.ceil(e);
        double f = (double)n / Math.pow(2.0, p);
        if (f == 0.5) {
            --p;
        }
        return p;
    }

    public static int nextPow2(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater or equal 1");
        }
        if ((n & n - 1) == 0) {
            return n;
        }
        int x = n;
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        return x + 1;
    }

    public static int prevPow2(int x) {
        if (x < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        return (int)Math.pow(2.0, Math.floor(Math.log(x) / Math.log(2.0)));
    }

    public static void setForceThreads(boolean forceThreads) {
        ConcurrencyUtils.forceThreads = forceThreads;
    }

    public static void setNumberOfThreads(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater or equal 1");
        }
        ConcurrencyUtils.setForceThreads(true);
        forceNThreads = n;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return THREAD_POOL.submit(task);
    }

    public static Future<?> submit(Runnable task) {
        return THREAD_POOL.submit(task);
    }

    public static void waitForCompletion(Future<?>[] futures) {
        int size = futures.length;
        try {
            for (int j = 0; j < size; ++j) {
                futures[j].get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private static final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private static int threadCounter = 1;
        private final Thread.UncaughtExceptionHandler handler;

        CustomThreadFactory(Thread.UncaughtExceptionHandler handler) {
            this.handler = handler;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = defaultFactory.newThread(r);
            t.setDaemon(true);
            t.setName("daemonised_chartfx_math_thread" + threadCounter);
            ++threadCounter;
            t.setUncaughtExceptionHandler(this.handler);
            return t;
        }
    }

    private static class CustomExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CustomExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            e.printStackTrace();
        }
    }
}

