/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra;

import de.gsi.dataset.spi.utils.DoublePoint;
import de.gsi.dataset.utils.ArrayCache;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.math.ArrayMath;
import de.gsi.math.ArrayUtils;
import de.gsi.math.Math;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSpectrum {
    private static final Logger LOGGER = LoggerFactory.getLogger(TSpectrum.class);
    private static final String CACHED_ARRAY_BACKGROUND = "TSpectrum::background:workingSpace";
    private static final String CACHED_ARRAY_SMOOTH_MARKOV = "TSpectrum::smoothMarkov:workingSpace";
    private static final String CACHED_ARRAY_SEARCH = "TSpectrum::search:workingSpace";
    private static final String CACHED_ARRAY_DECONVOLUTION = "TSpectrum::deconvolution:workingSpace";
    private static final String CACHED_ARRAY_DECONVOLUTION_RL = "TSpectrum::deconvolutionLR:workingSpace";
    private static final String CACHED_ARRAY_UNFOLDING = "TSpectrum::unfolding:workingSpace";
    private static final int PEAK_WINDOW = 1024;

    private TSpectrum() {
    }

    public static double[] background(double[] source, double[] destination, int length, int numberIterations, Direction direction, FilterOrder filterOrder, SmoothWindow smoothing, boolean compton) {
        if (source == null || length <= 0 || source.length < length) {
            throw new InvalidParameterException("input spectrum null or invalid vector size");
        }
        AssertUtils.gtOrEqual((String)"numberIterations", (int)1, (int)numberIterations);
        if (length < 2 * numberIterations + 1) {
            throw new InvalidParameterException("clipping window is too large (length < 2 * numberIterations + 1) -> " + length + "< " + (2 * numberIterations + 1));
        }
        AssertUtils.notNull((String)"filterOrder", (Object)((Object)filterOrder));
        AssertUtils.notNull((String)"smoothing", (Object)((Object)smoothing));
        double[] workingSpace = ArrayCache.getCachedDoubleArray((String)CACHED_ARRAY_BACKGROUND, (int)(2 * length));
        System.arraycopy(source, 0, workingSpace, 0, length);
        System.arraycopy(source, 0, workingSpace, length, length);
        switch (filterOrder) {
            case ORDER_2: {
                TSpectrum.filterBackgroundOrder2(workingSpace, length, numberIterations, direction, smoothing);
                break;
            }
            case ORDER_4: {
                TSpectrum.filterBackgroundOrder4(workingSpace, length, numberIterations, direction, smoothing);
                break;
            }
            case ORDER_6: {
                TSpectrum.filterBackgroundOrder6(workingSpace, length, numberIterations, direction, smoothing);
                break;
            }
            default: {
                TSpectrum.filterBackgroundOrder8(workingSpace, length, numberIterations, direction, smoothing);
            }
        }
        if (compton) {
            for (int i = 0; i < length; ++i) {
                int j;
                double yb2;
                int b2;
                double a = workingSpace[i];
                double b = source[i];
                if (!(Math.abs(a - b) >= 1.0)) continue;
                int b1 = i - 1;
                if (b1 < 0) {
                    b1 = 0;
                }
                double yb1 = workingSpace[b1];
                double c = 0.0;
                boolean priz = false;
                for (b2 = b1 + 1; !priz && b2 < length; ++b2) {
                    a = workingSpace[b2];
                    b = source[b2];
                    c = c + b - yb1;
                    if (!(Math.abs(a - b) < 1.0)) continue;
                    priz = true;
                }
                if (b2 == length) {
                    --b2;
                }
                if (yb1 <= (yb2 = workingSpace[b2])) {
                    c = 0.0;
                    for (int j2 = b1; j2 <= b2; ++j2) {
                        b = source[j2];
                        c = c + b - yb1;
                    }
                    if (c > 1.0) {
                        c = (yb2 - yb1) / c;
                        double d = 0.0;
                        for (j = b1; j <= b2 && j < length; ++j) {
                            b = source[j];
                            d = d + b - yb1;
                            workingSpace[length + j] = a = c * d + yb1;
                        }
                    }
                } else {
                    c = 0.0;
                    for (int j3 = b2; j3 >= b1; --j3) {
                        b = source[j3];
                        c = c + b - yb2;
                    }
                    if (c > 1.0) {
                        c = (yb1 - yb2) / c;
                        double d = 0.0;
                        for (j = b2; j >= b1; --j) {
                            b = source[j];
                            d = d + b - yb2;
                            workingSpace[length + j] = a = c * d + yb2;
                        }
                    }
                }
                i = b2;
            }
        }
        double[] returnVector = destination == null || destination.length < length ? new double[length] : destination;
        System.arraycopy(workingSpace, 0, returnVector, 0, length);
        ArrayCache.release((String)CACHED_ARRAY_BACKGROUND, (double[])workingSpace);
        return returnVector;
    }

    public static double[] deconvolution(double[] source, double[] response, double[] destination, int length, int numberIterations, int numberRepetitions, double boost) {
        int j;
        double lda;
        int i;
        AssertUtils.gtThanZero((String)"length", (int)length);
        AssertUtils.gtThanZero((String)"numberRepetitions", (int)numberRepetitions);
        double[] workingSpace = ArrayCache.getCachedDoubleArray((String)CACHED_ARRAY_DECONVOLUTION, (int)(4 * length));
        double maximum = 0.0;
        double area = 0.0;
        int lhGold = -1;
        int posit = 0;
        for (i = 0; i < length; ++i) {
            lda = response[i];
            if (lda != 0.0) {
                lhGold = i + 1;
            }
            workingSpace[i] = lda;
            area += lda;
            if (!(lda > maximum)) continue;
            maximum = lda;
            posit = i;
        }
        if (lhGold == -1) {
            throw new IllegalArgumentException("ZERO RESPONSE VECTOR");
        }
        for (i = 0; i < length; ++i) {
            workingSpace[2 * length + i] = source[i];
        }
        for (i = 0; i < length; ++i) {
            double ldc;
            lda = 0.0;
            for (int j2 = 0; j2 < length; ++j2) {
                double ldb = workingSpace[j2];
                int k = i + j2;
                if (k >= length) continue;
                ldc = workingSpace[k];
                lda += ldb * ldc;
            }
            workingSpace[length + i] = lda;
            lda = 0.0;
            for (int k = 0; k < length; ++k) {
                int l = k - i;
                if (l < 0) continue;
                double ldb = workingSpace[l];
                ldc = workingSpace[2 * length + k];
                lda += ldb * ldc;
            }
            workingSpace[3 * length + i] = lda;
        }
        for (i = 0; i < length; ++i) {
            workingSpace[2 * length + i] = workingSpace[3 * length + i];
        }
        for (i = 0; i < length; ++i) {
            workingSpace[i] = 1.0;
        }
        for (int repet = 0; repet < numberRepetitions; ++repet) {
            if (repet != 0) {
                for (int i2 = 0; i2 < length; ++i2) {
                    workingSpace[i2] = Math.pow(workingSpace[i2], boost);
                }
            }
            for (int lindex = 0; lindex < numberIterations; ++lindex) {
                int i3;
                for (i3 = 0; i3 < length; ++i3) {
                    double ldb;
                    if (!(workingSpace[2 * length + i3] > 1.0E-6) || !(workingSpace[i3] > 1.0E-6)) continue;
                    double lda2 = 0.0;
                    for (j = 0; j < lhGold; ++j) {
                        double ldc;
                        ldb = workingSpace[j + length];
                        if (j == 0) {
                            ldc = workingSpace[i3];
                        } else {
                            int k = i3 + j;
                            ldc = 0.0;
                            if (k < length) {
                                ldc = workingSpace[k];
                            }
                            if ((k = i3 - j) >= 0) {
                                ldc += workingSpace[k];
                            }
                        }
                        lda2 += ldb * ldc;
                    }
                    ldb = workingSpace[2 * length + i3];
                    if (lda2 != 0.0) {
                        lda2 = ldb / lda2;
                    }
                    ldb = workingSpace[i3];
                    workingSpace[3 * length + i3] = lda2 *= ldb;
                }
                for (i3 = 0; i3 < length; ++i3) {
                    workingSpace[i3] = workingSpace[3 * length + i3];
                }
            }
        }
        for (int i4 = 0; i4 < length; ++i4) {
            double lda3 = workingSpace[i4];
            j = i4 + posit;
            workingSpace[length + (j %= length)] = lda3;
        }
        double[] returnVector = destination == null || destination.length < length ? new double[length] : destination;
        System.arraycopy(workingSpace, 0, returnVector, 0, length);
        ArrayMath.multiplyInPlace(returnVector, area);
        ArrayCache.release((String)CACHED_ARRAY_DECONVOLUTION, (double[])workingSpace);
        return returnVector;
    }

    public static double[] deconvolutionRL(double[] source, double[] response, double[] destination, int length, int numberIterations, int numberRepetitions, double boost) {
        int i;
        int j;
        int i2;
        AssertUtils.gtThanZero((String)"length", (int)length);
        AssertUtils.gtThanZero((String)"numberRepetitions", (int)numberRepetitions);
        double[] workingSpace = ArrayCache.getCachedDoubleArray((String)CACHED_ARRAY_DECONVOLUTION_RL, (int)(4 * length));
        int posit = 0;
        int lhGold = -1;
        double maximum = 0.0;
        for (i2 = 0; i2 < length; ++i2) {
            double lda = response[i2];
            if (lda != 0.0) {
                lhGold = i2 + 1;
            }
            workingSpace[length + i2] = lda;
            if (!(lda > maximum)) continue;
            maximum = lda;
            posit = i2;
        }
        if (lhGold == -1) {
            throw new IllegalArgumentException("ZERO RESPONSE VECTOR");
        }
        for (i2 = 0; i2 < length; ++i2) {
            workingSpace[2 * length + i2] = source[i2];
        }
        for (i2 = 0; i2 < length; ++i2) {
            workingSpace[i2] = i2 <= length - lhGold ? 1.0 : 0.0;
        }
        for (int repet = 0; repet < numberRepetitions; ++repet) {
            if (repet != 0) {
                for (int i3 = 0; i3 < length; ++i3) {
                    workingSpace[i3] = Math.pow(workingSpace[i3], boost);
                }
            }
            for (int lindex = 0; lindex < numberIterations; ++lindex) {
                int i4;
                for (i4 = 0; i4 <= length - lhGold; ++i4) {
                    double lda = 0.0;
                    if (workingSpace[i4] > 0.0) {
                        for (j = i4; j < i4 + lhGold; ++j) {
                            double ldb = workingSpace[2 * length + j];
                            if (j < length) {
                                if (ldb > 0.0) {
                                    int kmin;
                                    int kmax = j;
                                    if (kmax > lhGold - 1) {
                                        kmax = lhGold - 1;
                                    }
                                    if ((kmin = j + lhGold - length) < 0) {
                                        kmin = 0;
                                    }
                                    double ldc = 0.0;
                                    for (int k = kmax; k >= kmin; --k) {
                                        ldc += workingSpace[length + k] * workingSpace[j - k];
                                    }
                                    ldb = ldc > 0.0 ? (ldb /= ldc) : 0.0;
                                }
                                ldb *= workingSpace[length + j - i4];
                            }
                            lda += ldb;
                        }
                        lda *= workingSpace[i4];
                    }
                    workingSpace[3 * length + i4] = lda;
                }
                for (i4 = 0; i4 < length; ++i4) {
                    workingSpace[i4] = workingSpace[3 * length + i4];
                }
            }
        }
        for (i = 0; i < length; ++i) {
            double lda = workingSpace[i];
            j = i + posit;
            workingSpace[length + (j %= length)] = lda;
        }
        for (i = 0; i < length; ++i) {
            source[i] = workingSpace[length + i];
        }
        double[] returnVector = destination == null || destination.length < length ? new double[length] : destination;
        System.arraycopy(workingSpace, 0, returnVector, 0, length);
        ArrayCache.release((String)CACHED_ARRAY_DECONVOLUTION_RL, (double[])workingSpace);
        return returnVector;
    }

    protected static void filterBackgroundOrder2(double[] workingSpace, int length, int numberIterations, Direction direction, SmoothWindow smoothing) {
        int startIndex = direction == Direction.INCREASING ? 1 : numberIterations;
        int bw = (smoothing.getValue() - 1) / 2;
        do {
            int j;
            for (j = startIndex; j < length - startIndex; ++j) {
                double b;
                double a;
                if (smoothing.isSmoothing()) {
                    a = workingSpace[length + j];
                    double av = 0.0;
                    double men = 0.0;
                    for (int w = j - bw; w <= j + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        av += workingSpace[length + w];
                        men += 1.0;
                    }
                    av /= men;
                    b = 0.0;
                    men = 0.0;
                    for (int w = j - startIndex - bw; w <= j - startIndex + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        b += workingSpace[length + w];
                        men += 1.0;
                    }
                    b /= men;
                    double c = 0.0;
                    men = 0.0;
                    for (int w = j + startIndex - bw; w <= j + startIndex + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        c += workingSpace[length + w];
                        men += 1.0;
                    }
                    if ((b = (b + (c /= men)) / 2.0) < a) {
                        av = b;
                    }
                    workingSpace[j] = av;
                    continue;
                }
                b = (workingSpace[length + j - startIndex] + workingSpace[length + j + startIndex]) / 2.0;
                a = workingSpace[length + j];
                if (b < a) {
                    a = b;
                }
                workingSpace[j] = a;
            }
            for (j = startIndex; j < length - startIndex; ++j) {
                workingSpace[length + j] = workingSpace[j];
            }
            if (direction == Direction.INCREASING) {
                ++startIndex;
                continue;
            }
            --startIndex;
        } while (direction == Direction.INCREASING && startIndex <= numberIterations || direction == Direction.DECREASING && startIndex >= 1);
    }

    protected static void filterBackgroundOrder4(double[] workingSpace, int length, int numberIterations, Direction direction, SmoothWindow smoothing) {
        int startIndex = direction == Direction.INCREASING ? 1 : numberIterations;
        int bw = (smoothing.getValue() - 1) / 2;
        do {
            int j;
            for (j = startIndex; j < length - startIndex; ++j) {
                double a;
                if (smoothing.isSmoothing()) {
                    a = workingSpace[length + j];
                    double av = 0.0;
                    double men = 0.0;
                    for (int w = j - bw; w <= j + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        av += workingSpace[length + w];
                        men += 1.0;
                    }
                    av /= men;
                    double b = 0.0;
                    men = 0.0;
                    for (int w = j - startIndex - bw; w <= j - startIndex + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        b += workingSpace[length + w];
                        men += 1.0;
                    }
                    b /= men;
                    double c = 0.0;
                    men = 0.0;
                    for (int w = j + startIndex - bw; w <= j + startIndex + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        c += workingSpace[length + w];
                        men += 1.0;
                    }
                    b = (b + (c /= men)) / 2.0;
                    double ai = (double)startIndex / 2.0;
                    double b4 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        b4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    b4 /= men;
                    double c4 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        c4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    c4 /= men;
                    double d4 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        d4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    d4 /= men;
                    double e4 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        e4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    if (b < (b4 = (-b4 + 4.0 * c4 + 4.0 * d4 - (e4 /= men)) / 6.0)) {
                        b = b4;
                    }
                    if (b < a) {
                        av = b;
                    }
                    workingSpace[j] = av;
                    continue;
                }
                a = workingSpace[length + j];
                double b = (workingSpace[length + j - startIndex] + workingSpace[length + j + startIndex]) / 2.0;
                double c = 0.0;
                double ai = (double)startIndex / 2.0;
                c -= workingSpace[length + j - (int)(2.0 * ai)] / 6.0;
                c += 4.0 * workingSpace[length + j - (int)ai] / 6.0;
                c += 4.0 * workingSpace[length + j + (int)ai] / 6.0;
                if (b < (c -= workingSpace[length + j + (int)(2.0 * ai)] / 6.0)) {
                    b = c;
                }
                if (b < a) {
                    a = b;
                }
                workingSpace[j] = a;
            }
            for (j = startIndex; j < length - startIndex; ++j) {
                workingSpace[length + j] = workingSpace[j];
            }
            if (direction == Direction.INCREASING) {
                ++startIndex;
                continue;
            }
            --startIndex;
        } while (direction == Direction.INCREASING && startIndex <= numberIterations || direction == Direction.DECREASING && startIndex >= 1);
    }

    protected static void filterBackgroundOrder6(double[] workingSpace, int length, int numberIterations, Direction direction, SmoothWindow smoothing) {
        int startIndex = direction == Direction.INCREASING ? 1 : numberIterations;
        int bw = (smoothing.getValue() - 1) / 2;
        do {
            int j;
            for (j = startIndex; j < length - startIndex; ++j) {
                double a;
                if (smoothing.isSmoothing()) {
                    a = workingSpace[length + j];
                    double av = 0.0;
                    double men = 0.0;
                    for (int w = j - bw; w <= j + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        av += workingSpace[length + w];
                        men += 1.0;
                    }
                    av /= men;
                    double b = 0.0;
                    men = 0.0;
                    for (int w = j - startIndex - bw; w <= j - startIndex + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        b += workingSpace[length + w];
                        men += 1.0;
                    }
                    b /= men;
                    double c = 0.0;
                    men = 0.0;
                    for (int w = j + startIndex - bw; w <= j + startIndex + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        c += workingSpace[length + w];
                        men += 1.0;
                    }
                    b = (b + (c /= men)) / 2.0;
                    double ai = (double)startIndex / 2.0;
                    double b4 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        b4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    b4 /= men;
                    double c4 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        c4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    c4 /= men;
                    double d4 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        d4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    d4 /= men;
                    double e4 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        e4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    b4 = (-b4 + 4.0 * c4 + 4.0 * d4 - (e4 /= men)) / 6.0;
                    ai = (double)startIndex / 3.0;
                    double b6 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)(3.0 * ai) - bw; w <= j - (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        b6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    b6 /= men;
                    double c6 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        c6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    c6 /= men;
                    double d6 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        d6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    d6 /= men;
                    double e6 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        e6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    e6 /= men;
                    double f6 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        f6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    f6 /= men;
                    double g6 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)(3.0 * ai) - bw; w <= j + (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        g6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    if (b < (b6 = (b6 - 6.0 * c6 + 15.0 * d6 + 15.0 * e6 - 6.0 * f6 + (g6 /= men)) / 20.0)) {
                        b = b6;
                    }
                    if (b < b4) {
                        b = b4;
                    }
                    if (b < a) {
                        av = b;
                    }
                    workingSpace[j] = av;
                    continue;
                }
                a = workingSpace[length + j];
                double b = (workingSpace[length + j - startIndex] + workingSpace[length + j + startIndex]) / 2.0;
                double c = 0.0;
                double ai = (double)startIndex / 2.0;
                c -= workingSpace[length + j - (int)(2.0 * ai)] / 6.0;
                c += 4.0 * workingSpace[length + j - (int)ai] / 6.0;
                c += 4.0 * workingSpace[length + j + (int)ai] / 6.0;
                c -= workingSpace[length + j + (int)(2.0 * ai)] / 6.0;
                double d = 0.0;
                ai = (double)startIndex / 3.0;
                d += workingSpace[length + j - (int)(3.0 * ai)] / 20.0;
                d -= 6.0 * workingSpace[length + j - (int)(2.0 * ai)] / 20.0;
                d += 15.0 * workingSpace[length + j - (int)ai] / 20.0;
                d += 15.0 * workingSpace[length + j + (int)ai] / 20.0;
                d -= 6.0 * workingSpace[length + j + (int)(2.0 * ai)] / 20.0;
                if (b < (d += workingSpace[length + j + (int)(3.0 * ai)] / 20.0)) {
                    b = d;
                }
                if (b < c) {
                    b = c;
                }
                if (b < a) {
                    a = b;
                }
                workingSpace[j] = a;
            }
            for (j = startIndex; j < length - startIndex; ++j) {
                workingSpace[length + j] = workingSpace[j];
            }
            if (direction == Direction.INCREASING) {
                ++startIndex;
                continue;
            }
            --startIndex;
        } while (direction == Direction.INCREASING && startIndex <= numberIterations || direction == Direction.DECREASING && startIndex >= 1);
    }

    protected static void filterBackgroundOrder8(double[] workingSpace, int length, int numberIterations, Direction direction, SmoothWindow smoothing) {
        int startIndex = direction == Direction.INCREASING ? 1 : numberIterations;
        int bw = (smoothing.getValue() - 1) / 2;
        do {
            int j;
            for (j = startIndex; j < length - startIndex; ++j) {
                double a;
                if (smoothing.isSmoothing()) {
                    a = workingSpace[length + j];
                    double av = 0.0;
                    double men = 0.0;
                    for (int w = j - bw; w <= j + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        av += workingSpace[length + w];
                        men += 1.0;
                    }
                    av /= men;
                    double b = 0.0;
                    men = 0.0;
                    for (int w = j - startIndex - bw; w <= j - startIndex + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        b += workingSpace[length + w];
                        men += 1.0;
                    }
                    b /= men;
                    double c = 0.0;
                    men = 0.0;
                    for (int w = j + startIndex - bw; w <= j + startIndex + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        c += workingSpace[length + w];
                        men += 1.0;
                    }
                    b = (b + (c /= men)) / 2.0;
                    double ai = (double)startIndex / 2.0;
                    double b4 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        b4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    b4 /= men;
                    double c4 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        c4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    c4 /= men;
                    double d4 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        d4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    d4 /= men;
                    double e4 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        e4 += workingSpace[length + w];
                        men += 1.0;
                    }
                    b4 = (-b4 + 4.0 * c4 + 4.0 * d4 - (e4 /= men)) / 6.0;
                    ai = (double)startIndex / 3.0;
                    double b6 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)(3.0 * ai) - bw; w <= j - (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        b6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    b6 /= men;
                    double c6 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        c6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    c6 /= men;
                    double d6 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        d6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    d6 /= men;
                    double e6 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        e6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    e6 /= men;
                    double f6 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        f6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    f6 /= men;
                    double g6 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)(3.0 * ai) - bw; w <= j + (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        g6 += workingSpace[length + w];
                        men += 1.0;
                    }
                    b6 = (b6 - 6.0 * c6 + 15.0 * d6 + 15.0 * e6 - 6.0 * f6 + (g6 /= men)) / 20.0;
                    ai = (double)startIndex / 4.0;
                    double b8 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)(4.0 * ai) - bw; w <= j - (int)(4.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        b8 += workingSpace[length + w];
                        men += 1.0;
                    }
                    b8 /= men;
                    double c8 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)(3.0 * ai) - bw; w <= j - (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        c8 += workingSpace[length + w];
                        men += 1.0;
                    }
                    c8 /= men;
                    double d8 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        d8 += workingSpace[length + w];
                        men += 1.0;
                    }
                    d8 /= men;
                    double e8 = 0.0;
                    men = 0.0;
                    for (int w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        e8 += workingSpace[length + w];
                        men += 1.0;
                    }
                    e8 /= men;
                    double f8 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        f8 += workingSpace[length + w];
                        men += 1.0;
                    }
                    f8 /= men;
                    double g8 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        g8 += workingSpace[length + w];
                        men += 1.0;
                    }
                    g8 /= men;
                    double h8 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)(3.0 * ai) - bw; w <= j + (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        h8 += workingSpace[length + w];
                        men += 1.0;
                    }
                    h8 /= men;
                    double i8 = 0.0;
                    men = 0.0;
                    for (int w = j + (int)(4.0 * ai) - bw; w <= j + (int)(4.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= length) continue;
                        i8 += workingSpace[length + w];
                        men += 1.0;
                    }
                    if (b < (b8 = (-b8 + 8.0 * c8 - 28.0 * d8 + 56.0 * e8 - 56.0 * f8 - 28.0 * g8 + 8.0 * h8 - (i8 /= men)) / 70.0)) {
                        b = b8;
                    }
                    if (b < b6) {
                        b = b6;
                    }
                    if (b < b4) {
                        b = b4;
                    }
                    if (b < a) {
                        av = b;
                    }
                    workingSpace[j] = av;
                    continue;
                }
                a = workingSpace[length + j];
                double b = (workingSpace[length + j - startIndex] + workingSpace[length + j + startIndex]) / 2.0;
                double c = 0.0;
                double ai = (double)startIndex / 2.0;
                c -= workingSpace[length + j - (int)(2.0 * ai)] / 6.0;
                c += 4.0 * workingSpace[length + j - (int)ai] / 6.0;
                c += 4.0 * workingSpace[length + j + (int)ai] / 6.0;
                c -= workingSpace[length + j + (int)(2.0 * ai)] / 6.0;
                double d = 0.0;
                ai = (double)startIndex / 3.0;
                d += workingSpace[length + j - (int)(3.0 * ai)] / 20.0;
                d -= 6.0 * workingSpace[length + j - (int)(2.0 * ai)] / 20.0;
                d += 15.0 * workingSpace[length + j - (int)ai] / 20.0;
                d += 15.0 * workingSpace[length + j + (int)ai] / 20.0;
                d -= 6.0 * workingSpace[length + j + (int)(2.0 * ai)] / 20.0;
                d += workingSpace[length + j + (int)(3.0 * ai)] / 20.0;
                double e = 0.0;
                ai = (double)startIndex / 4.0;
                e -= workingSpace[length + j - (int)(4.0 * ai)] / 70.0;
                e += 8.0 * workingSpace[length + j - (int)(3.0 * ai)] / 70.0;
                e -= 28.0 * workingSpace[length + j - (int)(2.0 * ai)] / 70.0;
                e += 56.0 * workingSpace[length + j - (int)ai] / 70.0;
                e += 56.0 * workingSpace[length + j + (int)ai] / 70.0;
                e -= 28.0 * workingSpace[length + j + (int)(2.0 * ai)] / 70.0;
                e += 8.0 * workingSpace[length + j + (int)(3.0 * ai)] / 70.0;
                if (b < (e -= workingSpace[length + j + (int)(4.0 * ai)] / 70.0)) {
                    b = e;
                }
                if (b < d) {
                    b = d;
                }
                if (b < c) {
                    b = c;
                }
                if (b < a) {
                    a = b;
                }
                workingSpace[j] = a;
            }
            for (j = startIndex; j < length - startIndex; ++j) {
                workingSpace[length + j] = workingSpace[j];
            }
            if (direction == Direction.INCREASING) {
                ++startIndex;
                continue;
            }
            --startIndex;
        } while (direction == Direction.INCREASING && startIndex <= numberIterations || direction == Direction.DECREASING && startIndex >= 1);
    }

    public static List<DoublePoint> search(double[] sourceX, double[] sourceY, double[] destVector, int length, int nMaxPeaks, double sigma, double threshold, boolean backgroundRemove, int deconIterations, boolean markov, int averWindow) {
        double ldc;
        int i;
        int i2;
        int j;
        int i3;
        if (sourceX == null || sourceY == null) {
            throw new IllegalArgumentException("neither sourceX '" + (sourceX == null ? "null" : "OK") + "' nor sourceY '" + (sourceY == null ? "null" : "OK") + "' must be null");
        }
        if (sourceX.length < length) {
            throw new IllegalArgumentException("sourceX.length too short is '" + sourceX.length + "' vs. should '" + length + "'");
        }
        if (sourceY.length < length) {
            throw new IllegalArgumentException("sourceY.length too short is '" + sourceY.length + "' vs. should '" + length + "'");
        }
        if ((destVector == null || destVector.length < length) && LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)(destVector == null ? Double.NaN : (double)destVector.length)).addArgument((Object)length).log("destination vector has insufficient length {} vs. {} needed, omitting copying background spectrum");
        }
        if (sigma < 1.0) {
            throw new IllegalArgumentException("Invalid sigma '" + sigma + "', must be greater than or equal to 1");
        }
        if (threshold <= 0.0 || threshold >= 100.0) {
            throw new IllegalArgumentException("invalid threshold '" + threshold + "', must be within ]0,100[");
        }
        if ((int)(5.0 * sigma + 0.5) >= 512) {
            throw new IllegalArgumentException("too large sigma");
        }
        if (markov && averWindow <= 0) {
            throw new IllegalArgumentException("averanging window must be positive");
        }
        int numberIterations = (int)(7.0 * sigma + 0.5);
        if (backgroundRemove && length < 2 * numberIterations + 1) {
            throw new IllegalArgumentException("too large clipping window");
        }
        int sizeExt = length + 2 * numberIterations;
        int shift = numberIterations;
        int searchK = (int)(2.0 * sigma + 0.5);
        double l1low = 0.0;
        if (searchK >= 2) {
            double m0low = 0.0;
            double m1low = 0.0;
            double m2low = 0.0;
            double l0low = 0.0;
            for (int i4 = 0; i4 < searchK; ++i4) {
                int a = i4;
                double b = sourceY[i4];
                m0low += 1.0;
                m1low += (double)a;
                m2low += (double)(a * a);
                l0low += b;
                l1low += (double)a * b;
            }
            double detlow = m0low * m2low - m1low * m1low;
            l1low = detlow == 0.0 ? 0.0 : (-l0low * m1low + l1low * m0low) / detlow;
            if (l1low > 0.0) {
                l1low = 0.0;
            }
        } else {
            l1low = 0.0;
        }
        int nWidthSigma = (int)(7.0 * sigma + 0.5) * 2;
        double[] workingSpace = ArrayCache.getCachedDoubleArray((String)CACHED_ARRAY_SEARCH, (int)(7 * (length + nWidthSigma)));
        ArrayUtils.fillArray(workingSpace, 0.0);
        for (i3 = 0; i3 < sizeExt; ++i3) {
            if (i3 < shift) {
                int a = i3 - shift;
                workingSpace[i3 + sizeExt] = sourceY[0] + l1low * (double)a;
                if (!(workingSpace[i3 + sizeExt] < 0.0)) continue;
                workingSpace[i3 + sizeExt] = 0.0;
                continue;
            }
            if (i3 >= length + shift) {
                workingSpace[i3 + sizeExt] = sourceY[length - 1];
                if (!(workingSpace[i3 + sizeExt] < 0.0)) continue;
                workingSpace[i3 + sizeExt] = 0.0;
                continue;
            }
            workingSpace[i3 + sizeExt] = sourceY[i3 - shift];
        }
        if (backgroundRemove) {
            for (i3 = 1; i3 <= numberIterations; ++i3) {
                int j2;
                for (j2 = i3; j2 < sizeExt - i3; ++j2) {
                    double a;
                    if (markov) {
                        a = workingSpace[sizeExt + j2];
                        double av = 0.0;
                        double men = 0.0;
                        int bw = Math.min(averWindow / 2, 2);
                        for (int w = j2 - bw; w <= j2 + bw; ++w) {
                            if (w < 0 || w >= sizeExt) continue;
                            av += workingSpace[sizeExt + w];
                            men += 1.0;
                        }
                        av /= men;
                        double b = 0.0;
                        men = 0.0;
                        for (int w = j2 - i3 - bw; w <= j2 - i3 + bw; ++w) {
                            if (w < 0 || w >= sizeExt) continue;
                            b += workingSpace[sizeExt + w];
                            men += 1.0;
                        }
                        b /= men;
                        double c = 0.0;
                        men = 0.0;
                        for (int w = j2 + i3 - bw; w <= j2 + i3 + bw; ++w) {
                            if (w < 0 || w >= sizeExt) continue;
                            c += workingSpace[sizeExt + w];
                            men += 1.0;
                        }
                        if ((b = (b + (c /= men)) / 2.0) < a) {
                            av = b;
                        }
                        workingSpace[j2] = av;
                        continue;
                    }
                    double b = (workingSpace[sizeExt + j2 - i3] + workingSpace[sizeExt + j2 + i3]) / 2.0;
                    a = workingSpace[sizeExt + j2];
                    if (b < a) {
                        a = b;
                    }
                    workingSpace[j2] = a;
                }
                for (j2 = i3; j2 < sizeExt - i3; ++j2) {
                    workingSpace[sizeExt + j2] = workingSpace[j2];
                }
            }
            for (j = 0; j < sizeExt; ++j) {
                if (j < shift) {
                    int a = j - shift;
                    double b = sourceY[0] + l1low * (double)a;
                    if (b < 0.0) {
                        b = 0.0;
                    }
                    workingSpace[sizeExt + j] = b - workingSpace[sizeExt + j];
                    continue;
                }
                if (j >= length + shift) {
                    double b = sourceY[length - 1];
                    if (b < 0.0) {
                        b = 0.0;
                    }
                    workingSpace[sizeExt + j] = b - workingSpace[sizeExt + j];
                    continue;
                }
                workingSpace[sizeExt + j] = sourceY[j - shift] - workingSpace[sizeExt + j];
            }
            for (j = 0; j < sizeExt; ++j) {
                if (!(workingSpace[sizeExt + j] < 0.0)) continue;
                workingSpace[sizeExt + j] = 0.0;
            }
        }
        for (i3 = 0; i3 < sizeExt; ++i3) {
            workingSpace[i3 + 6 * sizeExt] = workingSpace[i3 + sizeExt];
        }
        if (markov) {
            int j3;
            int i5;
            for (j = 0; j < sizeExt; ++j) {
                workingSpace[2 * sizeExt + j] = workingSpace[sizeExt + j];
            }
            double signalMax = 0.0;
            double plocha = 0.0;
            for (int i6 = 0; i6 < sizeExt; ++i6) {
                workingSpace[i6] = 0.0;
                if (signalMax < workingSpace[2 * sizeExt + i6]) {
                    signalMax = workingSpace[2 * sizeExt + i6];
                }
                plocha += workingSpace[2 * sizeExt + i6];
            }
            if (signalMax == 0.0) {
                ArrayCache.release((String)CACHED_ARRAY_SEARCH, (double[])workingSpace);
                return Collections.emptyList();
            }
            double nom = 1.0;
            boolean xmin = false;
            int xmax = sizeExt - 1;
            workingSpace[0] = 1.0;
            for (i5 = 0; i5 < xmax; ++i5) {
                double a;
                double nip = workingSpace[2 * sizeExt + i5] / signalMax;
                double nim = workingSpace[2 * sizeExt + i5 + 1] / signalMax;
                double sp = 0.0;
                double sm = 0.0;
                for (int l = 1; l <= averWindow; ++l) {
                    a = i5 + l > xmax ? workingSpace[2 * sizeExt + xmax] / signalMax : workingSpace[2 * sizeExt + i5 + l] / signalMax;
                    double b = a - nip;
                    a = a + nip <= 0.0 ? 1.0 : Math.sqrt(a + nip);
                    b /= a;
                    b = Math.exp(b);
                    sp += b;
                    a = i5 - l + 1 < 0 ? workingSpace[2 * sizeExt + 0] / signalMax : workingSpace[2 * sizeExt + i5 - l + 1] / signalMax;
                    b = a - nim;
                    a = a + nim <= 0.0 ? 1.0 : Math.sqrt(a + nim);
                    b /= a;
                    b = Math.exp(b);
                    sm += b;
                }
                a = sp / sm;
                double d = workingSpace[i5] * a;
                workingSpace[i5 + 1] = d;
                a = d;
                nom += a;
            }
            for (i5 = 0; i5 <= xmax; ++i5) {
                workingSpace[i5] = workingSpace[i5] / nom;
            }
            for (j3 = 0; j3 < sizeExt; ++j3) {
                workingSpace[sizeExt + j3] = workingSpace[j3] * plocha;
            }
            for (j3 = 0; j3 < sizeExt; ++j3) {
                workingSpace[2 * sizeExt + j3] = workingSpace[sizeExt + j3];
            }
            if (backgroundRemove) {
                for (i5 = 1; i5 <= numberIterations; ++i5) {
                    int j4;
                    for (j4 = i5; j4 < sizeExt - i5; ++j4) {
                        double b = (workingSpace[sizeExt + j4 - i5] + workingSpace[sizeExt + j4 + i5]) / 2.0;
                        double a = workingSpace[sizeExt + j4];
                        if (b < a) {
                            a = b;
                        }
                        workingSpace[j4] = a;
                    }
                    for (j4 = i5; j4 < sizeExt - i5; ++j4) {
                        workingSpace[sizeExt + j4] = workingSpace[j4];
                    }
                }
                for (j3 = 0; j3 < sizeExt; ++j3) {
                    workingSpace[sizeExt + j3] = workingSpace[2 * sizeExt + j3] - workingSpace[sizeExt + j3];
                }
            }
        }
        double area = 0.0;
        int lhGold = -1;
        int posit = 0;
        double maximum = 0.0;
        for (i2 = 0; i2 < sizeExt; ++i2) {
            double lda = (double)i2 - 3.0 * sigma;
            lda = lda * lda / (2.0 * sigma * sigma);
            if ((lda = (double)((int)(1000.0 * Math.exp(-lda)))) != 0.0) {
                lhGold = i2 + 1;
            }
            workingSpace[i2] = lda;
            area += lda;
            if (!(lda > maximum)) continue;
            maximum = lda;
            posit = i2;
        }
        for (i2 = 0; i2 < sizeExt; ++i2) {
            workingSpace[2 * sizeExt + i2] = Math.abs(workingSpace[sizeExt + i2]);
        }
        int startIndex = lhGold - 1;
        if (startIndex > sizeExt) {
            startIndex = sizeExt;
        }
        for (i = -startIndex; i <= startIndex; ++i) {
            int jmax;
            double lda = 0.0;
            int jmin = 0;
            if (i < 0) {
                jmin = -i;
            }
            if ((jmax = lhGold - 1 - i) > lhGold - 1) {
                jmax = lhGold - 1;
            }
            for (int j5 = jmin; j5 <= jmax; ++j5) {
                double ldb = workingSpace[j5];
                ldc = workingSpace[i + j5];
                lda += ldb * ldc;
            }
            workingSpace[sizeExt + i + startIndex] = lda;
        }
        startIndex = lhGold - 1;
        for (i = -startIndex; i <= sizeExt + startIndex - 1; ++i) {
            double lda = 0.0;
            for (int j6 = 0; j6 <= lhGold - 1; ++j6) {
                double ldb = workingSpace[j6];
                int k = i + j6;
                if (k < 0 || k >= sizeExt) continue;
                double ldc2 = workingSpace[2 * sizeExt + k];
                lda += ldb * ldc2;
            }
            workingSpace[4 * sizeExt + i + startIndex] = lda;
        }
        for (i = -startIndex; i <= sizeExt + startIndex - 1; ++i) {
            workingSpace[2 * sizeExt + i + startIndex] = workingSpace[4 * sizeExt + i + startIndex];
        }
        for (i2 = 0; i2 < sizeExt; ++i2) {
            workingSpace[i2] = 1.0;
        }
        for (int lindex = 0; lindex < deconIterations; ++lindex) {
            for (i = 0; i < sizeExt; ++i) {
                if (!(Math.abs(workingSpace[2 * sizeExt + i]) > 1.0E-5) || !(Math.abs(workingSpace[i]) > 1.0E-5)) continue;
                double lda = 0.0;
                int jmin = lhGold - 1;
                if (jmin > i) {
                    jmin = i;
                }
                jmin = -jmin;
                int jmax = lhGold - 1;
                if (jmax > sizeExt - 1 - i) {
                    jmax = sizeExt - 1 - i;
                }
                for (int j7 = jmin; j7 <= jmax; ++j7) {
                    double ldb = workingSpace[j7 + lhGold - 1 + sizeExt];
                    ldc = workingSpace[i + j7];
                    lda += ldb * ldc;
                }
                double ldb = workingSpace[2 * sizeExt + i];
                if (lda != 0.0) {
                    lda = ldb / lda;
                }
                ldb = workingSpace[i];
                workingSpace[3 * sizeExt + i] = lda *= ldb;
            }
            for (i = 0; i < sizeExt; ++i) {
                workingSpace[i] = workingSpace[3 * sizeExt + i];
            }
        }
        for (i2 = 0; i2 < sizeExt; ++i2) {
            int j8 = (i2 + posit) % sizeExt;
            workingSpace[sizeExt + j8] = workingSpace[i2];
        }
        maximum = 0.0;
        double maximumDecon = 0.0;
        int stop = lhGold - 1;
        for (int i7 = 0; i7 < sizeExt - stop; ++i7) {
            if (i7 >= shift && i7 < length + shift) {
                workingSpace[i7] = area * workingSpace[sizeExt + i7 + stop];
                if (maximumDecon < workingSpace[i7]) {
                    maximumDecon = workingSpace[i7];
                }
                if (!(maximum < workingSpace[6 * sizeExt + i7])) continue;
                maximum = workingSpace[6 * sizeExt + i7];
                continue;
            }
            workingSpace[i7] = 0.0;
        }
        double lda = 1.0;
        if (lda > threshold) {
            lda = threshold;
        }
        lda /= 100.0;
        ArrayList<Integer> peakList = new ArrayList<Integer>();
        int peakIndex = 0;
        for (int i8 = 1; i8 < sizeExt - 1; ++i8) {
            int searchIndex;
            boolean condition2;
            boolean bl = condition2 = workingSpace[i8] > workingSpace[i8 - 1] && workingSpace[i8] > workingSpace[i8 + 1] && i8 >= shift && i8 < length + shift && workingSpace[i8] > lda * maximumDecon && workingSpace[6 * sizeExt + i8] > threshold * maximum / 100.0;
            if (!condition2) continue;
            double a = 0.0;
            double b = 0.0;
            for (int j9 = i8 - 1; j9 <= i8 + 1; ++j9) {
                a += (double)(j9 - shift) * workingSpace[j9];
                b += workingSpace[j9];
            }
            if ((a /= b) < 0.0) {
                a = 0.0;
            }
            if (a >= (double)length) {
                a = (double)length - 1.0;
            }
            if (peakIndex == 0) {
                peakList.add((int)a);
                peakIndex = 1;
                continue;
            }
            boolean priz = false;
            for (searchIndex = 0; searchIndex < peakIndex && !priz; ++searchIndex) {
                if (!(workingSpace[6 * sizeExt + shift + (int)a] > workingSpace[6 * sizeExt + shift + (Integer)peakList.get(searchIndex)])) continue;
                priz = true;
            }
            if (!priz) {
                if (searchIndex < nMaxPeaks) {
                    if (peakList.size() > searchIndex) {
                        peakList.set(searchIndex, (int)a);
                    } else {
                        peakList.add((int)a);
                    }
                }
            } else {
                for (int k = peakIndex; k >= searchIndex; --k) {
                    if (k >= nMaxPeaks) continue;
                    Integer prevPoint = (Integer)peakList.get(k - 1);
                    if (peakList.size() > k) {
                        peakList.set(k, prevPoint);
                        continue;
                    }
                    peakList.add(prevPoint);
                }
                peakList.set(searchIndex - 1, (int)a);
            }
            if (peakIndex >= nMaxPeaks) continue;
            ++peakIndex;
        }
        if (destVector != null && destVector.length >= length) {
            System.arraycopy(workingSpace, shift, destVector, 0, length);
        }
        ArrayCache.release((String)CACHED_ARRAY_SEARCH, (double[])workingSpace);
        if (peakIndex == nMaxPeaks && LOGGER.isWarnEnabled()) {
            LOGGER.atWarn().addArgument((Object)nMaxPeaks).log("maximum specified number of peaks limit reached {}");
        }
        return peakList.stream().map(p -> new DoublePoint(Double.valueOf(sourceX[p]), Double.valueOf(sourceY[p]))).collect(Collectors.toList());
    }

    public static double[] smoothMarkov(double[] source, double[] destination, int length, int averWindow) {
        if (source == null || source.length < length) {
            throw new IllegalArgumentException("source must not be null or length smaller than '" + length + "'");
        }
        if (averWindow <= 0) {
            throw new IllegalArgumentException("averaging window must be positive");
        }
        double[] workingSpace = ArrayCache.getCachedDoubleArray((String)CACHED_ARRAY_SMOOTH_MARKOV, (int)length);
        ArrayUtils.fillArray(workingSpace, 0.0);
        double sourceMax = Math.maximum(source, length);
        if (sourceMax == -1.7976931348623157E308) {
            throw new IllegalArgumentException("source vector is not finite, could not find maximum");
        }
        double sourceMin = Math.minimum(source, length);
        if (sourceMin == Double.MAX_VALUE) {
            throw new IllegalArgumentException("source vector is not finite, could not find minimum");
        }
        boolean xmin = false;
        int xmax = length - 1;
        double nom = 1.0;
        workingSpace[0] = 1.0;
        for (int i = 0; i < xmax; ++i) {
            double a;
            double nip = source[i] / sourceMax;
            double nim = source[i + 1] / sourceMax;
            double sp = 0.0;
            double sm = 0.0;
            for (int l = 1; l <= averWindow; ++l) {
                a = i + l > xmax ? source[xmax] / sourceMax : source[i + l] / sourceMax;
                double b = a - nip;
                a = a + nip <= 0.0 ? 1.0 : Math.sqrt(a + nip);
                b /= a;
                b = Math.exp(b);
                sp += b;
                a = i - l + 1 < 0 ? source[0] / sourceMax : source[i - l + 1] / sourceMax;
                b = a - nim;
                a = a + nim <= 0.0 ? 1.0 : Math.sqrt(a + nim);
                b /= a;
                b = Math.exp(b);
                sm += b;
            }
            a = sp / sm;
            double d = workingSpace[i] * a;
            workingSpace[i + 1] = d;
            a = d;
            nom += a;
        }
        double area = 0.0;
        for (int i = 0; i < length; ++i) {
            area += source[i];
        }
        ArrayMath.multiplyInPlace(workingSpace, area / nom);
        ArrayCache.release((String)CACHED_ARRAY_SMOOTH_MARKOV, (double[])workingSpace);
        double[] returnVector = destination == null || destination.length < length ? new double[length] : destination;
        System.arraycopy(workingSpace, 0, returnVector, 0, length);
        return returnVector;
    }

    public static double[] unfolding(double[] source, double[][] respMatrix, double[] destination, int lengthx, int lengthy, int numberIterations, int numberRepetitions, double boost) {
        double ldc;
        int k;
        double lda;
        double ldc2;
        double ldb;
        double lda2;
        int i;
        AssertUtils.gtThanZero((String)"lengthx", (int)lengthx);
        AssertUtils.gtThanZero((String)"lengthy", (int)lengthy);
        if (lengthx < lengthy) {
            throw new IllegalArgumentException("lengthx:" + lengthx + " must be greater than lengthy" + lengthx + "<=0");
        }
        AssertUtils.gtThanZero((String)"numberIterations", (int)numberIterations);
        int workSpaceSize = lengthx * lengthy + 2 * lengthy * lengthy + 4 * lengthx;
        double[] workingSpace = ArrayCache.getCachedDoubleArray((String)CACHED_ARRAY_UNFOLDING, (int)workSpaceSize);
        int lhx = 0;
        for (int j = 0; j < lengthy && lhx != -1; ++j) {
            int i2;
            double area = 0.0;
            lhx = -1;
            for (i2 = 0; i2 < lengthx; ++i2) {
                double lda3 = respMatrix[j][i2];
                if (lda3 != 0.0) {
                    lhx = i2 + 1;
                }
                workingSpace[j * lengthx + i2] = lda3;
                area += lda3;
            }
            if (lhx == -1) continue;
            for (i2 = 0; i2 < lengthx; ++i2) {
                int n = j * lengthx + i2;
                workingSpace[n] = workingSpace[n] / area;
            }
        }
        if (lhx == -1) {
            throw new IllegalArgumentException("ZERO COLUMN IN RESPONSE MATRIX");
        }
        for (i = 0; i < lengthx; ++i) {
            workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 2 * lengthx + i] = source[i];
        }
        for (i = 0; i < lengthy; ++i) {
            for (int j = 0; j < lengthy; ++j) {
                lda2 = 0.0;
                for (int k2 = 0; k2 < lengthx; ++k2) {
                    ldb = workingSpace[lengthx * i + k2];
                    ldc2 = workingSpace[lengthx * j + k2];
                    lda2 += ldb * ldc2;
                }
                workingSpace[lengthx * lengthy + lengthy * i + j] = lda2;
            }
            lda = 0.0;
            for (k = 0; k < lengthx; ++k) {
                double ldb2 = workingSpace[lengthx * i + k];
                ldc = workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 2 * lengthx + k];
                lda += ldb2 * ldc;
            }
            workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 3 * lengthx + i] = lda;
        }
        for (i = 0; i < lengthy; ++i) {
            workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 2 * lengthx + i] = workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 3 * lengthx + i];
        }
        for (i = 0; i < lengthy; ++i) {
            for (int j = 0; j < lengthy; ++j) {
                lda2 = 0.0;
                for (int k3 = 0; k3 < lengthy; ++k3) {
                    ldb = workingSpace[lengthx * lengthy + lengthy * i + k3];
                    ldc2 = workingSpace[lengthx * lengthy + lengthy * j + k3];
                    lda2 += ldb * ldc2;
                }
                workingSpace[lengthx * lengthy + lengthy * lengthy + lengthy * i + j] = lda2;
            }
            lda = 0.0;
            for (k = 0; k < lengthy; ++k) {
                double ldb3 = workingSpace[lengthx * lengthy + lengthy * i + k];
                ldc = workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 2 * lengthx + k];
                lda += ldb3 * ldc;
            }
            workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 3 * lengthx + i] = lda;
        }
        for (i = 0; i < lengthy; ++i) {
            workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 2 * lengthx + i] = workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 3 * lengthx + i];
        }
        for (i = 0; i < lengthy; ++i) {
            workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + i] = 1.0;
        }
        for (int repet = 0; repet < numberRepetitions; ++repet) {
            if (repet != 0) {
                for (int i3 = 0; i3 < lengthy; ++i3) {
                    workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + i3] = Math.pow(workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + i3], boost);
                }
            }
            for (int lindex = 0; lindex < numberIterations; ++lindex) {
                int i4;
                for (i4 = 0; i4 < lengthy; ++i4) {
                    double lda4 = 0.0;
                    for (int j = 0; j < lengthy; ++j) {
                        double ldb4 = workingSpace[lengthx * lengthy + lengthy * lengthy + lengthy * i4 + j];
                        double ldc3 = workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + j];
                        lda4 += ldb4 * ldc3;
                    }
                    ldb = workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 2 * lengthx + i4];
                    if (lda4 != 0.0) {
                        lda4 = ldb / lda4;
                    }
                    ldc2 = workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + i4];
                    workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 3 * lengthx + i4] = lda4 *= ldc2;
                }
                for (i4 = 0; i4 < lengthy; ++i4) {
                    workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + i4] = workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + 3 * lengthx + i4];
                }
            }
        }
        double[] returnVector = destination == null || destination.length < source.length ? new double[source.length] : destination;
        for (int i5 = 0; i5 < lengthx; ++i5) {
            returnVector[i5] = i5 < lengthy ? workingSpace[lengthx * lengthy + 2 * lengthy * lengthy + i5] : 0.0;
        }
        ArrayCache.release((String)CACHED_ARRAY_UNFOLDING, (double[])workingSpace);
        return returnVector;
    }

    public static enum SmoothWindow {
        NO_SMOOTHING(1),
        SMOOTHING_WIDTH3(3),
        SMOOTHING_WIDTH5(5),
        SMOOTHING_WIDTH7(7),
        SMOOTHING_WIDTH9(9),
        SMOOTHING_WIDTH11(11),
        SMOOTHING_WIDTH13(13),
        SMOOTHING_WIDTH15(15);

        private final int value;

        private SmoothWindow(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isSmoothing() {
            return !this.equals((Object)NO_SMOOTHING);
        }
    }

    public static enum FilterOrder {
        ORDER_2,
        ORDER_4,
        ORDER_6,
        ORDER_8;

    }

    public static enum Direction {
        INCREASING,
        DECREASING;

    }
}

