/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.functions;

import de.gsi.math.MathBase;
import de.gsi.math.functions.AbstractFunction1D;
import de.gsi.math.functions.Function1D;

public class SigmoidFunction
extends AbstractFunction1D
implements Function1D {
    public SigmoidFunction(String name) {
        this(name, null);
    }

    public SigmoidFunction(String name, double[] parameter) {
        super(name, new double[3]);
        this.setParameterName(0, "location");
        this.setParameterValue(0, 0.0);
        this.setParameterName(1, "slope");
        this.setParameterValue(1, 1.0);
        this.setParameterName(2, "scaling");
        this.setParameterValue(2, 1.0);
        this.fixParameter(2, true);
        if (parameter == null) {
            return;
        }
        for (int i = 0; i < Math.min(parameter.length, 3); ++i) {
            this.setParameterValue(i, parameter[i]);
        }
    }

    @Override
    public double getValue(double x) {
        return this.fparameter[2] / (1.0 + MathBase.exp(-this.fparameter[1] * (x - this.fparameter[0])));
    }
}

