/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.fitter;

import de.gsi.math.ArrayConversion;
import de.gsi.math.Math;
import de.gsi.math.MathBase;
import de.gsi.math.functions.Function;
import de.gsi.math.functions.Function1D;
import de.gsi.math.functions.FunctionND;
import de.gsi.math.matrix.MatrixD;
import java.util.ArrayList;

public class NonLinearRegressionFitter {
    protected static double histTol = 1.0001;
    protected int nData0 = 0;
    protected int nData = 0;
    protected int nXarrays = 1;
    protected int nYarrays = 1;
    protected int nTerms = 0;
    protected int degreesOfFreedom = 0;
    protected double[][] xData = null;
    protected double[] yData = null;
    protected double[] yCalc = null;
    protected double[] weight = null;
    protected double[] residual = null;
    protected double[] residualW = null;
    protected boolean weightOpt = false;
    protected int weightFlag = 0;
    protected double[] best = null;
    protected double[] bestSd = null;
    protected double[] pseudoSd = null;
    protected double[] tValues = null;
    protected double[] pValues = null;
    protected double chiSquare = Double.NaN;
    protected double reducedChiSquare = Double.NaN;
    protected double sumOfSquares = Double.NaN;
    protected double lastSSnoConstraint = 0.0;
    protected double[][] covar = null;
    protected double[][] corrCoeff = null;
    protected double sampleR = Double.NaN;
    protected double sampleR2 = Double.NaN;
    protected double adjustedR = Double.NaN;
    protected double adjustedR2 = Double.NaN;
    protected double multipleF = Double.NaN;
    protected double adjustedF = Double.NaN;
    protected boolean linNonLin = true;
    protected boolean trueFreq = false;
    protected boolean nlrStatus = true;
    protected int scaleOpt = 0;
    protected double[] fscale = null;
    protected boolean zeroCheck = false;
    protected boolean penalty = false;
    protected boolean sumPenalty = false;
    protected int nConstraints = 0;
    protected int nSumConstraints = 0;
    protected int maxConstraintIndex = -1;
    protected double constraintTolerance = 1.0E-4;
    protected ArrayList<Object> penalties = new ArrayList();
    protected ArrayList<Object> sumPenalties = new ArrayList();
    protected int[] penaltyCheck = null;
    protected int[] sumPenaltyCheck = null;
    protected double penaltyWeight = 1.0E30;
    protected int[] penaltyParam = null;
    protected int[][] sumPenaltyParam = null;
    protected double[][] sumPlusOrMinus = null;
    protected int[] sumPenaltyNumber = null;
    protected double[] constraints = null;
    protected double[] sumConstraints = null;
    protected int constraintMethod = 0;
    protected int nMax = 3000;
    protected int nIter = 0;
    protected int konvge = 3;
    protected int kRestart = 0;
    protected double fMin = -1.0;
    protected double fTol = 1.0E-9;
    protected double rCoeff = 1.0;
    protected double eCoeff = 2.0;
    protected double cCoeff = 0.5;
    protected double[] startH = null;
    protected double[] step = null;
    protected double dStep = 0.5;
    protected double[][] grad = null;
    protected double delta = 1.0E-4;
    protected boolean invertFlag = true;
    protected boolean posVarFlag = true;
    protected int minTest = 0;
    protected double simplexSd = 0.0;
    protected boolean statFlag = true;
    protected boolean multipleY = false;
    protected double[] values = null;
    protected boolean[] fixed = null;
    protected boolean ignoreDofFcheck = false;
    protected boolean nFactorOption = false;

    public NonLinearRegressionFitter(double[] xxData, double[] yData) {
        int i;
        this.nData0 = yData.length;
        int n = xxData.length;
        double[][] xData = new double[1][n];
        double[] weight = new double[n];
        for (i = 0; i < n; ++i) {
            xData[0][i] = xxData[i];
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        for (i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public NonLinearRegressionFitter(double[] xxData, double[] yData, double[] weight) {
        this.nData0 = yData.length;
        int n = xxData.length;
        double[][] xData = new double[1][n];
        for (int i = 0; i < n; ++i) {
            xData[0][i] = xxData[i];
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public NonLinearRegressionFitter(double[] xxData, double[][] yyData) {
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        double[] yData = new double[nY1 * nY2];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                ++ii;
            }
        }
        double[][] xData = new double[1][nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        ii = 0;
        int n = xxData.length;
        for (int j = 0; j < nY1; ++j) {
            for (int i = 0; i < n; ++i) {
                xData[0][ii] = xxData[i];
                weight[ii] = 1.0;
                ++ii;
            }
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public NonLinearRegressionFitter(double[] xxData, double[][] yyData, double[][] wWeight) {
        int j;
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        double[] yData = new double[nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                weight[ii] = wWeight[i][j];
                ++ii;
            }
        }
        int n = xxData.length;
        if (n != nY2) {
            throw new IllegalArgumentException("x and y data lengths must be the same");
        }
        double[][] xData = new double[1][nY1 * n];
        ii = 0;
        for (j = 0; j < nY1; ++j) {
            for (int i = 0; i < n; ++i) {
                xData[0][ii] = xxData[i];
                ++ii;
            }
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public NonLinearRegressionFitter(double[][] xData, double[] yData) {
        this.nData0 = yData.length;
        int n = yData.length;
        double[] weight = new double[n];
        this.weightOpt = false;
        this.weightFlag = 0;
        for (int i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public NonLinearRegressionFitter(double[][] xData, double[] yData, double[] weight) {
        this.nData0 = yData.length;
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public NonLinearRegressionFitter(double[][] xxData, double[][] yyData) {
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        int nX1 = xxData.length;
        double[] yData = new double[nY1 * nY2];
        if (nY1 != nX1) {
            throw new IllegalArgumentException("Multiple xData and yData arrays of different overall dimensions not supported");
        }
        double[][] xData = new double[1][nY1 * nY2];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int nX = xxData[i].length;
            if (nY != nX) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                xData[0][ii] = xxData[i][j];
                ++ii;
            }
        }
        int n = yData.length;
        double[] weight = new double[n];
        this.weightOpt = false;
        for (int i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public NonLinearRegressionFitter(double[][] xxData, double[][] yyData, double[][] wWeight) {
        this.multipleY = true;
        int nY1 = yyData.length;
        int nY2 = yyData[0].length;
        this.nYarrays = nY1;
        this.nData0 = nY2;
        int nX1 = xxData.length;
        double[] yData = new double[nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        double[][] xData = new double[nY1 * nY2][nX1];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int nX = xxData[i].length;
            if (nY != nX) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                xData[ii][i] = xxData[i][j];
                weight[ii] = wWeight[i][j];
                ++ii;
            }
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public void addConstraint(int paramIndex, int conDir, double constraint) {
        this.penalty = true;
        if (this.penalties.isEmpty()) {
            this.penalties.add(this.constraintMethod);
        }
        if (this.penalties.size() == 1) {
            this.penalties.add(1);
        } else {
            int nPC = (Integer)this.penalties.get(1);
            this.penalties.set(1, ++nPC);
        }
        this.penalties.add(paramIndex);
        this.penalties.add(conDir);
        this.penalties.add(constraint);
        if (paramIndex > this.maxConstraintIndex) {
            this.maxConstraintIndex = paramIndex;
        }
    }

    public void addConstraint(int[] paramIndices, double[] plusOrMinus, int conDir, double constraint) {
        int nCon = paramIndices.length;
        int nPorM = plusOrMinus.length;
        if (nCon != nPorM) {
            throw new IllegalArgumentException("num of parameters, " + nCon + ", does not equal number of parameter signs, " + nPorM);
        }
        this.sumPenalty = true;
        if (this.sumPenalties.isEmpty()) {
            this.sumPenalties.add(this.constraintMethod);
        }
        if (this.sumPenalties.size() == 1) {
            this.sumPenalties.add(1);
        } else {
            int nPC = (Integer)this.sumPenalties.get(1);
            this.sumPenalties.set(1, ++nPC);
        }
        this.sumPenalties.add(nCon);
        this.sumPenalties.add(paramIndices);
        this.sumPenalties.add(plusOrMinus);
        this.sumPenalties.add(conDir);
        this.sumPenalties.add(constraint);
        int maxI = Math.maximum(paramIndices);
        if (maxI > this.maxConstraintIndex) {
            this.maxConstraintIndex = maxI;
        }
    }

    public void addConstraint(int[] paramIndices, int[] plusOrMinus, int conDir, double constraint) {
        double[] dpom = ArrayConversion.getDoubleArray(plusOrMinus);
        this.addConstraint(paramIndices, dpom, conDir, constraint);
    }

    protected double[] checkForZeroWeights(double[] weight) {
        this.weightOpt = true;
        int nZeros = 0;
        int n = weight.length;
        for (int i = 0; i < n; ++i) {
            if (!(weight[i] <= 0.0)) continue;
            ++nZeros;
        }
        double perCentZeros = 100.0 * (double)nZeros / (double)n;
        if (perCentZeros > 40.0) {
            System.out.println(perCentZeros + "% of the weights are zero or less; all weights set to 1.0");
            for (int i = 0; i < n; ++i) {
                weight[i] = 1.0;
            }
            this.weightOpt = false;
        } else if (perCentZeros > 0.0) {
            for (int i = 0; i < n; ++i) {
                double ww;
                boolean test;
                int ii;
                if (!(weight[i] <= 0.0)) continue;
                if (i == 0) {
                    ii = 1;
                    test = true;
                    while (test) {
                        if (weight[ii] > 0.0) {
                            ww = weight[0];
                            weight[0] = weight[ii];
                            System.out.println("weight at point " + i + ", " + ww + ", replaced by " + weight[i]);
                            test = false;
                            continue;
                        }
                        ++ii;
                    }
                }
                if (i == n - 1) {
                    ii = n - 2;
                    test = true;
                    while (test) {
                        if (weight[ii] > 0.0) {
                            ww = weight[i];
                            weight[i] = weight[ii];
                            System.out.println("weight at point " + i + ", " + ww + ", replaced by " + weight[i]);
                            test = false;
                            continue;
                        }
                        --ii;
                    }
                }
                if (i <= 0 || i >= n - 2) continue;
                double lower = 0.0;
                double upper = 0.0;
                int ii2 = i - 1;
                boolean test2 = true;
                while (test2) {
                    if (weight[ii2] > 0.0) {
                        lower = weight[ii2];
                        test2 = false;
                        continue;
                    }
                    if (--ii2 != 0) continue;
                    test2 = false;
                }
                ii2 = i + 1;
                test2 = true;
                while (test2) {
                    if (weight[ii2] > 0.0) {
                        upper = weight[ii2];
                        test2 = false;
                        continue;
                    }
                    if (++ii2 != n - 1) continue;
                    test2 = false;
                }
                double ww2 = weight[i];
                weight[i] = lower == 0.0 ? upper : (upper == 0.0 ? lower : (lower + upper) / 2.0);
                System.out.println("weight at point " + i + ", " + ww2 + ", replaced by " + weight[i]);
            }
        }
        return weight;
    }

    public double checkYallSmall(double yPeak, String ss) {
        double magScale = 1.0;
        double recipYpeak = (double)((int)(1.0 / yPeak * 10000.0)) * 1.0E-4;
        if (yPeak < 1.0E-4) {
            System.out.println(ss + " fitting: The ordinate axis (y axis) has been rescaled by " + recipYpeak + " to reduce rounding errors");
            for (int i = 0; i < this.nData; ++i) {
                int n = i;
                this.yData[n] = this.yData[n] * recipYpeak;
                if (!this.weightOpt) continue;
                int n2 = i;
                this.weight[n2] = this.weight[n2] * recipYpeak;
            }
            magScale = recipYpeak;
        }
        return magScale;
    }

    public void checkZeroNeg(double[] xx, double[] yy, double[] ww) {
        int jj = 0;
        boolean test = true;
        for (int i = 0; i < this.nData; ++i) {
            if (!(yy[i] <= 0.0)) continue;
            if (i <= jj) {
                test = true;
                jj = i;
                while (test) {
                    if (++jj >= this.nData) {
                        throw new ArithmeticException("all zero cumulative data!!");
                    }
                    if (!(yy[jj] > 0.0)) continue;
                    yy[i] = yy[jj];
                    xx[i] = xx[jj];
                    ww[i] = ww[jj];
                    test = false;
                }
                continue;
            }
            if (i == this.nData - 1) {
                yy[i] = yy[i - 1];
                xx[i] = xx[i - 1];
                ww[i] = ww[i - 1];
                continue;
            }
            yy[i] = (yy[i - 1] + yy[i + 1]) / 2.0;
            xx[i] = (xx[i - 1] + xx[i + 1]) / 2.0;
            ww[i] = (ww[i - 1] + ww[i + 1]) / 2.0;
        }
    }

    public void enterData(double[] xxData, double[] yData) {
        int i;
        this.nData0 = yData.length;
        int n = xxData.length;
        double[][] xData = new double[1][n];
        double[] weight = new double[n];
        for (i = 0; i < n; ++i) {
            xData[0][i] = xxData[i];
        }
        this.weightOpt = false;
        for (i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[] xxData, double[] yData, double[] weight) {
        this.nData0 = yData.length;
        int n = xxData.length;
        double[][] xData = new double[1][n];
        for (int i = 0; i < n; ++i) {
            xData[0][i] = xxData[i];
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[] xxData, double[][] yyData) {
        this.multipleY = true;
        int nY1 = yyData.length;
        int nY2 = yyData[0].length;
        this.nYarrays = nY1;
        this.nData0 = nY2;
        double[] yData = new double[nY1 * nY2];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                ++ii;
            }
        }
        double[][] xData = new double[1][nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        ii = 0;
        int n = xxData.length;
        for (int j = 0; j < nY1; ++j) {
            for (int i = 0; i < n; ++i) {
                xData[0][ii] = xxData[i];
                weight[ii] = 1.0;
                ++ii;
            }
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[] xxData, double[][] yyData, double[][] wWeight) {
        int j;
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        double[] yData = new double[nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                weight[ii] = wWeight[i][j];
                ++ii;
            }
        }
        int n = xxData.length;
        if (n != nY2) {
            throw new IllegalArgumentException("x and y data lengths must be the same");
        }
        double[][] xData = new double[1][nY1 * n];
        ii = 0;
        for (j = 0; j < nY1; ++j) {
            for (int i = 0; i < n; ++i) {
                xData[0][ii] = xxData[i];
                ++ii;
            }
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[][] xData, double[] yData) {
        this.nData0 = yData.length;
        int n = yData.length;
        double[] weight = new double[n];
        this.weightOpt = false;
        for (int i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[][] xData, double[] yData, double[] weight) {
        this.nData0 = yData.length;
        this.weightOpt = true;
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[][] xxData, double[][] yyData) {
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        int nX1 = xxData.length;
        double[] yData = new double[nY1 * nY2];
        double[][] xData = new double[nY1 * nY2][nX1];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int nX = xxData[i].length;
            if (nY != nX) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                xData[ii][i] = xxData[i][j];
                ++ii;
            }
        }
        int n = yData.length;
        double[] weight = new double[n];
        this.weightOpt = false;
        for (int i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[][] xxData, double[][] yyData, double[][] wWeight) {
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        int nX1 = xxData.length;
        double[] yData = new double[nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        double[][] xData = new double[nY1 * nY2][nX1];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int nX = xxData[i].length;
            if (nY != nX) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                xData[ii][i] = xxData[i][j];
                weight[ii] = wWeight[i][j];
                ++ii;
            }
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    protected void generalLinearStats(double[][] xd) {
        int j;
        int i;
        int i2;
        double sde = 0.0;
        double sum = 0.0;
        double yCalctemp = 0.0;
        double[][] h = new double[this.nTerms][this.nTerms];
        double[][] stat = new double[this.nTerms][this.nTerms];
        this.covar = new double[this.nTerms][this.nTerms];
        this.corrCoeff = new double[this.nTerms][this.nTerms];
        double[] coeffSd = new double[this.nTerms];
        double[] coeff = new double[this.nTerms];
        for (i2 = 0; i2 < this.nTerms; ++i2) {
            coeff[i2] = this.best[i2];
        }
        if (this.weightOpt) {
            this.chiSquare = 0.0;
        }
        this.sumOfSquares = 0.0;
        for (i2 = 0; i2 < this.nData; ++i2) {
            yCalctemp = 0.0;
            for (int j2 = 0; j2 < this.nTerms; ++j2) {
                yCalctemp += coeff[j2] * xd[j2][i2];
            }
            this.yCalc[i2] = yCalctemp;
            this.residual[i2] = yCalctemp -= this.yData[i2];
            this.residualW[i2] = yCalctemp / this.weight[i2];
            if (this.weightOpt) {
                this.chiSquare += MathBase.sqr(yCalctemp / this.weight[i2]);
            }
            this.sumOfSquares += yCalctemp * yCalctemp;
        }
        if (this.weightOpt || this.trueFreq) {
            this.reducedChiSquare = this.chiSquare / (double)this.degreesOfFreedom;
        }
        double varY = this.sumOfSquares / (double)this.degreesOfFreedom;
        double sdY = Math.sqrt(varY);
        if (this.sumOfSquares == 0.0) {
            for (i = 0; i < this.nTerms; ++i) {
                coeffSd[i] = 0.0;
                for (j = 0; j < this.nTerms; ++j) {
                    this.covar[i][j] = 0.0;
                    this.corrCoeff[i][j] = i == j ? 1.0 : 0.0;
                }
            }
        } else {
            int j3;
            int i3;
            for (int i4 = 0; i4 < this.nTerms; ++i4) {
                for (j = 0; j < this.nTerms; ++j) {
                    sum = 0.0;
                    for (int k = 0; k < this.nData; ++k) {
                        sde = this.weightOpt ? this.weight[k] : sdY;
                        sum += xd[i4][k] * xd[j][k] / (sde * sde);
                    }
                    h[j][i4] = sum;
                }
            }
            MatrixD hh = new MatrixD(h);
            hh = hh.inverse();
            stat = hh.getArrayCopy();
            for (j = 0; j < this.nTerms; ++j) {
                coeffSd[j] = Math.sqrt(stat[j][j]);
            }
            for (i3 = 0; i3 < this.nTerms; ++i3) {
                for (j3 = 0; j3 < this.nTerms; ++j3) {
                    this.covar[i3][j3] = stat[i3][j3];
                }
            }
            for (i3 = 0; i3 < this.nTerms; ++i3) {
                for (j3 = 0; j3 < this.nTerms; ++j3) {
                    this.corrCoeff[i3][j3] = i3 == j3 ? 1.0 : this.covar[i3][j3] / (coeffSd[i3] * coeffSd[j3]);
                }
            }
        }
        for (i = 0; i < this.nTerms; ++i) {
            this.bestSd[i] = coeffSd[i];
            this.tValues[i] = this.best[i] / this.bestSd[i];
            double atv = Math.abs(this.tValues[i]);
            this.pValues[i] = 1.0 - Math.student(atv, this.degreesOfFreedom);
        }
        if (this.nXarrays == 1 && this.nYarrays == 1) {
            this.sampleR = Math.correlationCoefficient(this.xData[0], this.yData, this.weight);
            this.sampleR2 = this.sampleR * this.sampleR;
            this.adjustedR = this.sampleR;
            this.adjustedR2 = this.sampleR2;
        } else {
            this.multCorrelCoeff(this.yData, this.yCalc, this.weight);
        }
    }

    public double getAdjustedR() {
        return this.adjustedR;
    }

    public double getAdjustedR2() {
        return this.adjustedR2;
    }

    public double[] getBestEstimates() {
        return (double[])this.best.clone();
    }

    public double[] getBestEstimatesErrors() {
        return (double[])this.bestSd.clone();
    }

    public double[] getBestEstimatesStandardDeviations() {
        return (double[])this.bestSd.clone();
    }

    public double getChiSquare() {
        double ret = 0.0;
        if (this.weightOpt) {
            ret = this.chiSquare;
        } else {
            System.out.println("Chi Square cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Chi Square");
            ret = -1.0;
        }
        return ret;
    }

    public double getchiSquareProb() {
        double ret = 0.0;
        if (this.weightOpt) {
            ret = 1.0 - Math.chisquareQuantile(this.chiSquare, this.nData - this.nXarrays);
        } else {
            System.out.println("A Chi Square probablity cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Reduced Chi Square");
            ret = -1.0;
        }
        return ret;
    }

    public double[] getCoeff() {
        return (double[])this.best.clone();
    }

    public double[] getCoeffSd() {
        return (double[])this.bestSd.clone();
    }

    public double[] getCoeffVar() {
        double[] coeffVar = new double[this.nTerms];
        for (int i = 0; i < this.nTerms; ++i) {
            coeffVar[i] = this.bestSd[i] * 100.0 / this.best[i];
        }
        return coeffVar;
    }

    public double[][] getCorrCoeffMatrix() {
        return this.corrCoeff;
    }

    public double[][] getCovMatrix() {
        return this.covar;
    }

    public double getDegFree() {
        return this.degreesOfFreedom;
    }

    public double getDelta() {
        return this.delta;
    }

    public double[][] getGrad() {
        return this.grad;
    }

    public boolean getInversionCheck() {
        return this.invertFlag;
    }

    public int getMinTest() {
        return this.minTest;
    }

    public double getMultipleF() {
        if (this.nXarrays == 1) {
            System.out.println("NonLinearRegression.getMultipleF - The regression is not a multple regession: NaN returned");
        }
        return this.multipleF;
    }

    public int getNiter() {
        return this.nIter;
    }

    public boolean getNlrStatus() {
        return this.nlrStatus;
    }

    public int getNmax() {
        return this.nMax;
    }

    public double getNMcontract() {
        return this.cCoeff;
    }

    public double getNMextend() {
        return this.eCoeff;
    }

    public double getNMreflect() {
        return this.rCoeff;
    }

    public int getNrestarts() {
        return this.kRestart;
    }

    public int getNrestartsMax() {
        return this.konvge;
    }

    public boolean getPosVarCheck() {
        return this.posVarFlag;
    }

    public double[] getPseudoErrors() {
        return (double[])this.pseudoSd.clone();
    }

    public double[] getPseudoSd() {
        return (double[])this.pseudoSd.clone();
    }

    public double[] getPvalues() {
        return (double[])this.pValues.clone();
    }

    public double getReducedChiSquare() {
        double ret = 0.0;
        if (this.weightOpt) {
            ret = this.reducedChiSquare;
        } else {
            System.out.println("A Reduced Chi Square cannot be calculated as data are neither true frequencies nor weighted");
            System.out.println("A value of -1 is returned as Reduced Chi Square");
            ret = -1.0;
        }
        return ret;
    }

    public double[] getResiduals() {
        double[] temp = new double[this.nData];
        for (int i = 0; i < this.nData; ++i) {
            temp[i] = this.yData[i] - this.yCalc[i];
        }
        return temp;
    }

    public double getSampleR() {
        return this.sampleR;
    }

    public double getSampleR2() {
        return this.sampleR2;
    }

    public double[] getScale() {
        return this.fscale;
    }

    public double getSimplexSd() {
        return this.simplexSd;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public double getTolerance() {
        return this.fTol;
    }

    public boolean getTrueFreq() {
        return this.trueFreq;
    }

    public double[] getTvalues() {
        return (double[])this.tValues.clone();
    }

    public double[] getWeightedResiduals() {
        double[] temp = new double[this.nData];
        for (int i = 0; i < this.nData; ++i) {
            temp[i] = (this.yData[i] - this.yCalc[i]) / this.weight[i];
        }
        return temp;
    }

    public double[][] getXdata() {
        return (double[][])this.xData.clone();
    }

    public double[] getYcalc() {
        double[] temp = new double[this.nData];
        for (int i = 0; i < this.nData; ++i) {
            temp[i] = this.yCalc[i];
        }
        return temp;
    }

    public double[] getYdata() {
        return (double[])this.yData.clone();
    }

    public void ignoreDofFcheck() {
        this.ignoreDofFcheck = true;
    }

    public boolean infinityCheck(double yPeak, int peaki) {
        boolean flag = false;
        if (yPeak == Double.POSITIVE_INFINITY || yPeak == Double.NEGATIVE_INFINITY) {
            int ii = peaki + 1;
            if (peaki == this.nData - 1) {
                ii = peaki - 1;
            }
            this.xData[0][peaki] = this.xData[0][ii];
            this.yData[peaki] = this.yData[ii];
            this.weight[peaki] = this.weight[ii];
            System.out.println("An infinty has been removed at point " + peaki);
            flag = true;
        }
        return flag;
    }

    protected void multCorrelCoeff(double[] yy, double[] yyCalc, double[] ww) {
        double sumRecipW = 0.0;
        for (int i = 0; i < this.nData; ++i) {
            sumRecipW += 1.0 / MathBase.sqr(ww[i]);
        }
        double my = 0.0;
        for (int j = 0; j < this.nData; ++j) {
            my += yy[j] / MathBase.sqr(ww[j]);
        }
        my /= sumRecipW;
        double mr = 0.0;
        double[] residuals = new double[this.nData];
        for (int j = 0; j < this.nData; ++j) {
            residuals[j] = yy[j] - yyCalc[j];
            mr += residuals[j] / MathBase.sqr(ww[j]);
        }
        mr /= sumRecipW;
        double s2yy = 0.0;
        for (int k = 0; k < this.nData; ++k) {
            s2yy += MathBase.sqr((yy[k] - my) / ww[k]);
        }
        double s2r = 0.0;
        for (int k = 0; k < this.nData; ++k) {
            s2r += MathBase.sqr((residuals[k] - mr) / ww[k]);
        }
        this.sampleR2 = 1.0 - s2r / s2yy;
        this.sampleR = Math.sqrt(this.sampleR2);
        this.adjustedR2 = ((double)(this.nData - 1) * this.sampleR2 - (double)this.nXarrays) / (double)(this.nData - this.nXarrays - 1);
        this.adjustedR = Math.sqrt(this.adjustedR2);
        if (this.nXarrays > 1) {
            this.multipleF = this.sampleR2 * (double)(this.nData - this.nXarrays) / ((1.0 - this.sampleR2) * (double)(this.nXarrays - 1));
            this.adjustedF = this.adjustedR2 * (double)(this.nData - this.nXarrays) / ((1.0 - this.adjustedR2) * (double)(this.nXarrays - 1));
        }
    }

    protected void nelderMead(Object regFun, double[] start, double[] step, double fTol, int nMax) {
        int i;
        int i2;
        int i3;
        int i4;
        int np = start.length;
        if (this.maxConstraintIndex >= np) {
            throw new IllegalArgumentException("You have entered more constrained parameters (" + this.maxConstraintIndex + ") than minimisation parameters (" + np + ")");
        }
        this.nlrStatus = true;
        this.nTerms = np;
        int nnp = np + 1;
        this.lastSSnoConstraint = 0.0;
        if (this.scaleOpt < 2) {
            this.fscale = new double[np];
        }
        if (this.scaleOpt == 2 && this.fscale.length != start.length) {
            throw new IllegalArgumentException("scale array and initial estimate array are of different lengths");
        }
        if (step.length != start.length) {
            throw new IllegalArgumentException("step array length " + step.length + " and initial estimate array length " + start.length + " are of different");
        }
        for (i4 = 0; i4 < np; ++i4) {
            if (step[i4] != 0.0) continue;
            throw new IllegalArgumentException("step " + i4 + " size is zero");
        }
        if (this.ignoreDofFcheck) {
            this.bestSd = new double[this.nTerms];
            this.pseudoSd = new double[this.nTerms];
            this.tValues = new double[this.nTerms];
            this.pValues = new double[this.nTerms];
            this.covar = new double[this.nTerms][this.nTerms];
            this.corrCoeff = new double[this.nTerms][this.nTerms];
            for (i4 = 0; i4 < this.nTerms; ++i4) {
                this.bestSd[i4] = Double.NaN;
                this.pseudoSd[i4] = Double.NaN;
                for (int j = 0; j < this.nTerms; ++j) {
                    this.covar[i4][j] = Double.NaN;
                    this.corrCoeff[i4][j] = Double.NaN;
                }
            }
        }
        this.startH = new double[np];
        this.step = new double[np];
        double[] pmin = new double[np];
        this.best = new double[np];
        this.bestSd = new double[np];
        this.tValues = new double[np];
        this.pValues = new double[np];
        double[][] pp = new double[nnp][nnp];
        double[] yy = new double[nnp];
        double[] pbar = new double[nnp];
        double[] pstar = new double[nnp];
        double[] p2star = new double[nnp];
        double yabsmean = 0.0;
        for (i3 = 0; i3 < this.nData; ++i3) {
            yabsmean += Math.abs(this.yData[i3]);
        }
        yabsmean /= (double)this.nData;
        if (this.penalty) {
            Integer itemp = (Integer)this.penalties.get(1);
            this.nConstraints = itemp;
            this.penaltyParam = new int[this.nConstraints];
            this.penaltyCheck = new int[this.nConstraints];
            this.constraints = new double[this.nConstraints];
            Double dtemp = null;
            int j = 2;
            for (i2 = 0; i2 < this.nConstraints; ++i2) {
                itemp = (Integer)this.penalties.get(j);
                this.penaltyParam[i2] = itemp;
                itemp = (Integer)this.penalties.get(++j);
                this.penaltyCheck[i2] = itemp;
                dtemp = (Double)this.penalties.get(++j);
                this.constraints[i2] = dtemp;
                ++j;
            }
        }
        if (this.sumPenalty) {
            Integer itemp = (Integer)this.sumPenalties.get(1);
            this.nSumConstraints = itemp;
            this.sumPenaltyParam = new int[this.nSumConstraints][];
            this.sumPlusOrMinus = new double[this.nSumConstraints][];
            this.sumPenaltyCheck = new int[this.nSumConstraints];
            this.sumPenaltyNumber = new int[this.nSumConstraints];
            this.sumConstraints = new double[this.nSumConstraints];
            int[] itempArray = null;
            double[] dtempArray = null;
            Double dtemp = null;
            int j = 2;
            for (int i5 = 0; i5 < this.nSumConstraints; ++i5) {
                itemp = (Integer)this.sumPenalties.get(j);
                this.sumPenaltyNumber[i5] = itemp;
                itempArray = (int[])this.sumPenalties.get(++j);
                this.sumPenaltyParam[i5] = itempArray;
                dtempArray = (double[])this.sumPenalties.get(++j);
                this.sumPlusOrMinus[i5] = dtempArray;
                itemp = (Integer)this.sumPenalties.get(++j);
                this.sumPenaltyCheck[i5] = itemp;
                dtemp = (Double)this.sumPenalties.get(++j);
                this.sumConstraints[i5] = dtemp;
                ++j;
            }
        }
        for (i3 = 0; i3 < np; ++i3) {
            this.startH[i3] = start[i3];
        }
        if (this.scaleOpt > 0) {
            boolean testzero = false;
            for (int i6 = 0; i6 < np; ++i6) {
                if (start[i6] != 0.0) continue;
                testzero = true;
            }
            if (testzero) {
                System.out.println("Neler and Mead Simplex: a start value of zero precludes scaling");
                System.out.println("Regression performed without scaling");
                this.scaleOpt = 0;
            }
        }
        switch (this.scaleOpt) {
            case 0: {
                for (i3 = 0; i3 < np; ++i3) {
                    this.fscale[i3] = 1.0;
                }
                break;
            }
            case 1: {
                for (i3 = 0; i3 < np; ++i3) {
                    this.fscale[i3] = 1.0 / start[i3];
                    step[i3] = step[i3] / start[i3];
                    start[i3] = 1.0;
                }
                break;
            }
            case 2: {
                for (i3 = 0; i3 < np; ++i3) {
                    int n = i3;
                    step[n] = step[n] * this.fscale[i3];
                    int n2 = i3;
                    start[n2] = start[n2] * this.fscale[i3];
                }
                break;
            }
        }
        this.fTol = fTol;
        this.nMax = nMax;
        this.nIter = 0;
        for (i3 = 0; i3 < np; ++i3) {
            this.step[i3] = step[i3];
            this.fscale[i3] = this.fscale[i3];
        }
        double sho = 0.0;
        for (int i7 = 0; i7 < np; ++i7) {
            pstar[i7] = sho = start[i7];
            p2star[i7] = sho;
            pmin[i7] = sho;
        }
        int jcount = this.konvge;
        for (i2 = 0; i2 < np; ++i2) {
            pp[i2][nnp - 1] = start[i2];
        }
        yy[nnp - 1] = this.sumSquares(regFun, start);
        for (int j = 0; j < np; ++j) {
            start[j] = start[j] + step[j];
            for (int i8 = 0; i8 < np; ++i8) {
                pp[i8][j] = start[i8];
            }
            yy[j] = this.sumSquares(regFun, start);
            start[j] = start[j] - step[j];
        }
        double ynewlo = 0.0;
        double ystar = 0.0;
        double y2star = 0.0;
        double ylo = 0.0;
        double curMin = 0.0;
        double sumnm = 0.0;
        double summnm = 0.0;
        double zn = 0.0;
        int ilo = 0;
        int ihi = 0;
        int ln = 0;
        boolean test = true;
        while (test) {
            int i9;
            int j;
            ynewlo = ylo = yy[0];
            ilo = 0;
            ihi = 0;
            for (i = 1; i < nnp; ++i) {
                if (yy[i] < ylo) {
                    ylo = yy[i];
                    ilo = i;
                }
                if (!(yy[i] > ynewlo)) continue;
                ynewlo = yy[i];
                ihi = i;
            }
            for (i = 0; i < np; ++i) {
                zn = 0.0;
                for (int j2 = 0; j2 < nnp; ++j2) {
                    zn += pp[i][j2];
                }
                pbar[i] = (zn -= pp[i][ihi]) / (double)np;
            }
            for (i = 0; i < np; ++i) {
                pstar[i] = (1.0 + this.rCoeff) * pbar[i] - this.rCoeff * pp[i][ihi];
            }
            ystar = this.sumSquares(regFun, pstar);
            ++this.nIter;
            if (ystar < ylo) {
                for (i = 0; i < np; ++i) {
                    p2star[i] = pstar[i] * (1.0 + this.eCoeff) - this.eCoeff * pbar[i];
                }
                y2star = this.sumSquares(regFun, p2star);
                ++this.nIter;
                if (y2star < ylo) {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = p2star[i];
                    }
                    yy[ihi] = y2star;
                } else {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = pstar[i];
                    }
                    yy[ihi] = ystar;
                }
            } else {
                ln = 0;
                for (i = 0; i < nnp; ++i) {
                    if (i == ihi || !(ystar > yy[i])) continue;
                    ++ln;
                }
                if (ln == np) {
                    if (ystar <= yy[ihi]) {
                        for (i = 0; i < np; ++i) {
                            pp[i][ihi] = pstar[i];
                        }
                        yy[ihi] = ystar;
                    }
                    for (i = 0; i < np; ++i) {
                        p2star[i] = this.cCoeff * pp[i][ihi] + (1.0 - this.cCoeff) * pbar[i];
                    }
                    y2star = this.sumSquares(regFun, p2star);
                    ++this.nIter;
                    if (y2star > yy[ihi]) {
                        for (j = 0; j < nnp; ++j) {
                            for (i9 = 0; i9 < np; ++i9) {
                                pp[i9][j] = 0.5 * (pp[i9][j] + pp[i9][ilo]);
                                pmin[i9] = pp[i9][j];
                            }
                            yy[j] = this.sumSquares(regFun, pmin);
                        }
                        this.nIter += nnp;
                    } else {
                        for (i = 0; i < np; ++i) {
                            pp[i][ihi] = p2star[i];
                        }
                        yy[ihi] = y2star;
                    }
                } else {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = pstar[i];
                    }
                    yy[ihi] = ystar;
                }
            }
            sumnm = 0.0;
            ynewlo = yy[0];
            ilo = 0;
            for (i = 0; i < nnp; ++i) {
                sumnm += yy[i];
                if (!(ynewlo > yy[i])) continue;
                ynewlo = yy[i];
                ilo = i;
            }
            sumnm /= (double)nnp;
            summnm = 0.0;
            for (i = 0; i < nnp; ++i) {
                zn = yy[i] - sumnm;
                summnm += zn * zn;
            }
            curMin = Math.sqrt(summnm / (double)np);
            switch (this.minTest) {
                case 0: {
                    if (!(curMin < fTol)) break;
                    test = false;
                    break;
                }
                case 1: {
                    if (!(Math.sqrt(ynewlo / (double)this.degreesOfFreedom) < yabsmean * fTol)) break;
                    test = false;
                }
            }
            this.sumOfSquares = ynewlo;
            if (!test) {
                for (i = 0; i < np; ++i) {
                    pmin[i] = pp[i][ilo];
                }
                yy[nnp - 1] = ynewlo;
                this.simplexSd = curMin;
                if (--jcount > 0) {
                    test = true;
                    for (j = 0; j < np; ++j) {
                        pmin[j] = pmin[j] + step[j];
                        for (i9 = 0; i9 < np; ++i9) {
                            pp[i9][j] = pmin[i9];
                        }
                        yy[j] = this.sumSquares(regFun, pmin);
                        pmin[j] = pmin[j] - step[j];
                    }
                }
            }
            if (!test || this.nIter <= this.nMax) continue;
            System.out.println("Maximum iteration number reached, in Regression.simplex(...)");
            System.out.println("without the convergence criterion being satisfied");
            System.out.println("Current parameter estimates and sum of squares values returned");
            this.nlrStatus = false;
            for (i = 0; i < np; ++i) {
                pmin[i] = pp[i][ilo];
            }
            yy[nnp - 1] = ynewlo;
            test = false;
        }
        for (i = 0; i < np; ++i) {
            pmin[i] = pp[i][ilo];
            this.best[i] = pmin[i] / this.fscale[i];
            this.fscale[i] = 1.0;
        }
        this.fMin = ynewlo;
        this.kRestart = this.konvge - jcount;
        if (this.statFlag) {
            if (!this.ignoreDofFcheck) {
                this.pseudoLinearStats(regFun);
            }
        } else {
            for (i = 0; i < np; ++i) {
                this.bestSd[i] = Double.NaN;
            }
        }
    }

    protected int pseudoLinearStats(Object regFun) {
        int i;
        int i2;
        double f1 = 0.0;
        double f2 = 0.0;
        double f3 = 0.0;
        double f4 = 0.0;
        int flag = 0;
        int np = this.nTerms;
        double[] f = new double[np];
        double[] pmin = new double[np];
        double[] coeffSd = new double[np];
        double[] xd = new double[this.nXarrays];
        double[][] stat = new double[np][np];
        this.pseudoSd = new double[np];
        this.grad = new double[np][2];
        this.covar = new double[np][np];
        this.corrCoeff = new double[np][np];
        pmin = (double[])this.best.clone();
        double hold0 = 1.0;
        double hold1 = 1.0;
        for (i2 = 0; i2 < np; ++i2) {
            for (int k = 0; k < np; ++k) {
                f[k] = pmin[k];
            }
            hold0 = pmin[i2];
            if (hold0 == 0.0) {
                hold0 = this.step[i2];
                this.zeroCheck = true;
            }
            f[i2] = hold0 * (1.0 - this.delta);
            this.lastSSnoConstraint = this.sumOfSquares;
            f1 = this.sumSquares(regFun, f);
            f[i2] = hold0 * (1.0 + this.delta);
            this.lastSSnoConstraint = this.sumOfSquares;
            f2 = this.sumSquares(regFun, f);
            this.grad[i2][0] = (this.fMin - f1) / Math.abs(this.delta * hold0);
            this.grad[i2][1] = (f2 - this.fMin) / Math.abs(this.delta * hold0);
        }
        this.lastSSnoConstraint = this.sumOfSquares;
        for (i2 = 0; i2 < np; ++i2) {
            for (int j = 0; j < np; ++j) {
                for (int k = 0; k < np; ++k) {
                    f[k] = pmin[k];
                }
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.step[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 + this.delta / 2.0);
                hold0 = f[j];
                if (hold0 == 0.0) {
                    hold0 = this.step[j];
                    this.zeroCheck = true;
                }
                f[j] = hold0 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                f1 = this.sumSquares(regFun, f);
                f[i2] = pmin[i2];
                f[j] = pmin[j];
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.step[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 - this.delta / 2.0);
                hold0 = f[j];
                if (hold0 == 0.0) {
                    hold0 = this.step[j];
                    this.zeroCheck = true;
                }
                f[j] = hold0 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                f2 = this.sumSquares(regFun, f);
                f[i2] = pmin[i2];
                f[j] = pmin[j];
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.step[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 + this.delta / 2.0);
                hold0 = f[j];
                if (hold0 == 0.0) {
                    hold0 = this.step[j];
                    this.zeroCheck = true;
                }
                f[j] = hold0 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                f3 = this.sumSquares(regFun, f);
                f[i2] = pmin[i2];
                f[j] = pmin[j];
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.step[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 - this.delta / 2.0);
                hold0 = f[j];
                if (hold0 == 0.0) {
                    hold0 = this.step[j];
                    this.zeroCheck = true;
                }
                f[j] = hold0 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquares;
                f4 = this.sumSquares(regFun, f);
                stat[i2][j] = (f1 - f2 - f3 + f4) / (this.delta * this.delta);
            }
        }
        if (regFun instanceof Function) {
            ((Function)regFun).setFitterMode(true);
            Function func = (Function)regFun;
            for (int i3 = 0; i3 < func.getParameterCount(); ++i3) {
                if (func.isParameterFixed(i3)) continue;
                func.setParameterValue(i3, pmin[i3]);
            }
        }
        double ss = 0.0;
        double sc = 0.0;
        for (int i4 = 0; i4 < this.nData; ++i4) {
            for (int j = 0; j < this.nXarrays; ++j) {
                xd[j] = this.xData[j][i4];
            }
            this.yCalc[i4] = this.multipleY ? ((FunctionND)regFun).getValue(xd, i4) : ((Function1D)regFun).getValue(xd[0]);
            this.residual[i4] = this.yCalc[i4] - this.yData[i4];
            ss += MathBase.sqr(this.residual[i4]);
            this.residualW[i4] = this.residual[i4] / this.weight[i4];
            sc += MathBase.sqr(this.residualW[i4]);
        }
        if (regFun instanceof Function) {
            ((Function)regFun).setFitterMode(false);
        }
        this.sumOfSquares = ss;
        if (this.weightOpt || this.trueFreq) {
            this.chiSquare = sc;
            this.reducedChiSquare = sc / (double)(this.nData - np);
        }
        double red = 1.0;
        if (!this.weightOpt && !this.trueFreq) {
            red = this.sumOfSquares / (double)(this.nData - np);
        }
        for (i = 0; i < np; ++i) {
            this.pseudoSd[i] = 2.0 * this.delta * red * Math.abs(pmin[i]) / (this.grad[i][1] - this.grad[i][0]);
            this.pseudoSd[i] = this.pseudoSd[i] >= 0.0 ? Math.sqrt(this.pseudoSd[i]) : Double.NaN;
        }
        if (np == 1) {
            hold0 = pmin[0];
            if (hold0 == 0.0) {
                hold0 = this.step[0];
            }
            stat[0][0] = 1.0 / stat[0][0];
            this.covar[0][0] = stat[0][0] * red * hold0 * hold0;
            if (this.covar[0][0] >= 0.0) {
                coeffSd[0] = Math.sqrt(this.covar[0][0]);
                this.corrCoeff[0][0] = 1.0;
            } else {
                coeffSd[0] = Double.NaN;
                this.corrCoeff[0][0] = Double.NaN;
                this.posVarFlag = false;
            }
        } else {
            int j;
            int i5;
            MatrixD cov = new MatrixD(stat);
            this.invertFlag = true;
            cov = cov.pseudoInverse(1.0E12);
            if (!this.invertFlag) {
                --flag;
            }
            stat = cov.getArrayCopy();
            this.posVarFlag = true;
            if (this.invertFlag) {
                for (i5 = 0; i5 < np; ++i5) {
                    hold0 = pmin[i5];
                    if (hold0 == 0.0) {
                        hold0 = this.step[i5];
                    }
                    for (j = i5; j < np; ++j) {
                        hold1 = pmin[j];
                        if (hold1 == 0.0) {
                            hold1 = this.step[j];
                        }
                        this.covar[i5][j] = 2.0 * stat[i5][j] * red * hold0 * hold1;
                        this.covar[j][i5] = this.covar[i5][j];
                    }
                    if (this.covar[i5][i5] >= 0.0) {
                        coeffSd[i5] = Math.sqrt(this.covar[i5][i5]);
                        continue;
                    }
                    coeffSd[i5] = Double.NaN;
                    this.posVarFlag = false;
                }
                for (i5 = 0; i5 < np; ++i5) {
                    for (j = 0; j < np; ++j) {
                        this.corrCoeff[i5][j] = Double.isFinite(coeffSd[i5]) && Double.isFinite(coeffSd[j]) ? this.covar[i5][j] / (coeffSd[i5] * coeffSd[j]) : Double.NaN;
                    }
                }
            } else {
                for (i5 = 0; i5 < np; ++i5) {
                    for (j = 0; j < np; ++j) {
                        this.covar[i5][j] = Double.NaN;
                        this.corrCoeff[i5][j] = Double.NaN;
                    }
                    coeffSd[i5] = Double.NaN;
                    this.posVarFlag = false;
                }
            }
        }
        if (!this.posVarFlag) {
            --flag;
        }
        for (i = 0; i < this.nTerms; ++i) {
            this.bestSd[i] = coeffSd[i];
            this.tValues[i] = this.best[i] / this.bestSd[i];
            double atv = Math.abs(this.tValues[i]);
            this.pValues[i] = 1.0 - Math.student(atv, this.degreesOfFreedom);
        }
        this.multCorrelCoeff(this.yData, this.yCalc, this.weight);
        return flag;
    }

    public void removeConstraints() {
        int i;
        int m;
        if (!this.penalties.isEmpty()) {
            m = this.penalties.size();
            for (i = m - 1; i >= 0; --i) {
                this.penalties.remove(i);
            }
        }
        this.penalty = false;
        this.nConstraints = 0;
        if (!this.sumPenalties.isEmpty()) {
            m = this.sumPenalties.size();
            for (i = m - 1; i >= 0; --i) {
                this.sumPenalties.remove(i);
            }
        }
        this.sumPenalty = false;
        this.nSumConstraints = 0;
        this.maxConstraintIndex = -1;
    }

    public void setConstraintTolerance(double tolerance) {
        this.constraintTolerance = tolerance;
    }

    protected void setDefaultValues(double[][] xData, double[] yData, double[] weight) {
        this.nData = yData.length;
        this.nTerms = this.nXarrays = xData.length;
        this.yData = new double[this.nData];
        this.yCalc = new double[this.nData];
        this.weight = new double[this.nData];
        this.residual = new double[this.nData];
        this.residualW = new double[this.nData];
        this.xData = new double[this.nXarrays][this.nData];
        int n = weight.length;
        if (n != this.nData) {
            throw new IllegalArgumentException("The weight and the y data lengths do not agree");
        }
        for (int i = 0; i < this.nData; ++i) {
            this.yData[i] = yData[i];
            this.weight[i] = weight[i];
        }
        for (int j = 0; j < this.nXarrays; ++j) {
            n = xData[j].length;
            if (n != this.nData) {
                throw new IllegalArgumentException("An x [" + j + "] length " + n + " and the y data length, " + this.nData + ", do not agree");
            }
            for (int i = 0; i < this.nData; ++i) {
                this.xData[j][i] = xData[j][i];
            }
        }
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public void setMinTest(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("minTest must be 0 or 1");
        }
        this.minTest = n;
    }

    public void setNmax(int nmax) {
        this.nMax = nmax;
    }

    public void setNMcontract(double con) {
        this.cCoeff = con;
    }

    public void setNMextend(double ext) {
        this.eCoeff = ext;
    }

    public void setNMreflect(double refl) {
        this.rCoeff = refl;
    }

    public void setNrestartsMax(int nrs) {
        this.konvge = nrs;
    }

    public void setScale(double[] sc) {
        this.fscale = sc;
        this.scaleOpt = 2;
    }

    public void setScale(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("The argument must be 0 (no scaling) 1(initial estimates all scaled to unity) or the array of scaling factors");
        }
        this.scaleOpt = n;
    }

    public void setTolerance(double tol) {
        this.fTol = tol;
    }

    public void setTrueFreq(boolean trFr) {
        boolean trFrOld = this.trueFreq;
        this.trueFreq = trFr;
        if (trFr) {
            boolean flag = NonLinearRegressionFitter.setTrueFreqWeights(this.yData, this.weight);
            if (flag) {
                this.trueFreq = true;
                this.weightOpt = true;
            } else {
                this.trueFreq = false;
                this.weightOpt = false;
            }
        } else if (trFrOld) {
            for (int i = 0; i < this.weight.length; ++i) {
                this.weight[i] = 1.0;
            }
            this.weightOpt = false;
        }
    }

    public void simplex(Function1D g, double[] start) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMaxx);
    }

    public void simplex(Function1D g, double[] start, double fTol) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMaxx);
    }

    public void simplex(Function1D g, double[] start, double fTol, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        int n = start.length;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMax);
    }

    public void simplex(Function1D g, double[] start, double[] step) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        double fToll = this.fTol;
        int nMaxx = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMaxx);
    }

    public void simplex(Function1D g, double[] start, double[] step, double fTol) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        int nMaxx = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMaxx);
    }

    public void simplex(Function1D g, double[] start, double[] step, double fTol, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMax);
    }

    public void simplex(Function1D g, double[] start, double[] step, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        double fToll = this.fTol;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMax);
    }

    public void simplex(Function1D g, double[] start, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        Function1D regFun = g;
        int n = start.length;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMax);
    }

    @Deprecated
    public void simplex2(FunctionND g, double[] start) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMaxx);
    }

    @Deprecated
    public void simplex2(FunctionND g, double[] start, double fTol) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMaxx);
    }

    @Deprecated
    public void simplex2(FunctionND g, double[] start, double fTol, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        int n = start.length;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMax);
    }

    @Deprecated
    public void simplex2(FunctionND g, double[] start, double[] step) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        double fToll = this.fTol;
        int nMaxx = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMaxx);
    }

    @Deprecated
    public void simplex2(FunctionND g, double[] start, double[] step, double fTol) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        int nMaxx = this.nMax;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMaxx);
    }

    @Deprecated
    public void simplex2(FunctionND g, double[] start, double[] step, double fTol, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMax);
    }

    @Deprecated
    public void simplex2(FunctionND g, double[] start, double[] step, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        double fToll = this.fTol;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMax);
    }

    @Deprecated
    public void simplex2(FunctionND g, double[] start, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        FunctionND regFun = g;
        int n = start.length;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMax);
    }

    protected double sumSquares(Object regFun, double[] testParameter) {
        int i;
        double ss = -3.0;
        double[] param = new double[this.nTerms];
        double[] xd = new double[this.nXarrays];
        for (int i2 = 0; i2 < this.nTerms; ++i2) {
            param[i2] = testParameter[i2] / this.fscale[i2];
        }
        double tempFunctVal = this.lastSSnoConstraint;
        boolean test = true;
        if (this.penalty) {
            int k = 0;
            block11: for (i = 0; i < this.nConstraints; ++i) {
                k = this.penaltyParam[i];
                switch (this.penaltyCheck[i]) {
                    case -1: {
                        if (!(param[k] < this.constraints[i])) continue block11;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(this.constraints[i] - param[k]);
                        test = false;
                        continue block11;
                    }
                    case 0: {
                        if (param[k] < this.constraints[i] * (1.0 - this.constraintTolerance)) {
                            ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(this.constraints[i] * (1.0 - this.constraintTolerance) - param[k]);
                            test = false;
                        }
                        if (!(param[k] > this.constraints[i] * (1.0 + this.constraintTolerance))) continue block11;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(param[k] - this.constraints[i] * (1.0 + this.constraintTolerance));
                        test = false;
                        continue block11;
                    }
                    case 1: {
                        if (!(param[k] > this.constraints[i])) continue block11;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(param[k] - this.constraints[i]);
                        test = false;
                    }
                }
            }
        }
        if (this.sumPenalty) {
            int kk = 0;
            double pSign = 0.0;
            double sumPenaltySum = 0.0;
            block12: for (int i3 = 0; i3 < this.nSumConstraints; ++i3) {
                for (int j = 0; j < this.sumPenaltyNumber[i3]; ++j) {
                    kk = this.sumPenaltyParam[i3][j];
                    pSign = this.sumPlusOrMinus[i3][j];
                    sumPenaltySum += param[kk] * pSign;
                }
                switch (this.sumPenaltyCheck[i3]) {
                    case -1: {
                        if (!(sumPenaltySum < this.sumConstraints[i3])) continue block12;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(this.sumConstraints[i3] - sumPenaltySum);
                        test = false;
                        continue block12;
                    }
                    case 0: {
                        if (sumPenaltySum < this.sumConstraints[i3] * (1.0 - this.constraintTolerance)) {
                            ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(this.sumConstraints[i3] * (1.0 - this.constraintTolerance) - sumPenaltySum);
                            test = false;
                        }
                        if (!(sumPenaltySum > this.sumConstraints[i3] * (1.0 + this.constraintTolerance))) continue block12;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(sumPenaltySum - this.sumConstraints[i3] * (1.0 + this.constraintTolerance));
                        test = false;
                        continue block12;
                    }
                    case 1: {
                        if (!(sumPenaltySum > this.sumConstraints[i3])) continue block12;
                        ss = tempFunctVal + this.penaltyWeight * MathBase.sqr(sumPenaltySum - this.sumConstraints[i3]);
                        test = false;
                    }
                }
            }
        }
        if (test) {
            if (regFun instanceof Function) {
                ((Function)regFun).setFitterMode(true);
                Function func = (Function)regFun;
                for (i = 0; i < func.getParameterCount(); ++i) {
                    if (func.isParameterFixed(i)) continue;
                    func.setParameterValue(i, param[i]);
                }
            }
            ss = 0.0;
            if (!this.multipleY) {
                Function1D g1 = (Function1D)regFun;
                for (i = 0; i < this.nData; ++i) {
                    for (int j = 0; j < this.nXarrays; ++j) {
                        xd[j] = this.xData[j][i];
                    }
                    ss += MathBase.sqr((this.yData[i] - g1.getValue(xd[0])) / this.weight[i]);
                }
            } else {
                FunctionND g2 = (FunctionND)regFun;
                int dimIn = g2.getInputDimension();
                int length = this.nData / dimIn;
                System.err.println("length = " + this.nData + " dim = " + dimIn);
                for (int i4 = 0; i4 < length; ++i4) {
                    for (int j = 0; j < this.nXarrays; ++j) {
                        xd[j] = this.xData[j][i4];
                    }
                    for (int dim = 0; dim < dimIn; ++dim) {
                        int index = dim * length + i4;
                        index = i4;
                        ss += MathBase.sqr((this.yData[index] - g2.getValue(xd, index)) / this.weight[index]);
                    }
                }
            }
            this.lastSSnoConstraint = ss;
            if (regFun instanceof Function) {
                ((Function)regFun).setFitterMode(false);
            }
        }
        return ss;
    }

    @Deprecated
    protected static ArrayList<Object> dataSign(double[] data) {
        ArrayList<Object> ret = new ArrayList<Object>();
        int n = data.length;
        double peak = 0.0;
        int peaki = -1;
        double shift = 0.0;
        double max = data[0];
        int maxi = 0;
        double min = data[0];
        int mini = 0;
        int signCheckPos = 0;
        int signCheckNeg = 0;
        int signCheckZero = 0;
        int signFlag = -1;
        double mean = 0.0;
        for (int i = 0; i < n; ++i) {
            mean = data[i];
            if (data[i] > max) {
                max = data[i];
                maxi = i;
            }
            if (data[i] < min) {
                min = data[i];
                mini = i;
            }
            if (data[i] == 0.0) {
                ++signCheckZero;
            }
            if (data[i] > 0.0) {
                ++signCheckPos;
            }
            if (!(data[i] < 0.0)) continue;
            ++signCheckNeg;
        }
        mean /= (double)n;
        if (signCheckZero + signCheckPos == n) {
            peak = max;
            peaki = maxi;
            signFlag = 0;
        } else if (signCheckZero + signCheckNeg == n) {
            peak = min;
            peaki = mini;
            signFlag = 1;
        } else {
            peak = max;
            peaki = maxi;
            if (-min > max) {
                peak = min;
                peaki = mini;
            }
            signFlag = 2;
            shift = -min;
        }
        ret.add(min);
        ret.add(mini);
        ret.add(max);
        ret.add(maxi);
        ret.add(peak);
        ret.add(peaki);
        ret.add(signFlag);
        ret.add(shift);
        ret.add(mean);
        return ret;
    }

    protected static double halfWidth(double[] xData, double[] yData) {
        double ymax = yData[0];
        int imax = 0;
        int n = xData.length;
        for (int i = 1; i < n; ++i) {
            if (!(yData[i] > ymax)) continue;
            ymax = yData[i];
            imax = i;
        }
        ymax /= 2.0;
        double halflow = -1.0;
        double temp = -1.0;
        int ihl = -1;
        if (imax > 0) {
            ihl = imax - 1;
            halflow = Math.abs(ymax - yData[ihl]);
            for (int i = imax - 2; i >= 0; --i) {
                temp = Math.abs(ymax - yData[i]);
                if (!(temp < halflow)) continue;
                halflow = temp;
                ihl = i;
            }
            halflow = Math.abs(xData[ihl] - xData[imax]);
        }
        double halfhigh = -1.0;
        temp = -1.0;
        int ihh = -1;
        if (imax < n - 1) {
            ihh = imax + 1;
            halfhigh = Math.abs(ymax - yData[ihh]);
            for (int i = imax + 2; i < n; ++i) {
                temp = Math.abs(ymax - yData[i]);
                if (!(temp < halfhigh)) continue;
                halfhigh = temp;
                ihh = i;
            }
            halfhigh = Math.abs(xData[ihh] - xData[imax]);
        }
        double halfw = 0.0;
        int nd = 0;
        if (ihl != -1) {
            halfw += halflow;
            ++nd;
        }
        if (ihh != -1) {
            halfw += halfhigh;
            ++nd;
        }
        return halfw /= (double)nd;
    }

    protected static boolean setTrueFreqWeights(double[] yData, double[] weight) {
        int ii;
        int nData = yData.length;
        boolean flag = true;
        for (ii = 0; ii < nData; ++ii) {
            weight[ii] = Math.sqrt(Math.abs(yData[ii]));
        }
        for (ii = 0; ii < nData; ++ii) {
            double last = 0.0;
            double next = 0.0;
            if (weight[ii] != 0.0) continue;
            boolean testLast = true;
            int iLast = ii - 1;
            while (testLast) {
                if (iLast < 0) {
                    testLast = false;
                    continue;
                }
                if (weight[iLast] == 0.0) {
                    --iLast;
                    continue;
                }
                last = weight[iLast];
                testLast = false;
            }
            boolean testNext = true;
            int iNext = ii + 1;
            while (testNext) {
                if (iNext >= nData) {
                    testNext = false;
                    continue;
                }
                if (weight[iNext] == 0.0) {
                    ++iNext;
                    continue;
                }
                next = weight[iNext];
                testNext = false;
            }
            weight[ii] = (last + next) / 2.0;
        }
        return true;
    }

    protected static void sort(double[] x, double[] y, double[] w) {
        int index = 0;
        int lastIndex = -1;
        int n = x.length;
        double holdx = 0.0;
        double holdy = 0.0;
        double holdw = 0.0;
        while (lastIndex < n - 1) {
            index = lastIndex + 1;
            for (int i = lastIndex + 2; i < n; ++i) {
                if (!(x[i] < x[index])) continue;
                index = i;
            }
            holdx = x[index];
            x[index] = x[++lastIndex];
            x[lastIndex] = holdx;
            holdy = y[index];
            y[index] = y[lastIndex];
            y[lastIndex] = holdy;
            holdw = w[index];
            w[index] = w[lastIndex];
            w[lastIndex] = holdw;
        }
    }
}

