/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.fitter;

import de.gsi.math.functions.Function;
import de.gsi.math.functions.Function1D;
import de.gsi.math.functions.PolynomialFunction;
import de.gsi.math.matrix.MatrixD;
import de.gsi.math.matrix.SingularValueDecomposition;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Random;

public class LinearRegressionFitter {
    private static final String NULL_FUNCTION_WARN = "function pointer is null/is not defined or fit hasn't been run yet";
    public static boolean USE_SVD = true;
    private MatrixD forwardMatrix;
    private MatrixD errorMatrix;
    private MatrixD inverseMatrix;
    private MatrixD errorPropagationMatrix;
    private Function1D function;
    private double[] xValuesRef;
    private double[] yValuesRef;
    private double fsvdCutOff = 1.0E-16;
    private double ftikhonov = 1.0;
    private REG_METHOD fregularisationMethod = REG_METHOD.STANDARD;
    private boolean useErrors;
    private boolean isConverged;
    private long lastPrepareDuration = -1L;
    private long lastFitDuration = -1L;
    private double chiSquared = -1.0;
    private boolean fisSilent = true;
    private MatrixD flastFitResult;
    private MatrixD flastFitError;

    public LinearRegressionFitter() {
        this.reinitialise();
    }

    public synchronized double[][] fit(Function func, double[] xValues, double[] yValues) {
        this.fitLocal(func, xValues, yValues);
        MatrixD valEstimate = this.forwardMatrix.times(this.flastFitResult);
        this.chiSquared = 0.0;
        double[] yValuesPred = new double[this.yValuesRef.length];
        double[] yValuesPredError = new double[this.yValuesRef.length];
        for (int i = 0; i < yValuesPred.length; ++i) {
            yValuesPred[i] = valEstimate.get(i, 0);
        }
        MatrixD error2 = this.flastFitError.copy();
        MatrixD errEstimate = this.errorPropagationMatrix.times(error2);
        for (int i = 0; i < yValuesPred.length; ++i) {
            yValuesPredError[i] = Math.sqrt(errEstimate.get(i, 0));
        }
        return new double[][]{this.xValuesRef, yValuesPred, yValuesPredError};
    }

    public synchronized void fit(Function func, Function returnFunction, double[] xValues, double[] yValues) {
        int p2;
        this.fitLocal(func, xValues, yValues);
        if (returnFunction == null) {
            throw new InvalidParameterException("LinearRegressionFitter::fit(Function, Function, double[], double[]) - return function pointer is null");
        }
        int p1 = func.getParameterCount();
        if (p1 >= (p2 = returnFunction.getParameterCount())) {
            throw new InvalidParameterException("LinearRegressionFitter::fit(Function, Function, double[], double[]) - return parameter function has insufficient parameter count (" + p2 + " vs. required " + p1);
        }
        for (int i = 0; i < func.getParameterCount(); ++i) {
            double value = this.getParameter(i);
            double error = this.getParError(i);
            returnFunction.setParameterValue(i, value);
            returnFunction.setParameterRange(i, value - error, value + error);
        }
    }

    private synchronized void fitLocal(Function func, double[] xValues, double[] yValues) {
        String funcName = "RegressionFitter::fit(Function,";
        String funcNameEmpty = "RegressionFitter::fit(Function, double[], double[]) - ";
        if (func == null) {
            throw new InvalidParameterException("RegressionFitter::fit(Function, double[], double[]) - function pointer is null");
        }
        if (xValues == null || yValues == null) {
            throw new InvalidParameterException("RegressionFitter::fit(Function," + (xValues != null ? "double[]" : "null") + ", " + (yValues != null ? "double[]" : "null") + ") - array pointer are null");
        }
        if (xValues.length != yValues.length) {
            throw new InvalidParameterException("RegressionFitter::fit(Function,double[" + xValues.length + "], double[" + yValues.length + "]) - array pointer size mis-match");
        }
        if (func.getInputDimension() != 1) {
            throw new InvalidParameterException("RegressionFitter::fit(Function, double[], double[]) -  for the time being: only one dimensional fits implemented");
        }
        if (func.getFreeParameterCount() > yValues.length) {
            throw new InvalidParameterException("RegressionFitter::fit(Function, double[], double[]) -  cannot fit function with more free parameters than data points (" + func.getParameterCount() + " vs. " + yValues.length + ")");
        }
        long start = System.currentTimeMillis();
        this.reinitialise();
        boolean recomputeMatrices = true;
        this.function = (Function1D)func;
        this.xValuesRef = Arrays.copyOf(xValues, xValues.length);
        this.yValuesRef = Arrays.copyOf(yValues, yValues.length);
        double[] localPar = new double[this.function.getParameterCount()];
        for (int i = 0; i < localPar.length; ++i) {
            localPar[i] = this.function.getParameterValue(i);
        }
        this.function.setFitterMode(true);
        if (recomputeMatrices) {
            double[][] temp = new double[this.yValuesRef.length][this.function.getParameterCount()];
            for (int i = 0; i < this.xValuesRef.length; ++i) {
                double x = xValues[i];
                for (int j = 0; j < this.function.getParameterCount(); ++j) {
                    if (!this.function.isParameterFixed(j)) {
                        this.function.clearParameterValues();
                        this.function.setParameterValue(j, 1.0);
                        temp[i][j] = this.function.getValue(x);
                        continue;
                    }
                    temp[i][j] = 0.0;
                }
            }
            this.function.clearParameterValues();
            this.forwardMatrix = new MatrixD(temp);
            this.errorPropagationMatrix = (MatrixD)this.forwardMatrix.clone();
            this.errorPropagationMatrix.squareElements();
            if (USE_SVD) {
                SingularValueDecomposition decomp = this.forwardMatrix.svd();
                double[] sig = decomp.getSingularValues();
                MatrixD newS = new MatrixD(sig.length, sig.length);
                double first = sig[0];
                switch (this.fregularisationMethod) {
                    case TIKHONOV: {
                        int i;
                        for (i = 0; i < sig.length; ++i) {
                            if (sig[i] != 0.0) {
                                if (this.ftikhonov > 0.0) {
                                    newS.set(i, i, sig[i] / (sig[i] * sig[i] + this.ftikhonov * this.ftikhonov));
                                    continue;
                                }
                                if (Math.abs(sig[i]) > 1.0E-16) {
                                    newS.set(i, i, 1.0 / sig[i]);
                                    continue;
                                }
                                newS.set(i, i, 0.0);
                                if (this.fisSilent) continue;
                                System.out.println("drop singluar eigenvalue " + i);
                                continue;
                            }
                            newS.set(i, i, 0.0);
                            if (this.fisSilent) continue;
                            System.out.println("drop singluar eigenvalue " + i);
                        }
                        break;
                    }
                    default: {
                        int i;
                        for (i = 0; i < sig.length; ++i) {
                            if (sig[i] / first < this.fsvdCutOff || sig[i] < 1.0E-16) {
                                if (!this.fisSilent) {
                                    System.out.println("drop singluar eigenvalue " + i);
                                }
                                newS.set(i, i, 0.0);
                                continue;
                            }
                            newS.set(i, i, 1.0 / sig[i]);
                        }
                        decomp.rank();
                    }
                }
                this.inverseMatrix = decomp.getV().times(newS).times(decomp.getU().transpose());
            } else {
                this.inverseMatrix = this.forwardMatrix.inverse();
            }
            this.errorMatrix = (MatrixD)this.inverseMatrix.clone();
            this.errorMatrix.squareElements();
        }
        this.function.setFitterMode(false);
        this.flastFitResult = this.inverseMatrix.times(new MatrixD(yValues, yValues.length));
        if (this.flastFitResult == null) {
            throw new IllegalArgumentException("could not generate fit results: null-vector");
        }
        this.chiSquared = 0.0;
        double[] yValuesPred = new double[this.yValuesRef.length];
        MatrixD valEstimate = this.forwardMatrix.times(this.flastFitResult);
        for (int i = 0; i < this.yValuesRef.length; ++i) {
            yValuesPred[i] = valEstimate.get(i, 0);
            this.chiSquared += Math.pow(yValuesPred[i], 2.0) / Math.abs(this.yValuesRef[i]);
        }
        MatrixD errorVector = new MatrixD(yValuesPred, yValuesPred.length);
        this.flastFitError = this.errorMatrix.times(errorVector);
        this.isConverged = true;
        long stop = System.currentTimeMillis();
        this.lastPrepareDuration = stop - start;
        this.lastFitDuration = stop - start;
        if (!this.fisSilent) {
            for (int i = 0; i < this.function.getParameterCount(); ++i) {
                System.out.printf("parameter %d (orig. vs. fit.): %+f vs. %+f ( %+f <-> %+f) \n", i, this.function.getParameterValue(i), this.flastFitResult.get(i, 0), Math.abs(this.function.getParameterValue(i) - this.flastFitResult.get(i, 0)) / this.function.getParameterValue(i), this.flastFitError.get(i, 0) / this.function.getParameterValue(i));
            }
        }
    }

    public double[] getBestEstimates() {
        if (this.flastFitResult == null) {
            throw new InvalidParameterException("LinearRegressionFitter::getBestEstimates() - function pointer is null/is not defined or fit hasn't been run yet");
        }
        double[] ret = new double[this.flastFitResult.getRowDimension()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.flastFitResult.get(i, 0);
        }
        return ret;
    }

    public double[] getBestEstimatesErrors() {
        if (this.flastFitError == null) {
            throw new InvalidParameterException("LinearRegressionFitter::getBestEstimatesErrors() - function pointer is null/is not defined or fit hasn't been run yet");
        }
        double[] ret = new double[this.flastFitError.getRowDimension()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.flastFitError.get(i, 0);
        }
        return ret;
    }

    public double getChiSquared() {
        return this.chiSquared;
    }

    public long getLastFitDuration() {
        return this.lastFitDuration;
    }

    public long getLastPrepareDuration() {
        return this.lastPrepareDuration;
    }

    public double getParameter(int index) {
        if (this.flastFitResult == null) {
            throw new InvalidParameterException("LinearRegressionFitter::getParameter(int) - function pointer is null/is not defined or fit hasn't been run yet");
        }
        if (index < 0 || index >= this.flastFitResult.getRowDimension()) {
            throw new InvalidParameterException("LinearRegressionFitter::getParameter(" + index + ") - requested invalid parameter index [0," + this.flastFitResult.getRowDimension() + "]");
        }
        return this.flastFitResult.get(index, 0);
    }

    public double getParError(int index) {
        if (this.flastFitError == null) {
            throw new InvalidParameterException("LinearRegressionFitter::getParameter(int) - function pointer is null/is not defined or fit hasn't been run yet");
        }
        if (index < 0 || index >= this.flastFitError.getRowDimension()) {
            throw new InvalidParameterException("LinearRegressionFitter::getParameter(" + index + ") - requested invalid parameter index [0," + this.flastFitError.getRowDimension() + "]");
        }
        return this.flastFitError.get(index, 0);
    }

    public REG_METHOD getRegularisationMethod() {
        return this.fregularisationMethod;
    }

    public double getSVDCutOff() {
        return this.fsvdCutOff;
    }

    public double getTikhonovRegularisation() {
        return this.ftikhonov;
    }

    public boolean isConverged() {
        return this.isConverged;
    }

    public boolean isErrorWeighting() {
        return this.useErrors;
    }

    public boolean isSilent() {
        return this.fisSilent;
    }

    private void reinitialise() {
        this.forwardMatrix = null;
        this.errorMatrix = null;
        this.inverseMatrix = null;
        this.errorPropagationMatrix = null;
        this.function = null;
        this.xValuesRef = null;
        this.yValuesRef = null;
        this.useErrors = false;
        this.isConverged = false;
        this.lastPrepareDuration = -1L;
        this.lastFitDuration = -1L;
        this.chiSquared = -1.0;
    }

    public void setErrorWeighting(boolean state) {
        this.useErrors = state;
    }

    public void setRegularisationMethod(REG_METHOD method) {
        this.fregularisationMethod = method;
    }

    public void setSVDCutOff(double cutOff) {
        this.fsvdCutOff = cutOff;
    }

    public void setTikhonovRegularisation(double cutOff) {
        this.ftikhonov = cutOff;
    }

    public void setVerbosity(boolean state) {
        this.fisSilent = !state;
    }

    public static void main(String[] args) {
        PolynomialFunction func = new PolynomialFunction("poly1", new double[]{0.5, 1.0, 2.0, 0.6, 1.0E-4});
        double[] xValues = new double[20];
        double[] yValues = new double[20];
        Random rnd = new Random();
        for (int i = 0; i < xValues.length; ++i) {
            double error = 1.0 * rnd.nextGaussian();
            xValues[i] = (double)i - (double)xValues.length / 2.0;
            yValues[i] = func.getValue(xValues[i]) + 0.1 * error;
        }
        func.fixParameter(0, true);
        LinearRegressionFitter fitter = new LinearRegressionFitter();
        fitter.fit(func, xValues, yValues);
        System.out.println("ellapsed time " + fitter.getLastFitDuration() + " ms,  ch2 = " + fitter.getChiSquared());
    }

    public static enum REG_METHOD {
        STANDARD,
        TIKHONOV;

    }
}

