/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.filter.iir;

import de.gsi.math.filter.iir.ComplexPair;
import de.gsi.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public class LayoutBase {
    private int mNumPoles;
    private PoleZeroPair[] mPair;
    private double mNormalW;
    private double mNormalGain;

    public LayoutBase(int numPoles) {
        this.mNumPoles = 0;
        this.mPair = numPoles % 2 == 1 ? new PoleZeroPair[numPoles / 2 + 1] : new PoleZeroPair[numPoles / 2];
    }

    public LayoutBase(PoleZeroPair ... pairs) {
        this.mNumPoles = pairs.length * 2;
        this.mPair = pairs;
    }

    public void add(Complex pole, Complex zero) {
        this.mPair[this.mNumPoles / 2] = new PoleZeroPair(pole, zero);
        ++this.mNumPoles;
    }

    public void add(ComplexPair poles, ComplexPair zeros) {
        this.mPair[this.mNumPoles / 2] = new PoleZeroPair(poles.first, zeros.first, poles.second, zeros.second);
        this.mNumPoles += 2;
    }

    public void addPoleZeroConjugatePairs(Complex pole, Complex zero) {
        if (pole == null) {
            throw new IllegalArgumentException("LayoutBase addConj() pole == null");
        }
        if (zero == null) {
            throw new IllegalArgumentException("LayoutBase addConj() zero == null");
        }
        this.mPair[this.mNumPoles / 2] = new PoleZeroPair(pole, zero, pole.conjugate(), zero.conjugate());
        this.mNumPoles += 2;
    }

    public double getNormalGain() {
        return this.mNormalGain;
    }

    public double getNormalW() {
        return this.mNormalW;
    }

    public int getNumPoles() {
        return this.mNumPoles;
    }

    public PoleZeroPair getPair(int pairIndex) {
        return this.mPair[pairIndex];
    }

    public void reset() {
        this.mNumPoles = 0;
    }

    public void setNormal(double w, double g) {
        this.mNormalW = w;
        this.mNormalGain = g;
    }
}

