/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.filter.iir;

import de.gsi.math.filter.iir.BandPassTransform;
import de.gsi.math.filter.iir.BandStopTransform;
import de.gsi.math.filter.iir.Cascade;
import de.gsi.math.filter.iir.HighPassTransform;
import de.gsi.math.filter.iir.LayoutBase;
import de.gsi.math.filter.iir.LowPassTransform;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.complex.ComplexUtils;

public class Butterworth
extends Cascade {
    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, 1);
    }

    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, directFormType);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, 1);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, directFormType);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, 1);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, directFormType);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, 1);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, directFormType);
    }

    private void setupBandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design();
        LayoutBase digitalProto = new LayoutBase(order * 2);
        BandPassTransform.transform(centerFrequency / sampleRate, widthFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private void setupBandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design();
        LayoutBase digitalProto = new LayoutBase(order * 2);
        BandStopTransform.transform(centerFrequency / sampleRate, widthFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private void setupHighPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design();
        LayoutBase digitalProto = new LayoutBase(order);
        HighPassTransform.transform(cutoffFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private void setupLowPass(int order, double sampleRate, double cutoffFrequency, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design();
        LayoutBase digitalProto = new LayoutBase(order);
        LowPassTransform.transform(cutoffFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private class AnalogLowPass
    extends LayoutBase {
        private final int nPoles;

        public AnalogLowPass(int nPoles) {
            super(nPoles);
            this.nPoles = nPoles;
            this.setNormal(0.0, 1.0);
        }

        public void design() {
            this.reset();
            double n2 = 2.0 * (double)this.nPoles;
            int pairs = this.nPoles / 2;
            for (int i = 0; i < pairs; ++i) {
                Complex c = ComplexUtils.polar2Complex((double)1.0, (double)(1.5707963267948966 + (double)(2 * i + 1) * Math.PI / n2));
                this.addPoleZeroConjugatePairs(c, Complex.INF);
            }
            if ((this.nPoles & 1) == 1) {
                this.add(new Complex(-1.0), Complex.INF);
            }
        }
    }
}

