/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.math.Math;
import de.gsi.math.MathBase;
import java.util.Arrays;

public final class SimpleDataSetEstimators {
    private SimpleDataSetEstimators() {
    }

    public static double computeCentreOfMass(DataSet dataSet) {
        return SimpleDataSetEstimators.computeCentreOfMass(dataSet, 0, dataSet.getDataCount());
    }

    public static double computeCentreOfMass(DataSet dataSet, double min, double max) {
        AssertUtils.gtOrEqual((String)"max must be greater than min", (double)min, (double)max);
        return SimpleDataSetEstimators.computeCentreOfMass(dataSet, dataSet.getIndex(0, new double[]{min}), dataSet.getIndex(0, new double[]{max}));
    }

    public static double computeCentreOfMass(DataSet dataSet, int minIndex, int maxIndex) {
        AssertUtils.gtEqThanZero((String)"minIndex", (int)minIndex);
        AssertUtils.gtOrEqual((String)"maxIndex must be smaller than dataCount()", (int)maxIndex, (int)dataSet.getDataCount());
        double com = 0.0;
        double mass = 0.0;
        for (int i = minIndex; i < maxIndex; ++i) {
            double freq = dataSet.get(0, i);
            double val = dataSet.get(1, i);
            if (!Double.isFinite(freq) || !Double.isFinite(val)) continue;
            com += freq * val;
            mass += val;
        }
        return com / mass;
    }

    public static double computeFWHM(double[] data, int length, int index) {
        int lowerLimit;
        int upperLimit;
        if (index <= 0 || index >= length - 1) {
            return Double.NaN;
        }
        double maxHalf = 0.5 * data[index];
        for (upperLimit = index; upperLimit < length && data[upperLimit] > maxHalf; ++upperLimit) {
        }
        for (lowerLimit = index; lowerLimit >= 0 && data[lowerLimit] > maxHalf; --lowerLimit) {
        }
        if (upperLimit >= length || lowerLimit < 0) {
            return Double.NaN;
        }
        return upperLimit - lowerLimit;
    }

    public static double computeInterpolatedFWHM(double[] data, int length, int index) {
        int lowerLimit;
        int upperLimit;
        if (index <= 0 || index >= length - 1) {
            return Double.NaN;
        }
        double maxHalf = 0.5 * data[index];
        for (upperLimit = index; upperLimit < length && data[upperLimit] > maxHalf; ++upperLimit) {
        }
        for (lowerLimit = index; lowerLimit >= 0 && data[lowerLimit] > maxHalf; --lowerLimit) {
        }
        if (upperLimit >= length || lowerLimit < 0) {
            return Double.NaN;
        }
        double lowerLimitRefined = SimpleDataSetEstimators.linearInterpolate(lowerLimit, (double)lowerLimit + 1.0, data[lowerLimit], data[lowerLimit + 1], maxHalf);
        double upperLimitRefined = SimpleDataSetEstimators.linearInterpolate((double)upperLimit - 1.0, upperLimit, data[upperLimit - 1], data[upperLimit], maxHalf);
        return upperLimitRefined - lowerLimitRefined;
    }

    public static double getDistance(DataSet dataSet, int indexMin, int indexMax, boolean isHorizontal) {
        return isHorizontal ? dataSet.get(0, indexMax) - dataSet.get(0, indexMin) : dataSet.get(1, indexMax) - dataSet.get(1, indexMin);
    }

    public static double[] getDoubleArray(DataSet dataSet, int indexMin, int indexMax) {
        if (indexMax - indexMin <= 0) {
            return new double[0];
        }
        double[] ret = new double[indexMax - indexMin];
        int count = 0;
        for (int index = indexMin; index < indexMax; ++index) {
            double actual;
            ret[count] = actual = dataSet.get(1, index);
            ++count;
        }
        return ret;
    }

    public static double getDutyCycle(DataSet dataSet, int indexMin, int indexMax) {
        double minVal = SimpleDataSetEstimators.getMinimum(dataSet, indexMin, indexMax);
        double maxVal = SimpleDataSetEstimators.getMaximum(dataSet, indexMin, indexMax);
        double range = Math.abs(maxVal - minVal);
        int countLow = 0;
        int countHigh = 0;
        double thresholdMin = minVal + 0.45 * range;
        double thresholdMax = minVal + 0.55 * range;
        for (int index = indexMin; index < indexMax; ++index) {
            double actual = dataSet.get(1, index);
            if (!Double.isFinite(actual)) continue;
            if (actual < thresholdMin) {
                ++countLow;
            }
            if (!(actual > thresholdMax)) continue;
            ++countHigh;
        }
        if (countLow + countHigh == 0) {
            return Double.NaN;
        }
        return (double)countHigh / (double)(countLow + countHigh);
    }

    public static double getEdgeDetect(DataSet dataSet, int indexMin, int indexMax) {
        if (dataSet.getDataCount() == 0 || indexMin == indexMax) {
            return Double.NaN;
        }
        double minVal = SimpleDataSetEstimators.getMinimum(dataSet, indexMin, indexMax);
        double maxVal = SimpleDataSetEstimators.getMaximum(dataSet, indexMin, indexMax);
        double range = Math.abs(maxVal - minVal);
        if (range == 0.0) {
            return Double.NaN;
        }
        boolean inverted = dataSet.get(1, indexMin) > dataSet.get(1, indexMax - 1);
        double startTime = dataSet.get(0, indexMin);
        if (inverted) {
            for (int index = indexMin; index < indexMax; ++index) {
                double actual = dataSet.get(1, index);
                if (!Double.isFinite(actual) || !(actual < maxVal - 0.5 * range)) continue;
                return dataSet.get(0, index) - startTime;
            }
        } else {
            for (int index = indexMin; index < indexMax; ++index) {
                double actual = dataSet.get(1, index);
                if (!Double.isFinite(actual) || !(actual > minVal + 0.5 * range)) continue;
                return dataSet.get(0, index) - startTime;
            }
        }
        return Double.NaN;
    }

    public static double getFrequencyEstimate(DataSet dataSet, int indexMin, int indexMax) {
        double minVal = SimpleDataSetEstimators.getMinimum(dataSet, indexMin, indexMax);
        double maxVal = SimpleDataSetEstimators.getMaximum(dataSet, indexMin, indexMax);
        double range = Math.abs(maxVal - minVal);
        double thresholdMin = minVal + 0.45 * range;
        double thresholdMax = minVal + 0.55 * range;
        double startRisingEdge = Double.NaN;
        double startFallingEdge = Double.NaN;
        double avgPeriod = 0.0;
        int avgPeriodCount = 0;
        double actualState = 0.0;
        for (int index = indexMin; index < indexMax; ++index) {
            double period;
            double time;
            double actual = dataSet.get(1, index);
            if (!Double.isFinite(actual)) continue;
            if (actualState < 0.5) {
                if (!(actual > thresholdMax)) continue;
                actualState = 1.0;
                time = dataSet.get(0, index);
                if (Double.isFinite(startRisingEdge)) {
                    period = time - startRisingEdge;
                    startRisingEdge = time;
                    avgPeriod += period;
                    ++avgPeriodCount;
                    continue;
                }
                startRisingEdge = time;
                continue;
            }
            if (!(actual < thresholdMin)) continue;
            actualState = 0.0;
            time = dataSet.get(0, index);
            if (Double.isFinite(startFallingEdge)) {
                period = time - startFallingEdge;
                startFallingEdge = time;
                avgPeriod += period;
                ++avgPeriodCount;
                continue;
            }
            startFallingEdge = time;
        }
        if (avgPeriodCount == 0) {
            return Double.NaN;
        }
        return (double)avgPeriodCount / avgPeriod;
    }

    public static double getFullWidthHalfMaximum(DataSet dataSet, int indexMin, int indexMax, boolean interpolate) {
        int locationMaximum = SimpleDataSetEstimators.getLocationMaximum(dataSet, indexMin, indexMax);
        if (locationMaximum <= indexMin + 1 || locationMaximum >= indexMax - 1) {
            return Double.NaN;
        }
        double[] data = SimpleDataSetEstimators.getDoubleArray(dataSet, indexMin, indexMax);
        AssertUtils.gtThanZero((String)"data.length", (int)data.length);
        if (interpolate) {
            return SimpleDataSetEstimators.computeInterpolatedFWHM(data, data.length, locationMaximum - indexMin);
        }
        return SimpleDataSetEstimators.computeFWHM(data, data.length, locationMaximum - indexMin);
    }

    public static double getIntegral(DataSet dataSet, int indexMin, int indexMax) {
        double sign = MathBase.sign(1.0, indexMax - indexMin);
        double integral = 0.0;
        for (int index = Math.min(indexMin, indexMax); index < Math.max(indexMin, indexMax) - 1; ++index) {
            double y1;
            double y0;
            double x0 = dataSet.get(0, index);
            double x1 = dataSet.get(0, index + 1);
            double localIntegral = (x1 - x0) * 0.5 * ((y0 = dataSet.get(1, index)) + (y1 = dataSet.get(1, index + 1)));
            if (!Double.isFinite(localIntegral)) continue;
            integral += localIntegral;
        }
        return sign * integral;
    }

    public static int getLocationMaximum(DataSet dataSet, int indexMin, int indexMax) {
        int locMax = -1;
        double maxVal = -1.7976931348623157E308;
        for (int index = indexMin; index < indexMax; ++index) {
            double actual = dataSet.get(1, index);
            if (!Double.isFinite(actual) || !(actual > maxVal)) continue;
            maxVal = actual;
            locMax = index;
        }
        return locMax;
    }

    public static double getLocationMaximumGaussInterpolated(DataSet dataSet, int indexMin, int indexMax) {
        int locationMaximum = SimpleDataSetEstimators.getLocationMaximum(dataSet, indexMin, indexMax);
        if (locationMaximum <= indexMin + 1 || locationMaximum >= indexMax - 1) {
            return Double.NaN;
        }
        double[] data = SimpleDataSetEstimators.getDoubleArray(dataSet, indexMin, indexMax);
        if (data.length == 0) {
            return Double.NaN;
        }
        double refinedValue = (double)indexMin + SimpleDataSetEstimators.interpolateGaussian(data, data.length, locationMaximum - indexMin) - (double)locationMaximum;
        double valX0 = dataSet.get(0, locationMaximum);
        double valX1 = dataSet.get(0, locationMaximum + 1);
        double diff = valX1 - valX0;
        return valX0 + refinedValue * diff;
    }

    public static double getMaximum(DataSet dataSet, int indexMin, int indexMax) {
        double val = -1.7976931348623157E308;
        for (int index = indexMin; index < indexMax; ++index) {
            double actual = dataSet.get(1, index);
            if (!Double.isFinite(actual)) continue;
            val = Math.max(val, actual);
        }
        return val;
    }

    public static double getMean(DataSet dataSet, int indexMin, int indexMax) {
        double val = 0.0;
        int count = 0;
        for (int index = indexMin; index < indexMax; ++index) {
            double actual = dataSet.get(1, index);
            if (!Double.isFinite(actual)) continue;
            val += actual;
            ++count;
        }
        if (count > 0) {
            return val / (double)count;
        }
        return Double.NaN;
    }

    public static double getMedian(DataSet dataSet, int indexMin, int indexMax) {
        double[] data = SimpleDataSetEstimators.getDoubleArray(dataSet, indexMin, indexMax);
        if (data.length == 0) {
            return Double.NaN;
        }
        return SimpleDataSetEstimators.median(data, data.length);
    }

    public static double getMinimum(DataSet dataSet, int indexMin, int indexMax) {
        double val = Double.MAX_VALUE;
        for (int index = indexMin; index < indexMax; ++index) {
            double actual = dataSet.get(1, index);
            if (!Double.isFinite(actual)) continue;
            val = Math.min(val, actual);
        }
        return val;
    }

    public static double getRange(DataSet dataSet, int indexMin, int indexMax) {
        if (dataSet.getDataCount() == 0) {
            return Double.NaN;
        }
        double valMin = Double.NaN;
        double valMax = Double.NaN;
        for (int index = indexMin; index < indexMax; ++index) {
            double actual = dataSet.get(1, index);
            if (Double.isNaN(actual)) continue;
            valMax = Double.isNaN(valMax) ? actual : Math.max(valMax, actual);
            valMin = Double.isNaN(valMin) ? actual : Math.min(valMin, actual);
        }
        return Math.abs(valMax - valMin);
    }

    public static double getRms(DataSet dataSet, int indexMin, int indexMax) {
        double[] data = SimpleDataSetEstimators.getDoubleArray(dataSet, indexMin, indexMax);
        if (data.length == 0) {
            return Double.NaN;
        }
        return SimpleDataSetEstimators.rootMeanSquare(data, data.length);
    }

    public static double getSimpleRiseTime(DataSet dataSet, int indexMin, int indexMax) {
        return SimpleDataSetEstimators.getSimpleRiseTime2080(dataSet, indexMin, indexMax);
    }

    public static double getSimpleRiseTime(DataSet dataSet, int indexMin, int indexMax, double min, double max) {
        if (!Double.isFinite(min) || min < 0.0 || min > 1.0 || !Double.isFinite(max) || max < 0.0 || max > 1.0 || max <= min) {
            throw new IllegalArgumentException("[min=" + min + ",max=" + max + "] must be within [0.0, 1.0]");
        }
        double minVal = SimpleDataSetEstimators.getMinimum(dataSet, indexMin, indexMax);
        double maxVal = SimpleDataSetEstimators.getMaximum(dataSet, indexMin, indexMax);
        double range = Math.abs(maxVal - minVal);
        boolean inverted = dataSet.get(1, indexMin) > dataSet.get(1, indexMax);
        double startTime = dataSet.get(0, indexMin);
        double stopTime = dataSet.get(0, indexMax);
        boolean foundStartRising = false;
        if (inverted) {
            for (int index = indexMin; index < indexMax; ++index) {
                double actual = dataSet.get(1, index);
                if (!Double.isFinite(actual)) continue;
                if (!foundStartRising && actual < maxVal - min * range) {
                    startTime = dataSet.get(0, index);
                    foundStartRising = true;
                    continue;
                }
                if (!foundStartRising || !(actual < maxVal - max * range)) continue;
                stopTime = dataSet.get(0, index);
                break;
            }
        } else {
            for (int index = indexMin; index < indexMax; ++index) {
                double actual = dataSet.get(1, index);
                if (!Double.isFinite(actual)) continue;
                if (!foundStartRising && actual > minVal + min * range) {
                    startTime = dataSet.get(0, index);
                    foundStartRising = true;
                    continue;
                }
                if (!foundStartRising || !(actual > minVal + max * range)) continue;
                stopTime = dataSet.get(0, index);
                break;
            }
        }
        return stopTime - startTime;
    }

    public static double getSimpleRiseTime1090(DataSet dataSet, int indexMin, int indexMax) {
        return SimpleDataSetEstimators.getSimpleRiseTime(dataSet, indexMin, indexMax, 0.1, 0.9);
    }

    public static double getSimpleRiseTime2080(DataSet dataSet, int indexMin, int indexMax) {
        return SimpleDataSetEstimators.getSimpleRiseTime(dataSet, indexMin, indexMax, 0.2, 0.8);
    }

    public static double getTransmission(DataSet dataSet, int indexMin, int indexMax, boolean isAbsoluteTransmission) {
        double valRef = dataSet.get(1, indexMin);
        double val = dataSet.get(1, indexMax);
        return (isAbsoluteTransmission ? val : val - valRef) / valRef * 100.0;
    }

    public static double getZeroCrossing(DataSet dataSet, double threshold) {
        int nLength = dataSet.getDataCount();
        if (nLength == 0) {
            return Double.NaN;
        }
        double initialValue = dataSet.get(1, 0);
        if (initialValue < threshold) {
            for (int i = 0; i < nLength; ++i) {
                double y = dataSet.get(1, i);
                if (!Double.isFinite(y) || !(y >= threshold)) continue;
                return dataSet.get(0, i);
            }
        } else if (initialValue > threshold) {
            for (int i = 0; i < nLength; ++i) {
                double y = dataSet.get(1, i);
                if (!Double.isFinite(y) || !(y <= threshold)) continue;
                return dataSet.get(0, i);
            }
        } else {
            return dataSet.get(0, 0);
        }
        return Double.NaN;
    }

    public static double interpolateGaussian(double[] data, int length, int index) {
        if (index <= 0 || index >= length - 1) {
            return index;
        }
        double left = Math.pow(data[index - 1], 1.0);
        double center = Math.pow(data[index - 0], 1.0);
        double right = Math.pow(data[index + 1], 1.0);
        double val = index;
        return val += 0.5 * Math.log(right / left) / Math.log(Math.pow(center, 2.0) / (left * right));
    }

    public static double linearInterpolate(double x0, double x1, double y0, double y1, double y) {
        return x0 + (y - y0) * (x1 - x0) / (y1 - y0);
    }

    private static synchronized double median(double[] data, int length) {
        double[] temp = SimpleDataSetEstimators.sort(data, length, false);
        if (length % 2 == 0) {
            return 0.5 * (temp[length / 2] + temp[length / 2 + 1]);
        }
        return temp[length / 2];
    }

    protected static double rootMeanSquare(double[] data, int length) {
        AssertUtils.notNull((String)"data", (Object)data);
        AssertUtils.indexInBounds((int)length, (int)(data.length + 1), (String)"length must be inside bounds of data");
        if (length == 0) {
            return Double.NaN;
        }
        double norm = 1.0 / (double)length;
        double val1 = 0.0;
        double val2 = 0.0;
        for (int i = 0; i < length; ++i) {
            val1 += data[i];
            val2 += data[i] * data[i];
        }
        return Math.sqrt(Math.abs((val2 *= norm) - (val1 *= norm) * val1));
    }

    protected static synchronized double[] sort(double[] a, int length, boolean down) {
        if (a == null || a.length <= 0) {
            return new double[0];
        }
        if (length > a.length) {
            throw new IllegalArgumentException("length must be smaller or equal to the size of the input array");
        }
        double[] index = Arrays.copyOf(a, length);
        Arrays.sort(index);
        if (down) {
            int nlast = length - 1;
            for (int i = 0; i < length / 2; ++i) {
                double temp = index[i];
                index[i] = index[nlast - i];
                index[nlast - i] = temp;
            }
        }
        return index;
    }
}

