/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

import de.gsi.dataset.utils.AssertUtils;
import de.gsi.math.ArrayUtils;
import de.gsi.math.Math;
import de.gsi.math.MathBase;

public class ArrayMath {
    protected static final String DIVISOR = "divisor";
    protected static final String IN = "in";
    protected static final String MULTIPLICATOR = "multiplicator";
    protected static final String VALUE = "value";

    ArrayMath() {
        throw new IllegalStateException("Utility class");
    }

    public static double[] add(double[] in, double value) {
        return ArrayMath.add(in, 0, value, in.length);
    }

    public static double[] add(double[] in, double[] value) {
        return ArrayMath.add(in, 0, value, 0, in.length);
    }

    public static double[] add(double[] in, int offsetIn, double[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offsetIn] + value[i + offsetValue];
        }
        return ret;
    }

    public static double[] add(double[] in, int offset, double value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] + value;
        }
        return ret;
    }

    public static double[] addInPlace(double[] in, double value) {
        return ArrayMath.addInPlace(in, 0, value, in.length);
    }

    public static double[] addInPlace(double[] in, double[] value) {
        return ArrayMath.addInPlace(in, 0, value, 0, in.length);
    }

    public static double[] addInPlace(double[] in, int offsetIn, double[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] + value[i + offsetValue];
        }
        return in;
    }

    public static double[] addInPlace(double[] in, int offset, double value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] + value;
        }
        return in;
    }

    public static float[] add(float[] in, float value) {
        return ArrayMath.add(in, 0, value, in.length);
    }

    public static float[] add(float[] in, float[] value) {
        return ArrayMath.add(in, 0, value, 0, in.length);
    }

    public static float[] add(float[] in, int offsetIn, float[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offsetIn] + value[i + offsetValue];
        }
        return ret;
    }

    public static float[] add(float[] in, int offset, float value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] + value;
        }
        return ret;
    }

    public static float[] addInPlace(float[] in, float value) {
        return ArrayMath.addInPlace(in, 0, value, in.length);
    }

    public static float[] addInPlace(float[] in, float[] value) {
        return ArrayMath.addInPlace(in, 0, value, 0, in.length);
    }

    public static float[] addInPlace(float[] in, int offsetIn, float[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] + value[i + offsetValue];
        }
        return in;
    }

    public static float[] addInPlace(float[] in, int offset, float value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] + value;
        }
        return in;
    }

    public static int[] add(int[] in, int value) {
        return ArrayMath.add(in, 0, value, in.length);
    }

    public static int[] add(int[] in, int[] value) {
        return ArrayMath.add(in, 0, value, 0, in.length);
    }

    public static int[] add(int[] in, int offsetIn, int[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offsetIn] + value[i + offsetValue];
        }
        return ret;
    }

    public static int[] add(int[] in, int offset, int value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] + value;
        }
        return ret;
    }

    public static int[] addInPlace(int[] in, int value) {
        return ArrayMath.addInPlace(in, 0, value, in.length);
    }

    public static int[] addInPlace(int[] in, int[] value) {
        return ArrayMath.addInPlace(in, 0, value, 0, in.length);
    }

    public static int[] addInPlace(int[] in, int offsetIn, int[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] + value[i + offsetValue];
        }
        return in;
    }

    public static int[] addInPlace(int[] in, int offset, int value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] + value;
        }
        return in;
    }

    public static long[] add(long[] in, long value) {
        return ArrayMath.add(in, 0, value, in.length);
    }

    public static long[] add(long[] in, long[] value) {
        return ArrayMath.add(in, 0, value, 0, in.length);
    }

    public static long[] add(long[] in, int offsetIn, long[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        long[] ret = new long[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offsetIn] + value[i + offsetValue];
        }
        return ret;
    }

    public static long[] add(long[] in, int offset, long value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        long[] ret = new long[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] + value;
        }
        return ret;
    }

    public static long[] addInPlace(long[] in, long value) {
        return ArrayMath.addInPlace(in, 0, value, in.length);
    }

    public static long[] addInPlace(long[] in, long[] value) {
        return ArrayMath.addInPlace(in, 0, value, 0, in.length);
    }

    public static long[] addInPlace(long[] in, int offsetIn, long[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] + value[i + offsetValue];
        }
        return in;
    }

    public static long[] addInPlace(long[] in, int offset, long value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] + value;
        }
        return in;
    }

    public static short[] add(short[] in, short value) {
        return ArrayMath.add(in, 0, value, in.length);
    }

    public static short[] add(short[] in, short[] value) {
        return ArrayMath.add(in, 0, value, 0, in.length);
    }

    public static short[] add(short[] in, int offsetIn, short[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        short[] ret = new short[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = (short)(in[i + offsetIn] + value[i + offsetValue]);
        }
        return ret;
    }

    public static short[] add(short[] in, int offset, short value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        short[] ret = new short[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = (short)(in[i + offset] + value);
        }
        return ret;
    }

    public static short[] addInPlace(short[] in, short value) {
        return ArrayMath.addInPlace(in, 0, value, in.length);
    }

    public static short[] addInPlace(short[] in, short[] value) {
        return ArrayMath.addInPlace(in, 0, value, 0, in.length);
    }

    public static short[] addInPlace(short[] in, int offsetIn, short[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = (short)(in[n] + value[i + offsetValue]);
        }
        return in;
    }

    public static short[] addInPlace(short[] in, int offset, short value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = (short)(in[n] + value);
        }
        return in;
    }

    public static double[] decibel(double[] in) {
        return ArrayMath.decibel(in, 0, in.length);
    }

    public static double[] decibel(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = 20.0 * MathBase.log10(in[i + offset]);
        }
        return ret;
    }

    public static double[] decibelInPlace(double[] in) {
        return ArrayMath.decibelInPlace(in, 0, in.length);
    }

    public static double[] decibelInPlace(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = 20.0 * MathBase.log10(in[i]);
        }
        return in;
    }

    public static float[] decibel(float[] in) {
        return ArrayMath.decibel(in, 0, in.length);
    }

    public static float[] decibel(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = (float)(20.0 * MathBase.log10(in[i + offset]));
        }
        return ret;
    }

    public static float[] decibelInPlace(float[] in) {
        return ArrayMath.decibelInPlace(in, 0, in.length);
    }

    public static float[] decibelInPlace(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = (float)(20.0 * MathBase.log10(in[i]));
        }
        return in;
    }

    public static double[] divide(double[] in, double divisor) {
        return ArrayMath.divide(in, 0, divisor, in.length);
    }

    public static double[] divide(double[] in, double[] divisor) {
        return ArrayMath.divide(in, 0, divisor, 0, in.length);
    }

    public static double[] divide(double[] in, int offsetIn, double[] divisor, int offsetDiv, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)(length + offsetDiv), (int)divisor.length);
        double[] ret = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = divisor[i + offsetDiv] == 0.0 ? Double.NaN : in[i + offsetIn] / divisor[i + offsetDiv];
        }
        return ret;
    }

    public static double[] divide(double[] in, int offset, double divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        double[] ret = new double[length];
        if (divisor == 0.0) {
            return ArrayMath.notANumberInPlace(ret);
        }
        double invDivisor = 1.0 / divisor;
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] * invDivisor;
        }
        return ret;
    }

    public static double[] divideInPlace(double[] in, double divisor) {
        return ArrayMath.divideInPlace(in, 0, divisor, in.length);
    }

    public static double[] divideInPlace(double[] in, double[] divisor) {
        return ArrayMath.divideInPlace(in, 0, divisor, 0, in.length);
    }

    public static double[] divideInPlace(double[] in, int offsetIn, double[] divisor, int offsetDiv, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)(length + offsetDiv), (int)divisor.length);
        for (int i = 0; i < length; ++i) {
            if (divisor[i + offsetIn] == 0.0) {
                in[i] = Double.NaN;
                continue;
            }
            int n = i + offsetIn;
            in[n] = in[n] / divisor[i + offsetDiv];
        }
        return in;
    }

    public static double[] divideInPlace(double[] in, int offset, double divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        if (divisor == 0.0) {
            return ArrayMath.notANumberInPlace(in);
        }
        double invDivisor = 1.0 / divisor;
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] * invDivisor;
        }
        return in;
    }

    public static float[] divide(float[] in, float divisor) {
        return ArrayMath.divide(in, 0, divisor, in.length);
    }

    public static float[] divide(float[] in, float[] divisor) {
        return ArrayMath.divide(in, 0, divisor, 0, in.length);
    }

    public static float[] divide(float[] in, int offsetIn, float[] divisor, int offsetDiv, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)(length + offsetDiv), (int)divisor.length);
        float[] ret = new float[in.length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = (double)divisor[i + offsetDiv] == 0.0 ? Float.NaN : in[i + offsetIn] / divisor[i + offsetDiv];
        }
        return ret;
    }

    public static float[] divide(float[] in, int offset, float divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        float[] ret = new float[length];
        if ((double)divisor == 0.0) {
            return ArrayMath.notANumberInPlace(ret);
        }
        float invDivisor = 1.0f / divisor;
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] * invDivisor;
        }
        return ret;
    }

    public static float[] divideInPlace(float[] in, float divisor) {
        return ArrayMath.divideInPlace(in, 0, divisor, in.length);
    }

    public static float[] divideInPlace(float[] in, float[] divisor) {
        return ArrayMath.divideInPlace(in, 0, divisor, 0, in.length);
    }

    public static float[] divideInPlace(float[] in, int offsetIn, float[] divisor, int offsetDiv, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)(length + offsetDiv), (int)divisor.length);
        for (int i = 0; i < length; ++i) {
            if ((double)divisor[i + offsetIn] == 0.0) {
                in[i] = Float.NaN;
                continue;
            }
            int n = i + offsetIn;
            in[n] = in[n] / divisor[i + offsetDiv];
        }
        return in;
    }

    public static float[] divideInPlace(float[] in, int offset, float divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        if ((double)divisor == 0.0) {
            return ArrayMath.notANumberInPlace(in);
        }
        float invDivisor = 1.0f / divisor;
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] * invDivisor;
        }
        return in;
    }

    public static long[] divide(long[] in, long divisor) {
        return ArrayMath.divide(in, 0, divisor, in.length);
    }

    public static long[] divide(long[] in, long[] divisor) {
        return ArrayMath.divide(in, 0, divisor, 0, in.length);
    }

    public static long[] divide(long[] in, int offsetIn, long[] divisor, int offsetDiv, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)(length + offsetDiv), (int)divisor.length);
        long[] ret = new long[in.length];
        for (int i = 0; i < in.length; ++i) {
            if ((double)divisor[i + offsetDiv] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            ret[i + offsetIn] = in[i + offsetIn] / divisor[i + offsetDiv];
        }
        return ret;
    }

    public static long[] divide(long[] in, int offset, long divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        long[] ret = new long[length];
        if ((double)divisor == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        for (int i = 0; i < length; ++i) {
            ret[i + offset] = in[i + offset] / divisor;
        }
        return ret;
    }

    public static long[] divideInPlace(long[] in, long divisor) {
        return ArrayMath.divideInPlace(in, 0, divisor, in.length);
    }

    public static long[] divideInPlace(long[] in, long[] divisor) {
        return ArrayMath.divideInPlace(in, 0, divisor, 0, in.length);
    }

    public static long[] divideInPlace(long[] in, int offsetIn, long[] divisor, int offsetDiv, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)(length + offsetDiv), (int)divisor.length);
        for (int i = 0; i < length; ++i) {
            if ((double)divisor[i + offsetDiv] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            int n = i + offsetIn;
            in[n] = in[n] / divisor[i + offsetDiv];
        }
        return in;
    }

    public static long[] divideInPlace(long[] in, int offset, long divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        if ((double)divisor == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] / divisor;
        }
        return in;
    }

    public static int[] divide(int[] in, int divisor) {
        return ArrayMath.divide(in, 0, divisor, in.length);
    }

    public static int[] divide(int[] in, int[] divisor) {
        return ArrayMath.divide(in, 0, divisor, 0, in.length);
    }

    public static int[] divide(int[] in, int offsetIn, int[] divisor, int offsetDiv, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)(length + offsetDiv), (int)divisor.length);
        int[] ret = new int[in.length];
        for (int i = 0; i < in.length; ++i) {
            if ((double)divisor[i + offsetDiv] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            ret[i + offsetIn] = in[i + offsetIn] / divisor[i + offsetDiv];
        }
        return ret;
    }

    public static int[] divide(int[] in, int offset, int divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int[] ret = new int[length];
        if ((double)divisor == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        for (int i = 0; i < length; ++i) {
            ret[i + offset] = in[i + offset] / divisor;
        }
        return ret;
    }

    public static int[] divideInPlace(int[] in, int divisor) {
        return ArrayMath.divideInPlace(in, 0, divisor, in.length);
    }

    public static int[] divideInPlace(int[] in, int[] divisor) {
        return ArrayMath.divideInPlace(in, 0, divisor, 0, in.length);
    }

    public static int[] divideInPlace(int[] in, int offsetIn, int[] divisor, int offsetDiv, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)(length + offsetDiv), (int)divisor.length);
        for (int i = 0; i < length; ++i) {
            if ((double)divisor[i + offsetDiv] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            int n = i + offsetIn;
            in[n] = in[n] / divisor[i + offsetDiv];
        }
        return in;
    }

    public static int[] divideInPlace(int[] in, int offset, int divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        if ((double)divisor == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] / divisor;
        }
        return in;
    }

    public static short[] divide(short[] in, short divisor) {
        return ArrayMath.divide(in, 0, divisor, in.length);
    }

    public static short[] divide(short[] in, short[] divisor) {
        return ArrayMath.divide(in, 0, divisor, 0, in.length);
    }

    public static short[] divide(short[] in, int offsetIn, short[] divisor, int offsetDiv, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)(length + offsetDiv), (int)divisor.length);
        short[] ret = new short[in.length];
        for (int i = 0; i < in.length; ++i) {
            if ((double)divisor[i + offsetDiv] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            ret[i + offsetIn] = (short)(in[i + offsetIn] / divisor[i + offsetDiv]);
        }
        return ret;
    }

    public static short[] divide(short[] in, int offset, short divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        short[] ret = new short[length];
        if ((double)divisor == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        for (int i = 0; i < length; ++i) {
            ret[i + offset] = (short)(in[i + offset] / divisor);
        }
        return ret;
    }

    public static short[] divideInPlace(short[] in, short divisor) {
        return ArrayMath.divideInPlace(in, 0, divisor, in.length);
    }

    public static short[] divideInPlace(short[] in, short[] divisor) {
        return ArrayMath.divideInPlace(in, 0, divisor, 0, in.length);
    }

    public static short[] divideInPlace(short[] in, int offsetIn, short[] divisor, int offsetDiv, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)DIVISOR, (Object)divisor);
        AssertUtils.gtOrEqual((String)DIVISOR, (int)(length + offsetDiv), (int)divisor.length);
        for (int i = 0; i < length; ++i) {
            if ((double)divisor[i + offsetDiv] == 0.0) {
                throw new ArithmeticException("Division by zero");
            }
            int n = i + offsetIn;
            in[n] = (short)(in[n] / divisor[i + offsetDiv]);
        }
        return in;
    }

    public static short[] divideInPlace(short[] in, int offset, short divisor, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)length, (int)in.length);
        if ((double)divisor == 0.0) {
            throw new ArithmeticException("Division by zero");
        }
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = (short)(in[n] / divisor);
        }
        return in;
    }

    public static double[] inverseDecibel(double[] in) {
        return ArrayMath.inverseDecibel(in, 0, in.length);
    }

    public static double[] inverseDecibel(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i + offset] = Math.pow(10.0, in[i] / 20.0);
        }
        return ret;
    }

    public static double[] inverseDecibelInPlace(double[] in) {
        return ArrayMath.inverseDecibelInPlace(in, 0, in.length);
    }

    public static double[] inverseDecibelInPlace(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = Math.pow(10.0, in[i] / 20.0);
        }
        return in;
    }

    public static float[] inverseDecibel(float[] in) {
        return ArrayMath.inverseDecibel(in, 0, in.length);
    }

    public static float[] inverseDecibel(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i + offset] = (float)Math.pow(10.0, in[i] / 20.0f);
        }
        return ret;
    }

    public static float[] inverseDecibelInPlace(float[] in) {
        return ArrayMath.inverseDecibelInPlace(in, 0, in.length);
    }

    public static float[] inverseDecibelInPlace(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = (float)Math.pow(10.0, in[i] / 20.0f);
        }
        return in;
    }

    public static double[] multiply(double[] in, double multiplicator) {
        return ArrayMath.multiply(in, 0, multiplicator, in.length);
    }

    public static double[] multiply(double[] in, double[] multiplicator) {
        return ArrayMath.multiply(in, 0, multiplicator, 0, in.length);
    }

    public static double[] multiply(double[] in, int offsetIn, double[] multiplicator, int offsetMul, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)(length + offsetMul), (int)multiplicator.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offsetIn] * multiplicator[i + offsetMul];
        }
        return ret;
    }

    public static double[] multiply(double[] in, int offset, double multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] * multiplicator;
        }
        return ret;
    }

    public static double[] multiplyInPlace(double[] in, double multiplicator) {
        return ArrayMath.multiplyInPlace(in, 0, multiplicator, in.length);
    }

    public static double[] multiplyInPlace(double[] in, double[] multiplicator) {
        return ArrayMath.multiplyInPlace(in, 0, multiplicator, 0, in.length);
    }

    public static double[] multiplyInPlace(double[] in, int offsetIn, double[] multiplicator, int offsetMul, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)(length + offsetMul), (int)multiplicator.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] * multiplicator[i + offsetMul];
        }
        return in;
    }

    public static double[] multiplyInPlace(double[] in, int offset, double multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] * multiplicator;
        }
        return in;
    }

    public static float[] multiply(float[] in, float multiplicator) {
        return ArrayMath.multiply(in, 0, multiplicator, in.length);
    }

    public static float[] multiply(float[] in, float[] multiplicator) {
        return ArrayMath.multiply(in, 0, multiplicator, 0, in.length);
    }

    public static float[] multiply(float[] in, int offsetIn, float[] multiplicator, int offsetMul, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)(length + offsetMul), (int)multiplicator.length);
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offsetIn] * multiplicator[i + offsetMul];
        }
        return ret;
    }

    public static float[] multiply(float[] in, int offset, float multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] * multiplicator;
        }
        return ret;
    }

    public static float[] multiplyInPlace(float[] in, float multiplicator) {
        return ArrayMath.multiplyInPlace(in, 0, multiplicator, in.length);
    }

    public static float[] multiplyInPlace(float[] in, float[] multiplicator) {
        return ArrayMath.multiplyInPlace(in, 0, multiplicator, 0, in.length);
    }

    public static float[] multiplyInPlace(float[] in, int offsetIn, float[] multiplicator, int offsetMul, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)(length + offsetMul), (int)multiplicator.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] * multiplicator[i + offsetMul];
        }
        return in;
    }

    public static float[] multiplyInPlace(float[] in, int offset, float multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] * multiplicator;
        }
        return in;
    }

    public static int[] multiply(int[] in, int multiplicator) {
        return ArrayMath.multiply(in, 0, multiplicator, in.length);
    }

    public static int[] multiply(int[] in, int[] multiplicator) {
        return ArrayMath.multiply(in, 0, multiplicator, 0, in.length);
    }

    public static int[] multiply(int[] in, int offsetIn, int[] multiplicator, int offsetMul, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)(length + offsetMul), (int)multiplicator.length);
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offsetIn] * multiplicator[i + offsetMul];
        }
        return ret;
    }

    public static int[] multiply(int[] in, int offset, int multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] * multiplicator;
        }
        return ret;
    }

    public static int[] multiplyInPlace(int[] in, int multiplicator) {
        return ArrayMath.multiplyInPlace(in, 0, multiplicator, in.length);
    }

    public static int[] multiplyInPlace(int[] in, int[] multiplicator) {
        return ArrayMath.multiplyInPlace(in, 0, multiplicator, 0, in.length);
    }

    public static int[] multiplyInPlace(int[] in, int offsetIn, int[] multiplicator, int offsetMul, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)(length + offsetMul), (int)multiplicator.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] * multiplicator[i + offsetMul];
        }
        return in;
    }

    public static int[] multiplyInPlace(int[] in, int offset, int multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] * multiplicator;
        }
        return in;
    }

    public static long[] multiply(long[] in, long multiplicator) {
        return ArrayMath.multiply(in, 0, multiplicator, in.length);
    }

    public static long[] multiply(long[] in, long[] multiplicator) {
        return ArrayMath.multiply(in, 0, multiplicator, 0, in.length);
    }

    public static long[] multiply(long[] in, int offsetIn, long[] multiplicator, int offsetMul, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)(length + offsetMul), (int)multiplicator.length);
        long[] ret = new long[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offsetIn] * multiplicator[i + offsetMul];
        }
        return ret;
    }

    public static long[] multiply(long[] in, int offset, long multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        long[] ret = new long[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] * multiplicator;
        }
        return ret;
    }

    public static long[] multiplyInPlace(long[] in, long multiplicator) {
        return ArrayMath.multiplyInPlace(in, 0, multiplicator, in.length);
    }

    public static long[] multiplyInPlace(long[] in, long[] multiplicator) {
        return ArrayMath.multiplyInPlace(in, 0, multiplicator, 0, in.length);
    }

    public static long[] multiplyInPlace(long[] in, int offsetIn, long[] multiplicator, int offsetMul, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)(length + offsetMul), (int)multiplicator.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] * multiplicator[i + offsetMul];
        }
        return in;
    }

    public static long[] multiplyInPlace(long[] in, int offset, long multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] * multiplicator;
        }
        return in;
    }

    public static short[] multiply(short[] in, short multiplicator) {
        return ArrayMath.multiply(in, 0, multiplicator, in.length);
    }

    public static short[] multiply(short[] in, short[] multiplicator) {
        return ArrayMath.multiply(in, 0, multiplicator, 0, in.length);
    }

    public static short[] multiply(short[] in, int offsetIn, short[] multiplicator, int offsetMul, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)(length + offsetMul), (int)multiplicator.length);
        short[] ret = new short[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = (short)(in[i + offsetIn] * multiplicator[i + offsetMul]);
        }
        return ret;
    }

    public static short[] multiply(short[] in, int offset, short multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        short[] ret = new short[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = (short)(in[i + offset] * multiplicator);
        }
        return ret;
    }

    public static short[] multiplyInPlace(short[] in, short multiplicator) {
        return ArrayMath.multiplyInPlace(in, 0, multiplicator, in.length);
    }

    public static short[] multiplyInPlace(short[] in, short[] multiplicator) {
        return ArrayMath.multiplyInPlace(in, 0, multiplicator, 0, in.length);
    }

    public static short[] multiplyInPlace(short[] in, int offsetIn, short[] multiplicator, int offsetMul, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)MULTIPLICATOR, (Object)multiplicator);
        AssertUtils.gtOrEqual((String)MULTIPLICATOR, (int)(length + offsetMul), (int)multiplicator.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = (short)(in[n] * multiplicator[i + offsetMul]);
        }
        return in;
    }

    public static short[] multiplyInPlace(short[] in, int offset, short multiplicator, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = (short)(in[n] * multiplicator);
        }
        return in;
    }

    public static double[] notANumber(int length) {
        double[] ret = new double[length];
        ArrayUtils.fillArray(ret, 0, length, Double.NaN);
        return ret;
    }

    public static double[] notANumberInPlace(double[] in) {
        return ArrayMath.notANumberInPlace(in, 0, in.length);
    }

    public static double[] notANumberInPlace(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        ArrayUtils.fillArray(in, offset, offset + length, Double.NaN);
        return in;
    }

    public static float[] notANumberFloat(int length) {
        float[] ret = new float[length];
        ArrayUtils.fillArray(ret, 0, length, Float.NaN);
        return ret;
    }

    public static float[] notANumberInPlace(float[] in) {
        return ArrayMath.notANumberInPlace(in, 0, in.length);
    }

    public static float[] notANumberInPlace(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        ArrayUtils.fillArray(in, offset, offset + length, Float.NaN);
        return in;
    }

    public static double[] sqr(double[] in) {
        return ArrayMath.sqr(in, 0, in.length);
    }

    public static double[] sqr(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] * in[i + offset];
        }
        return ret;
    }

    public static double[] sqrInPlace(double[] in) {
        return ArrayMath.sqrInPlace(in, 0, in.length);
    }

    public static double[] sqrInPlace(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = in[i] * in[i];
        }
        return in;
    }

    public static float[] sqr(float[] in) {
        return ArrayMath.sqr(in, 0, in.length);
    }

    public static float[] sqr(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] * in[i + offset];
        }
        return ret;
    }

    public static float[] sqrInPlace(float[] in) {
        return ArrayMath.sqrInPlace(in, 0, in.length);
    }

    public static float[] sqrInPlace(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = in[i] * in[i];
        }
        return in;
    }

    public static int[] sqr(int[] in) {
        return ArrayMath.sqr(in, 0, in.length);
    }

    public static int[] sqr(int[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] * in[i + offset];
        }
        return ret;
    }

    public static int[] sqrInPlace(int[] in) {
        return ArrayMath.sqrInPlace(in, 0, in.length);
    }

    public static int[] sqrInPlace(int[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = in[i] * in[i];
        }
        return in;
    }

    public static long[] sqr(long[] in) {
        return ArrayMath.sqr(in, 0, in.length);
    }

    public static long[] sqr(long[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        long[] ret = new long[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] * in[i + offset];
        }
        return ret;
    }

    public static long[] sqrInPlace(long[] in) {
        return ArrayMath.sqrInPlace(in, 0, in.length);
    }

    public static long[] sqrInPlace(long[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = in[i] * in[i];
        }
        return in;
    }

    public static short[] sqr(short[] in) {
        return ArrayMath.sqr(in, 0, in.length);
    }

    public static short[] sqr(short[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        short[] ret = new short[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = (short)(in[i + offset] * in[i + offset]);
        }
        return ret;
    }

    public static short[] sqrInPlace(short[] in) {
        return ArrayMath.sqrInPlace(in, 0, in.length);
    }

    public static short[] sqrInPlace(short[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = (short)(in[i] * in[i]);
        }
        return in;
    }

    public static double[] sqrt(double[] in) {
        return ArrayMath.sqrt(in, 0, in.length);
    }

    public static double[] sqrt(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = MathBase.sqrt(in[i + offset]);
        }
        return ret;
    }

    public static double[] sqrtInPlace(double[] in) {
        return ArrayMath.sqrtInPlace(in, 0, in.length);
    }

    public static double[] sqrtInPlace(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = MathBase.sqrt(in[i]);
        }
        return in;
    }

    public static float[] sqrt(float[] in) {
        return ArrayMath.sqrt(in, 0, in.length);
    }

    public static float[] sqrt(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = (float)MathBase.sqrt(in[i + offset]);
        }
        return ret;
    }

    public static float[] sqrtInPlace(float[] in) {
        return ArrayMath.sqrtInPlace(in, 0, in.length);
    }

    public static float[] sqrtInPlace(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = (float)MathBase.sqrt(in[i]);
        }
        return in;
    }

    public static double[] subtract(double[] in, double value) {
        return ArrayMath.subtract(in, 0, value, in.length);
    }

    public static double[] subtract(double[] in, double[] value) {
        return ArrayMath.subtract(in, 0, value, 0, in.length);
    }

    public static double[] subtract(double[] in, int offsetIn, double[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        double[] ret = new double[length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i + offsetIn] - value[i + offsetValue];
        }
        return ret;
    }

    public static double[] subtract(double[] in, int offset, double value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] - value;
        }
        return ret;
    }

    public static double[] subtractInPlace(double[] in, double value) {
        return ArrayMath.subtractInPlace(in, 0, value, in.length);
    }

    public static double[] subtractInPlace(double[] in, double[] value) {
        return ArrayMath.subtractInPlace(in, 0, value, 0, in.length);
    }

    public static double[] subtractInPlace(double[] in, int offsetIn, double[] value, int offsetVal, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetVal), (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] - value[i + offsetVal];
        }
        return in;
    }

    public static double[] subtractInPlace(double[] in, int offset, double value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] - value;
        }
        return in;
    }

    public static float[] subtract(float[] in, float value) {
        return ArrayMath.subtract(in, 0, value, in.length);
    }

    public static float[] subtract(float[] in, float[] value) {
        return ArrayMath.subtract(in, 0, value, 0, in.length);
    }

    public static float[] subtract(float[] in, int offsetIn, float[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        float[] ret = new float[length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i + offsetIn] - value[i + offsetValue];
        }
        return ret;
    }

    public static float[] subtract(float[] in, int offset, float value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] - value;
        }
        return ret;
    }

    public static float[] subtractInPlace(float[] in, float value) {
        return ArrayMath.subtractInPlace(in, 0, value, in.length);
    }

    public static float[] subtractInPlace(float[] in, float[] value) {
        return ArrayMath.subtractInPlace(in, 0, value, 0, in.length);
    }

    public static float[] subtractInPlace(float[] in, int offsetIn, float[] value, int offsetVal, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetVal), (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] - value[i + offsetVal];
        }
        return in;
    }

    public static float[] subtractInPlace(float[] in, int offset, float value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] - value;
        }
        return in;
    }

    public static int[] subtract(int[] in, int value) {
        return ArrayMath.subtract(in, 0, value, in.length);
    }

    public static int[] subtract(int[] in, int[] value) {
        return ArrayMath.subtract(in, 0, value, 0, in.length);
    }

    public static int[] subtract(int[] in, int offsetIn, int[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        int[] ret = new int[length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i + offsetIn] - value[i + offsetValue];
        }
        return ret;
    }

    public static int[] subtract(int[] in, int offset, int value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int[] ret = new int[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] - value;
        }
        return ret;
    }

    public static int[] subtractInPlace(int[] in, int value) {
        return ArrayMath.subtractInPlace(in, 0, value, in.length);
    }

    public static int[] subtractInPlace(int[] in, int[] value) {
        return ArrayMath.subtractInPlace(in, 0, value, 0, in.length);
    }

    public static int[] subtractInPlace(int[] in, int offsetIn, int[] value, int offsetVal, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetVal), (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] - value[i + offsetVal];
        }
        return in;
    }

    public static int[] subtractInPlace(int[] in, int offset, int value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] - value;
        }
        return in;
    }

    public static long[] subtract(long[] in, long value) {
        return ArrayMath.subtract(in, 0, value, in.length);
    }

    public static long[] subtract(long[] in, long[] value) {
        return ArrayMath.subtract(in, 0, value, 0, in.length);
    }

    public static long[] subtract(long[] in, int offsetIn, long[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        long[] ret = new long[length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = in[i + offsetIn] - value[i + offsetValue];
        }
        return ret;
    }

    public static long[] subtract(long[] in, int offset, long value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        long[] ret = new long[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = in[i + offset] - value;
        }
        return ret;
    }

    public static long[] subtractInPlace(long[] in, long value) {
        return ArrayMath.subtractInPlace(in, 0, value, in.length);
    }

    public static long[] subtractInPlace(long[] in, long[] value) {
        return ArrayMath.subtractInPlace(in, 0, value, 0, in.length);
    }

    public static long[] subtractInPlace(long[] in, int offsetIn, long[] value, int offsetVal, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetVal), (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = in[n] - value[i + offsetVal];
        }
        return in;
    }

    public static long[] subtractInPlace(long[] in, int offset, long value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = in[n] - value;
        }
        return in;
    }

    public static short[] subtract(short[] in, short value) {
        return ArrayMath.subtract(in, 0, value, in.length);
    }

    public static short[] subtract(short[] in, short[] value) {
        return ArrayMath.subtract(in, 0, value, 0, in.length);
    }

    public static short[] subtract(short[] in, int offsetIn, short[] value, int offsetValue, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetValue), (int)value.length);
        short[] ret = new short[length];
        for (int i = 0; i < in.length; ++i) {
            ret[i] = (short)(in[i + offsetIn] - value[i + offsetValue]);
        }
        return ret;
    }

    public static short[] subtract(short[] in, int offset, short value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        short[] ret = new short[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = (short)(in[i + offset] - value);
        }
        return ret;
    }

    public static short[] subtractInPlace(short[] in, short value) {
        return ArrayMath.subtractInPlace(in, 0, value, in.length);
    }

    public static short[] subtractInPlace(short[] in, short[] value) {
        return ArrayMath.subtractInPlace(in, 0, value, 0, in.length);
    }

    public static short[] subtractInPlace(short[] in, int offsetIn, short[] value, int offsetVal, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offsetIn), (int)in.length);
        AssertUtils.notNull((String)VALUE, (Object)value);
        AssertUtils.gtOrEqual((String)VALUE, (int)(length + offsetVal), (int)value.length);
        for (int i = 0; i < length; ++i) {
            int n = i + offsetIn;
            in[n] = (short)(in[n] - value[i + offsetVal]);
        }
        return in;
    }

    public static short[] subtractInPlace(short[] in, int offset, short value, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        int i = offset;
        while (i < length + offset) {
            int n = i++;
            in[n] = (short)(in[n] - value);
        }
        return in;
    }

    public static double[] tenLog10(double[] in) {
        return ArrayMath.tenLog10(in, 0, in.length);
    }

    public static double[] tenLog10(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = 10.0 * MathBase.log10(in[i + offset]);
        }
        return ret;
    }

    public static double[] tenLog10InPlace(double[] in) {
        return ArrayMath.tenLog10InPlace(in, 0, in.length);
    }

    public static double[] tenLog10InPlace(double[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = 10.0 * MathBase.log10(in[i]);
        }
        return in;
    }

    public static float[] tenLog10(float[] in) {
        return ArrayMath.tenLog10(in, 0, in.length);
    }

    public static float[] tenLog10(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        float[] ret = new float[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = (float)(10.0 * MathBase.log10(in[i + offset]));
        }
        return ret;
    }

    public static float[] tenLog10InPlace(float[] in) {
        return ArrayMath.tenLog10InPlace(in, 0, in.length);
    }

    public static float[] tenLog10InPlace(float[] in, int offset, int length) {
        AssertUtils.notNull((String)IN, (Object)in);
        AssertUtils.gtOrEqual((String)IN, (int)(length + offset), (int)in.length);
        for (int i = offset; i < length + offset; ++i) {
            in[i] = (float)(10.0 * MathBase.log10(in[i]));
        }
        return in;
    }
}

