/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class ConcurrencyUtils {
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool(new CustomThreadFactory(new CustomExceptionHandler()));
    private static int THREADS_BEGIN_N_1D_FFT_2THREADS = 8192;
    private static int THREADS_BEGIN_N_1D_FFT_4THREADS = 65536;
    private static int THREADS_BEGIN_N_1D = 32768;
    private static int THREADS_BEGIN_N_2D = 65536;
    private static int THREADS_BEGIN_N_3D = 65536;
    private static boolean forceThreads = false;
    private static int forceNThreads = 1;

    public static int extendDimension(int x) {
        if (x < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        int nextExp = ConcurrencyUtils.nextExp2(x);
        int nextPow = nextExp + 1;
        int extDim = (int)Math.round(Math.pow(2.0, nextPow));
        return extDim;
    }

    public static int getNumberOfProcessors() {
        return forceThreads ? forceNThreads : Runtime.getRuntime().availableProcessors();
    }

    public static int getNumberOfThreads() {
        return ConcurrencyUtils.getNumberOfProcessors();
    }

    public static int getThreadsBeginN_1D() {
        return THREADS_BEGIN_N_1D;
    }

    public static int getThreadsBeginN_1D_FFT_2Threads() {
        return THREADS_BEGIN_N_1D_FFT_2THREADS;
    }

    public static int getThreadsBeginN_1D_FFT_4Threads() {
        return THREADS_BEGIN_N_1D_FFT_4THREADS;
    }

    public static int getThreadsBeginN_2D() {
        return THREADS_BEGIN_N_2D;
    }

    public static int getThreadsBeginN_3D() {
        return THREADS_BEGIN_N_3D;
    }

    public static boolean isForceThreads() {
        return forceThreads;
    }

    public static boolean isPowerOf2(int n) {
        if (n <= 0) {
            return false;
        }
        return (n & n - 1) == 0;
    }

    public static int nextExp2(int n) {
        double e = Math.log(n) / Math.log(2.0);
        int p = (int)Math.ceil(e);
        double f = (double)n / Math.pow(2.0, p);
        if (f == 0.5) {
            --p;
        }
        return p;
    }

    public static int nextPow2(int x) {
        if (x < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        if ((x & x - 1) == 0) {
            return x;
        }
        x |= x >>> 1;
        x |= x >>> 2;
        x |= x >>> 4;
        x |= x >>> 8;
        x |= x >>> 16;
        x |= x >>> 32;
        return x + 1;
    }

    public static int prevPow2(int x) {
        if (x < 1) {
            throw new IllegalArgumentException("x must be greater or equal 1");
        }
        return (int)Math.pow(2.0, Math.floor(Math.log(x) / Math.log(2.0)));
    }

    public static void resetThreadsBeginN() {
        THREADS_BEGIN_N_1D = 32768;
        THREADS_BEGIN_N_2D = 65536;
        THREADS_BEGIN_N_3D = 65536;
    }

    public static void resetThreadsBeginN_FFT() {
        THREADS_BEGIN_N_1D_FFT_2THREADS = 8192;
        THREADS_BEGIN_N_1D_FFT_4THREADS = 65536;
    }

    public static void setForceThreads(boolean forceThreads) {
        ConcurrencyUtils.forceThreads = forceThreads;
    }

    public static void setNumberOfThreads(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater or equal 1");
        }
        ConcurrencyUtils.setForceThreads(true);
        forceNThreads = n;
    }

    public static void setThreadsBeginN_1D(int n) {
        THREADS_BEGIN_N_1D = n;
    }

    public static void setThreadsBeginN_1D_FFT_2Threads(int n) {
        THREADS_BEGIN_N_1D_FFT_2THREADS = n < 512 ? 512 : n;
    }

    public static void setThreadsBeginN_1D_FFT_4Threads(int n) {
        THREADS_BEGIN_N_1D_FFT_4THREADS = n < 512 ? 512 : n;
    }

    public static void setThreadsBeginN_2D(int n) {
        THREADS_BEGIN_N_2D = n;
    }

    public static void setThreadsBeginN_3D(int n) {
        THREADS_BEGIN_N_3D = n;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static <T> Future<T> submit(Callable<T> task) {
        return THREAD_POOL.submit(task);
    }

    public static Future<?> submit(Runnable task) {
        return THREAD_POOL.submit(task);
    }

    public static void waitForCompletion(Future<?>[] futures) {
        int size = futures.length;
        try {
            for (int j = 0; j < size; ++j) {
                futures[j].get();
            }
        }
        catch (ExecutionException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static class CustomThreadFactory
    implements ThreadFactory {
        private static final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private static int threadCounter = 1;
        private final Thread.UncaughtExceptionHandler handler;

        CustomThreadFactory(Thread.UncaughtExceptionHandler handler) {
            this.handler = handler;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = defaultFactory.newThread(r);
            t.setDaemon(true);
            t.setName("daemonised_chartfx_math_thread" + threadCounter);
            ++threadCounter;
            t.setUncaughtExceptionHandler(this.handler);
            return t;
        }
    }

    private static class CustomExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CustomExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            e.printStackTrace();
        }
    }
}

