/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.fft;

import de.gsi.math.spectra.fft.DoubleFFT_1D;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleFFT_3D {
    private final int slices;
    private final int rows;
    private int columns;
    private int sliceStride;
    private int rowStride;
    private double[] t;
    private final DoubleFFT_1D fftSlices;
    private DoubleFFT_1D fftRows;
    private DoubleFFT_1D fftColumns;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleFFT_3D(int slices, int rows, int columns) {
        if (slices <= 1 || rows <= 1 || columns <= 1) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = slices;
        this.rows = rows;
        this.columns = columns;
        this.sliceStride = rows * columns;
        this.rowStride = columns;
        if (slices * rows * columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(slices) && ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = slices;
            if (this.nt < rows) {
                this.nt = rows;
            }
            this.nt *= 8;
            if (this.oldNthreads > 1) {
                this.nt *= this.oldNthreads;
            }
            if (2 * columns == 4) {
                this.nt >>= 1;
            }
            this.t = new double[this.nt];
        }
        this.fftSlices = new DoubleFFT_1D(slices);
        this.fftRows = slices == rows ? this.fftSlices : new DoubleFFT_1D(rows);
        this.fftColumns = slices == columns ? this.fftSlices : (rows == columns ? this.fftRows : new DoubleFFT_1D(columns));
    }

    private void cdft3db_sub(int isgn, double[] a, boolean scale) {
        block27: {
            block25: {
                block28: {
                    block26: {
                        if (isgn != -1) break block25;
                        if (this.columns <= 4) break block26;
                        for (int r = 0; r < this.rows; ++r) {
                            int idx0 = r * this.rowStride;
                            for (int c = 0; c < this.columns; c += 8) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int idx1;
                                int s;
                                for (s = 0; s < this.slices; ++s) {
                                    idx1 = s * this.sliceStride + idx0 + c;
                                    idx2 = 2 * s;
                                    idx3 = 2 * this.slices + 2 * s;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    this.t[idx2] = a[idx1];
                                    this.t[idx2 + 1] = a[idx1 + 1];
                                    this.t[idx3] = a[idx1 + 2];
                                    this.t[idx3 + 1] = a[idx1 + 3];
                                    this.t[idx4] = a[idx1 + 4];
                                    this.t[idx4 + 1] = a[idx1 + 5];
                                    this.t[idx5] = a[idx1 + 6];
                                    this.t[idx5 + 1] = a[idx1 + 7];
                                }
                                this.fftSlices.complexForward(this.t, 0);
                                this.fftSlices.complexForward(this.t, 2 * this.slices);
                                this.fftSlices.complexForward(this.t, 4 * this.slices);
                                this.fftSlices.complexForward(this.t, 6 * this.slices);
                                for (s = 0; s < this.slices; ++s) {
                                    idx1 = s * this.sliceStride + idx0 + c;
                                    idx2 = 2 * s;
                                    idx3 = 2 * this.slices + 2 * s;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    a[idx1] = this.t[idx2];
                                    a[idx1 + 1] = this.t[idx2 + 1];
                                    a[idx1 + 2] = this.t[idx3];
                                    a[idx1 + 3] = this.t[idx3 + 1];
                                    a[idx1 + 4] = this.t[idx4];
                                    a[idx1 + 5] = this.t[idx4 + 1];
                                    a[idx1 + 6] = this.t[idx5];
                                    a[idx1 + 7] = this.t[idx5 + 1];
                                }
                            }
                        }
                        break block27;
                    }
                    if (this.columns != 4) break block28;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx3;
                        int idx2;
                        int idx1;
                        int s;
                        int idx0 = r * this.rowStride;
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0;
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                        }
                        this.fftSlices.complexForward(this.t, 0);
                        this.fftSlices.complexForward(this.t, 2 * this.slices);
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0;
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                        }
                    }
                    break block27;
                }
                if (this.columns != 2) break block27;
                for (int r = 0; r < this.rows; ++r) {
                    int idx2;
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                    }
                    this.fftSlices.complexForward(this.t, 0);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                    }
                }
                break block27;
            }
            if (this.columns > 4) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx0 = r * this.rowStride;
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int idx3;
                        int idx2;
                        int idx1;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            this.t[idx4] = a[idx1 + 4];
                            this.t[idx4 + 1] = a[idx1 + 5];
                            this.t[idx5] = a[idx1 + 6];
                            this.t[idx5 + 1] = a[idx1 + 7];
                        }
                        this.fftSlices.complexInverse(this.t, 0, scale);
                        this.fftSlices.complexInverse(this.t, 2 * this.slices, scale);
                        this.fftSlices.complexInverse(this.t, 4 * this.slices, scale);
                        this.fftSlices.complexInverse(this.t, 6 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            a[idx1 + 4] = this.t[idx4];
                            a[idx1 + 5] = this.t[idx4 + 1];
                            a[idx1 + 6] = this.t[idx5];
                            a[idx1 + 7] = this.t[idx5 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx3;
                    int idx2;
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        idx3 = 2 * this.slices + 2 * s;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                    }
                    this.fftSlices.complexInverse(this.t, 0, scale);
                    this.fftSlices.complexInverse(this.t, 2 * this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        idx3 = 2 * this.slices + 2 * s;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx2;
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                    }
                    this.fftSlices.complexInverse(this.t, 0, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        idx2 = 2 * s;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                    }
                }
            }
        }
    }

    private void cdft3db_sub(int isgn, double[][][] a, boolean scale) {
        block27: {
            block25: {
                block28: {
                    block26: {
                        if (isgn != -1) break block25;
                        if (this.columns <= 4) break block26;
                        for (int r = 0; r < this.rows; ++r) {
                            for (int c = 0; c < this.columns; c += 8) {
                                int idx5;
                                int idx4;
                                int idx3;
                                int idx2;
                                int s;
                                for (s = 0; s < this.slices; ++s) {
                                    idx2 = 2 * s;
                                    idx3 = 2 * this.slices + 2 * s;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    this.t[idx2] = a[s][r][c];
                                    this.t[idx2 + 1] = a[s][r][c + 1];
                                    this.t[idx3] = a[s][r][c + 2];
                                    this.t[idx3 + 1] = a[s][r][c + 3];
                                    this.t[idx4] = a[s][r][c + 4];
                                    this.t[idx4 + 1] = a[s][r][c + 5];
                                    this.t[idx5] = a[s][r][c + 6];
                                    this.t[idx5 + 1] = a[s][r][c + 7];
                                }
                                this.fftSlices.complexForward(this.t, 0);
                                this.fftSlices.complexForward(this.t, 2 * this.slices);
                                this.fftSlices.complexForward(this.t, 4 * this.slices);
                                this.fftSlices.complexForward(this.t, 6 * this.slices);
                                for (s = 0; s < this.slices; ++s) {
                                    idx2 = 2 * s;
                                    idx3 = 2 * this.slices + 2 * s;
                                    idx4 = idx3 + 2 * this.slices;
                                    idx5 = idx4 + 2 * this.slices;
                                    a[s][r][c] = this.t[idx2];
                                    a[s][r][c + 1] = this.t[idx2 + 1];
                                    a[s][r][c + 2] = this.t[idx3];
                                    a[s][r][c + 3] = this.t[idx3 + 1];
                                    a[s][r][c + 4] = this.t[idx4];
                                    a[s][r][c + 5] = this.t[idx4 + 1];
                                    a[s][r][c + 6] = this.t[idx5];
                                    a[s][r][c + 7] = this.t[idx5 + 1];
                                }
                            }
                        }
                        break block27;
                    }
                    if (this.columns != 4) break block28;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx3;
                        int idx2;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            this.t[idx2] = a[s][r][0];
                            this.t[idx2 + 1] = a[s][r][1];
                            this.t[idx3] = a[s][r][2];
                            this.t[idx3 + 1] = a[s][r][3];
                        }
                        this.fftSlices.complexForward(this.t, 0);
                        this.fftSlices.complexForward(this.t, 2 * this.slices);
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            a[s][r][0] = this.t[idx2];
                            a[s][r][1] = this.t[idx2 + 1];
                            a[s][r][2] = this.t[idx3];
                            a[s][r][3] = this.t[idx3 + 1];
                        }
                    }
                    break block27;
                }
                if (this.columns != 2) break block27;
                for (int r = 0; r < this.rows; ++r) {
                    int idx2;
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        idx2 = 2 * s;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                    }
                    this.fftSlices.complexForward(this.t, 0);
                    for (s = 0; s < this.slices; ++s) {
                        idx2 = 2 * s;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                    }
                }
                break block27;
            }
            if (this.columns > 4) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int idx3;
                        int idx2;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            this.t[idx2] = a[s][r][c];
                            this.t[idx2 + 1] = a[s][r][c + 1];
                            this.t[idx3] = a[s][r][c + 2];
                            this.t[idx3 + 1] = a[s][r][c + 3];
                            this.t[idx4] = a[s][r][c + 4];
                            this.t[idx4 + 1] = a[s][r][c + 5];
                            this.t[idx5] = a[s][r][c + 6];
                            this.t[idx5 + 1] = a[s][r][c + 7];
                        }
                        this.fftSlices.complexInverse(this.t, 0, scale);
                        this.fftSlices.complexInverse(this.t, 2 * this.slices, scale);
                        this.fftSlices.complexInverse(this.t, 4 * this.slices, scale);
                        this.fftSlices.complexInverse(this.t, 6 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = 2 * s;
                            idx3 = 2 * this.slices + 2 * s;
                            idx4 = idx3 + 2 * this.slices;
                            idx5 = idx4 + 2 * this.slices;
                            a[s][r][c] = this.t[idx2];
                            a[s][r][c + 1] = this.t[idx2 + 1];
                            a[s][r][c + 2] = this.t[idx3];
                            a[s][r][c + 3] = this.t[idx3 + 1];
                            a[s][r][c + 4] = this.t[idx4];
                            a[s][r][c + 5] = this.t[idx4 + 1];
                            a[s][r][c + 6] = this.t[idx5];
                            a[s][r][c + 7] = this.t[idx5 + 1];
                        }
                    }
                }
            } else if (this.columns == 4) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx3;
                    int idx2;
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        idx2 = 2 * s;
                        idx3 = 2 * this.slices + 2 * s;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        this.t[idx3] = a[s][r][2];
                        this.t[idx3 + 1] = a[s][r][3];
                    }
                    this.fftSlices.complexInverse(this.t, 0, scale);
                    this.fftSlices.complexInverse(this.t, 2 * this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx2 = 2 * s;
                        idx3 = 2 * this.slices + 2 * s;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        a[s][r][2] = this.t[idx3];
                        a[s][r][3] = this.t[idx3 + 1];
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx2;
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        idx2 = 2 * s;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                    }
                    this.fftSlices.complexInverse(this.t, 0, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx2 = 2 * s;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                    }
                }
            }
        }
    }

    private void cdft3db_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int nt = 8 * this.slices;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        block25: {
                            block28: {
                                block26: {
                                    if (isgn != -1) break block25;
                                    if (DoubleFFT_3D.this.columns <= 4) break block26;
                                    for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                        int idx0 = r * DoubleFFT_3D.this.rowStride;
                                        for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                            int idx5;
                                            int idx4;
                                            int idx3;
                                            int idx2;
                                            int idx1;
                                            int s;
                                            for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                                idx1 = s * DoubleFFT_3D.this.sliceStride + idx0 + c;
                                                idx2 = startt + 2 * s;
                                                idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                                idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                                DoubleFFT_3D.this.t[idx2] = a[idx1];
                                                DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                                DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                                DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                                DoubleFFT_3D.this.t[idx4] = a[idx1 + 4];
                                                DoubleFFT_3D.this.t[idx4 + 1] = a[idx1 + 5];
                                                DoubleFFT_3D.this.t[idx5] = a[idx1 + 6];
                                                DoubleFFT_3D.this.t[idx5 + 1] = a[idx1 + 7];
                                            }
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.slices);
                                            for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                                idx1 = s * DoubleFFT_3D.this.sliceStride + idx0 + c;
                                                idx2 = startt + 2 * s;
                                                idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                                idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                                a[idx1] = DoubleFFT_3D.this.t[idx2];
                                                a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                                a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                                a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                                a[idx1 + 4] = DoubleFFT_3D.this.t[idx4];
                                                a[idx1 + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                                a[idx1 + 6] = DoubleFFT_3D.this.t[idx5];
                                                a[idx1 + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.columns != 4) break block28;
                                for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                    int idx3;
                                    int idx2;
                                    int idx1;
                                    int s;
                                    int idx0 = r * DoubleFFT_3D.this.rowStride;
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx1 = s * DoubleFFT_3D.this.sliceStride + idx0;
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                        DoubleFFT_3D.this.t[idx2] = a[idx1];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt);
                                    DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.slices);
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx1 = s * DoubleFFT_3D.this.sliceStride + idx0;
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                        a[idx1] = DoubleFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.columns != 2) break block27;
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx2;
                                int idx1;
                                int s;
                                int idx0 = r * DoubleFFT_3D.this.rowStride;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    DoubleFFT_3D.this.t[idx2] = a[idx1];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    a[idx1] = DoubleFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.columns > 4) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx0 = r * DoubleFFT_3D.this.rowStride;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int idx3;
                                    int idx2;
                                    int idx1;
                                    int s;
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx1 = s * DoubleFFT_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                        DoubleFFT_3D.this.t[idx2] = a[idx1];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                        DoubleFFT_3D.this.t[idx4] = a[idx1 + 4];
                                        DoubleFFT_3D.this.t[idx4 + 1] = a[idx1 + 5];
                                        DoubleFFT_3D.this.t[idx5] = a[idx1 + 6];
                                        DoubleFFT_3D.this.t[idx5 + 1] = a[idx1 + 7];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.slices, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.slices, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.slices, scale);
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx1 = s * DoubleFFT_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                        a[idx1] = DoubleFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                        a[idx1 + 4] = DoubleFFT_3D.this.t[idx4];
                                        a[idx1 + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                        a[idx1 + 6] = DoubleFFT_3D.this.t[idx5];
                                        a[idx1 + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 4) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx3;
                                int idx2;
                                int idx1;
                                int s;
                                int idx0 = r * DoubleFFT_3D.this.rowStride;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                    DoubleFFT_3D.this.t[idx2] = a[idx1];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                    DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                    DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.slices, scale);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                    a[idx1] = DoubleFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                    a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                    a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx2;
                                int idx1;
                                int s;
                                int idx0 = r * DoubleFFT_3D.this.rowStride;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    DoubleFFT_3D.this.t[idx2] = a[idx1];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx1 = s * DoubleFFT_3D.this.sliceStride + idx0;
                                    idx2 = startt + 2 * s;
                                    a[idx1] = DoubleFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void cdft3db_subth(final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.rows);
        int nt = 8 * this.slices;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block27: {
                        block25: {
                            block28: {
                                block26: {
                                    if (isgn != -1) break block25;
                                    if (DoubleFFT_3D.this.columns <= 4) break block26;
                                    for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                        for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                            int idx5;
                                            int idx4;
                                            int idx3;
                                            int idx2;
                                            int s;
                                            for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                                idx2 = startt + 2 * s;
                                                idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                                idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                                DoubleFFT_3D.this.t[idx2] = a[s][r][c];
                                                DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][c + 1];
                                                DoubleFFT_3D.this.t[idx3] = a[s][r][c + 2];
                                                DoubleFFT_3D.this.t[idx3 + 1] = a[s][r][c + 3];
                                                DoubleFFT_3D.this.t[idx4] = a[s][r][c + 4];
                                                DoubleFFT_3D.this.t[idx4 + 1] = a[s][r][c + 5];
                                                DoubleFFT_3D.this.t[idx5] = a[s][r][c + 6];
                                                DoubleFFT_3D.this.t[idx5 + 1] = a[s][r][c + 7];
                                            }
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.slices);
                                            DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.slices);
                                            for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                                idx2 = startt + 2 * s;
                                                idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                                idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                                idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                                a[s][r][c] = DoubleFFT_3D.this.t[idx2];
                                                a[s][r][c + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                                a[s][r][c + 2] = DoubleFFT_3D.this.t[idx3];
                                                a[s][r][c + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                                a[s][r][c + 4] = DoubleFFT_3D.this.t[idx4];
                                                a[s][r][c + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                                a[s][r][c + 6] = DoubleFFT_3D.this.t[idx5];
                                                a[s][r][c + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                            }
                                        }
                                    }
                                    break block27;
                                }
                                if (DoubleFFT_3D.this.columns != 4) break block28;
                                for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                    int idx3;
                                    int idx2;
                                    int s;
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                        DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                                        DoubleFFT_3D.this.t[idx3] = a[s][r][2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[s][r][3];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt);
                                    DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.slices);
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                        a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                        a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[s][r][2] = DoubleFFT_3D.this.t[idx3];
                                        a[s][r][3] = DoubleFFT_3D.this.t[idx3 + 1];
                                    }
                                }
                                break block27;
                            }
                            if (DoubleFFT_3D.this.columns != 2) break block27;
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx2;
                                int s;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = startt + 2 * s;
                                    DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(DoubleFFT_3D.this.t, startt);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = startt + 2 * s;
                                    a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                    a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                                }
                            }
                            break block27;
                        }
                        if (DoubleFFT_3D.this.columns > 4) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int idx3;
                                    int idx2;
                                    int s;
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                        DoubleFFT_3D.this.t[idx2] = a[s][r][c];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][c + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[s][r][c + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[s][r][c + 3];
                                        DoubleFFT_3D.this.t[idx4] = a[s][r][c + 4];
                                        DoubleFFT_3D.this.t[idx4 + 1] = a[s][r][c + 5];
                                        DoubleFFT_3D.this.t[idx5] = a[s][r][c + 6];
                                        DoubleFFT_3D.this.t[idx5 + 1] = a[s][r][c + 7];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.slices, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.slices, scale);
                                    DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.slices, scale);
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx2 = startt + 2 * s;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.slices;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.slices;
                                        a[s][r][c] = DoubleFFT_3D.this.t[idx2];
                                        a[s][r][c + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[s][r][c + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[s][r][c + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                        a[s][r][c + 4] = DoubleFFT_3D.this.t[idx4];
                                        a[s][r][c + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                        a[s][r][c + 6] = DoubleFFT_3D.this.t[idx5];
                                        a[s][r][c + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                    }
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 4) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx3;
                                int idx2;
                                int s;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = startt + 2 * s;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                    DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                                    DoubleFFT_3D.this.t[idx3] = a[s][r][2];
                                    DoubleFFT_3D.this.t[idx3 + 1] = a[s][r][3];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.slices, scale);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = startt + 2 * s;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.slices + 2 * s;
                                    a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                    a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                                    a[s][r][2] = DoubleFFT_3D.this.t[idx3];
                                    a[s][r][3] = DoubleFFT_3D.this.t[idx3 + 1];
                                }
                            }
                        } else if (DoubleFFT_3D.this.columns == 2) {
                            for (int r = n0; r < DoubleFFT_3D.this.rows; r += nthreads) {
                                int idx2;
                                int s;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = startt + 2 * s;
                                    DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = startt + 2 * s;
                                    a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                    a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    public void complexForward(final double[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, a, true);
                this.cdft3db_subth(-1, a, true);
            } else {
                this.xdft3da_sub2(0, -1, a, true);
                this.cdft3db_sub(-1, a, true);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * DoubleFFT_3D.this.sliceStride;
                                for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a, idx1 + r * DoubleFFT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * DoubleFFT_3D.this.sliceStride;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx4;
                                    int idx3;
                                    int r;
                                    int idx2 = 2 * c;
                                    for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(temp);
                                    for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                int idx1 = r * DoubleFFT_3D.this.rowStride;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx4;
                                    int idx3;
                                    int s;
                                    int idx2 = 2 * c;
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx3 = s * DoubleFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexForward(temp);
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx3 = s * DoubleFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx4;
                int idx3;
                int idx2;
                int c;
                int idx1;
                for (int s = 0; s < this.slices; ++s) {
                    int idx12 = s * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexForward(a, idx12 + r * this.rowStride);
                    }
                }
                double[] temp = new double[2 * this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    idx1 = s * this.sliceStride;
                    for (c = 0; c < this.columns; ++c) {
                        int r;
                        idx2 = 2 * c;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                        }
                        this.fftRows.complexForward(temp);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
                temp = new double[2 * this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c = 0; c < this.columns; ++c) {
                        int s;
                        idx2 = 2 * c;
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                        }
                        this.fftSlices.complexForward(temp);
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexForward(final double[][][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, -1, a, true);
                this.cdft3db_subth(-1, a, true);
            } else {
                this.xdft3da_sub2(0, -1, a, true);
                this.cdft3db_sub(-1, a, true);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.complexForward(a[s][r]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(temp);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int s;
                                int idx2 = 2 * c;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx4 = 2 * s;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(temp);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx4 = 2 * s;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx4;
            int idx2;
            int c;
            int r;
            for (int s = 0; s < this.slices; ++s) {
                for (r = 0; r < this.rows; ++r) {
                    this.fftColumns.complexForward(a[s][r]);
                }
            }
            double[] temp = new double[2 * this.rows];
            for (int s = 0; s < this.slices; ++s) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    idx2 = 2 * c;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        temp[idx4] = a[s][r2][idx2];
                        temp[idx4 + 1] = a[s][r2][idx2 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        a[s][r2][idx2] = temp[idx4];
                        a[s][r2][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    idx2 = 2 * c;
                    for (s = 0; s < this.slices; ++s) {
                        idx4 = 2 * s;
                        temp[idx4] = a[s][r][idx2];
                        temp[idx4 + 1] = a[s][r][idx2 + 1];
                    }
                    this.fftSlices.complexForward(temp);
                    for (s = 0; s < this.slices; ++s) {
                        idx4 = 2 * s;
                        a[s][r][idx2] = temp[idx4];
                        a[s][r][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
        }
    }

    public void complexInverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
            } else {
                this.xdft3da_sub2(0, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else {
            this.sliceStride = 2 * this.rows * this.columns;
            this.rowStride = 2 * this.columns;
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * DoubleFFT_3D.this.sliceStride;
                                for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a, idx1 + r * DoubleFFT_3D.this.rowStride, scale);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * DoubleFFT_3D.this.sliceStride;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx4;
                                    int idx3;
                                    int r;
                                    int idx2 = 2 * c;
                                    for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(temp, scale);
                                    for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                        idx3 = idx1 + idx2 + r * DoubleFFT_3D.this.rowStride;
                                        idx4 = 2 * r;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                int idx1 = r * DoubleFFT_3D.this.rowStride;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx4;
                                    int idx3;
                                    int s;
                                    int idx2 = 2 * c;
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx3 = s * DoubleFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s;
                                        temp[idx4] = a[idx3];
                                        temp[idx4 + 1] = a[idx3 + 1];
                                    }
                                    DoubleFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                    for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                        idx3 = s * DoubleFFT_3D.this.sliceStride + idx1 + idx2;
                                        idx4 = 2 * s;
                                        a[idx3] = temp[idx4];
                                        a[idx3 + 1] = temp[idx4 + 1];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx4;
                int idx3;
                int idx2;
                int c;
                int idx1;
                for (int s = 0; s < this.slices; ++s) {
                    int idx12 = s * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexInverse(a, idx12 + r * this.rowStride, scale);
                    }
                }
                double[] temp = new double[2 * this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    idx1 = s * this.sliceStride;
                    for (c = 0; c < this.columns; ++c) {
                        int r;
                        idx2 = 2 * c;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                        }
                        this.fftRows.complexInverse(temp, scale);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + idx2 + r * this.rowStride;
                            idx4 = 2 * r;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
                temp = new double[2 * this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c = 0; c < this.columns; ++c) {
                        int s;
                        idx2 = 2 * c;
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s;
                            temp[idx4] = a[idx3];
                            temp[idx4 + 1] = a[idx3 + 1];
                        }
                        this.fftSlices.complexInverse(temp, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + idx2;
                            idx4 = 2 * s;
                            a[idx3] = temp[idx4];
                            a[idx3 + 1] = temp[idx4 + 1];
                        }
                    }
                }
            }
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        }
    }

    public void complexInverse(final double[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            int oldn3 = this.columns;
            this.columns = 2 * this.columns;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(0, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
            } else {
                this.xdft3da_sub2(0, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
            }
            this.columns = oldn3;
            this.sliceStride = this.rows * this.columns;
            this.rowStride = this.columns;
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.complexInverse(a[s][r], scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int s;
                                int idx2 = 2 * c;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx4 = 2 * s;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx4 = 2 * s;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx4;
            int idx2;
            int c;
            int r;
            for (int s = 0; s < this.slices; ++s) {
                for (r = 0; r < this.rows; ++r) {
                    this.fftColumns.complexInverse(a[s][r], scale);
                }
            }
            double[] temp = new double[2 * this.rows];
            for (int s = 0; s < this.slices; ++s) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    idx2 = 2 * c;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        temp[idx4] = a[s][r2][idx2];
                        temp[idx4 + 1] = a[s][r2][idx2 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        idx4 = 2 * r2;
                        a[s][r2][idx2] = temp[idx4];
                        a[s][r2][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    idx2 = 2 * c;
                    for (s = 0; s < this.slices; ++s) {
                        idx4 = 2 * s;
                        temp[idx4] = a[s][r][idx2];
                        temp[idx4 + 1] = a[s][r][idx2 + 1];
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx4 = 2 * s;
                        a[s][r][idx2] = temp[idx4];
                        a[s][r][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
        }
    }

    private void fillSymmetric(final double[] a) {
        int idx2;
        int idx1;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        final int twon3 = 2 * this.columns;
        final int n2d2 = this.rows / 2;
        int n1d2 = this.slices / 2;
        final int twoSliceStride = this.rows * twon3;
        final int twoRowStride = twon3;
        for (int s = this.slices - 1; s >= 1; --s) {
            idx3 = s * this.sliceStride;
            idx4 = 2 * idx3;
            for (int r = 0; r < this.rows; ++r) {
                idx5 = r * this.rowStride;
                idx6 = 2 * idx5;
                for (int c = 0; c < this.columns; c += 2) {
                    idx1 = idx3 + idx5 + c;
                    idx2 = idx4 + idx6 + c;
                    a[idx2] = a[idx1];
                    a[idx1] = 0.0;
                    a[++idx2] = a[++idx1];
                    a[idx1] = 0.0;
                }
            }
        }
        for (int r = 1; r < this.rows; ++r) {
            idx3 = (this.rows - r) * this.rowStride;
            idx4 = (this.rows - r) * twoRowStride;
            for (int c = 0; c < this.columns; c += 2) {
                idx1 = idx3 + c;
                idx2 = idx4 + c;
                a[idx2] = a[idx1];
                a[idx1] = 0.0;
                a[++idx2] = a[++idx1];
                a[idx1] = 0.0;
            }
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx3 = (DoubleFFT_3D.this.slices - s) % DoubleFFT_3D.this.slices * twoSliceStride;
                            int idx5 = s * twoSliceStride;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                int idx4 = (DoubleFFT_3D.this.rows - r) % DoubleFFT_3D.this.rows * twoRowStride;
                                int idx6 = r * twoRowStride;
                                for (int c = 1; c < DoubleFFT_3D.this.columns; c += 2) {
                                    int idx1 = idx3 + idx4 + twon3 - c;
                                    int idx2 = idx5 + idx6 + c;
                                    a[idx1] = -a[idx2 + 2];
                                    a[idx1 - 1] = a[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx5 = (DoubleFFT_3D.this.slices - s) % DoubleFFT_3D.this.slices * twoSliceStride;
                            int idx6 = s * twoSliceStride;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx4 = idx6 + (DoubleFFT_3D.this.rows - r) * twoRowStride;
                                int idx1 = idx5 + r * twoRowStride + DoubleFFT_3D.this.columns;
                                int idx2 = idx4 + DoubleFFT_3D.this.columns;
                                int idx3 = idx4 + 1;
                                a[idx1] = a[idx3];
                                a[idx2] = a[idx3];
                                a[idx1 + 1] = -a[idx4];
                                a[idx2 + 1] = a[idx4];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx3 = (DoubleFFT_3D.this.slices - s) % DoubleFFT_3D.this.slices * twoSliceStride;
                            int idx4 = s * twoSliceStride;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx1 = idx3 + (DoubleFFT_3D.this.rows - r) * twoRowStride;
                                int idx2 = idx4 + r * twoRowStride;
                                a[idx1] = a[idx2];
                                a[idx1 + 1] = -a[idx2 + 1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int r;
            int s;
            for (s = 0; s < this.slices; ++s) {
                idx3 = (this.slices - s) % this.slices * twoSliceStride;
                idx5 = s * twoSliceStride;
                for (r = 0; r < this.rows; ++r) {
                    idx4 = (this.rows - r) % this.rows * twoRowStride;
                    idx6 = r * twoRowStride;
                    for (int c = 1; c < this.columns; c += 2) {
                        idx1 = idx3 + idx4 + twon3 - c;
                        idx2 = idx5 + idx6 + c;
                        a[idx1] = -a[idx2 + 2];
                        a[idx1 - 1] = a[idx2 + 1];
                    }
                }
            }
            for (s = 0; s < this.slices; ++s) {
                idx5 = (this.slices - s) % this.slices * twoSliceStride;
                idx6 = s * twoSliceStride;
                for (r = 1; r < n2d2; ++r) {
                    idx4 = idx6 + (this.rows - r) * twoRowStride;
                    idx1 = idx5 + r * twoRowStride + this.columns;
                    idx2 = idx4 + this.columns;
                    idx3 = idx4 + 1;
                    a[idx1] = a[idx3];
                    a[idx2] = a[idx3];
                    a[idx1 + 1] = -a[idx4];
                    a[idx2 + 1] = a[idx4];
                }
            }
            for (s = 0; s < this.slices; ++s) {
                idx3 = (this.slices - s) % this.slices * twoSliceStride;
                idx4 = s * twoSliceStride;
                for (r = 1; r < n2d2; ++r) {
                    idx1 = idx3 + (this.rows - r) * twoRowStride;
                    idx2 = idx4 + r * twoRowStride;
                    a[idx1] = a[idx2];
                    a[idx1 + 1] = -a[idx2 + 1];
                }
            }
        }
        for (int s = 1; s < n1d2; ++s) {
            idx1 = s * twoSliceStride;
            idx2 = (this.slices - s) * twoSliceStride;
            idx3 = n2d2 * twoRowStride;
            idx4 = idx1 + idx3;
            idx5 = idx2 + idx3;
            a[idx1 + this.columns] = a[idx2 + 1];
            a[idx2 + this.columns] = a[idx2 + 1];
            a[idx1 + this.columns + 1] = -a[idx2];
            a[idx2 + this.columns + 1] = a[idx2];
            a[idx4 + this.columns] = a[idx5 + 1];
            a[idx5 + this.columns] = a[idx5 + 1];
            a[idx4 + this.columns + 1] = -a[idx5];
            a[idx5 + this.columns + 1] = a[idx5];
            a[idx2] = a[idx1];
            a[idx2 + 1] = -a[idx1 + 1];
            a[idx5] = a[idx4];
            a[idx5 + 1] = -a[idx4 + 1];
        }
        a[this.columns] = a[1];
        a[1] = 0.0;
        idx1 = n2d2 * twoRowStride;
        idx2 = n1d2 * twoSliceStride;
        idx3 = idx1 + idx2;
        a[idx1 + this.columns] = a[idx1 + 1];
        a[idx1 + 1] = 0.0;
        a[idx2 + this.columns] = a[idx2 + 1];
        a[idx2 + 1] = 0.0;
        a[idx3 + this.columns] = a[idx3 + 1];
        a[idx3 + 1] = 0.0;
        a[idx2 + this.columns + 1] = 0.0;
        a[idx3 + this.columns + 1] = 0.0;
    }

    private void fillSymmetric(final double[][][] a) {
        int idx1;
        final int twon3 = 2 * this.columns;
        final int n2d2 = this.rows / 2;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = (DoubleFFT_3D.this.slices - s) % DoubleFFT_3D.this.slices;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                int idx2 = (DoubleFFT_3D.this.rows - r) % DoubleFFT_3D.this.rows;
                                for (int c = 1; c < DoubleFFT_3D.this.columns; c += 2) {
                                    int idx3 = twon3 - c;
                                    a[idx1][idx2][idx3] = -a[s][r][c + 2];
                                    a[idx1][idx2][idx3 - 1] = a[s][r][c + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = (DoubleFFT_3D.this.slices - s) % DoubleFFT_3D.this.slices;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx2 = DoubleFFT_3D.this.rows - r;
                                a[idx1][r][DoubleFFT_3D.this.columns] = a[s][idx2][1];
                                a[s][idx2][DoubleFFT_3D.this.columns] = a[s][idx2][1];
                                a[idx1][r][DoubleFFT_3D.this.columns + 1] = -a[s][idx2][0];
                                a[s][idx2][DoubleFFT_3D.this.columns + 1] = a[s][idx2][0];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = (DoubleFFT_3D.this.slices - s) % DoubleFFT_3D.this.slices;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx2 = DoubleFFT_3D.this.rows - r;
                                a[idx1][idx2][0] = a[s][r][0];
                                a[idx1][idx2][1] = -a[s][r][1];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx2;
            int r;
            int s;
            for (s = 0; s < this.slices; ++s) {
                idx1 = (this.slices - s) % this.slices;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = (this.rows - r) % this.rows;
                    for (int c = 1; c < this.columns; c += 2) {
                        int idx3 = twon3 - c;
                        a[idx1][idx2][idx3] = -a[s][r][c + 2];
                        a[idx1][idx2][idx3 - 1] = a[s][r][c + 1];
                    }
                }
            }
            for (s = 0; s < this.slices; ++s) {
                idx1 = (this.slices - s) % this.slices;
                for (r = 1; r < n2d2; ++r) {
                    idx2 = this.rows - r;
                    a[idx1][r][this.columns] = a[s][idx2][1];
                    a[s][idx2][this.columns] = a[s][idx2][1];
                    a[idx1][r][this.columns + 1] = -a[s][idx2][0];
                    a[s][idx2][this.columns + 1] = a[s][idx2][0];
                }
            }
            for (s = 0; s < this.slices; ++s) {
                idx1 = (this.slices - s) % this.slices;
                for (r = 1; r < n2d2; ++r) {
                    idx2 = this.rows - r;
                    a[idx1][idx2][0] = a[s][r][0];
                    a[idx1][idx2][1] = -a[s][r][1];
                }
            }
        }
        for (int s = 1; s < n1d2; ++s) {
            idx1 = this.slices - s;
            a[s][0][this.columns] = a[idx1][0][1];
            a[idx1][0][this.columns] = a[idx1][0][1];
            a[s][0][this.columns + 1] = -a[idx1][0][0];
            a[idx1][0][this.columns + 1] = a[idx1][0][0];
            a[s][n2d2][this.columns] = a[idx1][n2d2][1];
            a[idx1][n2d2][this.columns] = a[idx1][n2d2][1];
            a[s][n2d2][this.columns + 1] = -a[idx1][n2d2][0];
            a[idx1][n2d2][this.columns + 1] = a[idx1][n2d2][0];
            a[idx1][0][0] = a[s][0][0];
            a[idx1][0][1] = -a[s][0][1];
            a[idx1][n2d2][0] = a[s][n2d2][0];
            a[idx1][n2d2][1] = -a[s][n2d2][1];
        }
        a[0][0][this.columns] = a[0][0][1];
        a[0][0][1] = 0.0;
        a[0][n2d2][this.columns] = a[0][n2d2][1];
        a[0][n2d2][1] = 0.0;
        a[n1d2][0][this.columns] = a[n1d2][0][1];
        a[n1d2][0][1] = 0.0;
        a[n1d2][n2d2][this.columns] = a[n1d2][n2d2][1];
        a[n1d2][n2d2][1] = 0.0;
        a[n1d2][0][this.columns + 1] = 0.0;
        a[n1d2][n2d2][this.columns + 1] = 0.0;
    }

    private void mixedRadixRealForwardFull(final double[] a) {
        final int twon3 = 2 * this.columns;
        double[] temp = new double[twon3];
        int ldimn2 = this.rows / 2 + 1;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int twoSliceStride = 2 * this.sliceStride;
        final int twoRowStride = 2 * this.rowStride;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = n1d2 / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final int firstSlice2 = this.slices - 1 - l2 * p;
                final int lastSlice2 = l2 == nthreads - 1 ? n1d2 + 1 : firstSlice2 - p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[twon3];
                        for (int s = firstSlice2; s >= lastSlice2; --s) {
                            int idx1 = s * DoubleFFT_3D.this.sliceStride;
                            int idx2 = s * twoSliceStride;
                            for (int r = DoubleFFT_3D.this.rows - 1; r >= 0; --r) {
                                System.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStride, temp, 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(temp);
                                System.arraycopy(temp, 0, a, idx2 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            final double[][][] temp2 = new double[n1d2 + 1][this.rows][twon3];
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * DoubleFFT_3D.this.sliceStride;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                System.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStride, temp2[s][r], 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realForwardFull(temp2[s][r]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * twoSliceStride;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                System.arraycopy(temp2[s][r], 0, a, idx1 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * twoSliceStride;
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int idx3;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    temp[idx4] = a[idx3];
                                    temp[idx4 + 1] = a[idx3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(temp);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    a[idx3] = temp[idx4];
                                    a[idx3 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = ldimn2 / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx3 = r * twoRowStride;
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int idx2;
                                int s;
                                int idx1 = 2 * c;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = 2 * s;
                                    idx4 = s * twoSliceStride + idx3 + idx1;
                                    temp[idx2] = a[idx4];
                                    temp[idx2 + 1] = a[idx4 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(temp);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = 2 * s;
                                    idx4 = s * twoSliceStride + idx3 + idx1;
                                    a[idx4] = temp[idx2];
                                    a[idx4 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx2 = (DoubleFFT_3D.this.slices - s) % DoubleFFT_3D.this.slices;
                            int idx5 = idx2 * twoSliceStride;
                            int idx6 = s * twoSliceStride;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx4 = DoubleFFT_3D.this.rows - r;
                                int idx7 = idx4 * twoRowStride;
                                int idx8 = r * twoRowStride;
                                int idx9 = idx5 + idx7;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx1 = 2 * c;
                                    int idx3 = twon3 - idx1;
                                    int idx10 = idx6 + idx8 + idx1;
                                    a[idx9 + idx3 % twon3] = a[idx10];
                                    a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx4;
            int r;
            int c;
            int idx1;
            int s;
            for (s = this.slices - 1; s >= 0; --s) {
                idx1 = s * this.sliceStride;
                int idx2 = s * twoSliceStride;
                for (int r2 = this.rows - 1; r2 >= 0; --r2) {
                    System.arraycopy(a, idx1 + r2 * this.rowStride, temp, 0, this.columns);
                    this.fftColumns.realForwardFull(temp);
                    System.arraycopy(temp, 0, a, idx2 + r2 * twoRowStride, twon3);
                }
            }
            temp = new double[2 * this.rows];
            for (s = 0; s < this.slices; ++s) {
                idx1 = s * twoSliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int idx3;
                    int idx2 = 2 * c;
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        temp[idx4] = a[idx3];
                        temp[idx4 + 1] = a[idx3 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        a[idx3] = temp[idx4];
                        a[idx3 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (int r3 = 0; r3 < ldimn2; ++r3) {
                int idx3 = r3 * twoRowStride;
                for (c = 0; c < this.columns; ++c) {
                    int idx42;
                    int idx2;
                    int s2;
                    int idx12 = 2 * c;
                    for (s2 = 0; s2 < this.slices; ++s2) {
                        idx2 = 2 * s2;
                        idx42 = s2 * twoSliceStride + idx3 + idx12;
                        temp[idx2] = a[idx42];
                        temp[idx2 + 1] = a[idx42 + 1];
                    }
                    this.fftSlices.complexForward(temp);
                    for (s2 = 0; s2 < this.slices; ++s2) {
                        idx2 = 2 * s2;
                        idx42 = s2 * twoSliceStride + idx3 + idx12;
                        a[idx42] = temp[idx2];
                        a[idx42 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s = 0; s < this.slices; ++s) {
                int idx2 = (this.slices - s) % this.slices;
                int idx5 = idx2 * twoSliceStride;
                int idx6 = s * twoSliceStride;
                for (r = 1; r < n2d2; ++r) {
                    idx4 = this.rows - r;
                    int idx7 = idx4 * twoRowStride;
                    int idx8 = r * twoRowStride;
                    int idx9 = idx5 + idx7;
                    for (int c2 = 0; c2 < this.columns; ++c2) {
                        int idx13 = 2 * c2;
                        int idx3 = twon3 - idx13;
                        int idx10 = idx6 + idx8 + idx13;
                        a[idx9 + idx3 % twon3] = a[idx10];
                        a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealForwardFull(final double[][][] a) {
        double[] temp = new double[2 * this.rows];
        int ldimn2 = this.rows / 2 + 1;
        final int newn3 = 2 * this.columns;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.realForwardFull(a[s][r]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(temp);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = ldimn2 / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx2;
                                int s;
                                int idx1 = 2 * c;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = 2 * s;
                                    temp[idx2] = a[s][r][idx1];
                                    temp[idx2 + 1] = a[s][r][idx1 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexForward(temp);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = 2 * s;
                                    a[s][r][idx1] = temp[idx2];
                                    a[s][r][idx1 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx2 = (DoubleFFT_3D.this.slices - s) % DoubleFFT_3D.this.slices;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx4 = DoubleFFT_3D.this.rows - r;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx1 = 2 * c;
                                    int idx3 = newn3 - idx1;
                                    a[idx2][idx4][idx3 % newn3] = a[s][r][idx1];
                                    a[idx2][idx4][(idx3 + 1) % newn3] = -a[s][r][idx1 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int s;
            for (s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.realForwardFull(a[s][r]);
                }
            }
            for (s = 0; s < this.slices; ++s) {
                for (c = 0; c < this.columns; ++c) {
                    int idx4;
                    int r;
                    int idx2 = 2 * c;
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        temp[idx4] = a[s][r][idx2];
                        temp[idx4 + 1] = a[s][r][idx2 + 1];
                    }
                    this.fftRows.complexForward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        a[s][r][idx2] = temp[idx4];
                        a[s][r][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (int r = 0; r < ldimn2; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int idx2;
                    int s2;
                    int idx1 = 2 * c;
                    for (s2 = 0; s2 < this.slices; ++s2) {
                        idx2 = 2 * s2;
                        temp[idx2] = a[s2][r][idx1];
                        temp[idx2 + 1] = a[s2][r][idx1 + 1];
                    }
                    this.fftSlices.complexForward(temp);
                    for (s2 = 0; s2 < this.slices; ++s2) {
                        idx2 = 2 * s2;
                        a[s2][r][idx1] = temp[idx2];
                        a[s2][r][idx1 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s = 0; s < this.slices; ++s) {
                int idx2 = (this.slices - s) % this.slices;
                for (int r = 1; r < n2d2; ++r) {
                    int idx4 = this.rows - r;
                    for (int c2 = 0; c2 < this.columns; ++c2) {
                        int idx1 = 2 * c2;
                        int idx3 = newn3 - idx1;
                        a[idx2][idx4][idx3 % newn3] = a[s][r][idx1];
                        a[idx2][idx4][(idx3 + 1) % newn3] = -a[s][r][idx1 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final double[] a, final boolean scale) {
        final int twon3 = 2 * this.columns;
        double[] temp = new double[twon3];
        int ldimn2 = this.rows / 2 + 1;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        final int twoSliceStride = 2 * this.sliceStride;
        final int twoRowStride = 2 * this.rowStride;
        int n1d2 = this.slices / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && n1d2 >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = n1d2 / nthreads;
            for (int l2 = 0; l2 < nthreads; ++l2) {
                final int firstSlice2 = this.slices - 1 - l2 * p;
                final int lastSlice2 = l2 == nthreads - 1 ? n1d2 + 1 : firstSlice2 - p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[twon3];
                        for (int s = firstSlice2; s >= lastSlice2; --s) {
                            int idx1 = s * DoubleFFT_3D.this.sliceStride;
                            int idx2 = s * twoSliceStride;
                            for (int r = DoubleFFT_3D.this.rows - 1; r >= 0; --r) {
                                System.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStride, temp, 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(temp, scale);
                                System.arraycopy(temp, 0, a, idx2 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            final double[][][] temp2 = new double[n1d2 + 1][this.rows][twon3];
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * DoubleFFT_3D.this.sliceStride;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                System.arraycopy(a, idx1 + r * DoubleFFT_3D.this.rowStride, temp2[s][r], 0, DoubleFFT_3D.this.columns);
                                DoubleFFT_3D.this.fftColumns.realInverseFull(temp2[s][r], scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? n1d2 + 1 : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * twoSliceStride;
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                System.arraycopy(temp2[s][r], 0, a, idx1 + r * twoRowStride, twon3);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * twoSliceStride;
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int idx3;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    temp[idx4] = a[idx3];
                                    temp[idx4 + 1] = a[idx3 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * twoRowStride + idx2;
                                    idx4 = 2 * r;
                                    a[idx3] = temp[idx4];
                                    a[idx3 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = ldimn2 / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx3 = r * twoRowStride;
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int idx2;
                                int s;
                                int idx1 = 2 * c;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = 2 * s;
                                    idx4 = s * twoSliceStride + idx3 + idx1;
                                    temp[idx2] = a[idx4];
                                    temp[idx2 + 1] = a[idx4 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = 2 * s;
                                    idx4 = s * twoSliceStride + idx3 + idx1;
                                    a[idx4] = temp[idx2];
                                    a[idx4 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx2 = (DoubleFFT_3D.this.slices - s) % DoubleFFT_3D.this.slices;
                            int idx5 = idx2 * twoSliceStride;
                            int idx6 = s * twoSliceStride;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx4 = DoubleFFT_3D.this.rows - r;
                                int idx7 = idx4 * twoRowStride;
                                int idx8 = r * twoRowStride;
                                int idx9 = idx5 + idx7;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx1 = 2 * c;
                                    int idx3 = twon3 - idx1;
                                    int idx10 = idx6 + idx8 + idx1;
                                    a[idx9 + idx3 % twon3] = a[idx10];
                                    a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx4;
            int r;
            int c;
            int idx1;
            int s;
            for (s = this.slices - 1; s >= 0; --s) {
                idx1 = s * this.sliceStride;
                int idx2 = s * twoSliceStride;
                for (int r2 = this.rows - 1; r2 >= 0; --r2) {
                    System.arraycopy(a, idx1 + r2 * this.rowStride, temp, 0, this.columns);
                    this.fftColumns.realInverseFull(temp, scale);
                    System.arraycopy(temp, 0, a, idx2 + r2 * twoRowStride, twon3);
                }
            }
            temp = new double[2 * this.rows];
            for (s = 0; s < this.slices; ++s) {
                idx1 = s * twoSliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int idx3;
                    int idx2 = 2 * c;
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        temp[idx4] = a[idx3];
                        temp[idx4 + 1] = a[idx3 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        idx3 = idx1 + r * twoRowStride + idx2;
                        a[idx3] = temp[idx4];
                        a[idx3 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (int r3 = 0; r3 < ldimn2; ++r3) {
                int idx3 = r3 * twoRowStride;
                for (c = 0; c < this.columns; ++c) {
                    int idx42;
                    int idx2;
                    int s2;
                    int idx12 = 2 * c;
                    for (s2 = 0; s2 < this.slices; ++s2) {
                        idx2 = 2 * s2;
                        idx42 = s2 * twoSliceStride + idx3 + idx12;
                        temp[idx2] = a[idx42];
                        temp[idx2 + 1] = a[idx42 + 1];
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s2 = 0; s2 < this.slices; ++s2) {
                        idx2 = 2 * s2;
                        idx42 = s2 * twoSliceStride + idx3 + idx12;
                        a[idx42] = temp[idx2];
                        a[idx42 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s = 0; s < this.slices; ++s) {
                int idx2 = (this.slices - s) % this.slices;
                int idx5 = idx2 * twoSliceStride;
                int idx6 = s * twoSliceStride;
                for (r = 1; r < n2d2; ++r) {
                    idx4 = this.rows - r;
                    int idx7 = idx4 * twoRowStride;
                    int idx8 = r * twoRowStride;
                    int idx9 = idx5 + idx7;
                    for (int c2 = 0; c2 < this.columns; ++c2) {
                        int idx13 = 2 * c2;
                        int idx3 = twon3 - idx13;
                        int idx10 = idx6 + idx8 + idx13;
                        a[idx9 + idx3 % twon3] = a[idx10];
                        a[idx9 + (idx3 + 1) % twon3] = -a[idx10 + 1];
                    }
                }
            }
        }
    }

    private void mixedRadixRealInverseFull(final double[][][] a, final boolean scale) {
        double[] temp = new double[2 * this.rows];
        int ldimn2 = this.rows / 2 + 1;
        final int newn3 = 2 * this.columns;
        final int n2d2 = this.rows % 2 == 0 ? this.rows / 2 : (this.rows + 1) / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.columns >= nthreads && ldimn2 >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.realInverseFull(a[s][r], scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx4;
                                int r;
                                int idx2 = 2 * c;
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    temp[idx4] = a[s][r][idx2];
                                    temp[idx4 + 1] = a[s][r][idx2 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(temp, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx4 = 2 * r;
                                    a[s][r][idx2] = temp[idx4];
                                    a[s][r][idx2 + 1] = temp[idx4 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = ldimn2 / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? ldimn2 : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[2 * DoubleFFT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                int idx2;
                                int s;
                                int idx1 = 2 * c;
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = 2 * s;
                                    temp[idx2] = a[s][r][idx1];
                                    temp[idx2 + 1] = a[s][r][idx1 + 1];
                                }
                                DoubleFFT_3D.this.fftSlices.complexInverse(temp, scale);
                                for (s = 0; s < DoubleFFT_3D.this.slices; ++s) {
                                    idx2 = 2 * s;
                                    a[s][r][idx1] = temp[idx2];
                                    a[s][r][idx1 + 1] = temp[idx2 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx2 = (DoubleFFT_3D.this.slices - s) % DoubleFFT_3D.this.slices;
                            for (int r = 1; r < n2d2; ++r) {
                                int idx4 = DoubleFFT_3D.this.rows - r;
                                for (int c = 0; c < DoubleFFT_3D.this.columns; ++c) {
                                    int idx1 = 2 * c;
                                    int idx3 = newn3 - idx1;
                                    a[idx2][idx4][idx3 % newn3] = a[s][r][idx1];
                                    a[idx2][idx4][(idx3 + 1) % newn3] = -a[s][r][idx1 + 1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int s;
            for (s = 0; s < this.slices; ++s) {
                for (int r = 0; r < this.rows; ++r) {
                    this.fftColumns.realInverseFull(a[s][r], scale);
                }
            }
            for (s = 0; s < this.slices; ++s) {
                for (c = 0; c < this.columns; ++c) {
                    int idx4;
                    int r;
                    int idx2 = 2 * c;
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        temp[idx4] = a[s][r][idx2];
                        temp[idx4 + 1] = a[s][r][idx2 + 1];
                    }
                    this.fftRows.complexInverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx4 = 2 * r;
                        a[s][r][idx2] = temp[idx4];
                        a[s][r][idx2 + 1] = temp[idx4 + 1];
                    }
                }
            }
            temp = new double[2 * this.slices];
            for (int r = 0; r < ldimn2; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int idx2;
                    int s2;
                    int idx1 = 2 * c;
                    for (s2 = 0; s2 < this.slices; ++s2) {
                        idx2 = 2 * s2;
                        temp[idx2] = a[s2][r][idx1];
                        temp[idx2 + 1] = a[s2][r][idx1 + 1];
                    }
                    this.fftSlices.complexInverse(temp, scale);
                    for (s2 = 0; s2 < this.slices; ++s2) {
                        idx2 = 2 * s2;
                        a[s2][r][idx1] = temp[idx2];
                        a[s2][r][idx1 + 1] = temp[idx2 + 1];
                    }
                }
            }
            for (s = 0; s < this.slices; ++s) {
                int idx2 = (this.slices - s) % this.slices;
                for (int r = 1; r < n2d2; ++r) {
                    int idx4 = this.rows - r;
                    for (int c2 = 0; c2 < this.columns; ++c2) {
                        int idx1 = 2 * c2;
                        int idx3 = newn3 - idx1;
                        a[idx2][idx4][idx3 % newn3] = a[s][r][idx1];
                        a[idx2][idx4][(idx3 + 1) % newn3] = -a[s][r][idx1 + 1];
                    }
                }
            }
        }
    }

    private void rdft3d_sub(int isgn, double[] a) {
        int n1h = this.slices >> 1;
        int n2h = this.rows >> 1;
        if (isgn < 0) {
            int l;
            int k;
            double xi;
            int idx4;
            int idx3;
            int idx2;
            int idx1;
            for (int i = 1; i < n1h; ++i) {
                int j = this.slices - i;
                idx1 = i * this.sliceStride;
                idx2 = j * this.sliceStride;
                idx3 = i * this.sliceStride + n2h * this.rowStride;
                idx4 = j * this.sliceStride + n2h * this.rowStride;
                xi = a[idx1] - a[idx2];
                int n = idx1;
                a[n] = a[n] + a[idx2];
                a[idx2] = xi;
                xi = a[idx2 + 1] - a[idx1 + 1];
                int n2 = idx1 + 1;
                a[n2] = a[n2] + a[idx2 + 1];
                a[idx2 + 1] = xi;
                xi = a[idx3] - a[idx4];
                int n3 = idx3;
                a[n3] = a[n3] + a[idx4];
                a[idx4] = xi;
                xi = a[idx4 + 1] - a[idx3 + 1];
                int n4 = idx3 + 1;
                a[n4] = a[n4] + a[idx4 + 1];
                a[idx4 + 1] = xi;
                for (k = 1; k < n2h; ++k) {
                    l = this.rows - k;
                    idx1 = i * this.sliceStride + k * this.rowStride;
                    idx2 = j * this.sliceStride + l * this.rowStride;
                    xi = a[idx1] - a[idx2];
                    int n5 = idx1;
                    a[n5] = a[n5] + a[idx2];
                    a[idx2] = xi;
                    xi = a[idx2 + 1] - a[idx1 + 1];
                    int n6 = idx1 + 1;
                    a[n6] = a[n6] + a[idx2 + 1];
                    a[idx2 + 1] = xi;
                    idx3 = j * this.sliceStride + k * this.rowStride;
                    idx4 = i * this.sliceStride + l * this.rowStride;
                    xi = a[idx3] - a[idx4];
                    int n7 = idx3;
                    a[n7] = a[n7] + a[idx4];
                    a[idx4] = xi;
                    xi = a[idx4 + 1] - a[idx3 + 1];
                    int n8 = idx3 + 1;
                    a[n8] = a[n8] + a[idx4 + 1];
                    a[idx4 + 1] = xi;
                }
            }
            for (k = 1; k < n2h; ++k) {
                l = this.rows - k;
                idx1 = k * this.rowStride;
                idx2 = l * this.rowStride;
                xi = a[idx1] - a[idx2];
                int n = idx1;
                a[n] = a[n] + a[idx2];
                a[idx2] = xi;
                xi = a[idx2 + 1] - a[idx1 + 1];
                int n9 = idx1 + 1;
                a[n9] = a[n9] + a[idx2 + 1];
                a[idx2 + 1] = xi;
                idx3 = n1h * this.sliceStride + k * this.rowStride;
                idx4 = n1h * this.sliceStride + l * this.rowStride;
                xi = a[idx3] - a[idx4];
                int n10 = idx3;
                a[n10] = a[n10] + a[idx4];
                a[idx4] = xi;
                xi = a[idx4 + 1] - a[idx3 + 1];
                int n11 = idx3 + 1;
                a[n11] = a[n11] + a[idx4 + 1];
                a[idx4 + 1] = xi;
            }
        } else {
            int l;
            int k;
            int idx4;
            int idx3;
            int idx2;
            int idx1;
            for (int i = 1; i < n1h; ++i) {
                int j = this.slices - i;
                idx1 = j * this.sliceStride;
                idx2 = i * this.sliceStride;
                a[idx1] = 0.5 * (a[idx2] - a[idx1]);
                int n = idx2;
                a[n] = a[n] - a[idx1];
                a[idx1 + 1] = 0.5 * (a[idx2 + 1] + a[idx1 + 1]);
                int n12 = idx2 + 1;
                a[n12] = a[n12] - a[idx1 + 1];
                idx3 = j * this.sliceStride + n2h * this.rowStride;
                idx4 = i * this.sliceStride + n2h * this.rowStride;
                a[idx3] = 0.5 * (a[idx4] - a[idx3]);
                int n13 = idx4;
                a[n13] = a[n13] - a[idx3];
                a[idx3 + 1] = 0.5 * (a[idx4 + 1] + a[idx3 + 1]);
                int n14 = idx4 + 1;
                a[n14] = a[n14] - a[idx3 + 1];
                for (k = 1; k < n2h; ++k) {
                    l = this.rows - k;
                    idx1 = j * this.sliceStride + l * this.rowStride;
                    idx2 = i * this.sliceStride + k * this.rowStride;
                    a[idx1] = 0.5 * (a[idx2] - a[idx1]);
                    int n15 = idx2;
                    a[n15] = a[n15] - a[idx1];
                    a[idx1 + 1] = 0.5 * (a[idx2 + 1] + a[idx1 + 1]);
                    int n16 = idx2 + 1;
                    a[n16] = a[n16] - a[idx1 + 1];
                    idx3 = i * this.sliceStride + l * this.rowStride;
                    idx4 = j * this.sliceStride + k * this.rowStride;
                    a[idx3] = 0.5 * (a[idx4] - a[idx3]);
                    int n17 = idx4;
                    a[n17] = a[n17] - a[idx3];
                    a[idx3 + 1] = 0.5 * (a[idx4 + 1] + a[idx3 + 1]);
                    int n18 = idx4 + 1;
                    a[n18] = a[n18] - a[idx3 + 1];
                }
            }
            for (k = 1; k < n2h; ++k) {
                l = this.rows - k;
                idx1 = l * this.rowStride;
                idx2 = k * this.rowStride;
                a[idx1] = 0.5 * (a[idx2] - a[idx1]);
                int n = idx2;
                a[n] = a[n] - a[idx1];
                a[idx1 + 1] = 0.5 * (a[idx2 + 1] + a[idx1 + 1]);
                int n19 = idx2 + 1;
                a[n19] = a[n19] - a[idx1 + 1];
                idx3 = n1h * this.sliceStride + l * this.rowStride;
                idx4 = n1h * this.sliceStride + k * this.rowStride;
                a[idx3] = 0.5 * (a[idx4] - a[idx3]);
                int n20 = idx4;
                a[n20] = a[n20] - a[idx3];
                a[idx3 + 1] = 0.5 * (a[idx4 + 1] + a[idx3 + 1]);
                int n21 = idx4 + 1;
                a[n21] = a[n21] - a[idx3 + 1];
            }
        }
    }

    private void rdft3d_sub(int isgn, double[][][] a) {
        int n1h = this.slices >> 1;
        int n2h = this.rows >> 1;
        if (isgn < 0) {
            int l;
            int k;
            double xi;
            for (int i = 1; i < n1h; ++i) {
                int j = this.slices - i;
                xi = a[i][0][0] - a[j][0][0];
                double[] dArray = a[i][0];
                dArray[0] = dArray[0] + a[j][0][0];
                a[j][0][0] = xi;
                xi = a[j][0][1] - a[i][0][1];
                double[] dArray2 = a[i][0];
                dArray2[1] = dArray2[1] + a[j][0][1];
                a[j][0][1] = xi;
                xi = a[i][n2h][0] - a[j][n2h][0];
                double[] dArray3 = a[i][n2h];
                dArray3[0] = dArray3[0] + a[j][n2h][0];
                a[j][n2h][0] = xi;
                xi = a[j][n2h][1] - a[i][n2h][1];
                double[] dArray4 = a[i][n2h];
                dArray4[1] = dArray4[1] + a[j][n2h][1];
                a[j][n2h][1] = xi;
                for (k = 1; k < n2h; ++k) {
                    l = this.rows - k;
                    xi = a[i][k][0] - a[j][l][0];
                    double[] dArray5 = a[i][k];
                    dArray5[0] = dArray5[0] + a[j][l][0];
                    a[j][l][0] = xi;
                    xi = a[j][l][1] - a[i][k][1];
                    double[] dArray6 = a[i][k];
                    dArray6[1] = dArray6[1] + a[j][l][1];
                    a[j][l][1] = xi;
                    xi = a[j][k][0] - a[i][l][0];
                    double[] dArray7 = a[j][k];
                    dArray7[0] = dArray7[0] + a[i][l][0];
                    a[i][l][0] = xi;
                    xi = a[i][l][1] - a[j][k][1];
                    double[] dArray8 = a[j][k];
                    dArray8[1] = dArray8[1] + a[i][l][1];
                    a[i][l][1] = xi;
                }
            }
            for (k = 1; k < n2h; ++k) {
                l = this.rows - k;
                xi = a[0][k][0] - a[0][l][0];
                double[] dArray = a[0][k];
                dArray[0] = dArray[0] + a[0][l][0];
                a[0][l][0] = xi;
                xi = a[0][l][1] - a[0][k][1];
                double[] dArray9 = a[0][k];
                dArray9[1] = dArray9[1] + a[0][l][1];
                a[0][l][1] = xi;
                xi = a[n1h][k][0] - a[n1h][l][0];
                double[] dArray10 = a[n1h][k];
                dArray10[0] = dArray10[0] + a[n1h][l][0];
                a[n1h][l][0] = xi;
                xi = a[n1h][l][1] - a[n1h][k][1];
                double[] dArray11 = a[n1h][k];
                dArray11[1] = dArray11[1] + a[n1h][l][1];
                a[n1h][l][1] = xi;
            }
        } else {
            int l;
            int k;
            for (int i = 1; i < n1h; ++i) {
                int j = this.slices - i;
                a[j][0][0] = 0.5 * (a[i][0][0] - a[j][0][0]);
                double[] dArray = a[i][0];
                dArray[0] = dArray[0] - a[j][0][0];
                a[j][0][1] = 0.5 * (a[i][0][1] + a[j][0][1]);
                double[] dArray12 = a[i][0];
                dArray12[1] = dArray12[1] - a[j][0][1];
                a[j][n2h][0] = 0.5 * (a[i][n2h][0] - a[j][n2h][0]);
                double[] dArray13 = a[i][n2h];
                dArray13[0] = dArray13[0] - a[j][n2h][0];
                a[j][n2h][1] = 0.5 * (a[i][n2h][1] + a[j][n2h][1]);
                double[] dArray14 = a[i][n2h];
                dArray14[1] = dArray14[1] - a[j][n2h][1];
                for (k = 1; k < n2h; ++k) {
                    l = this.rows - k;
                    a[j][l][0] = 0.5 * (a[i][k][0] - a[j][l][0]);
                    double[] dArray15 = a[i][k];
                    dArray15[0] = dArray15[0] - a[j][l][0];
                    a[j][l][1] = 0.5 * (a[i][k][1] + a[j][l][1]);
                    double[] dArray16 = a[i][k];
                    dArray16[1] = dArray16[1] - a[j][l][1];
                    a[i][l][0] = 0.5 * (a[j][k][0] - a[i][l][0]);
                    double[] dArray17 = a[j][k];
                    dArray17[0] = dArray17[0] - a[i][l][0];
                    a[i][l][1] = 0.5 * (a[j][k][1] + a[i][l][1]);
                    double[] dArray18 = a[j][k];
                    dArray18[1] = dArray18[1] - a[i][l][1];
                }
            }
            for (k = 1; k < n2h; ++k) {
                l = this.rows - k;
                a[0][l][0] = 0.5 * (a[0][k][0] - a[0][l][0]);
                double[] dArray = a[0][k];
                dArray[0] = dArray[0] - a[0][l][0];
                a[0][l][1] = 0.5 * (a[0][k][1] + a[0][l][1]);
                double[] dArray19 = a[0][k];
                dArray19[1] = dArray19[1] - a[0][l][1];
                a[n1h][l][0] = 0.5 * (a[n1h][k][0] - a[n1h][l][0]);
                double[] dArray20 = a[n1h][k];
                dArray20[0] = dArray20[0] - a[n1h][l][0];
                a[n1h][l][1] = 0.5 * (a[n1h][k][1] + a[n1h][l][1]);
                double[] dArray21 = a[n1h][k];
                dArray21[1] = dArray21[1] - a[n1h][l][1];
            }
        }
    }

    public void realForward(double[] a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (nthreads > 1) {
                this.nt *= nthreads;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, a, true);
            this.cdft3db_subth(-1, a, true);
            this.rdft3d_sub(1, a);
        } else {
            this.xdft3da_sub1(1, -1, a, true);
            this.cdft3db_sub(-1, a, true);
            this.rdft3d_sub(1, a);
        }
    }

    public void realForward(double[][][] a) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (nthreads > 1) {
                this.nt *= nthreads;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.xdft3da_subth1(1, -1, a, true);
            this.cdft3db_subth(-1, a, true);
            this.rdft3d_sub(1, a);
        } else {
            this.xdft3da_sub1(1, -1, a, true);
            this.cdft3db_sub(-1, a, true);
            this.rdft3d_sub(1, a);
        }
    }

    public void realForwardFull(double[] a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, a, true);
                this.cdft3db_subth(-1, a, true);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, -1, a, true);
                this.cdft3db_sub(-1, a, true);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realForwardFull(double[][][] a) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, -1, a, true);
                this.cdft3db_subth(-1, a, true);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, -1, a, true);
                this.cdft3db_sub(-1, a, true);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealForwardFull(a);
        }
    }

    public void realInverse(double[] a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (nthreads > 1) {
                this.nt *= nthreads;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.rdft3d_sub(-1, a);
            this.cdft3db_subth(1, a, scale);
            this.xdft3da_subth1(1, 1, a, scale);
        } else {
            this.rdft3d_sub(-1, a);
            this.cdft3db_sub(1, a, scale);
            this.xdft3da_sub1(1, 1, a, scale);
        }
    }

    public void realInverse(double[][][] a, boolean scale) {
        if (!this.isPowerOfTwo) {
            throw new IllegalArgumentException("slices, rows and columns must be power of two numbers");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads != this.oldNthreads) {
            this.nt = this.slices;
            if (this.nt < this.rows) {
                this.nt = this.rows;
            }
            this.nt *= 8;
            if (nthreads > 1) {
                this.nt *= nthreads;
            }
            if (this.columns == 4) {
                this.nt >>= 1;
            } else if (this.columns < 4) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
            this.oldNthreads = nthreads;
        }
        if (nthreads > 1 && this.useThreads) {
            this.rdft3d_sub(-1, a);
            this.cdft3db_subth(1, a, scale);
            this.xdft3da_subth1(1, 1, a, scale);
        } else {
            this.rdft3d_sub(-1, a);
            this.cdft3db_sub(1, a, scale);
            this.xdft3da_sub1(1, 1, a, scale);
        }
    }

    public void realInverseFull(double[] a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    public void realInverseFull(double[][][] a, boolean scale) {
        if (this.isPowerOfTwo) {
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 8;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 4) {
                    this.nt >>= 1;
                } else if (this.columns < 4) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.xdft3da_subth2(1, 1, a, scale);
                this.cdft3db_subth(1, a, scale);
                this.rdft3d_sub(1, a);
            } else {
                this.xdft3da_sub2(1, 1, a, scale);
                this.cdft3db_sub(1, a, scale);
                this.rdft3d_sub(1, a);
            }
            this.fillSymmetric(a);
        } else {
            this.mixedRadixRealInverseFull(a, scale);
        }
    }

    private void xdft3da_sub1(int icr, int isgn, double[] a, boolean scale) {
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexForward(a, idx0 + r * this.rowStride);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realInverse(a, idx0 + r * this.rowStride, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            this.t[idx4] = a[idx1 + 4];
                            this.t[idx4 + 1] = a[idx1 + 5];
                            this.t[idx5] = a[idx1 + 6];
                            this.t[idx5 + 1] = a[idx1 + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            a[idx1 + 4] = this.t[idx4];
                            a[idx1 + 5] = this.t[idx4 + 1];
                            a[idx1 + 6] = this.t[idx5];
                            a[idx1 + 7] = this.t[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexInverse(a, idx0 + r * this.rowStride, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            this.t[idx4] = a[idx1 + 4];
                            this.t[idx4 + 1] = a[idx1 + 5];
                            this.t[idx5] = a[idx1 + 6];
                            this.t[idx5 + 1] = a[idx1 + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, scale);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            a[idx1 + 4] = this.t[idx4];
                            a[idx1 + 5] = this.t[idx4 + 1];
                            a[idx1 + 6] = this.t[idx5];
                            a[idx1 + 7] = this.t[idx5 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                    }
                } else if (this.columns == 2) {
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                    }
                }
                if (icr == 0) continue;
                for (r = 0; r < this.rows; ++r) {
                    this.fftColumns.realForward(a, idx0 + r * this.rowStride);
                }
            }
        }
    }

    private void xdft3da_sub1(int icr, int isgn, double[][][] a, boolean scale) {
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexForward(a[s][r]);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realInverse(a[s][r], 0, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[s][r2][c];
                            this.t[idx2 + 1] = a[s][r2][c + 1];
                            this.t[idx3] = a[s][r2][c + 2];
                            this.t[idx3 + 1] = a[s][r2][c + 3];
                            this.t[idx4] = a[s][r2][c + 4];
                            this.t[idx4 + 1] = a[s][r2][c + 5];
                            this.t[idx5] = a[s][r2][c + 6];
                            this.t[idx5 + 1] = a[s][r2][c + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s][r2][c] = this.t[idx2];
                            a[s][r2][c + 1] = this.t[idx2 + 1];
                            a[s][r2][c + 2] = this.t[idx3];
                            a[s][r2][c + 3] = this.t[idx3 + 1];
                            a[s][r2][c + 4] = this.t[idx4];
                            a[s][r2][c + 5] = this.t[idx4 + 1];
                            a[s][r2][c + 6] = this.t[idx5];
                            a[s][r2][c + 7] = this.t[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        this.t[idx3] = a[s][r][2];
                        this.t[idx3 + 1] = a[s][r][3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        a[s][r][2] = this.t[idx3];
                        a[s][r][3] = this.t[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    this.t[idx2] = a[s][r][0];
                    this.t[idx2 + 1] = a[s][r][1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[s][r][0] = this.t[idx2];
                    a[s][r][1] = this.t[idx2 + 1];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexInverse(a[s][r], scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[s][r3][c];
                            this.t[idx2 + 1] = a[s][r3][c + 1];
                            this.t[idx3] = a[s][r3][c + 2];
                            this.t[idx3 + 1] = a[s][r3][c + 3];
                            this.t[idx4] = a[s][r3][c + 4];
                            this.t[idx4 + 1] = a[s][r3][c + 5];
                            this.t[idx5] = a[s][r3][c + 6];
                            this.t[idx5 + 1] = a[s][r3][c + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, scale);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s][r3][c] = this.t[idx2];
                            a[s][r3][c + 1] = this.t[idx2 + 1];
                            a[s][r3][c + 2] = this.t[idx3];
                            a[s][r3][c + 3] = this.t[idx3 + 1];
                            a[s][r3][c + 4] = this.t[idx4];
                            a[s][r3][c + 5] = this.t[idx4 + 1];
                            a[s][r3][c + 6] = this.t[idx5];
                            a[s][r3][c + 7] = this.t[idx5 + 1];
                        }
                    }
                } else if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        this.t[idx3] = a[s][r][2];
                        this.t[idx3 + 1] = a[s][r][3];
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        a[s][r][2] = this.t[idx3];
                        a[s][r][3] = this.t[idx3 + 1];
                    }
                } else if (this.columns == 2) {
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                    }
                }
                if (icr == 0) continue;
                for (r = 0; r < this.rows; ++r) {
                    this.fftColumns.realForward(a[s][r], 0);
                }
            }
        }
    }

    private void xdft3da_sub2(int icr, int isgn, double[] a, boolean scale) {
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexForward(a, idx0 + r * this.rowStride);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realForward(a, idx0 + r * this.rowStride);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            this.t[idx4] = a[idx1 + 4];
                            this.t[idx4 + 1] = a[idx1 + 5];
                            this.t[idx5] = a[idx1 + 6];
                            this.t[idx5 + 1] = a[idx1 + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            a[idx1 + 4] = this.t[idx4];
                            a[idx1 + 5] = this.t[idx4 + 1];
                            a[idx1 + 6] = this.t[idx5];
                            a[idx1 + 7] = this.t[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int idx3;
                int idx2;
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexInverse(a, idx0 + r * this.rowStride, scale);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realInverse2(a, idx0 + r * this.rowStride, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[idx1];
                            this.t[idx2 + 1] = a[idx1 + 1];
                            this.t[idx3] = a[idx1 + 2];
                            this.t[idx3 + 1] = a[idx1 + 3];
                            this.t[idx4] = a[idx1 + 4];
                            this.t[idx4 + 1] = a[idx1 + 5];
                            this.t[idx5] = a[idx1 + 6];
                            this.t[idx5 + 1] = a[idx1 + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, scale);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[idx1] = this.t[idx2];
                            a[idx1 + 1] = this.t[idx2 + 1];
                            a[idx1 + 2] = this.t[idx3];
                            a[idx1 + 3] = this.t[idx3 + 1];
                            a[idx1 + 4] = this.t[idx4];
                            a[idx1 + 5] = this.t[idx4 + 1];
                            a[idx1 + 6] = this.t[idx5];
                            a[idx1 + 7] = this.t[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[idx1];
                        this.t[idx2 + 1] = a[idx1 + 1];
                        this.t[idx3] = a[idx1 + 2];
                        this.t[idx3 + 1] = a[idx1 + 3];
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx1 = idx0 + r * this.rowStride;
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[idx1] = this.t[idx2];
                        a[idx1 + 1] = this.t[idx2 + 1];
                        a[idx1 + 2] = this.t[idx3];
                        a[idx1 + 3] = this.t[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    this.t[idx2] = a[idx1];
                    this.t[idx2 + 1] = a[idx1 + 1];
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    idx2 = 2 * r;
                    a[idx1] = this.t[idx2];
                    a[idx1 + 1] = this.t[idx2 + 1];
                }
            }
        }
    }

    private void xdft3da_sub2(int icr, int isgn, double[][][] a, boolean scale) {
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexForward(a[s][r]);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realForward(a[s][r]);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[s][r2][c];
                            this.t[idx2 + 1] = a[s][r2][c + 1];
                            this.t[idx3] = a[s][r2][c + 2];
                            this.t[idx3 + 1] = a[s][r2][c + 3];
                            this.t[idx4] = a[s][r2][c + 4];
                            this.t[idx4 + 1] = a[s][r2][c + 5];
                            this.t[idx5] = a[s][r2][c + 6];
                            this.t[idx5 + 1] = a[s][r2][c + 7];
                        }
                        this.fftRows.complexForward(this.t, 0);
                        this.fftRows.complexForward(this.t, 2 * this.rows);
                        this.fftRows.complexForward(this.t, 4 * this.rows);
                        this.fftRows.complexForward(this.t, 6 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = 2 * r2;
                            idx3 = 2 * this.rows + 2 * r2;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s][r2][c] = this.t[idx2];
                            a[s][r2][c + 1] = this.t[idx2 + 1];
                            a[s][r2][c + 2] = this.t[idx3];
                            a[s][r2][c + 3] = this.t[idx3 + 1];
                            a[s][r2][c + 4] = this.t[idx4];
                            a[s][r2][c + 5] = this.t[idx4 + 1];
                            a[s][r2][c + 6] = this.t[idx5];
                            a[s][r2][c + 7] = this.t[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        this.t[idx3] = a[s][r][2];
                        this.t[idx3 + 1] = a[s][r][3];
                    }
                    this.fftRows.complexForward(this.t, 0);
                    this.fftRows.complexForward(this.t, 2 * this.rows);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        a[s][r][2] = this.t[idx3];
                        a[s][r][3] = this.t[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    this.t[idx2] = a[s][r][0];
                    this.t[idx2 + 1] = a[s][r][1];
                }
                this.fftRows.complexForward(this.t, 0);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[s][r][0] = this.t[idx2];
                    a[s][r][1] = this.t[idx2 + 1];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int idx3;
                int idx2;
                int r;
                if (icr == 0) {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.complexInverse(a[s][r], scale);
                    }
                } else {
                    for (r = 0; r < this.rows; ++r) {
                        this.fftColumns.realInverse2(a[s][r], 0, scale);
                    }
                }
                if (this.columns > 4) {
                    for (int c = 0; c < this.columns; c += 8) {
                        int idx5;
                        int idx4;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            this.t[idx2] = a[s][r3][c];
                            this.t[idx2 + 1] = a[s][r3][c + 1];
                            this.t[idx3] = a[s][r3][c + 2];
                            this.t[idx3 + 1] = a[s][r3][c + 3];
                            this.t[idx4] = a[s][r3][c + 4];
                            this.t[idx4 + 1] = a[s][r3][c + 5];
                            this.t[idx5] = a[s][r3][c + 6];
                            this.t[idx5 + 1] = a[s][r3][c + 7];
                        }
                        this.fftRows.complexInverse(this.t, 0, scale);
                        this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 4 * this.rows, scale);
                        this.fftRows.complexInverse(this.t, 6 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = 2 * r3;
                            idx3 = 2 * this.rows + 2 * r3;
                            idx4 = idx3 + 2 * this.rows;
                            idx5 = idx4 + 2 * this.rows;
                            a[s][r3][c] = this.t[idx2];
                            a[s][r3][c + 1] = this.t[idx2 + 1];
                            a[s][r3][c + 2] = this.t[idx3];
                            a[s][r3][c + 3] = this.t[idx3 + 1];
                            a[s][r3][c + 4] = this.t[idx4];
                            a[s][r3][c + 5] = this.t[idx4 + 1];
                            a[s][r3][c + 6] = this.t[idx5];
                            a[s][r3][c + 7] = this.t[idx5 + 1];
                        }
                    }
                    continue;
                }
                if (this.columns == 4) {
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        this.t[idx2] = a[s][r][0];
                        this.t[idx2 + 1] = a[s][r][1];
                        this.t[idx3] = a[s][r][2];
                        this.t[idx3 + 1] = a[s][r][3];
                    }
                    this.fftRows.complexInverse(this.t, 0, scale);
                    this.fftRows.complexInverse(this.t, 2 * this.rows, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx2 = 2 * r;
                        idx3 = 2 * this.rows + 2 * r;
                        a[s][r][0] = this.t[idx2];
                        a[s][r][1] = this.t[idx2 + 1];
                        a[s][r][2] = this.t[idx3];
                        a[s][r][3] = this.t[idx3 + 1];
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    this.t[idx2] = a[s][r][0];
                    this.t[idx2 + 1] = a[s][r][1];
                }
                this.fftRows.complexInverse(this.t, 0, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx2 = 2 * r;
                    a[s][r][0] = this.t[idx2];
                    a[s][r][1] = this.t[idx2 + 1];
                }
            }
        }
    }

    private void xdft3da_subth1(final int icr, final int isgn, final double[] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = 8 * this.rows;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int s = n0; s < DoubleFFT_3D.this.slices; s += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s * DoubleFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a, idx0 + r * DoubleFFT_3D.this.rowStride);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realInverse(a, idx0 + r * DoubleFFT_3D.this.rowStride, scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        DoubleFFT_3D.this.t[idx2] = a[idx1];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                        DoubleFFT_3D.this.t[idx4] = a[idx1 + 4];
                                        DoubleFFT_3D.this.t[idx4 + 1] = a[idx1 + 5];
                                        DoubleFFT_3D.this.t[idx5] = a[idx1 + 6];
                                        DoubleFFT_3D.this.t[idx5 + 1] = a[idx1 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[idx1] = DoubleFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                        a[idx1 + 4] = DoubleFFT_3D.this.t[idx4];
                                        a[idx1 + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                        a[idx1 + 6] = DoubleFFT_3D.this.t[idx5];
                                        a[idx1 + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    DoubleFFT_3D.this.t[idx2] = a[idx1];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                    DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                    DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[idx1] = DoubleFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                    a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                    a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = startt + 2 * r;
                                DoubleFFT_3D.this.t[idx2] = a[idx1];
                                DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = startt + 2 * r;
                                a[idx1] = DoubleFFT_3D.this.t[idx2];
                                a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s = n0; s < DoubleFFT_3D.this.slices; s += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s * DoubleFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a, idx0 + r * DoubleFFT_3D.this.rowStride, scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        DoubleFFT_3D.this.t[idx2] = a[idx1];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                        DoubleFFT_3D.this.t[idx4] = a[idx1 + 4];
                                        DoubleFFT_3D.this.t[idx4 + 1] = a[idx1 + 5];
                                        DoubleFFT_3D.this.t[idx5] = a[idx1 + 6];
                                        DoubleFFT_3D.this.t[idx5 + 1] = a[idx1 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[idx1] = DoubleFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                        a[idx1 + 4] = DoubleFFT_3D.this.t[idx4];
                                        a[idx1 + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                        a[idx1 + 6] = DoubleFFT_3D.this.t[idx5];
                                        a[idx1 + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                    }
                                }
                            } else if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    DoubleFFT_3D.this.t[idx2] = a[idx1];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                    DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                    DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[idx1] = DoubleFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                    a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                    a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                }
                            } else if (DoubleFFT_3D.this.columns == 2) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    DoubleFFT_3D.this.t[idx2] = a[idx1];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    a[idx1] = DoubleFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                }
                            }
                            if (icr == 0) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.realForward(a, idx0 + r * DoubleFFT_3D.this.rowStride);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft3da_subth1(final int icr, final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = 8 * this.rows;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int s = n0; s < DoubleFFT_3D.this.slices; s += nthreads) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a[s][r]);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realInverse(a[s][r], 0, scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        DoubleFFT_3D.this.t[idx2] = a[s][r2][c];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[s][r2][c + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[s][r2][c + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[s][r2][c + 3];
                                        DoubleFFT_3D.this.t[idx4] = a[s][r2][c + 4];
                                        DoubleFFT_3D.this.t[idx4 + 1] = a[s][r2][c + 5];
                                        DoubleFFT_3D.this.t[idx5] = a[s][r2][c + 6];
                                        DoubleFFT_3D.this.t[idx5 + 1] = a[s][r2][c + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[s][r2][c] = DoubleFFT_3D.this.t[idx2];
                                        a[s][r2][c + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[s][r2][c + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[s][r2][c + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                        a[s][r2][c + 4] = DoubleFFT_3D.this.t[idx4];
                                        a[s][r2][c + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                        a[s][r2][c + 6] = DoubleFFT_3D.this.t[idx5];
                                        a[s][r2][c + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                                    DoubleFFT_3D.this.t[idx3] = a[s][r][2];
                                    DoubleFFT_3D.this.t[idx3 + 1] = a[s][r][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                    a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                                    a[s][r][2] = DoubleFFT_3D.this.t[idx3];
                                    a[s][r][3] = DoubleFFT_3D.this.t[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s = n0; s < DoubleFFT_3D.this.slices; s += nthreads) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a[s][r], scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        DoubleFFT_3D.this.t[idx2] = a[s][r3][c];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[s][r3][c + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[s][r3][c + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[s][r3][c + 3];
                                        DoubleFFT_3D.this.t[idx4] = a[s][r3][c + 4];
                                        DoubleFFT_3D.this.t[idx4 + 1] = a[s][r3][c + 5];
                                        DoubleFFT_3D.this.t[idx5] = a[s][r3][c + 6];
                                        DoubleFFT_3D.this.t[idx5 + 1] = a[s][r3][c + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[s][r3][c] = DoubleFFT_3D.this.t[idx2];
                                        a[s][r3][c + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[s][r3][c + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[s][r3][c + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                        a[s][r3][c + 4] = DoubleFFT_3D.this.t[idx4];
                                        a[s][r3][c + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                        a[s][r3][c + 6] = DoubleFFT_3D.this.t[idx5];
                                        a[s][r3][c + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                    }
                                }
                            } else if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                                    DoubleFFT_3D.this.t[idx3] = a[s][r][2];
                                    DoubleFFT_3D.this.t[idx3 + 1] = a[s][r][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                    a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                                    a[s][r][2] = DoubleFFT_3D.this.t[idx3];
                                    a[s][r][3] = DoubleFFT_3D.this.t[idx3 + 1];
                                }
                            } else if (DoubleFFT_3D.this.columns == 2) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                    a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                                }
                            }
                            if (icr == 0) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                DoubleFFT_3D.this.fftColumns.realForward(a[s][r]);
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft3da_subth2(final int icr, final int isgn, final double[] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = 8 * this.rows;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int s = n0; s < DoubleFFT_3D.this.slices; s += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s * DoubleFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a, idx0 + r * DoubleFFT_3D.this.rowStride);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realForward(a, idx0 + r * DoubleFFT_3D.this.rowStride);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        DoubleFFT_3D.this.t[idx2] = a[idx1];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                        DoubleFFT_3D.this.t[idx4] = a[idx1 + 4];
                                        DoubleFFT_3D.this.t[idx4 + 1] = a[idx1 + 5];
                                        DoubleFFT_3D.this.t[idx5] = a[idx1 + 6];
                                        DoubleFFT_3D.this.t[idx5 + 1] = a[idx1 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[idx1] = DoubleFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                        a[idx1 + 4] = DoubleFFT_3D.this.t[idx4];
                                        a[idx1 + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                        a[idx1 + 6] = DoubleFFT_3D.this.t[idx5];
                                        a[idx1 + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    DoubleFFT_3D.this.t[idx2] = a[idx1];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                    DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                    DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[idx1] = DoubleFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                    a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                    a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = startt + 2 * r;
                                DoubleFFT_3D.this.t[idx2] = a[idx1];
                                DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = startt + 2 * r;
                                a[idx1] = DoubleFFT_3D.this.t[idx2];
                                a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s = n0; s < DoubleFFT_3D.this.slices; s += nthreads) {
                            int idx3;
                            int idx2;
                            int idx1;
                            int r;
                            int idx0 = s * DoubleFFT_3D.this.sliceStride;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a, idx0 + r * DoubleFFT_3D.this.rowStride, scale);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realInverse2(a, idx0 + r * DoubleFFT_3D.this.rowStride, scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        DoubleFFT_3D.this.t[idx2] = a[idx1];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                        DoubleFFT_3D.this.t[idx4] = a[idx1 + 4];
                                        DoubleFFT_3D.this.t[idx4 + 1] = a[idx1 + 5];
                                        DoubleFFT_3D.this.t[idx5] = a[idx1 + 6];
                                        DoubleFFT_3D.this.t[idx5 + 1] = a[idx1 + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * DoubleFFT_3D.this.rowStride + c;
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[idx1] = DoubleFFT_3D.this.t[idx2];
                                        a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                        a[idx1 + 4] = DoubleFFT_3D.this.t[idx4];
                                        a[idx1 + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                        a[idx1 + 6] = DoubleFFT_3D.this.t[idx5];
                                        a[idx1 + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    DoubleFFT_3D.this.t[idx2] = a[idx1];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                                    DoubleFFT_3D.this.t[idx3] = a[idx1 + 2];
                                    DoubleFFT_3D.this.t[idx3 + 1] = a[idx1 + 3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[idx1] = DoubleFFT_3D.this.t[idx2];
                                    a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                    a[idx1 + 2] = DoubleFFT_3D.this.t[idx3];
                                    a[idx1 + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = startt + 2 * r;
                                DoubleFFT_3D.this.t[idx2] = a[idx1];
                                DoubleFFT_3D.this.t[idx2 + 1] = a[idx1 + 1];
                            }
                            DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * DoubleFFT_3D.this.rowStride;
                                idx2 = startt + 2 * r;
                                a[idx1] = DoubleFFT_3D.this.t[idx2];
                                a[idx1 + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void xdft3da_subth2(final int icr, final int isgn, final double[][][] a, final boolean scale) {
        final int nthreads = Math.min(ConcurrencyUtils.getNumberOfThreads(), this.slices);
        int nt = 8 * this.rows;
        if (this.columns == 4) {
            nt >>= 1;
        } else if (this.columns < 4) {
            nt >>= 2;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int s = n0; s < DoubleFFT_3D.this.slices; s += nthreads) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexForward(a[s][r]);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realForward(a[s][r]);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r2;
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        DoubleFFT_3D.this.t[idx2] = a[s][r2][c];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[s][r2][c + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[s][r2][c + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[s][r2][c + 3];
                                        DoubleFFT_3D.this.t[idx4] = a[s][r2][c + 4];
                                        DoubleFFT_3D.this.t[idx4 + 1] = a[s][r2][c + 5];
                                        DoubleFFT_3D.this.t[idx5] = a[s][r2][c + 6];
                                        DoubleFFT_3D.this.t[idx5 + 1] = a[s][r2][c + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.rows);
                                    DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.rows);
                                    for (r2 = 0; r2 < DoubleFFT_3D.this.rows; ++r2) {
                                        idx2 = startt + 2 * r2;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r2;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[s][r2][c] = DoubleFFT_3D.this.t[idx2];
                                        a[s][r2][c + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[s][r2][c + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[s][r2][c + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                        a[s][r2][c + 4] = DoubleFFT_3D.this.t[idx4];
                                        a[s][r2][c + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                        a[s][r2][c + 6] = DoubleFFT_3D.this.t[idx5];
                                        a[s][r2][c + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                                    DoubleFFT_3D.this.t[idx3] = a[s][r][2];
                                    DoubleFFT_3D.this.t[idx3 + 1] = a[s][r][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                                DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                    a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                                    a[s][r][2] = DoubleFFT_3D.this.t[idx3];
                                    a[s][r][3] = DoubleFFT_3D.this.t[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexForward(DoubleFFT_3D.this.t, startt);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                            }
                        }
                    } else {
                        for (int s = n0; s < DoubleFFT_3D.this.slices; s += nthreads) {
                            int idx3;
                            int idx2;
                            int r;
                            if (icr == 0) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.complexInverse(a[s][r], scale);
                                }
                            } else {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    DoubleFFT_3D.this.fftColumns.realInverse2(a[s][r], 0, scale);
                                }
                            }
                            if (DoubleFFT_3D.this.columns > 4) {
                                for (int c = 0; c < DoubleFFT_3D.this.columns; c += 8) {
                                    int idx5;
                                    int idx4;
                                    int r3;
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        DoubleFFT_3D.this.t[idx2] = a[s][r3][c];
                                        DoubleFFT_3D.this.t[idx2 + 1] = a[s][r3][c + 1];
                                        DoubleFFT_3D.this.t[idx3] = a[s][r3][c + 2];
                                        DoubleFFT_3D.this.t[idx3 + 1] = a[s][r3][c + 3];
                                        DoubleFFT_3D.this.t[idx4] = a[s][r3][c + 4];
                                        DoubleFFT_3D.this.t[idx4 + 1] = a[s][r3][c + 5];
                                        DoubleFFT_3D.this.t[idx5] = a[s][r3][c + 6];
                                        DoubleFFT_3D.this.t[idx5 + 1] = a[s][r3][c + 7];
                                    }
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 4 * DoubleFFT_3D.this.rows, scale);
                                    DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 6 * DoubleFFT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < DoubleFFT_3D.this.rows; ++r3) {
                                        idx2 = startt + 2 * r3;
                                        idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r3;
                                        idx4 = idx3 + 2 * DoubleFFT_3D.this.rows;
                                        idx5 = idx4 + 2 * DoubleFFT_3D.this.rows;
                                        a[s][r3][c] = DoubleFFT_3D.this.t[idx2];
                                        a[s][r3][c + 1] = DoubleFFT_3D.this.t[idx2 + 1];
                                        a[s][r3][c + 2] = DoubleFFT_3D.this.t[idx3];
                                        a[s][r3][c + 3] = DoubleFFT_3D.this.t[idx3 + 1];
                                        a[s][r3][c + 4] = DoubleFFT_3D.this.t[idx4];
                                        a[s][r3][c + 5] = DoubleFFT_3D.this.t[idx4 + 1];
                                        a[s][r3][c + 6] = DoubleFFT_3D.this.t[idx5];
                                        a[s][r3][c + 7] = DoubleFFT_3D.this.t[idx5 + 1];
                                    }
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns == 4) {
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                    DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                                    DoubleFFT_3D.this.t[idx3] = a[s][r][2];
                                    DoubleFFT_3D.this.t[idx3 + 1] = a[s][r][3];
                                }
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                                DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt + 2 * DoubleFFT_3D.this.rows, scale);
                                for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                    idx2 = startt + 2 * r;
                                    idx3 = startt + 2 * DoubleFFT_3D.this.rows + 2 * r;
                                    a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                    a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                                    a[s][r][2] = DoubleFFT_3D.this.t[idx3];
                                    a[s][r][3] = DoubleFFT_3D.this.t[idx3 + 1];
                                }
                                continue;
                            }
                            if (DoubleFFT_3D.this.columns != 2) continue;
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                DoubleFFT_3D.this.t[idx2] = a[s][r][0];
                                DoubleFFT_3D.this.t[idx2 + 1] = a[s][r][1];
                            }
                            DoubleFFT_3D.this.fftRows.complexInverse(DoubleFFT_3D.this.t, startt, scale);
                            for (r = 0; r < DoubleFFT_3D.this.rows; ++r) {
                                idx2 = startt + 2 * r;
                                a[s][r][0] = DoubleFFT_3D.this.t[idx2];
                                a[s][r][1] = DoubleFFT_3D.this.t[idx2 + 1];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }
}

