/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.dht;

import de.gsi.math.spectra.fft.FloatFFT_1D;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class FloatDHT_1D {
    private final int n;
    private final FloatFFT_1D fft;

    public FloatDHT_1D(int n) {
        this.n = n;
        this.fft = new FloatFFT_1D(n);
    }

    public void forward(float[] a) {
        this.forward(a, 0);
    }

    public void forward(final float[] a, final int offa) {
        if (this.n == 1) {
            return;
        }
        this.fft.realForward(a, offa);
        final float[] b = new float[this.n];
        System.arraycopy(a, offa, b, 0, this.n);
        int nd2 = this.n / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && nd2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k1 = nd2 / nthreads;
            Future[] futures = new Future[nthreads];
            for (int i = 0; i < nthreads; ++i) {
                final int firstIdx = 1 + i * k1;
                final int lastIdx = i == nthreads - 1 ? nd2 : firstIdx + k1;
                futures[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int idx1 = 2 * i;
                            int idx2 = idx1 + 1;
                            a[offa + i] = b[idx1] - b[idx2];
                            a[offa + FloatDHT_1D.this.n - i] = b[idx1] + b[idx2];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 1; i < nd2; ++i) {
                int idx1 = 2 * i;
                int idx2 = idx1 + 1;
                a[offa + i] = b[idx1] - b[idx2];
                a[offa + this.n - i] = b[idx1] + b[idx2];
            }
        }
        if (this.n % 2 == 0) {
            a[offa + nd2] = b[1];
        } else {
            a[offa + nd2] = b[this.n - 1] - b[1];
            a[offa + nd2 + 1] = b[this.n - 1] + b[1];
        }
    }

    public void inverse(float[] a, boolean scale) {
        this.inverse(a, 0, scale);
    }

    public void inverse(float[] a, int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        this.forward(a, offa);
        if (scale) {
            this.scale(this.n, a, offa);
        }
    }

    private void scale(float m, final float[] a, int offa) {
        final float norm = (float)(1.0 / (double)m);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k = this.n / nthreads;
            Future[] futures = new Future[nthreads];
            for (int i = 0; i < nthreads; ++i) {
                final int firstIdx = offa + i * k;
                final int lastIdx = i == nthreads - 1 ? offa + this.n : firstIdx + k;
                futures[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int n = i++;
                            a[n] = a[n] * norm;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int lastIdx = offa + this.n;
            int i = offa;
            while (i < lastIdx) {
                int n = i++;
                a[n] = a[n] * norm;
            }
        }
    }
}

