/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.dct;

import de.gsi.math.spectra.fft.DoubleFFT_1D;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDCT_1D {
    private static final double PI = Math.PI;
    private final int n;
    private int[] ip;
    private double[] w;
    private int nw;
    private int nc;
    private boolean isPowerOfTwo = false;
    private DoubleFFT_1D fft;

    public DoubleDCT_1D(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.n = n;
        if (ConcurrencyUtils.isPowerOf2(n)) {
            this.isPowerOfTwo = true;
            this.ip = new int[(int)Math.ceil(2 + (1 << (int)(Math.log((double)(n / 2) + 0.5) / Math.log(2.0)) / 2))];
            this.w = new double[n * 5 / 4];
            this.nw = this.ip[0];
            if (n > this.nw << 2) {
                this.nw = n >> 2;
                this.makewt(this.nw);
            }
            this.nc = this.ip[1];
            if (n > this.nc) {
                this.nc = n;
                this.makect(this.nc, this.w, this.nw);
            }
        } else {
            this.w = this.makect(n);
            this.fft = new DoubleFFT_1D(2 * n);
        }
    }

    private void bitrv2(int n, int[] ip, double[] a, int offa) {
        int l;
        int m = 1;
        for (l = n >> 2; l > 8; l >>= 2) {
            m <<= 1;
        }
        int nh = n >> 1;
        int nm = 4 * m;
        if (l == 8) {
            for (int k = 0; k < m; ++k) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                for (int j = 0; j < k; ++j) {
                    j1 = 4 * j + 2 * ip[m + k];
                    k1 = 4 * k + 2 * ip[m + j];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                }
                k1 = 4 * k + 2 * ip[m + k];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2 * nm);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 -= 2);
                idx2 = offa + (k1 -= nh);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nh + 2);
                idx2 = offa + (k1 += nh + 2);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2 * nm - 2);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
            }
        } else {
            for (int k = 0; k < m; ++k) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                for (int j = 0; j < k; ++j) {
                    j1 = 4 * j + ip[m + k];
                    k1 = 4 * k + ip[m + j];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                }
                k1 = 4 * k + ip[m + k];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
            }
        }
    }

    private void bitrv208(double[] a, int offa) {
        double x1r = a[offa + 2];
        double x1i = a[offa + 3];
        double x3r = a[offa + 6];
        double x3i = a[offa + 7];
        double x4r = a[offa + 8];
        double x4i = a[offa + 9];
        double x6r = a[offa + 12];
        double x6i = a[offa + 13];
        a[offa + 2] = x4r;
        a[offa + 3] = x4i;
        a[offa + 6] = x6r;
        a[offa + 7] = x6i;
        a[offa + 8] = x1r;
        a[offa + 9] = x1i;
        a[offa + 12] = x3r;
        a[offa + 13] = x3i;
    }

    private void bitrv208neg(double[] a, int offa) {
        double x1r = a[offa + 2];
        double x1i = a[offa + 3];
        double x2r = a[offa + 4];
        double x2i = a[offa + 5];
        double x3r = a[offa + 6];
        double x3i = a[offa + 7];
        double x4r = a[offa + 8];
        double x4i = a[offa + 9];
        double x5r = a[offa + 10];
        double x5i = a[offa + 11];
        double x6r = a[offa + 12];
        double x6i = a[offa + 13];
        double x7r = a[offa + 14];
        double x7i = a[offa + 15];
        a[offa + 2] = x7r;
        a[offa + 3] = x7i;
        a[offa + 4] = x3r;
        a[offa + 5] = x3i;
        a[offa + 6] = x5r;
        a[offa + 7] = x5i;
        a[offa + 8] = x1r;
        a[offa + 9] = x1i;
        a[offa + 10] = x6r;
        a[offa + 11] = x6i;
        a[offa + 12] = x2r;
        a[offa + 13] = x2i;
        a[offa + 14] = x4r;
        a[offa + 15] = x4i;
    }

    private void bitrv216(double[] a, int offa) {
        double x1r = a[offa + 2];
        double x1i = a[offa + 3];
        double x2r = a[offa + 4];
        double x2i = a[offa + 5];
        double x3r = a[offa + 6];
        double x3i = a[offa + 7];
        double x4r = a[offa + 8];
        double x4i = a[offa + 9];
        double x5r = a[offa + 10];
        double x5i = a[offa + 11];
        double x7r = a[offa + 14];
        double x7i = a[offa + 15];
        double x8r = a[offa + 16];
        double x8i = a[offa + 17];
        double x10r = a[offa + 20];
        double x10i = a[offa + 21];
        double x11r = a[offa + 22];
        double x11i = a[offa + 23];
        double x12r = a[offa + 24];
        double x12i = a[offa + 25];
        double x13r = a[offa + 26];
        double x13i = a[offa + 27];
        double x14r = a[offa + 28];
        double x14i = a[offa + 29];
        a[offa + 2] = x8r;
        a[offa + 3] = x8i;
        a[offa + 4] = x4r;
        a[offa + 5] = x4i;
        a[offa + 6] = x12r;
        a[offa + 7] = x12i;
        a[offa + 8] = x2r;
        a[offa + 9] = x2i;
        a[offa + 10] = x10r;
        a[offa + 11] = x10i;
        a[offa + 14] = x14r;
        a[offa + 15] = x14i;
        a[offa + 16] = x1r;
        a[offa + 17] = x1i;
        a[offa + 20] = x5r;
        a[offa + 21] = x5i;
        a[offa + 22] = x13r;
        a[offa + 23] = x13i;
        a[offa + 24] = x3r;
        a[offa + 25] = x3i;
        a[offa + 26] = x11r;
        a[offa + 27] = x11i;
        a[offa + 28] = x7r;
        a[offa + 29] = x7i;
    }

    private void bitrv216neg(double[] a, int offa) {
        double x1r = a[offa + 2];
        double x1i = a[offa + 3];
        double x2r = a[offa + 4];
        double x2i = a[offa + 5];
        double x3r = a[offa + 6];
        double x3i = a[offa + 7];
        double x4r = a[offa + 8];
        double x4i = a[offa + 9];
        double x5r = a[offa + 10];
        double x5i = a[offa + 11];
        double x6r = a[offa + 12];
        double x6i = a[offa + 13];
        double x7r = a[offa + 14];
        double x7i = a[offa + 15];
        double x8r = a[offa + 16];
        double x8i = a[offa + 17];
        double x9r = a[offa + 18];
        double x9i = a[offa + 19];
        double x10r = a[offa + 20];
        double x10i = a[offa + 21];
        double x11r = a[offa + 22];
        double x11i = a[offa + 23];
        double x12r = a[offa + 24];
        double x12i = a[offa + 25];
        double x13r = a[offa + 26];
        double x13i = a[offa + 27];
        double x14r = a[offa + 28];
        double x14i = a[offa + 29];
        double x15r = a[offa + 30];
        double x15i = a[offa + 31];
        a[offa + 2] = x15r;
        a[offa + 3] = x15i;
        a[offa + 4] = x7r;
        a[offa + 5] = x7i;
        a[offa + 6] = x11r;
        a[offa + 7] = x11i;
        a[offa + 8] = x3r;
        a[offa + 9] = x3i;
        a[offa + 10] = x13r;
        a[offa + 11] = x13i;
        a[offa + 12] = x5r;
        a[offa + 13] = x5i;
        a[offa + 14] = x9r;
        a[offa + 15] = x9i;
        a[offa + 16] = x1r;
        a[offa + 17] = x1i;
        a[offa + 18] = x14r;
        a[offa + 19] = x14i;
        a[offa + 20] = x6r;
        a[offa + 21] = x6i;
        a[offa + 22] = x10r;
        a[offa + 23] = x10i;
        a[offa + 24] = x2r;
        a[offa + 25] = x2i;
        a[offa + 26] = x12r;
        a[offa + 27] = x12i;
        a[offa + 28] = x4r;
        a[offa + 29] = x4i;
        a[offa + 30] = x8r;
        a[offa + 31] = x8i;
    }

    private void bitrv2conj(int n, int[] ip, double[] a, int offa) {
        int l;
        int m = 1;
        for (l = n >> 2; l > 8; l >>= 2) {
            m <<= 1;
        }
        int nh = n >> 1;
        int nm = 4 * m;
        if (l == 8) {
            for (int k = 0; k < m; ++k) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                for (int j = 0; j < k; ++j) {
                    j1 = 4 * j + 2 * ip[m + k];
                    k1 = 4 * k + 2 * ip[m + j];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                }
                k1 = 4 * k + 2 * ip[m + k];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a[idx1 - 1] = -a[idx1 - 1];
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                a[idx2 + 3] = -a[idx2 + 3];
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2 * nm);
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 -= 2);
                idx2 = offa + (k1 -= nh);
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nh + 2);
                idx2 = offa + (k1 += nh + 2);
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2 * nm - 2);
                a[idx1 - 1] = -a[idx1 - 1];
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                a[idx2 + 3] = -a[idx2 + 3];
            }
        } else {
            for (int k = 0; k < m; ++k) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                for (int j = 0; j < k; ++j) {
                    j1 = 4 * j + ip[m + k];
                    k1 = 4 * k + ip[m + j];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                }
                k1 = 4 * k + ip[m + k];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a[idx1 - 1] = -a[idx1 - 1];
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                a[idx2 + 3] = -a[idx2 + 3];
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                a[idx1 - 1] = -a[idx1 - 1];
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                a[idx2 + 3] = -a[idx2 + 3];
            }
        }
    }

    private void cftb040(double[] a, int offa) {
        double x0r = a[offa] + a[offa + 4];
        double x0i = a[offa + 1] + a[offa + 5];
        double x1r = a[offa] - a[offa + 4];
        double x1i = a[offa + 1] - a[offa + 5];
        double x2r = a[offa + 2] + a[offa + 6];
        double x2i = a[offa + 3] + a[offa + 7];
        double x3r = a[offa + 2] - a[offa + 6];
        double x3i = a[offa + 3] - a[offa + 7];
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i + x2i;
        a[offa + 2] = x1r + x3i;
        a[offa + 3] = x1i - x3r;
        a[offa + 4] = x0r - x2r;
        a[offa + 5] = x0i - x2i;
        a[offa + 6] = x1r - x3i;
        a[offa + 7] = x1i + x3r;
    }

    private void cftb1st(int n, double[] a, int offa, double[] w, int startw) {
        int idx0;
        int j0;
        double wk3i;
        double wk3r;
        double wk1i;
        double wk1r;
        int m;
        int mh = n >> 3;
        int j1 = m = 2 * mh;
        int j2 = j1 + m;
        int j3 = j2 + m;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a[offa] + a[idx2];
        double x0i = -a[offa + 1] - a[idx2 + 1];
        double x1r = a[offa] - a[idx2];
        double x1i = -a[offa + 1] + a[idx2 + 1];
        double x2r = a[idx1] + a[idx3];
        double x2i = a[idx1 + 1] + a[idx3 + 1];
        double x3r = a[idx1] - a[idx3];
        double x3i = a[idx1 + 1] - a[idx3 + 1];
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i - x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i + x2i;
        a[idx2] = x1r + x3i;
        a[idx2 + 1] = x1i + x3r;
        a[idx3] = x1r - x3i;
        a[idx3 + 1] = x1i - x3r;
        double wn4r = w[startw + 1];
        double csc1 = w[startw + 2];
        double csc3 = w[startw + 3];
        double wd1r = 1.0;
        double wd1i = 0.0;
        double wd3r = 1.0;
        double wd3i = 0.0;
        int k = 0;
        for (int j = 2; j < mh - 2; j += 4) {
            int idx4 = startw + (k += 4);
            wk1r = csc1 * (wd1r + w[idx4]);
            wk1i = csc1 * (wd1i + w[idx4 + 1]);
            wk3r = csc3 * (wd3r + w[idx4 + 2]);
            wk3i = csc3 * (wd3i + w[idx4 + 3]);
            wd1r = w[idx4];
            wd1i = w[idx4 + 1];
            wd3r = w[idx4 + 2];
            wd3i = w[idx4 + 3];
            j1 = j + m;
            j2 = j1 + m;
            j3 = j2 + m;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j;
            x0r = a[idx5] + a[idx2];
            x0i = -a[idx5 + 1] - a[idx2 + 1];
            x1r = a[idx5] - a[offa + j2];
            x1i = -a[idx5 + 1] + a[idx2 + 1];
            double y0r = a[idx5 + 2] + a[idx2 + 2];
            double y0i = -a[idx5 + 3] - a[idx2 + 3];
            double y1r = a[idx5 + 2] - a[idx2 + 2];
            double y1i = -a[idx5 + 3] + a[idx2 + 3];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            double y2r = a[idx1 + 2] + a[idx3 + 2];
            double y2i = a[idx1 + 3] + a[idx3 + 3];
            double y3r = a[idx1 + 2] - a[idx3 + 2];
            double y3i = a[idx1 + 3] - a[idx3 + 3];
            a[idx5] = x0r + x2r;
            a[idx5 + 1] = x0i - x2i;
            a[idx5 + 2] = y0r + y2r;
            a[idx5 + 3] = y0i - y2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i + x2i;
            a[idx1 + 2] = y0r - y2r;
            a[idx1 + 3] = y0i + y2i;
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1r * x0r - wk1i * x0i;
            a[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a[idx2 + 2] = wd1r * x0r - wd1i * x0i;
            a[idx2 + 3] = wd1r * x0i + wd1i * x0r;
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3r * x0r + wk3i * x0i;
            a[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a[idx3 + 2] = wd3r * x0r + wd3i * x0i;
            a[idx3 + 3] = wd3r * x0i - wd3i * x0r;
            j0 = m - j;
            j1 = j0 + m;
            j2 = j1 + m;
            j3 = j2 + m;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a[idx0] + a[idx2];
            x0i = -a[idx0 + 1] - a[idx2 + 1];
            x1r = a[idx0] - a[idx2];
            x1i = -a[idx0 + 1] + a[idx2 + 1];
            y0r = a[idx0 - 2] + a[idx2 - 2];
            y0i = -a[idx0 - 1] - a[idx2 - 1];
            y1r = a[idx0 - 2] - a[idx2 - 2];
            y1i = -a[idx0 - 1] + a[idx2 - 1];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            y2r = a[idx1 - 2] + a[idx3 - 2];
            y2i = a[idx1 - 1] + a[idx3 - 1];
            y3r = a[idx1 - 2] - a[idx3 - 2];
            y3i = a[idx1 - 1] - a[idx3 - 1];
            a[idx0] = x0r + x2r;
            a[idx0 + 1] = x0i - x2i;
            a[idx0 - 2] = y0r + y2r;
            a[idx0 - 1] = y0i - y2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i + x2i;
            a[idx1 - 2] = y0r - y2r;
            a[idx1 - 1] = y0i + y2i;
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1i * x0r - wk1r * x0i;
            a[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a[idx2 - 2] = wd1i * x0r - wd1r * x0i;
            a[idx2 - 1] = wd1i * x0i + wd1r * x0r;
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3i * x0r + wk3r * x0i;
            a[idx3 + 1] = wk3i * x0i - wk3r * x0r;
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a[idx3 - 2] = wd3i * x0r + wd3r * x0i;
            a[idx3 - 1] = wd3i * x0i - wd3r * x0r;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m;
        j2 = j1 + m;
        j3 = j2 + m;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a[idx0 - 2] + a[idx2 - 2];
        x0i = -a[idx0 - 1] - a[idx2 - 1];
        x1r = a[idx0 - 2] - a[idx2 - 2];
        x1i = -a[idx0 - 1] + a[idx2 - 1];
        x2r = a[idx1 - 2] + a[idx3 - 2];
        x2i = a[idx1 - 1] + a[idx3 - 1];
        x3r = a[idx1 - 2] - a[idx3 - 2];
        x3i = a[idx1 - 1] - a[idx3 - 1];
        a[idx0 - 2] = x0r + x2r;
        a[idx0 - 1] = x0i - x2i;
        a[idx1 - 2] = x0r - x2r;
        a[idx1 - 1] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a[idx2 - 2] = wk1r * x0r - wk1i * x0i;
        a[idx2 - 1] = wk1r * x0i + wk1i * x0r;
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a[idx3 - 2] = wk3r * x0r + wk3i * x0i;
        a[idx3 - 1] = wk3r * x0i - wk3i * x0r;
        x0r = a[idx0] + a[idx2];
        x0i = -a[idx0 + 1] - a[idx2 + 1];
        x1r = a[idx0] - a[idx2];
        x1i = -a[idx0 + 1] + a[idx2 + 1];
        x2r = a[idx1] + a[idx3];
        x2i = a[idx1 + 1] + a[idx3 + 1];
        x3r = a[idx1] - a[idx3];
        x3i = a[idx1 + 1] - a[idx3 + 1];
        a[idx0] = x0r + x2r;
        a[idx0 + 1] = x0i - x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a[idx2] = wn4r * (x0r - x0i);
        a[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a[idx3] = -wn4r * (x0r + x0i);
        a[idx3 + 1] = -wn4r * (x0i - x0r);
        x0r = a[idx0 + 2] + a[idx2 + 2];
        x0i = -a[idx0 + 3] - a[idx2 + 3];
        x1r = a[idx0 + 2] - a[idx2 + 2];
        x1i = -a[idx0 + 3] + a[idx2 + 3];
        x2r = a[idx1 + 2] + a[idx3 + 2];
        x2i = a[idx1 + 3] + a[idx3 + 3];
        x3r = a[idx1 + 2] - a[idx3 + 2];
        x3i = a[idx1 + 3] - a[idx3 + 3];
        a[idx0 + 2] = x0r + x2r;
        a[idx0 + 3] = x0i - x2i;
        a[idx1 + 2] = x0r - x2r;
        a[idx1 + 3] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a[idx2 + 2] = wk1i * x0r - wk1r * x0i;
        a[idx2 + 3] = wk1i * x0i + wk1r * x0r;
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a[idx3 + 2] = wk3i * x0r + wk3r * x0i;
        a[idx3 + 3] = wk3i * x0i - wk3r * x0r;
    }

    private void cftbsub(int n, double[] a, int offa, int[] ip, int nw, double[] w) {
        if (n > 8) {
            if (n > 32) {
                this.cftb1st(n, a, offa, w, nw - (n >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n, a, offa, nw, w);
                } else if (n > 512) {
                    this.cftrec4(n, a, offa, nw, w);
                } else if (n > 128) {
                    this.cftleaf(n, 1, a, offa, nw, w);
                } else {
                    this.cftfx41(n, a, offa, nw, w);
                }
                this.bitrv2conj(n, ip, a, offa);
            } else if (n == 32) {
                this.cftf161(a, offa, w, nw - 8);
                this.bitrv216neg(a, offa);
            } else {
                this.cftf081(a, offa, w, 0);
                this.bitrv208neg(a, offa);
            }
        } else if (n == 8) {
            this.cftb040(a, offa);
        } else if (n == 4) {
            this.cftx020(a, offa);
        }
    }

    private void cftf040(double[] a, int offa) {
        double x0r = a[offa] + a[offa + 4];
        double x0i = a[offa + 1] + a[offa + 5];
        double x1r = a[offa] - a[offa + 4];
        double x1i = a[offa + 1] - a[offa + 5];
        double x2r = a[offa + 2] + a[offa + 6];
        double x2i = a[offa + 3] + a[offa + 7];
        double x3r = a[offa + 2] - a[offa + 6];
        double x3i = a[offa + 3] - a[offa + 7];
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i + x2i;
        a[offa + 2] = x1r - x3i;
        a[offa + 3] = x1i + x3r;
        a[offa + 4] = x0r - x2r;
        a[offa + 5] = x0i - x2i;
        a[offa + 6] = x1r + x3i;
        a[offa + 7] = x1i - x3r;
    }

    private void cftf081(double[] a, int offa, double[] w, int startw) {
        double wn4r = w[startw + 1];
        double x0r = a[offa] + a[offa + 8];
        double x0i = a[offa + 1] + a[offa + 9];
        double x1r = a[offa] - a[offa + 8];
        double x1i = a[offa + 1] - a[offa + 9];
        double x2r = a[offa + 4] + a[offa + 12];
        double x2i = a[offa + 5] + a[offa + 13];
        double x3r = a[offa + 4] - a[offa + 12];
        double x3i = a[offa + 5] - a[offa + 13];
        double y0r = x0r + x2r;
        double y0i = x0i + x2i;
        double y2r = x0r - x2r;
        double y2i = x0i - x2i;
        double y1r = x1r - x3i;
        double y1i = x1i + x3r;
        double y3r = x1r + x3i;
        double y3i = x1i - x3r;
        x0r = a[offa + 2] + a[offa + 10];
        x0i = a[offa + 3] + a[offa + 11];
        x1r = a[offa + 2] - a[offa + 10];
        x1i = a[offa + 3] - a[offa + 11];
        x2r = a[offa + 6] + a[offa + 14];
        x2i = a[offa + 7] + a[offa + 15];
        x3r = a[offa + 6] - a[offa + 14];
        x3i = a[offa + 7] - a[offa + 15];
        double y4r = x0r + x2r;
        double y4i = x0i + x2i;
        double y6r = x0r - x2r;
        double y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        x2r = x1r + x3i;
        x2i = x1i - x3r;
        double y5r = wn4r * (x0r - x0i);
        double y5i = wn4r * (x0r + x0i);
        double y7r = wn4r * (x2r - x2i);
        double y7i = wn4r * (x2r + x2i);
        a[offa + 8] = y1r + y5r;
        a[offa + 9] = y1i + y5i;
        a[offa + 10] = y1r - y5r;
        a[offa + 11] = y1i - y5i;
        a[offa + 12] = y3r - y7i;
        a[offa + 13] = y3i + y7r;
        a[offa + 14] = y3r + y7i;
        a[offa + 15] = y3i - y7r;
        a[offa] = y0r + y4r;
        a[offa + 1] = y0i + y4i;
        a[offa + 2] = y0r - y4r;
        a[offa + 3] = y0i - y4i;
        a[offa + 4] = y2r - y6i;
        a[offa + 5] = y2i + y6r;
        a[offa + 6] = y2r + y6i;
        a[offa + 7] = y2i - y6r;
    }

    private void cftf082(double[] a, int offa, double[] w, int startw) {
        double wn4r = w[startw + 1];
        double wk1r = w[startw + 2];
        double wk1i = w[startw + 3];
        double y0r = a[offa] - a[offa + 9];
        double y0i = a[offa + 1] + a[offa + 8];
        double y1r = a[offa] + a[offa + 9];
        double y1i = a[offa + 1] - a[offa + 8];
        double x0r = a[offa + 4] - a[offa + 13];
        double x0i = a[offa + 5] + a[offa + 12];
        double y2r = wn4r * (x0r - x0i);
        double y2i = wn4r * (x0i + x0r);
        x0r = a[offa + 4] + a[offa + 13];
        x0i = a[offa + 5] - a[offa + 12];
        double y3r = wn4r * (x0r - x0i);
        double y3i = wn4r * (x0i + x0r);
        x0r = a[offa + 2] - a[offa + 11];
        x0i = a[offa + 3] + a[offa + 10];
        double y4r = wk1r * x0r - wk1i * x0i;
        double y4i = wk1r * x0i + wk1i * x0r;
        x0r = a[offa + 2] + a[offa + 11];
        x0i = a[offa + 3] - a[offa + 10];
        double y5r = wk1i * x0r - wk1r * x0i;
        double y5i = wk1i * x0i + wk1r * x0r;
        x0r = a[offa + 6] - a[offa + 15];
        x0i = a[offa + 7] + a[offa + 14];
        double y6r = wk1i * x0r - wk1r * x0i;
        double y6i = wk1i * x0i + wk1r * x0r;
        x0r = a[offa + 6] + a[offa + 15];
        x0i = a[offa + 7] - a[offa + 14];
        double y7r = wk1r * x0r - wk1i * x0i;
        double y7i = wk1r * x0i + wk1i * x0r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        double x1r = y4r + y6r;
        double x1i = y4i + y6i;
        a[offa] = x0r + x1r;
        a[offa + 1] = x0i + x1i;
        a[offa + 2] = x0r - x1r;
        a[offa + 3] = x0i - x1i;
        x0r = y0r - y2r;
        x0i = y0i - y2i;
        x1r = y4r - y6r;
        x1i = y4i - y6i;
        a[offa + 4] = x0r - x1i;
        a[offa + 5] = x0i + x1r;
        a[offa + 6] = x0r + x1i;
        a[offa + 7] = x0i - x1r;
        x0r = y1r - y3i;
        x0i = y1i + y3r;
        x1r = y5r - y7r;
        x1i = y5i - y7i;
        a[offa + 8] = x0r + x1r;
        a[offa + 9] = x0i + x1i;
        a[offa + 10] = x0r - x1r;
        a[offa + 11] = x0i - x1i;
        x0r = y1r + y3i;
        x0i = y1i - y3r;
        x1r = y5r + y7r;
        x1i = y5i + y7i;
        a[offa + 12] = x0r - x1i;
        a[offa + 13] = x0i + x1r;
        a[offa + 14] = x0r + x1i;
        a[offa + 15] = x0i - x1r;
    }

    private void cftf161(double[] a, int offa, double[] w, int startw) {
        double wn4r = w[startw + 1];
        double wk1r = w[startw + 2];
        double wk1i = w[startw + 3];
        double x0r = a[offa] + a[offa + 16];
        double x0i = a[offa + 1] + a[offa + 17];
        double x1r = a[offa] - a[offa + 16];
        double x1i = a[offa + 1] - a[offa + 17];
        double x2r = a[offa + 8] + a[offa + 24];
        double x2i = a[offa + 9] + a[offa + 25];
        double x3r = a[offa + 8] - a[offa + 24];
        double x3i = a[offa + 9] - a[offa + 25];
        double y0r = x0r + x2r;
        double y0i = x0i + x2i;
        double y4r = x0r - x2r;
        double y4i = x0i - x2i;
        double y8r = x1r - x3i;
        double y8i = x1i + x3r;
        double y12r = x1r + x3i;
        double y12i = x1i - x3r;
        x0r = a[offa + 2] + a[offa + 18];
        x0i = a[offa + 3] + a[offa + 19];
        x1r = a[offa + 2] - a[offa + 18];
        x1i = a[offa + 3] - a[offa + 19];
        x2r = a[offa + 10] + a[offa + 26];
        x2i = a[offa + 11] + a[offa + 27];
        x3r = a[offa + 10] - a[offa + 26];
        x3i = a[offa + 11] - a[offa + 27];
        double y1r = x0r + x2r;
        double y1i = x0i + x2i;
        double y5r = x0r - x2r;
        double y5i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y9r = wk1r * x0r - wk1i * x0i;
        double y9i = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y13r = wk1i * x0r - wk1r * x0i;
        double y13i = wk1i * x0i + wk1r * x0r;
        x0r = a[offa + 4] + a[offa + 20];
        x0i = a[offa + 5] + a[offa + 21];
        x1r = a[offa + 4] - a[offa + 20];
        x1i = a[offa + 5] - a[offa + 21];
        x2r = a[offa + 12] + a[offa + 28];
        x2i = a[offa + 13] + a[offa + 29];
        x3r = a[offa + 12] - a[offa + 28];
        x3i = a[offa + 13] - a[offa + 29];
        double y2r = x0r + x2r;
        double y2i = x0i + x2i;
        double y6r = x0r - x2r;
        double y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y10r = wn4r * (x0r - x0i);
        double y10i = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y14r = wn4r * (x0r + x0i);
        double y14i = wn4r * (x0i - x0r);
        x0r = a[offa + 6] + a[offa + 22];
        x0i = a[offa + 7] + a[offa + 23];
        x1r = a[offa + 6] - a[offa + 22];
        x1i = a[offa + 7] - a[offa + 23];
        x2r = a[offa + 14] + a[offa + 30];
        x2i = a[offa + 15] + a[offa + 31];
        x3r = a[offa + 14] - a[offa + 30];
        x3i = a[offa + 15] - a[offa + 31];
        double y3r = x0r + x2r;
        double y3i = x0i + x2i;
        double y7r = x0r - x2r;
        double y7i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y11r = wk1i * x0r - wk1r * x0i;
        double y11i = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y15r = wk1r * x0r - wk1i * x0i;
        double y15i = wk1r * x0i + wk1i * x0r;
        x0r = y12r - y14r;
        x0i = y12i - y14i;
        x1r = y12r + y14r;
        x1i = y12i + y14i;
        x2r = y13r - y15r;
        x2i = y13i - y15i;
        x3r = y13r + y15r;
        x3i = y13i + y15i;
        a[offa + 24] = x0r + x2r;
        a[offa + 25] = x0i + x2i;
        a[offa + 26] = x0r - x2r;
        a[offa + 27] = x0i - x2i;
        a[offa + 28] = x1r - x3i;
        a[offa + 29] = x1i + x3r;
        a[offa + 30] = x1r + x3i;
        a[offa + 31] = x1i - x3r;
        x0r = y8r + y10r;
        x0i = y8i + y10i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        x3r = y9r - y11r;
        x3i = y9i - y11i;
        a[offa + 16] = x0r + x2r;
        a[offa + 17] = x0i + x2i;
        a[offa + 18] = x0r - x2r;
        a[offa + 19] = x0i - x2i;
        a[offa + 20] = x1r - x3i;
        a[offa + 21] = x1i + x3r;
        a[offa + 22] = x1r + x3i;
        a[offa + 23] = x1i - x3r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x3r = wn4r * (x0r - x0i);
        x3i = wn4r * (x0i + x0r);
        x0r = y4r - y6i;
        x0i = y4i + y6r;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        a[offa + 8] = x0r + x2r;
        a[offa + 9] = x0i + x2i;
        a[offa + 10] = x0r - x2r;
        a[offa + 11] = x0i - x2i;
        a[offa + 12] = x1r - x3i;
        a[offa + 13] = x1i + x3r;
        a[offa + 14] = x1r + x3i;
        a[offa + 15] = x1i - x3r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        x3r = y1r - y3r;
        x3i = y1i - y3i;
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i + x2i;
        a[offa + 2] = x0r - x2r;
        a[offa + 3] = x0i - x2i;
        a[offa + 4] = x1r - x3i;
        a[offa + 5] = x1i + x3r;
        a[offa + 6] = x1r + x3i;
        a[offa + 7] = x1i - x3r;
    }

    private void cftf162(double[] a, int offa, double[] w, int startw) {
        double wn4r = w[startw + 1];
        double wk1r = w[startw + 4];
        double wk1i = w[startw + 5];
        double wk3r = w[startw + 6];
        double wk3i = -w[startw + 7];
        double wk2r = w[startw + 8];
        double wk2i = w[startw + 9];
        double x1r = a[offa] - a[offa + 17];
        double x1i = a[offa + 1] + a[offa + 16];
        double x0r = a[offa + 8] - a[offa + 25];
        double x0i = a[offa + 9] + a[offa + 24];
        double x2r = wn4r * (x0r - x0i);
        double x2i = wn4r * (x0i + x0r);
        double y0r = x1r + x2r;
        double y0i = x1i + x2i;
        double y4r = x1r - x2r;
        double y4i = x1i - x2i;
        x1r = a[offa] + a[offa + 17];
        x1i = a[offa + 1] - a[offa + 16];
        x0r = a[offa + 8] + a[offa + 25];
        x0i = a[offa + 9] - a[offa + 24];
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        double y8r = x1r - x2i;
        double y8i = x1i + x2r;
        double y12r = x1r + x2i;
        double y12i = x1i - x2r;
        x0r = a[offa + 2] - a[offa + 19];
        x0i = a[offa + 3] + a[offa + 18];
        x1r = wk1r * x0r - wk1i * x0i;
        x1i = wk1r * x0i + wk1i * x0r;
        x0r = a[offa + 10] - a[offa + 27];
        x0i = a[offa + 11] + a[offa + 26];
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        double y1r = x1r + x2r;
        double y1i = x1i + x2i;
        double y5r = x1r - x2r;
        double y5i = x1i - x2i;
        x0r = a[offa + 2] + a[offa + 19];
        x0i = a[offa + 3] - a[offa + 18];
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a[offa + 10] + a[offa + 27];
        x0i = a[offa + 11] - a[offa + 26];
        x2r = wk1r * x0r + wk1i * x0i;
        x2i = wk1r * x0i - wk1i * x0r;
        double y9r = x1r - x2r;
        double y9i = x1i - x2i;
        double y13r = x1r + x2r;
        double y13i = x1i + x2i;
        x0r = a[offa + 4] - a[offa + 21];
        x0i = a[offa + 5] + a[offa + 20];
        x1r = wk2r * x0r - wk2i * x0i;
        x1i = wk2r * x0i + wk2i * x0r;
        x0r = a[offa + 12] - a[offa + 29];
        x0i = a[offa + 13] + a[offa + 28];
        x2r = wk2i * x0r - wk2r * x0i;
        x2i = wk2i * x0i + wk2r * x0r;
        double y2r = x1r + x2r;
        double y2i = x1i + x2i;
        double y6r = x1r - x2r;
        double y6i = x1i - x2i;
        x0r = a[offa + 4] + a[offa + 21];
        x0i = a[offa + 5] - a[offa + 20];
        x1r = wk2i * x0r - wk2r * x0i;
        x1i = wk2i * x0i + wk2r * x0r;
        x0r = a[offa + 12] + a[offa + 29];
        x0i = a[offa + 13] - a[offa + 28];
        x2r = wk2r * x0r - wk2i * x0i;
        x2i = wk2r * x0i + wk2i * x0r;
        double y10r = x1r - x2r;
        double y10i = x1i - x2i;
        double y14r = x1r + x2r;
        double y14i = x1i + x2i;
        x0r = a[offa + 6] - a[offa + 23];
        x0i = a[offa + 7] + a[offa + 22];
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a[offa + 14] - a[offa + 31];
        x0i = a[offa + 15] + a[offa + 30];
        x2r = wk1i * x0r - wk1r * x0i;
        x2i = wk1i * x0i + wk1r * x0r;
        double y3r = x1r + x2r;
        double y3i = x1i + x2i;
        double y7r = x1r - x2r;
        double y7i = x1i - x2i;
        x0r = a[offa + 6] + a[offa + 23];
        x0i = a[offa + 7] - a[offa + 22];
        x1r = wk1i * x0r + wk1r * x0i;
        x1i = wk1i * x0i - wk1r * x0r;
        x0r = a[offa + 14] + a[offa + 31];
        x0i = a[offa + 15] - a[offa + 30];
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        double y11r = x1r + x2r;
        double y11i = x1i + x2i;
        double y15r = x1r - x2r;
        double y15i = x1i - x2i;
        x1r = y0r + y2r;
        x1i = y0i + y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        a[offa] = x1r + x2r;
        a[offa + 1] = x1i + x2i;
        a[offa + 2] = x1r - x2r;
        a[offa + 3] = x1i - x2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r - y3r;
        x2i = y1i - y3i;
        a[offa + 4] = x1r - x2i;
        a[offa + 5] = x1i + x2r;
        a[offa + 6] = x1r + x2i;
        a[offa + 7] = x1i - x2r;
        x1r = y4r - y6i;
        x1i = y4i + y6r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[offa + 8] = x1r + x2r;
        a[offa + 9] = x1i + x2i;
        a[offa + 10] = x1r - x2r;
        a[offa + 11] = x1i - x2i;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[offa + 12] = x1r - x2i;
        a[offa + 13] = x1i + x2r;
        a[offa + 14] = x1r + x2i;
        a[offa + 15] = x1i - x2r;
        x1r = y8r + y10r;
        x1i = y8i + y10i;
        x2r = y9r - y11r;
        x2i = y9i - y11i;
        a[offa + 16] = x1r + x2r;
        a[offa + 17] = x1i + x2i;
        a[offa + 18] = x1r - x2r;
        a[offa + 19] = x1i - x2i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        a[offa + 20] = x1r - x2i;
        a[offa + 21] = x1i + x2r;
        a[offa + 22] = x1r + x2i;
        a[offa + 23] = x1i - x2r;
        x1r = y12r - y14i;
        x1i = y12i + y14r;
        x0r = y13r + y15i;
        x0i = y13i - y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[offa + 24] = x1r + x2r;
        a[offa + 25] = x1i + x2i;
        a[offa + 26] = x1r - x2r;
        a[offa + 27] = x1i - x2i;
        x1r = y12r + y14i;
        x1i = y12i - y14r;
        x0r = y13r - y15i;
        x0i = y13i + y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[offa + 28] = x1r - x2i;
        a[offa + 29] = x1i + x2r;
        a[offa + 30] = x1r + x2i;
        a[offa + 31] = x1i - x2r;
    }

    private void cftf1st(int n, double[] a, int offa, double[] w, int startw) {
        int idx0;
        int j0;
        double wk3i;
        double wk3r;
        double wk1i;
        double wk1r;
        int m;
        int mh = n >> 3;
        int j1 = m = 2 * mh;
        int j2 = j1 + m;
        int j3 = j2 + m;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a[offa] + a[idx2];
        double x0i = a[offa + 1] + a[idx2 + 1];
        double x1r = a[offa] - a[idx2];
        double x1i = a[offa + 1] - a[idx2 + 1];
        double x2r = a[idx1] + a[idx3];
        double x2i = a[idx1 + 1] + a[idx3 + 1];
        double x3r = a[idx1] - a[idx3];
        double x3i = a[idx1 + 1] - a[idx3 + 1];
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i + x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i - x2i;
        a[idx2] = x1r - x3i;
        a[idx2 + 1] = x1i + x3r;
        a[idx3] = x1r + x3i;
        a[idx3 + 1] = x1i - x3r;
        double wn4r = w[startw + 1];
        double csc1 = w[startw + 2];
        double csc3 = w[startw + 3];
        double wd1r = 1.0;
        double wd1i = 0.0;
        double wd3r = 1.0;
        double wd3i = 0.0;
        int k = 0;
        for (int j = 2; j < mh - 2; j += 4) {
            int idx4 = startw + (k += 4);
            wk1r = csc1 * (wd1r + w[idx4]);
            wk1i = csc1 * (wd1i + w[idx4 + 1]);
            wk3r = csc3 * (wd3r + w[idx4 + 2]);
            wk3i = csc3 * (wd3i + w[idx4 + 3]);
            wd1r = w[idx4];
            wd1i = w[idx4 + 1];
            wd3r = w[idx4 + 2];
            wd3i = w[idx4 + 3];
            j1 = j + m;
            j2 = j1 + m;
            j3 = j2 + m;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j;
            x0r = a[idx5] + a[idx2];
            x0i = a[idx5 + 1] + a[idx2 + 1];
            x1r = a[idx5] - a[idx2];
            x1i = a[idx5 + 1] - a[idx2 + 1];
            double y0r = a[idx5 + 2] + a[idx2 + 2];
            double y0i = a[idx5 + 3] + a[idx2 + 3];
            double y1r = a[idx5 + 2] - a[idx2 + 2];
            double y1i = a[idx5 + 3] - a[idx2 + 3];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            double y2r = a[idx1 + 2] + a[idx3 + 2];
            double y2i = a[idx1 + 3] + a[idx3 + 3];
            double y3r = a[idx1 + 2] - a[idx3 + 2];
            double y3i = a[idx1 + 3] - a[idx3 + 3];
            a[idx5] = x0r + x2r;
            a[idx5 + 1] = x0i + x2i;
            a[idx5 + 2] = y0r + y2r;
            a[idx5 + 3] = y0i + y2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i - x2i;
            a[idx1 + 2] = y0r - y2r;
            a[idx1 + 3] = y0i - y2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1r * x0r - wk1i * x0i;
            a[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a[idx2 + 2] = wd1r * x0r - wd1i * x0i;
            a[idx2 + 3] = wd1r * x0i + wd1i * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3r * x0r + wk3i * x0i;
            a[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a[idx3 + 2] = wd3r * x0r + wd3i * x0i;
            a[idx3 + 3] = wd3r * x0i - wd3i * x0r;
            j0 = m - j;
            j1 = j0 + m;
            j2 = j1 + m;
            j3 = j2 + m;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a[idx0] + a[idx2];
            x0i = a[idx0 + 1] + a[idx2 + 1];
            x1r = a[idx0] - a[idx2];
            x1i = a[idx0 + 1] - a[idx2 + 1];
            y0r = a[idx0 - 2] + a[idx2 - 2];
            y0i = a[idx0 - 1] + a[idx2 - 1];
            y1r = a[idx0 - 2] - a[idx2 - 2];
            y1i = a[idx0 - 1] - a[idx2 - 1];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            y2r = a[idx1 - 2] + a[idx3 - 2];
            y2i = a[idx1 - 1] + a[idx3 - 1];
            y3r = a[idx1 - 2] - a[idx3 - 2];
            y3i = a[idx1 - 1] - a[idx3 - 1];
            a[idx0] = x0r + x2r;
            a[idx0 + 1] = x0i + x2i;
            a[idx0 - 2] = y0r + y2r;
            a[idx0 - 1] = y0i + y2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i - x2i;
            a[idx1 - 2] = y0r - y2r;
            a[idx1 - 1] = y0i - y2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1i * x0r - wk1r * x0i;
            a[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a[idx2 - 2] = wd1i * x0r - wd1r * x0i;
            a[idx2 - 1] = wd1i * x0i + wd1r * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3i * x0r + wk3r * x0i;
            a[idx3 + 1] = wk3i * x0i - wk3r * x0r;
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a[offa + j3 - 2] = wd3i * x0r + wd3r * x0i;
            a[offa + j3 - 1] = wd3i * x0i - wd3r * x0r;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m;
        j2 = j1 + m;
        j3 = j2 + m;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a[idx0 - 2] + a[idx2 - 2];
        x0i = a[idx0 - 1] + a[idx2 - 1];
        x1r = a[idx0 - 2] - a[idx2 - 2];
        x1i = a[idx0 - 1] - a[idx2 - 1];
        x2r = a[idx1 - 2] + a[idx3 - 2];
        x2i = a[idx1 - 1] + a[idx3 - 1];
        x3r = a[idx1 - 2] - a[idx3 - 2];
        x3i = a[idx1 - 1] - a[idx3 - 1];
        a[idx0 - 2] = x0r + x2r;
        a[idx0 - 1] = x0i + x2i;
        a[idx1 - 2] = x0r - x2r;
        a[idx1 - 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[idx2 - 2] = wk1r * x0r - wk1i * x0i;
        a[idx2 - 1] = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[idx3 - 2] = wk3r * x0r + wk3i * x0i;
        a[idx3 - 1] = wk3r * x0i - wk3i * x0r;
        x0r = a[idx0] + a[idx2];
        x0i = a[idx0 + 1] + a[idx2 + 1];
        x1r = a[idx0] - a[idx2];
        x1i = a[idx0 + 1] - a[idx2 + 1];
        x2r = a[idx1] + a[idx3];
        x2i = a[idx1 + 1] + a[idx3 + 1];
        x3r = a[idx1] - a[idx3];
        x3i = a[idx1 + 1] - a[idx3 + 1];
        a[idx0] = x0r + x2r;
        a[idx0 + 1] = x0i + x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[idx2] = wn4r * (x0r - x0i);
        a[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[idx3] = -wn4r * (x0r + x0i);
        a[idx3 + 1] = -wn4r * (x0i - x0r);
        x0r = a[idx0 + 2] + a[idx2 + 2];
        x0i = a[idx0 + 3] + a[idx2 + 3];
        x1r = a[idx0 + 2] - a[idx2 + 2];
        x1i = a[idx0 + 3] - a[idx2 + 3];
        x2r = a[idx1 + 2] + a[idx3 + 2];
        x2i = a[idx1 + 3] + a[idx3 + 3];
        x3r = a[idx1 + 2] - a[idx3 + 2];
        x3i = a[idx1 + 3] - a[idx3 + 3];
        a[idx0 + 2] = x0r + x2r;
        a[idx0 + 3] = x0i + x2i;
        a[idx1 + 2] = x0r - x2r;
        a[idx1 + 3] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[idx2 + 2] = wk1i * x0r - wk1r * x0i;
        a[idx2 + 3] = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[idx3 + 2] = wk3i * x0r + wk3r * x0i;
        a[idx3 + 3] = wk3i * x0i - wk3r * x0r;
    }

    private void cftfsub(int n, double[] a, int offa, int[] ip, int nw, double[] w) {
        if (n > 8) {
            if (n > 32) {
                this.cftf1st(n, a, offa, w, nw - (n >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n, a, offa, nw, w);
                } else if (n > 512) {
                    this.cftrec4(n, a, offa, nw, w);
                } else if (n > 128) {
                    this.cftleaf(n, 1, a, offa, nw, w);
                } else {
                    this.cftfx41(n, a, offa, nw, w);
                }
                this.bitrv2(n, ip, a, offa);
            } else if (n == 32) {
                this.cftf161(a, offa, w, nw - 8);
                this.bitrv216(a, offa);
            } else {
                this.cftf081(a, offa, w, 0);
                this.bitrv208(a, offa);
            }
        } else if (n == 8) {
            this.cftf040(a, offa);
        } else if (n == 4) {
            this.cftx020(a, offa);
        }
    }

    private void cftfx41(int n, double[] a, int offa, int nw, double[] w) {
        if (n == 128) {
            this.cftf161(a, offa, w, nw - 8);
            this.cftf162(a, offa + 32, w, nw - 32);
            this.cftf161(a, offa + 64, w, nw - 8);
            this.cftf161(a, offa + 96, w, nw - 8);
        } else {
            this.cftf081(a, offa, w, nw - 8);
            this.cftf082(a, offa + 16, w, nw - 8);
            this.cftf081(a, offa + 32, w, nw - 8);
            this.cftf081(a, offa + 48, w, nw - 8);
        }
    }

    private void cftleaf(int n, int isplt, double[] a, int offa, int nw, double[] w) {
        if (n == 512) {
            this.cftmdl1(128, a, offa, w, nw - 64);
            this.cftf161(a, offa, w, nw - 8);
            this.cftf162(a, offa + 32, w, nw - 32);
            this.cftf161(a, offa + 64, w, nw - 8);
            this.cftf161(a, offa + 96, w, nw - 8);
            this.cftmdl2(128, a, offa + 128, w, nw - 128);
            this.cftf161(a, offa + 128, w, nw - 8);
            this.cftf162(a, offa + 160, w, nw - 32);
            this.cftf161(a, offa + 192, w, nw - 8);
            this.cftf162(a, offa + 224, w, nw - 32);
            this.cftmdl1(128, a, offa + 256, w, nw - 64);
            this.cftf161(a, offa + 256, w, nw - 8);
            this.cftf162(a, offa + 288, w, nw - 32);
            this.cftf161(a, offa + 320, w, nw - 8);
            this.cftf161(a, offa + 352, w, nw - 8);
            if (isplt != 0) {
                this.cftmdl1(128, a, offa + 384, w, nw - 64);
                this.cftf161(a, offa + 480, w, nw - 8);
            } else {
                this.cftmdl2(128, a, offa + 384, w, nw - 128);
                this.cftf162(a, offa + 480, w, nw - 32);
            }
            this.cftf161(a, offa + 384, w, nw - 8);
            this.cftf162(a, offa + 416, w, nw - 32);
            this.cftf161(a, offa + 448, w, nw - 8);
        } else {
            this.cftmdl1(64, a, offa, w, nw - 32);
            this.cftf081(a, offa, w, nw - 8);
            this.cftf082(a, offa + 16, w, nw - 8);
            this.cftf081(a, offa + 32, w, nw - 8);
            this.cftf081(a, offa + 48, w, nw - 8);
            this.cftmdl2(64, a, offa + 64, w, nw - 64);
            this.cftf081(a, offa + 64, w, nw - 8);
            this.cftf082(a, offa + 80, w, nw - 8);
            this.cftf081(a, offa + 96, w, nw - 8);
            this.cftf082(a, offa + 112, w, nw - 8);
            this.cftmdl1(64, a, offa + 128, w, nw - 32);
            this.cftf081(a, offa + 128, w, nw - 8);
            this.cftf082(a, offa + 144, w, nw - 8);
            this.cftf081(a, offa + 160, w, nw - 8);
            this.cftf081(a, offa + 176, w, nw - 8);
            if (isplt != 0) {
                this.cftmdl1(64, a, offa + 192, w, nw - 32);
                this.cftf081(a, offa + 240, w, nw - 8);
            } else {
                this.cftmdl2(64, a, offa + 192, w, nw - 64);
                this.cftf082(a, offa + 240, w, nw - 8);
            }
            this.cftf081(a, offa + 192, w, nw - 8);
            this.cftf082(a, offa + 208, w, nw - 8);
            this.cftf081(a, offa + 224, w, nw - 8);
        }
    }

    private void cftmdl1(int n, double[] a, int offa, double[] w, int startw) {
        int idx0;
        int j0;
        int m;
        int mh = n >> 3;
        int j1 = m = 2 * mh;
        int j2 = j1 + m;
        int j3 = j2 + m;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a[offa] + a[idx2];
        double x0i = a[offa + 1] + a[idx2 + 1];
        double x1r = a[offa] - a[idx2];
        double x1i = a[offa + 1] - a[idx2 + 1];
        double x2r = a[idx1] + a[idx3];
        double x2i = a[idx1 + 1] + a[idx3 + 1];
        double x3r = a[idx1] - a[idx3];
        double x3i = a[idx1 + 1] - a[idx3 + 1];
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i + x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i - x2i;
        a[idx2] = x1r - x3i;
        a[idx2 + 1] = x1i + x3r;
        a[idx3] = x1r + x3i;
        a[idx3 + 1] = x1i - x3r;
        double wn4r = w[startw + 1];
        int k = 0;
        for (int j = 2; j < mh; j += 2) {
            int idx4 = startw + (k += 4);
            double wk1r = w[idx4];
            double wk1i = w[idx4 + 1];
            double wk3r = w[idx4 + 2];
            double wk3i = w[idx4 + 3];
            j1 = j + m;
            j2 = j1 + m;
            j3 = j2 + m;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j;
            x0r = a[idx5] + a[idx2];
            x0i = a[idx5 + 1] + a[idx2 + 1];
            x1r = a[idx5] - a[idx2];
            x1i = a[idx5 + 1] - a[idx2 + 1];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            a[idx5] = x0r + x2r;
            a[idx5 + 1] = x0i + x2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i - x2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1r * x0r - wk1i * x0i;
            a[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3r * x0r + wk3i * x0i;
            a[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            j0 = m - j;
            j1 = j0 + m;
            j2 = j1 + m;
            j3 = j2 + m;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a[idx0] + a[idx2];
            x0i = a[idx0 + 1] + a[idx2 + 1];
            x1r = a[idx0] - a[idx2];
            x1i = a[idx0 + 1] - a[idx2 + 1];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            a[idx0] = x0r + x2r;
            a[idx0 + 1] = x0i + x2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i - x2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1i * x0r - wk1r * x0i;
            a[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3i * x0r + wk3r * x0i;
            a[idx3 + 1] = wk3i * x0i - wk3r * x0r;
        }
        j0 = mh;
        j1 = j0 + m;
        j2 = j1 + m;
        j3 = j2 + m;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a[idx0] + a[idx2];
        x0i = a[idx0 + 1] + a[idx2 + 1];
        x1r = a[idx0] - a[idx2];
        x1i = a[idx0 + 1] - a[idx2 + 1];
        x2r = a[idx1] + a[idx3];
        x2i = a[idx1 + 1] + a[idx3 + 1];
        x3r = a[idx1] - a[idx3];
        x3i = a[idx1 + 1] - a[idx3 + 1];
        a[idx0] = x0r + x2r;
        a[idx0 + 1] = x0i + x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[idx2] = wn4r * (x0r - x0i);
        a[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[idx3] = -wn4r * (x0r + x0i);
        a[idx3 + 1] = -wn4r * (x0i - x0r);
    }

    private void cftmdl2(int n, double[] a, int offa, double[] w, int startw) {
        int idx0;
        int j0;
        double y2i;
        double y2r;
        double wk1i;
        double wk1r;
        int mh = n >> 3;
        int m = 2 * mh;
        double wn4r = w[startw + 1];
        int j1 = m;
        int j2 = j1 + m;
        int j3 = j2 + m;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a[offa] - a[idx2 + 1];
        double x0i = a[offa + 1] + a[idx2];
        double x1r = a[offa] + a[idx2 + 1];
        double x1i = a[offa + 1] - a[idx2];
        double x2r = a[idx1] - a[idx3 + 1];
        double x2i = a[idx1 + 1] + a[idx3];
        double x3r = a[idx1] + a[idx3 + 1];
        double x3i = a[idx1 + 1] - a[idx3];
        double y0r = wn4r * (x2r - x2i);
        double y0i = wn4r * (x2i + x2r);
        a[offa] = x0r + y0r;
        a[offa + 1] = x0i + y0i;
        a[idx1] = x0r - y0r;
        a[idx1 + 1] = x0i - y0i;
        y0r = wn4r * (x3r - x3i);
        y0i = wn4r * (x3i + x3r);
        a[idx2] = x1r - y0i;
        a[idx2 + 1] = x1i + y0r;
        a[idx3] = x1r + y0i;
        a[idx3 + 1] = x1i - y0r;
        int k = 0;
        int kr = 2 * m;
        for (int j = 2; j < mh; j += 2) {
            int idx4 = startw + (k += 4);
            wk1r = w[idx4];
            wk1i = w[idx4 + 1];
            double wk3r = w[idx4 + 2];
            double wk3i = w[idx4 + 3];
            int idx5 = startw + (kr -= 4);
            double wd1i = w[idx5];
            double wd1r = w[idx5 + 1];
            double wd3i = w[idx5 + 2];
            double wd3r = w[idx5 + 3];
            j1 = j + m;
            j2 = j1 + m;
            j3 = j2 + m;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx6 = offa + j;
            x0r = a[idx6] - a[idx2 + 1];
            x0i = a[idx6 + 1] + a[idx2];
            x1r = a[idx6] + a[idx2 + 1];
            x1i = a[idx6 + 1] - a[idx2];
            x2r = a[idx1] - a[idx3 + 1];
            x2i = a[idx1 + 1] + a[idx3];
            x3r = a[idx1] + a[idx3 + 1];
            x3i = a[idx1 + 1] - a[idx3];
            y0r = wk1r * x0r - wk1i * x0i;
            y0i = wk1r * x0i + wk1i * x0r;
            y2r = wd1r * x2r - wd1i * x2i;
            y2i = wd1r * x2i + wd1i * x2r;
            a[idx6] = y0r + y2r;
            a[idx6 + 1] = y0i + y2i;
            a[idx1] = y0r - y2r;
            a[idx1 + 1] = y0i - y2i;
            y0r = wk3r * x1r + wk3i * x1i;
            y0i = wk3r * x1i - wk3i * x1r;
            y2r = wd3r * x3r + wd3i * x3i;
            y2i = wd3r * x3i - wd3i * x3r;
            a[idx2] = y0r + y2r;
            a[idx2 + 1] = y0i + y2i;
            a[idx3] = y0r - y2r;
            a[idx3 + 1] = y0i - y2i;
            j0 = m - j;
            j1 = j0 + m;
            j2 = j1 + m;
            j3 = j2 + m;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a[idx0] - a[idx2 + 1];
            x0i = a[idx0 + 1] + a[idx2];
            x1r = a[idx0] + a[idx2 + 1];
            x1i = a[idx0 + 1] - a[idx2];
            x2r = a[idx1] - a[idx3 + 1];
            x2i = a[idx1 + 1] + a[idx3];
            x3r = a[idx1] + a[idx3 + 1];
            x3i = a[idx1 + 1] - a[idx3];
            y0r = wd1i * x0r - wd1r * x0i;
            y0i = wd1i * x0i + wd1r * x0r;
            y2r = wk1i * x2r - wk1r * x2i;
            y2i = wk1i * x2i + wk1r * x2r;
            a[idx0] = y0r + y2r;
            a[idx0 + 1] = y0i + y2i;
            a[idx1] = y0r - y2r;
            a[idx1 + 1] = y0i - y2i;
            y0r = wd3i * x1r + wd3r * x1i;
            y0i = wd3i * x1i - wd3r * x1r;
            y2r = wk3i * x3r + wk3r * x3i;
            y2i = wk3i * x3i - wk3r * x3r;
            a[idx2] = y0r + y2r;
            a[idx2 + 1] = y0i + y2i;
            a[idx3] = y0r - y2r;
            a[idx3 + 1] = y0i - y2i;
        }
        wk1r = w[startw + m];
        wk1i = w[startw + m + 1];
        j0 = mh;
        j1 = j0 + m;
        j2 = j1 + m;
        j3 = j2 + m;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a[idx0] - a[idx2 + 1];
        x0i = a[idx0 + 1] + a[idx2];
        x1r = a[idx0] + a[idx2 + 1];
        x1i = a[idx0 + 1] - a[idx2];
        x2r = a[idx1] - a[idx3 + 1];
        x2i = a[idx1 + 1] + a[idx3];
        x3r = a[idx1] + a[idx3 + 1];
        x3i = a[idx1 + 1] - a[idx3];
        y0r = wk1r * x0r - wk1i * x0i;
        y0i = wk1r * x0i + wk1i * x0r;
        y2r = wk1i * x2r - wk1r * x2i;
        y2i = wk1i * x2i + wk1r * x2r;
        a[idx0] = y0r + y2r;
        a[idx0 + 1] = y0i + y2i;
        a[idx1] = y0r - y2r;
        a[idx1 + 1] = y0i - y2i;
        y0r = wk1i * x1r - wk1r * x1i;
        y0i = wk1i * x1i + wk1r * x1r;
        y2r = wk1r * x3r - wk1i * x3i;
        y2i = wk1r * x3i + wk1i * x3r;
        a[idx2] = y0r - y2r;
        a[idx2 + 1] = y0i - y2i;
        a[idx3] = y0r + y2r;
        a[idx3 + 1] = y0i + y2i;
    }

    private void cftrec4(int n, double[] a, int offa, int nw, double[] w) {
        int idx1 = offa + n;
        int m = n;
        while (m > 512) {
            this.cftmdl1(m >>= 2, a, idx1 - m, w, nw - (m >> 1));
        }
        this.cftleaf(m, 1, a, idx1 - m, nw, w);
        int k = 0;
        int idx2 = offa - m;
        for (int j = n - m; j > 0; j -= m) {
            int isplt = this.cfttree(m, j, ++k, a, offa, nw, w);
            this.cftleaf(m, isplt, a, idx2 + j, nw, w);
        }
    }

    private void cftrec4_th(final int n, final double[] a, int offa, final int nw, final double[] w) {
        int idx = 0;
        int nthread = 2;
        int idiv4 = 0;
        int m = n >> 1;
        if (n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            nthread = 4;
            idiv4 = 1;
            m >>= 1;
        }
        Future[] futures = new Future[nthread];
        final int mf = m;
        for (int i = 0; i < nthread; ++i) {
            final int firstIdx = offa + i * m;
            futures[idx++] = i != idiv4 ? ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    int idx1 = firstIdx + mf;
                    int m = n;
                    while (m > 512) {
                        DoubleDCT_1D.this.cftmdl1(m >>= 2, a, idx1 - m, w, nw - (m >> 1));
                    }
                    DoubleDCT_1D.this.cftleaf(m, 1, a, idx1 - m, nw, w);
                    int k = 0;
                    int idx2 = firstIdx - m;
                    for (int j = mf - m; j > 0; j -= m) {
                        int isplt = DoubleDCT_1D.this.cfttree(m, j, ++k, a, firstIdx, nw, w);
                        DoubleDCT_1D.this.cftleaf(m, isplt, a, idx2 + j, nw, w);
                    }
                }
            }) : ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    int idx1 = firstIdx + mf;
                    int k = 1;
                    int m = n;
                    while (m > 512) {
                        k <<= 2;
                        DoubleDCT_1D.this.cftmdl2(m >>= 2, a, idx1 - m, w, nw - m);
                    }
                    DoubleDCT_1D.this.cftleaf(m, 0, a, idx1 - m, nw, w);
                    k >>= 1;
                    int idx2 = firstIdx - m;
                    for (int j = mf - m; j > 0; j -= m) {
                        int isplt = DoubleDCT_1D.this.cfttree(m, j, ++k, a, firstIdx, nw, w);
                        DoubleDCT_1D.this.cftleaf(m, isplt, a, idx2 + j, nw, w);
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private int cfttree(int n, int j, int k, double[] a, int offa, int nw, double[] w) {
        int isplt;
        int idx1 = offa - n;
        if ((k & 3) != 0) {
            isplt = k & 1;
            if (isplt != 0) {
                this.cftmdl1(n, a, idx1 + j, w, nw - (n >> 1));
            } else {
                this.cftmdl2(n, a, idx1 + j, w, nw - n);
            }
        } else {
            int m = n;
            int i = k;
            while ((i & 3) == 0) {
                m <<= 2;
                i >>= 2;
            }
            isplt = i & 1;
            int idx2 = offa + j;
            if (isplt != 0) {
                while (m > 128) {
                    this.cftmdl1(m, a, idx2 - m, w, nw - (m >> 1));
                    m >>= 2;
                }
            } else {
                while (m > 128) {
                    this.cftmdl2(m, a, idx2 - m, w, nw - m);
                    m >>= 2;
                }
            }
        }
        return isplt;
    }

    private void cftx020(double[] a, int offa) {
        double x0r = a[offa] - a[offa + 2];
        double x0i = a[offa + 1] - a[offa + 3];
        int n = offa;
        a[n] = a[n] + a[offa + 2];
        int n2 = offa + 1;
        a[n2] = a[n2] + a[offa + 3];
        a[offa + 2] = x0r;
        a[offa + 3] = x0i;
    }

    private void dctsub(int n, double[] a, int offa, int nc, double[] c, int startc) {
        int m = n >> 1;
        int ks = nc / n;
        int kk = 0;
        for (int j = 1; j < m; ++j) {
            int k = n - j;
            int idx0 = startc + (kk += ks);
            int idx1 = offa + j;
            int idx2 = offa + k;
            double wkr = c[idx0] - c[startc + nc - kk];
            double wki = c[idx0] + c[startc + nc - kk];
            double xr = wki * a[idx1] - wkr * a[idx2];
            a[idx1] = wkr * a[idx1] + wki * a[idx2];
            a[idx2] = xr;
        }
        int n2 = offa + m;
        a[n2] = a[n2] * c[startc];
    }

    public void forward(double[] a, boolean scale) {
        this.forward(a, 0, scale);
    }

    public void forward(final double[] a, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        if (this.isPowerOfTwo) {
            double xr = a[offa + this.n - 1];
            for (int j = this.n - 2; j >= 2; j -= 2) {
                a[offa + j + 1] = a[offa + j] - a[offa + j - 1];
                int n = offa + j;
                a[n] = a[n] + a[offa + j - 1];
            }
            a[offa + 1] = a[offa] - xr;
            int n = offa;
            a[n] = a[n] + xr;
            if (this.n > 4) {
                this.rftbsub(this.n, a, offa, this.nc, this.w, this.nw);
                this.cftbsub(this.n, a, offa, this.ip, this.nw, this.w);
            } else if (this.n == 4) {
                this.cftbsub(this.n, a, offa, this.ip, this.nw, this.w);
            }
            this.dctsub(this.n, a, offa, this.nc, this.w, this.nw);
            if (scale) {
                this.scale(Math.sqrt(2.0 / (double)this.n), a, offa);
                a[offa] = a[offa] / Math.sqrt(2.0);
            }
        } else {
            int i;
            int twon = 2 * this.n;
            final double[] t = new double[twon];
            System.arraycopy(a, offa, t, 0, this.n);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            for (i = this.n; i < twon; ++i) {
                t[i] = t[twon - i - 1];
            }
            this.fft.realForward(t);
            if (nthreads > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                int k = this.n / nthreads;
                Future[] futures = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? this.n : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                int twoi = 2 * i;
                                int idx = offa + i;
                                a[idx] = DoubleDCT_1D.this.w[twoi] * t[twoi] - DoubleDCT_1D.this.w[twoi + 1] * t[twoi + 1];
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (i = 0; i < this.n; ++i) {
                    int twoi = 2 * i;
                    int idx = offa + i;
                    a[idx] = this.w[twoi] * t[twoi] - this.w[twoi + 1] * t[twoi + 1];
                }
            }
            if (scale) {
                this.scale(1.0 / Math.sqrt(twon), a, offa);
                a[offa] = a[offa] / Math.sqrt(2.0);
            }
        }
    }

    public void inverse(double[] a, boolean scale) {
        this.inverse(a, 0, scale);
    }

    public void inverse(final double[] a, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        if (this.isPowerOfTwo) {
            if (scale) {
                this.scale(Math.sqrt(2.0 / (double)this.n), a, offa);
                a[offa] = a[offa] / Math.sqrt(2.0);
            }
            this.dctsub(this.n, a, offa, this.nc, this.w, this.nw);
            if (this.n > 4) {
                this.cftfsub(this.n, a, offa, this.ip, this.nw, this.w);
                this.rftfsub(this.n, a, offa, this.nc, this.w, this.nw);
            } else if (this.n == 4) {
                this.cftfsub(this.n, a, offa, this.ip, this.nw, this.w);
            }
            double xr = a[offa] - a[offa + 1];
            int n = offa;
            a[n] = a[n] + a[offa + 1];
            for (int j = 2; j < this.n; j += 2) {
                a[offa + j - 1] = a[offa + j] - a[offa + j + 1];
                int n2 = offa + j;
                a[n2] = a[n2] + a[offa + j + 1];
            }
            a[offa + this.n - 1] = xr;
        } else {
            int twon = 2 * this.n;
            if (scale) {
                this.scale(Math.sqrt(twon), a, offa);
                a[offa] = a[offa] * Math.sqrt(2.0);
            }
            final double[] t = new double[twon];
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                int k = this.n / nthreads;
                Future[] futures = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? this.n : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                int twoi = 2 * i;
                                double elem = a[offa + i];
                                t[twoi] = DoubleDCT_1D.this.w[twoi] * elem;
                                t[twoi + 1] = -DoubleDCT_1D.this.w[twoi + 1] * elem;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int i = 0; i < this.n; ++i) {
                    int twoi = 2 * i;
                    double elem = a[offa + i];
                    t[twoi] = this.w[twoi] * elem;
                    t[twoi + 1] = -this.w[twoi + 1] * elem;
                }
            }
            this.fft.realInverse(t, true);
            System.arraycopy(t, 0, a, offa, this.n);
        }
    }

    private double[] makect(int n) {
        int twon = 2 * n;
        double delta = Math.PI / (double)twon;
        double[] c = new double[twon];
        c[0] = 1.0;
        for (int j = 1; j < n; ++j) {
            int idx = 2 * j;
            double deltaj = delta * (double)j;
            c[idx] = Math.cos(deltaj);
            c[idx + 1] = -Math.sin(deltaj);
        }
        return c;
    }

    private void makect(int nc, double[] c, int startc) {
        this.ip[1] = nc;
        if (nc > 1) {
            int nch = nc >> 1;
            double delta = 0.7853981633974483 / (double)nch;
            c[startc] = Math.cos(delta * (double)nch);
            c[startc + nch] = 0.5 * c[startc];
            for (int j = 1; j < nch; ++j) {
                double deltaj = delta * (double)j;
                c[startc + j] = 0.5 * Math.cos(deltaj);
                c[startc + nc - j] = 0.5 * Math.sin(deltaj);
            }
        }
    }

    private void makeipt(int nw) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int m = 2;
        for (int l = nw; l > 32; l >>= 2) {
            int m2 = m << 1;
            int q = m2 << 3;
            for (int j = m; j < m2; ++j) {
                int p;
                this.ip[m + j] = p = this.ip[j] << 2;
                this.ip[m2 + j] = p + q;
            }
            m = m2;
        }
    }

    private void makewt(int nw) {
        this.ip[0] = nw;
        this.ip[1] = 1;
        if (nw > 2) {
            int j;
            int nwh = nw >> 1;
            double delta = 0.7853981633974483 / (double)nwh;
            double delta2 = delta * 2.0;
            double wn4r = Math.cos(delta * (double)nwh);
            this.w[0] = 1.0;
            this.w[1] = wn4r;
            if (nwh == 4) {
                this.w[2] = Math.cos(delta2);
                this.w[3] = Math.sin(delta2);
            } else if (nwh > 4) {
                this.makeipt(nw);
                this.w[2] = 0.5 / Math.cos(delta2);
                this.w[3] = 0.5 / Math.cos(delta * 6.0);
                for (j = 4; j < nwh; j += 4) {
                    double deltaj = delta * (double)j;
                    double deltaj3 = 3.0 * deltaj;
                    this.w[j] = Math.cos(deltaj);
                    this.w[j + 1] = Math.sin(deltaj);
                    this.w[j + 2] = Math.cos(deltaj3);
                    this.w[j + 3] = -Math.sin(deltaj3);
                }
            }
            int nw0 = 0;
            while (nwh > 2) {
                double wk1i;
                double wk1r;
                int nw1 = nw0 + nwh;
                this.w[nw1] = 1.0;
                this.w[nw1 + 1] = wn4r;
                if ((nwh >>= 1) == 4) {
                    wk1r = this.w[nw0 + 4];
                    wk1i = this.w[nw0 + 5];
                    this.w[nw1 + 2] = wk1r;
                    this.w[nw1 + 3] = wk1i;
                } else if (nwh > 4) {
                    wk1r = this.w[nw0 + 4];
                    double wk3r = this.w[nw0 + 6];
                    this.w[nw1 + 2] = 0.5 / wk1r;
                    this.w[nw1 + 3] = 0.5 / wk3r;
                    for (j = 4; j < nwh; j += 4) {
                        int idx1 = nw0 + 2 * j;
                        int idx2 = nw1 + j;
                        wk1r = this.w[idx1];
                        wk1i = this.w[idx1 + 1];
                        wk3r = this.w[idx1 + 2];
                        double wk3i = this.w[idx1 + 3];
                        this.w[idx2] = wk1r;
                        this.w[idx2 + 1] = wk1i;
                        this.w[idx2 + 2] = wk3r;
                        this.w[idx2 + 3] = wk3i;
                    }
                }
                nw0 = nw1;
            }
        }
    }

    private void rftbsub(int n, double[] a, int offa, int nc, double[] c, int startc) {
        int m = n >> 1;
        int ks = 2 * nc / m;
        int kk = 0;
        for (int j = 2; j < m; j += 2) {
            int k = n - j;
            double wkr = 0.5 - c[startc + nc - (kk += ks)];
            double wki = c[startc + kk];
            int idx1 = offa + j;
            int idx2 = offa + k;
            double xr = a[idx1] - a[idx2];
            double xi = a[idx1 + 1] + a[idx2 + 1];
            double yr = wkr * xr + wki * xi;
            double yi = wkr * xi - wki * xr;
            int n2 = idx1;
            a[n2] = a[n2] - yr;
            int n3 = idx1 + 1;
            a[n3] = a[n3] - yi;
            int n4 = idx2;
            a[n4] = a[n4] + yr;
            int n5 = idx2 + 1;
            a[n5] = a[n5] - yi;
        }
    }

    private void rftfsub(int n, double[] a, int offa, int nc, double[] c, int startc) {
        int m = n >> 1;
        int ks = 2 * nc / m;
        int kk = 0;
        for (int j = 2; j < m; j += 2) {
            int k = n - j;
            double wkr = 0.5 - c[startc + nc - (kk += ks)];
            double wki = c[startc + kk];
            int idx1 = offa + j;
            int idx2 = offa + k;
            double xr = a[idx1] - a[idx2];
            double xi = a[idx1 + 1] + a[idx2 + 1];
            double yr = wkr * xr - wki * xi;
            double yi = wkr * xi + wki * xr;
            int n2 = idx1;
            a[n2] = a[n2] - yr;
            int n3 = idx1 + 1;
            a[n3] = a[n3] - yi;
            int n4 = idx2;
            a[n4] = a[n4] + yr;
            int n5 = idx2 + 1;
            a[n5] = a[n5] - yi;
        }
    }

    private void scale(final double m, final double[] a, int offa) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k = this.n / nthreads;
            Future[] futures = new Future[nthreads];
            for (int i = 0; i < nthreads; ++i) {
                final int firstIdx = offa + i * k;
                final int lastIdx = i == nthreads - 1 ? offa + this.n : firstIdx + k;
                futures[i] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            int n = i++;
                            a[n] = a[n] * m;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int firstIdx = offa;
            int lastIdx = offa + this.n;
            int i = firstIdx;
            while (i < lastIdx) {
                int n = i++;
                a[n] = a[n] * m;
            }
        }
    }
}

