/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra;

import de.gsi.math.TMathConstants;

public enum Apodization {
    Rectangular("rectangular"),
    Hamming("Hamming"),
    Hann("von Hann"),
    HannExp("exp. von Hann"),
    Blackman("Blackman"),
    Nuttall("Nuttall"),
    BlackmanHarris("Blackman-Harris"),
    BlackmanNuttall("Blackman-Nuttall"),
    FlatTop("Flat-Top"),
    Exponential("exponential");

    private String fname;

    private Apodization(String name) {
        this.fname = name;
    }

    public double getIndex(int i, int n) {
        switch (this) {
            case Rectangular: {
                return 1.0;
            }
            case Hamming: {
                double a = TMathConstants.TwoPi() / (double)n;
                return 0.53836 - 0.46164 * TMathConstants.Cos(a * (double)i);
            }
            case Hann: {
                double a = TMathConstants.TwoPi() / (double)(n - 1);
                return 0.5 - 0.5 * TMathConstants.Cos(a * (double)i);
            }
            case HannExp: {
                double a = TMathConstants.TwoPi() / (double)(n - 1);
                return 1.0 * TMathConstants.Power(TMathConstants.Sin(a * (double)i), 2.0);
            }
            case Blackman: {
                double a = TMathConstants.TwoPi() / (double)(n - 1);
                return 0.42 - 0.5 * TMathConstants.Cos(a * (double)i) + 0.08 * TMathConstants.Cos(2.0 * a * (double)i);
            }
            case Nuttall: {
                double a = TMathConstants.TwoPi() / (double)(n - 1);
                return 0.355768 - 0.487396 * TMathConstants.Cos(a * (double)i) + 0.144232 * TMathConstants.Cos(2.0 * a * (double)i) - 0.012604 * TMathConstants.Cos(3.0 * a * (double)i);
            }
            case BlackmanHarris: {
                double a = TMathConstants.TwoPi() / (double)(n - 1);
                return 0.35875 - 0.48829 * TMathConstants.Cos(a * (double)i) + 0.14128 * TMathConstants.Cos(2.0 * a * (double)i) - 0.01168 * TMathConstants.Cos(3.0 * a * (double)i);
            }
            case BlackmanNuttall: {
                double a = TMathConstants.TwoPi() / (double)(n - 1);
                return 0.3635819 - 0.4891775 * TMathConstants.Cos(a * (double)i) + 0.1365995 * TMathConstants.Cos(2.0 * a * (double)i) - 0.0106411 * TMathConstants.Cos(3.0 * a * (double)i);
            }
            case FlatTop: {
                double a = TMathConstants.TwoPi() / (double)(n - 1);
                return 1.0 - 1.93 * TMathConstants.Cos(a * (double)i) + 1.29 * TMathConstants.Cos(2.0 * a * (double)i) - 0.388 * TMathConstants.Cos(3.0 * a * (double)i) + 0.032 * TMathConstants.Cos(4.0 * a * (double)i);
            }
            case Exponential: {
                double a = 3 * n;
                double exp0 = TMathConstants.Exp(0.0);
                return TMathConstants.Exp((double)i / a) / exp0;
            }
        }
        return 1.0;
    }

    public double getIndex(int i, int n, double m) {
        switch (this) {
            case Rectangular: {
                return this.getIndex(i, n);
            }
            case Hamming: {
                return this.getIndex(i, n);
            }
            case Hann: {
                return this.getIndex(i, n);
            }
            case HannExp: {
                double a = TMathConstants.TwoPi() / (double)(n - 1);
                return 1.0 * TMathConstants.Power(TMathConstants.Sin(a * (double)i), m);
            }
            case Nuttall: {
                return this.getIndex(i, n);
            }
            case BlackmanHarris: {
                return this.getIndex(i, n);
            }
            case BlackmanNuttall: {
                return this.getIndex(i, n);
            }
            case FlatTop: {
                return this.getIndex(i, n);
            }
            case Blackman: {
                return this.getIndex(i, n);
            }
            case Exponential: {
                return this.getIndex(i, n);
            }
        }
        return 1.0;
    }

    public String getName() {
        return this.fname;
    }

    public static void apodize(double[] data, Apodization function) {
        for (int i = 0; i < data.length; ++i) {
            double val = function.getIndex(i, data.length);
            data[i] = data[i] * val;
        }
    }

    public static void main(String[] argv) {
        System.out.println(Hann.getName() + " index (240,1024) = " + Hann.getIndex(240, 1024));
    }
}

