/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.matrix;

import de.gsi.math.TRandom;
import de.gsi.math.matrix.MatrixD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingularValueDecomposition {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingularValueDecomposition.class);
    private static final int MAX_SVD_CONVERSION_LIMIT = 30;
    private static final double TEST_SVD_THRESHOLD = 1.0E-10;
    private static final double TEST_INVERT_THRESHOLD = 1.0E-6;
    private boolean fInit;
    private boolean fInitSVD;
    private MatrixD finputMatrix;
    private MatrixD feigenVectorsU;
    private MatrixD feigenVectorsV;
    private MatrixD fEigenValues;
    private MatrixD fInverseEigenValues;
    private double fCut;

    public SingularValueDecomposition() {
        this.fInit = false;
        this.fInitSVD = false;
        this.fCut = 1.0E-20;
    }

    public SingularValueDecomposition(MatrixD inputMatrix) {
        int m = inputMatrix.getRowDimension();
        int n = inputMatrix.getColumnDimension();
        this.fInitSVD = false;
        this.fCut = 1.0E-20;
        this.finputMatrix = new MatrixD(m, n);
        this.feigenVectorsU = new MatrixD(m, n);
        this.fEigenValues = new MatrixD(n, n);
        this.fInverseEigenValues = new MatrixD(n, n);
        this.feigenVectorsV = new MatrixD(n, n);
        this.finputMatrix = inputMatrix.copy();
        this.fInit = true;
        this.fInitSVD = false;
    }

    public double cond() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        double firstEigenValue = this.fEigenValues.get(0, 0);
        int m = this.getEigenVectorMatrixU().getRowDimension();
        int n = this.getEigenVectorMatrixU().getColumnDimension();
        int index = Math.min(m, n) - 1;
        double lastEigenValue = this.fEigenValues.get(index, index);
        return firstEigenValue / lastEigenValue;
    }

    public boolean decompose() {
        return this.decompose(false);
    }

    public boolean decompose(boolean useSquareMatrix) {
        int row_index;
        int i;
        int i2;
        double[] a;
        if (!this.fInit) {
            LOGGER.error("no matrix specified");
            return false;
        }
        int m = this.finputMatrix.getRowDimension();
        int n = this.finputMatrix.getColumnDimension();
        if (m == 0 || n == 0) {
            LOGGER.error(String.format("null matrix specified (%d,%d)", m, n));
            return false;
        }
        double[] eigenValues = new double[n];
        double[] eigenVectorMatrixV = new double[n * n];
        if (useSquareMatrix) {
            MatrixD square = this.finputMatrix.transpose().times(this.finputMatrix);
            m = n = square.getRowDimension();
            LOGGER.debug(String.format("reduced to %dx%d matrix", n, n));
            a = new double[n * n];
            for (i2 = 0; i2 < m; ++i2) {
                for (int j = 0; j < n; ++j) {
                    a[i2 * n + j] = square.get(i2, j);
                }
            }
        } else {
            a = new double[m * n];
            for (int i3 = 0; i3 < m; ++i3) {
                for (int j = 0; j < n; ++j) {
                    a[i3 * n + j] = this.finputMatrix.get(i3, j);
                }
            }
        }
        this.svdcmp(a, m, n, eigenValues, eigenVectorMatrixV);
        if (useSquareMatrix) {
            this.sortEigenValues(eigenValues, eigenVectorMatrixV);
        } else {
            this.sortEigenValues(a, eigenValues, eigenVectorMatrixV, m);
        }
        this.fInverseEigenValues.times(0.0);
        this.fEigenValues.times(0.0);
        if (useSquareMatrix) {
            for (i = 0; i < n; ++i) {
                double eigenValue = Math.sqrt(eigenValues[i]);
                this.fEigenValues.set(i, i, eigenValue);
                if (eigenValue == 0.0) {
                    this.fInverseEigenValues.set(i, i, 0.0);
                    continue;
                }
                this.fInverseEigenValues.set(i, i, 1.0 / eigenValue);
            }
        } else {
            for (i = 0; i < n; ++i) {
                double eigenValue = eigenValues[i];
                this.fEigenValues.set(i, i, eigenValue);
                if (eigenValue == 0.0) {
                    this.fInverseEigenValues.set(i, i, 0.0);
                    continue;
                }
                this.fInverseEigenValues.set(i, i, 1.0 / eigenValue);
            }
        }
        if (useSquareMatrix) {
            MatrixD EigenTimesLambda_minus1 = new MatrixD(n, n);
            for (i2 = 0; i2 < n; ++i2) {
                row_index = i2 * n;
                for (int j = 0; j < n; ++j) {
                    this.feigenVectorsV.set(i2, j, eigenVectorMatrixV[row_index + j]);
                    double eigenValue = this.fInverseEigenValues.get(j, j);
                    EigenTimesLambda_minus1.set(i2, j, eigenValue * eigenVectorMatrixV[row_index + j]);
                }
            }
            this.feigenVectorsU = this.finputMatrix.times(EigenTimesLambda_minus1);
        } else {
            MatrixD EigenTimesLambda_minus1 = new MatrixD(n, n);
            for (i2 = 0; i2 < n; ++i2) {
                row_index = i2 * n;
                for (int j = 0; j < n; ++j) {
                    this.feigenVectorsV.set(i2, j, eigenVectorMatrixV[row_index + j]);
                    double eigenValue = this.fInverseEigenValues.get(j, j);
                    EigenTimesLambda_minus1.set(i2, j, eigenValue * eigenVectorMatrixV[row_index + j]);
                }
            }
            this.feigenVectorsU = this.finputMatrix.times(EigenTimesLambda_minus1);
        }
        this.fInitSVD = true;
        return true;
    }

    public MatrixD getEigenSolution(int eigen) {
        if (!this.fInitSVD) {
            this.decompose();
        }
        int n = this.feigenVectorsU.getRowDimension();
        MatrixD ret = new MatrixD(n, 1);
        for (int i = 0; i < n; ++i) {
            ret.set(i, 0, this.feigenVectorsU.get(i, eigen));
        }
        return ret;
    }

    public MatrixD getEigenValues() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.fEigenValues;
    }

    public MatrixD getEigenVector(int eigen) {
        if (!this.fInitSVD) {
            this.decompose();
        }
        int n = this.feigenVectorsV.getRowDimension();
        MatrixD ret = new MatrixD(n, 1);
        for (int i = 0; i < n; ++i) {
            ret.set(i, 0, this.feigenVectorsV.get(i, eigen));
        }
        return ret;
    }

    public MatrixD getEigenVectorMatrixU() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.feigenVectorsU;
    }

    public MatrixD getEigenVectorMatrixV() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.feigenVectorsV;
    }

    public MatrixD getInverse() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.getInverse(false, -1);
    }

    public MatrixD getInverse(boolean timer, int nEigenValues) {
        int m = this.feigenVectorsU.getRowDimension();
        int n = this.feigenVectorsU.getColumnDimension();
        int nEigen = nEigenValues;
        if (nEigen < 0) {
            nEigen = this.fEigenValues.getRowDimension() - 1;
        }
        if (nEigen < 0 || nEigen >= n) {
            LOGGER.warn(String.format("selected number of eigenvalues %d exceeds maximum %d . et to max", nEigen, n));
            nEigen = n;
        }
        if (!this.fInitSVD) {
            LOGGER.debug(String.format("forced decomposition of %dx%d matrix", m, n));
            this.decompose(false);
        }
        LOGGER.debug(String.format("cut below %e and max %d eigenvalues", this.fCut, nEigen));
        MatrixD lambdaMinus1 = new MatrixD(n, n);
        double eigenValueMax = this.fEigenValues.get(0, 0);
        for (int i = 0; i < n; ++i) {
            double eigenValue = this.fEigenValues.get(i, i);
            if (!(eigenValue / eigenValueMax > this.fCut) || i > nEigen) {
                LOGGER.debug(String.format("discarding from eigenvalue %d", i + 1));
                break;
            }
            lambdaMinus1.set(i, i, this.fInverseEigenValues.get(i, i));
        }
        MatrixD eigenVectorsUt = this.feigenVectorsU.transpose();
        MatrixD iRESPONSE = this.feigenVectorsV.times(lambdaMinus1.times(eigenVectorsUt));
        return iRESPONSE;
    }

    public MatrixD getMatrix() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.feigenVectorsU.times(this.fEigenValues.times(this.feigenVectorsV.transpose()));
    }

    public MatrixD getPseudoInverseEigenvalues() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.fInverseEigenValues.copy();
    }

    public double[] getSingularValues() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        int n = this.fEigenValues.getColumnDimension();
        double[] retVal = new double[n];
        for (int i = 0; i < n; ++i) {
            retVal[i] = this.fEigenValues.get(i, i);
        }
        return retVal;
    }

    public double getThreshold() {
        return this.fCut;
    }

    public double getTol() {
        return this.getThreshold();
    }

    public MatrixD getU() {
        return this.getEigenVectorMatrixU();
    }

    public MatrixD getV() {
        return this.getEigenVectorMatrixV();
    }

    private double mySIGN(double a, double b) {
        return b >= 0.0 ? Math.abs(a) : -Math.abs(a);
    }

    @Deprecated
    public double norm2() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        return this.fEigenValues.get(0, 0);
    }

    private double pythagoras(double a, double b) {
        double absb;
        double absa = Math.abs(a);
        if (absa > (absb = Math.abs(b))) {
            return absa * Math.sqrt(1.0 + this.square(absb / absa));
        }
        return absb == 0.0 ? 0.0 : absb * Math.sqrt(1.0 + this.square(absa / absb));
    }

    public int rank() {
        if (!this.fInitSVD) {
            this.decompose();
        }
        int rank = 0;
        double eps = Math.pow(2.0, -52.0);
        int m = this.getEigenVectorMatrixU().getRowDimension();
        int n = this.getEigenVectorMatrixU().getColumnDimension();
        double firstEigenValue = this.fEigenValues.get(0, 0);
        double tol = (double)Math.max(m, n) * firstEigenValue * eps;
        for (int i = 0; i < this.fEigenValues.getColumnDimension(); ++i) {
            double eigenValue = this.fEigenValues.get(i, i);
            if (!(eigenValue > tol)) continue;
            ++rank;
        }
        return rank;
    }

    public void setMatrix(MatrixD inputMatrix) {
        int m = inputMatrix.getRowDimension();
        int n = inputMatrix.getColumnDimension();
        this.fInitSVD = false;
        this.fCut = 1.0E-20;
        this.finputMatrix = new MatrixD(m, n);
        this.feigenVectorsU = new MatrixD(m, n);
        this.fEigenValues = new MatrixD(n, n);
        this.fInverseEigenValues = new MatrixD(n, n);
        this.feigenVectorsV = new MatrixD(n, n);
        this.finputMatrix = inputMatrix.copy();
        this.fInit = true;
        this.fInitSVD = false;
    }

    public void setThreshold(double val) {
        this.fCut = val;
    }

    public void setTol(double val) {
        this.setThreshold(val);
    }

    private void sortEigenValues(double[] eigenValues, double[] eigenVectorMatrixV) {
        int n = eigenValues.length;
        for (int i = 0; i < n - 1; ++i) {
            int j;
            int k = i;
            double p = eigenValues[k];
            for (j = i + 1; j < n; ++j) {
                if (!(eigenValues[j] >= p)) continue;
                k = j;
                p = eigenValues[k];
            }
            if (k == i) continue;
            eigenValues[k] = eigenValues[i];
            eigenValues[i] = p;
            for (j = 0; j < n; ++j) {
                p = eigenVectorMatrixV[j * n + i];
                eigenVectorMatrixV[j * n + i] = eigenVectorMatrixV[j * n + k];
                eigenVectorMatrixV[j * n + k] = p;
            }
        }
    }

    private void sortEigenValues(double[] eigenVectorU, double[] eigenValues, double[] eigenVectorMatrixV, int m) {
        int n = eigenValues.length;
        for (int i = 0; i < n - 1; ++i) {
            int j;
            int k = i;
            double p = eigenValues[k];
            for (j = i + 1; j < n; ++j) {
                if (!(eigenValues[j] >= p)) continue;
                k = j;
                p = eigenValues[k];
            }
            if (k == i) continue;
            eigenValues[k] = eigenValues[i];
            eigenValues[i] = p;
            for (j = 0; j < n; ++j) {
                p = eigenVectorMatrixV[j * n + i];
                eigenVectorMatrixV[j * n + i] = eigenVectorMatrixV[j * n + k];
                eigenVectorMatrixV[j * n + k] = p;
            }
            for (j = 0; j < m; ++j) {
                p = eigenVectorU[j * n + i];
                eigenVectorU[j * n + i] = eigenVectorU[j * n + k];
                eigenVectorU[j * n + k] = p;
            }
        }
    }

    private double square(double a) {
        return a * a;
    }

    private void svdcmp(double[] inputMatrix, int m, int n, double[] eigenValues, double[] eigenVectorMatrixV) {
        double s;
        int i;
        int l = 0;
        int nm = 0;
        double anorm = 0.0;
        double g = 0.0;
        double scale = 0.0;
        double[] rv = new double[n];
        for (i = 0; i < n; ++i) {
            int k;
            int k2;
            int j;
            double h;
            int k3;
            l = i + 1;
            rv[i] = scale * g;
            g = 0.0;
            double s2 = 0.0;
            scale = 0.0;
            if (i < m) {
                for (k3 = i; k3 < m; ++k3) {
                    scale += Math.abs(inputMatrix[k3 * n + i]);
                }
                if (scale != 0.0) {
                    for (k3 = i; k3 < m; ++k3) {
                        int n2 = k3 * n + i;
                        inputMatrix[n2] = inputMatrix[n2] / scale;
                        s2 += inputMatrix[k3 * n + i] * inputMatrix[k3 * n + i];
                    }
                    double f = inputMatrix[i * n + i];
                    g = -this.mySIGN(Math.sqrt(s2), f);
                    h = f * g - s2;
                    inputMatrix[i * n + i] = f - g;
                    for (j = l; j < n; ++j) {
                        s2 = 0.0;
                        for (k2 = i; k2 < m; ++k2) {
                            s2 += inputMatrix[k2 * n + i] * inputMatrix[k2 * n + j];
                        }
                        f = s2 / h;
                        for (k2 = i; k2 < m; ++k2) {
                            int n3 = k2 * n + j;
                            inputMatrix[n3] = inputMatrix[n3] + f * inputMatrix[k2 * n + i];
                        }
                    }
                    for (k = i; k < m; ++k) {
                        int n4 = k * n + i;
                        inputMatrix[n4] = inputMatrix[n4] * scale;
                    }
                }
            }
            eigenValues[i] = scale * g;
            g = 0.0;
            s2 = 0.0;
            scale = 0.0;
            if (i < m && i != n - 1) {
                for (k3 = l; k3 < n; ++k3) {
                    scale += Math.abs(inputMatrix[i * n + k3]);
                }
                if (scale != 0.0) {
                    for (k3 = l; k3 < n; ++k3) {
                        int n5 = i * n + k3;
                        inputMatrix[n5] = inputMatrix[n5] / scale;
                        s2 += inputMatrix[i * n + k3] * inputMatrix[i * n + k3];
                    }
                    double f = inputMatrix[i * n + l];
                    g = -this.mySIGN(Math.sqrt(s2), f);
                    h = f * g - s2;
                    inputMatrix[i * n + l] = f - g;
                    for (k = l; k < n; ++k) {
                        rv[k] = inputMatrix[i * n + k] / h;
                    }
                    for (j = l; j < m; ++j) {
                        s2 = 0.0;
                        for (k2 = l; k2 < n; ++k2) {
                            s2 += inputMatrix[j * n + k2] * inputMatrix[i * n + k2];
                        }
                        for (k2 = l; k2 < n; ++k2) {
                            int n6 = j * n + k2;
                            inputMatrix[n6] = inputMatrix[n6] + s2 * rv[k2];
                        }
                    }
                    for (k = l; k < n; ++k) {
                        int n7 = i * n + k;
                        inputMatrix[n7] = inputMatrix[n7] * scale;
                    }
                }
            }
            anorm = Math.max(anorm, Math.abs(eigenValues[i]) + Math.abs(rv[i]));
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                int j;
                if (g != 0.0) {
                    for (j = l; j < n; ++j) {
                        eigenVectorMatrixV[j * n + i] = inputMatrix[i * n + j] / inputMatrix[i * n + l] / g;
                    }
                    for (j = l; j < n; ++j) {
                        int k;
                        s = 0.0;
                        for (k = l; k < n; ++k) {
                            s += inputMatrix[i * n + k] * eigenVectorMatrixV[k * n + j];
                        }
                        for (k = l; k < n; ++k) {
                            int n8 = k * n + j;
                            eigenVectorMatrixV[n8] = eigenVectorMatrixV[n8] + s * eigenVectorMatrixV[k * n + i];
                        }
                    }
                }
                for (j = l; j < n; ++j) {
                    eigenVectorMatrixV[i * n + j] = 0.0;
                    eigenVectorMatrixV[j * n + i] = 0.0;
                }
            }
            eigenVectorMatrixV[i * n + i] = 1.0;
            g = rv[i];
            l = i--;
        }
        for (i = Math.min(m - 1, n - 1); i >= 0; --i) {
            int j;
            l = i + 1;
            g = eigenValues[i];
            for (j = l; j < n; ++j) {
                inputMatrix[i * n + j] = 0.0;
            }
            if (g == 0.0) {
                for (j = i; j < m; ++j) {
                    inputMatrix[j * n + i] = 0.0;
                }
            } else {
                g = 1.0 / g;
                for (j = l; j < n; ++j) {
                    s = 0.0;
                    for (int k = l; k < m; ++k) {
                        s += inputMatrix[k * n + i] * inputMatrix[k * n + j];
                    }
                    double f = s / inputMatrix[i * n + i] * g;
                    for (int k = i; k < m; ++k) {
                        int n9 = k * n + j;
                        inputMatrix[n9] = inputMatrix[n9] + f * inputMatrix[k * n + i];
                    }
                }
                for (j = i; j < m; ++j) {
                    int n10 = j * n + i;
                    inputMatrix[n10] = inputMatrix[n10] * g;
                }
            }
            int n11 = i * n + i;
            inputMatrix[n11] = inputMatrix[n11] + 1.0;
        }
        block27: for (int k = n - 1; k >= 0; --k) {
            for (int its = 1; its <= 30; ++its) {
                boolean flag = true;
                for (l = k; l >= 0; --l) {
                    nm = l - 1;
                    if (Math.abs(rv[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(eigenValues[nm]) + anorm == anorm) break;
                }
                if (flag) {
                    double c = 0.0;
                    double s3 = 1.0;
                    for (int i2 = l; i2 <= k; ++i2) {
                        double h;
                        double f = s3 * rv[i2];
                        rv[i2] = c * rv[i2];
                        if (Math.abs(f) + anorm == anorm) break;
                        g = eigenValues[i2];
                        eigenValues[i2] = h = this.pythagoras(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s3 = -f * h;
                        for (int j = 0; j < m; ++j) {
                            int row = j * n;
                            double y = inputMatrix[row + nm];
                            double z = inputMatrix[row + i2];
                            inputMatrix[row + nm] = y * c + z * s3;
                            inputMatrix[row + i2] = z * c - y * s3;
                        }
                    }
                }
                double z = eigenValues[k];
                if (l == k) {
                    if (!(z < 0.0)) continue block27;
                    eigenValues[k] = -z;
                    for (int j = 0; j < n; ++j) {
                        eigenVectorMatrixV[j * n + k] = -eigenVectorMatrixV[j * n + k];
                    }
                    continue block27;
                }
                if (its == 30) {
                    LOGGER.warn(String.format("no convergence in %d svdcmp iterations", 30));
                    continue block27;
                }
                double x = eigenValues[l];
                nm = k - 1;
                double y = eigenValues[nm];
                g = rv[nm];
                double h = rv[k];
                double f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = this.pythagoras(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + this.mySIGN(g, f)) - h)) / x;
                double c = 1.0;
                double s4 = 1.0;
                for (int j = l; j <= nm; ++j) {
                    int row;
                    int jj;
                    int i3 = j + 1;
                    g = rv[i3];
                    y = eigenValues[i3];
                    h = s4 * g;
                    g = c * g;
                    rv[j] = z = this.pythagoras(f, h);
                    c = f / z;
                    s4 = h / z;
                    f = x * c + g * s4;
                    g = g * c - x * s4;
                    h = y * s4;
                    y *= c;
                    for (jj = 0; jj < n; ++jj) {
                        row = jj * n;
                        x = eigenVectorMatrixV[row + j];
                        z = eigenVectorMatrixV[row + i3];
                        eigenVectorMatrixV[row + j] = x * c + z * s4;
                        eigenVectorMatrixV[row + i3] = z * c - x * s4;
                    }
                    eigenValues[j] = z = this.pythagoras(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s4 = h * z;
                    }
                    f = c * g + s4 * y;
                    x = c * y - s4 * g;
                    for (jj = 0; jj < m; ++jj) {
                        row = jj * n;
                        y = inputMatrix[row + j];
                        z = inputMatrix[row + i3];
                        inputMatrix[row + j] = y * c + z * s4;
                        inputMatrix[row + i3] = z * c - y * s4;
                    }
                }
                rv[l] = 0.0;
                rv[k] = f;
                eigenValues[k] = x;
            }
        }
    }

    public boolean testInvert() {
        return this.testInvert(1.0E-6);
    }

    public boolean testInvert(double threshold) {
        double stol = this.getTol();
        this.setTol(0.0);
        MatrixD pseudoInverse = this.getInverse();
        MatrixD inputRAW = this.finputMatrix;
        MatrixD testMatrix = pseudoInverse.times(inputRAW);
        this.setTol(stol);
        LOGGER.debug(String.format("dimension of test matrix %dx%d", testMatrix.getRowDimension(), testMatrix.getColumnDimension()));
        int nEigenMax = this.fEigenValues.getRowDimension() - 1;
        LOGGER.debug(String.format("max/min eigenvalue ratio: %+e", this.fEigenValues.get(0, 0) / this.fEigenValues.get(nEigenMax, nEigenMax)));
        for (int i = 0; i < testMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < testMatrix.getColumnDimension(); ++j) {
                if (i == j) {
                    testMatrix.set(i, j, testMatrix.get(i, j) - 1.0);
                }
                if (!(Math.abs(testMatrix.get(i, j)) > threshold)) continue;
                LOGGER.warn("TestInvert() - found that element (%d,%d) differs %e from zero!", new Object[]{i, j, testMatrix.get(i, j)});
                return false;
            }
        }
        return true;
    }

    public boolean testSVD() {
        return this.testSVD(1.0E-10);
    }

    public boolean testSVD(double threshold) {
        MatrixD testMatrix = this.finputMatrix.minus(this.getMatrix());
        for (int i = 0; i < testMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < testMatrix.getColumnDimension(); ++j) {
                if (!(Math.abs(testMatrix.get(i, j)) > threshold)) continue;
                LOGGER.warn(String.format("found that element (%d,%d) differs %e from zero!", i, j, testMatrix.get(i, j)));
                return false;
            }
        }
        return true;
    }

    public static void main(String[] argc) {
        int i;
        TRandom rnd = new TRandom(1L);
        MatrixD input = new MatrixD(200, 100);
        for (int i2 = 0; i2 < input.getRowDimension(); ++i2) {
            for (int j = 0; j < input.getColumnDimension(); ++j) {
                double value = rnd.Integer(10L);
                input.set(i2, j, value);
            }
        }
        SingularValueDecomposition svd = new SingularValueDecomposition(input);
        MatrixD eigenvalues1 = null;
        MatrixD eigenvalues2 = null;
        boolean useIntermediateSquareMatrix = true;
        if (svd.decompose(true)) {
            LOGGER.info("decompose() - square intermediate matrix - successful");
            eigenvalues1 = svd.getEigenValues();
        } else {
            LOGGER.info("decompose() - failed");
        }
        if (svd.decompose(false)) {
            LOGGER.info("decompose() - successful");
            eigenvalues2 = svd.getEigenValues();
        } else {
            LOGGER.info("decompose() - failed");
        }
        if (eigenvalues1 != null && eigenvalues2 != null) {
            for (i = 0; i < eigenvalues1.getRowDimension(); ++i) {
                LOGGER.info("eigenvalue(%2d) = %+e vs %+e   diff = %+e", new Object[]{i, eigenvalues1.get(i, i), eigenvalues2.get(i, i), eigenvalues1.get(i, i) - eigenvalues2.get(i, i)});
            }
        } else if (eigenvalues1 != null) {
            for (i = 0; i < eigenvalues1.getRowDimension(); ++i) {
                LOGGER.info("eigenvalue(%2d) = %+e", (Object)i, (Object)eigenvalues1.get(i, i));
            }
        } else if (eigenvalues2 != null) {
            for (i = 0; i < eigenvalues2.getRowDimension(); ++i) {
                LOGGER.info("eigenvalue(%2d) = %+e", (Object)i, (Object)eigenvalues2.get(i, i));
            }
        }
        LOGGER.info("norm2 = %lf", (Object)svd.norm2());
        LOGGER.info("cond = %lf", (Object)svd.cond());
        LOGGER.info("rank = %lf", (Object)svd.rank());
        LOGGER.info("check - testSVD()");
        if (svd.testSVD()) {
            LOGGER.info("testSVD() - passed");
        } else {
            LOGGER.warn("testSVD() - failed");
        }
        LOGGER.info("check - testInvert()");
        if (svd.testInvert()) {
            LOGGER.info("testInvert() - passed");
        } else {
            LOGGER.warn("testInvert() - failed");
            if (input.getRowDimension() < 20 && input.getColumnDimension() < 20) {
                MatrixD matS = svd.getEigenValues();
                MatrixD matSm = svd.getPseudoInverseEigenvalues();
                MatrixD matU = svd.getEigenVectorMatrixU();
                MatrixD matV = svd.getEigenVectorMatrixV();
                LOGGER.info("eigenvalues x pseudo-inverse eigenvalue matrix =");
                matS.times(matSm).print(4, 3);
                LOGGER.info("V x Vt =");
                matV.times(matV.transpose()).print(4, 2);
                LOGGER.info("U x Ut =");
                matU.times(matU.transpose()).print(4, 2);
                LOGGER.info("Ut x U =");
                matU.transpose().times(matU).print(4, 2);
            }
        }
    }
}

