/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.filter.iir;

import de.gsi.math.filter.iir.LayoutBase;
import de.gsi.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public class LowPassTransform {
    private LowPassTransform() {
    }

    private static Complex transform(Complex in, double f) {
        if (in.isInfinite()) {
            return new Complex(-1.0, 0.0);
        }
        Complex c = in.multiply(f);
        Complex one = new Complex(1.0, 0.0);
        return one.add(c).divide(one.subtract(c));
    }

    public static void transform(double fc, LayoutBase digital, LayoutBase analog) {
        digital.reset();
        double f = Math.tan(Math.PI * fc);
        int numPoles = analog.getNumPoles();
        int pairs = numPoles / 2;
        for (int i = 0; i < pairs; ++i) {
            PoleZeroPair pair = analog.getPair(i);
            digital.addPoleZeroConjugatePairs(LowPassTransform.transform(pair.poles.first, f), LowPassTransform.transform(pair.zeros.first, f));
        }
        if ((numPoles & 1) == 1) {
            PoleZeroPair pair = analog.getPair(pairs);
            digital.add(LowPassTransform.transform(pair.poles.first, f), LowPassTransform.transform(pair.zeros.first, f));
        }
        digital.setNormal(analog.getNormalW(), analog.getNormalGain());
    }
}

