/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.filter.iir;

import de.gsi.math.filter.iir.LayoutBase;
import de.gsi.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public class HighPassTransform {
    private HighPassTransform() {
    }

    private static Complex transform(Complex in, double f) {
        if (in.isInfinite()) {
            return new Complex(1.0, 0.0);
        }
        Complex c = in.multiply(f);
        return new Complex(-1.0).multiply(new Complex(1.0).add(c)).divide(new Complex(1.0).subtract(c));
    }

    public static void transform(double fc, LayoutBase digital, LayoutBase analog) {
        digital.reset();
        double f = 1.0 / Math.tan(Math.PI * fc);
        int numPoles = analog.getNumPoles();
        int pairs = numPoles / 2;
        for (int i = 0; i < pairs; ++i) {
            PoleZeroPair pair = analog.getPair(i);
            digital.addPoleZeroConjugatePairs(HighPassTransform.transform(pair.poles.first, f), HighPassTransform.transform(pair.zeros.first, f));
        }
        if ((numPoles & 1) == 1) {
            PoleZeroPair pair = analog.getPair(pairs);
            digital.add(HighPassTransform.transform(pair.poles.first, f), HighPassTransform.transform(pair.zeros.first, f));
        }
        digital.setNormal(Math.PI - analog.getNormalW(), analog.getNormalGain());
    }
}

