/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.filter.iir;

import de.gsi.math.filter.iir.BandPassTransform;
import de.gsi.math.filter.iir.BandStopTransform;
import de.gsi.math.filter.iir.Cascade;
import de.gsi.math.filter.iir.HighPassTransform;
import de.gsi.math.filter.iir.LayoutBase;
import de.gsi.math.filter.iir.LowPassTransform;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.util.FastMath;

public class ChebyshevII
extends Cascade {
    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, rippleDb, 1);
    }

    public void bandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        this.setupBandPass(order, sampleRate, centerFrequency, widthFrequency, rippleDb, directFormType);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, rippleDb, 1);
    }

    public void bandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        this.setupBandStop(order, sampleRate, centerFrequency, widthFrequency, rippleDb, directFormType);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency, double rippleDb) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, rippleDb, 1);
    }

    public void highPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        this.setupHighPass(order, sampleRate, cutoffFrequency, rippleDb, directFormType);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency, double rippleDb) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, rippleDb, 1);
    }

    public void lowPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        this.setupLowPass(order, sampleRate, cutoffFrequency, rippleDb, directFormType);
    }

    private void setupBandPass(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design(rippleDb);
        LayoutBase digitalProto = new LayoutBase(order * 2);
        BandPassTransform.transform(centerFrequency / sampleRate, widthFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private void setupBandStop(int order, double sampleRate, double centerFrequency, double widthFrequency, double rippleDb, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design(rippleDb);
        LayoutBase digitalProto = new LayoutBase(order * 2);
        BandStopTransform.transform(centerFrequency / sampleRate, widthFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private void setupHighPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design(rippleDb);
        LayoutBase digitalProto = new LayoutBase(order);
        HighPassTransform.transform(cutoffFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    private void setupLowPass(int order, double sampleRate, double cutoffFrequency, double rippleDb, int directFormType) {
        AnalogLowPass analogProto = new AnalogLowPass(order);
        analogProto.design(rippleDb);
        LayoutBase digitalProto = new LayoutBase(order);
        LowPassTransform.transform(cutoffFrequency / sampleRate, digitalProto, analogProto);
        this.setLayout(digitalProto, directFormType);
    }

    class AnalogLowPass
    extends LayoutBase {
        private final int nPoles;

        public AnalogLowPass(int _nPoles) {
            super(_nPoles);
            this.nPoles = _nPoles;
        }

        public void design(double stopBandDb) {
            this.reset();
            double eps = Math.sqrt(1.0 / (Math.exp(stopBandDb * 0.1 * Math.log(10.0)) - 1.0));
            double v0 = FastMath.asinh((double)(1.0 / eps)) / (double)this.nPoles;
            double sinh_v0 = -Math.sinh(v0);
            double cosh_v0 = Math.cosh(v0);
            double fn = Math.PI / (double)(2 * this.nPoles);
            int k = 1;
            int i = this.nPoles / 2;
            while (--i >= 0) {
                double a = sinh_v0 * Math.cos((double)(k - this.nPoles) * fn);
                double b = cosh_v0 * Math.sin((double)(k - this.nPoles) * fn);
                double d2 = a * a + b * b;
                double im = 1.0 / Math.cos((double)k * fn);
                Complex pole = new Complex(a / d2, b / d2);
                Complex zero = new Complex(0.0, im);
                this.addPoleZeroConjugatePairs(pole, zero);
                k += 2;
            }
            if ((this.nPoles & 1) == 1) {
                this.add(new Complex(1.0 / sinh_v0), new Complex(Double.POSITIVE_INFINITY));
            }
            this.setNormal(0.0, 1.0);
        }
    }
}

