/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.spi.utils.DoublePointError;
import de.gsi.math.ArrayMath;
import de.gsi.math.TMath;
import de.gsi.math.TMathConstants;
import de.gsi.math.TRandom;
import de.gsi.math.spectra.Apodization;
import de.gsi.math.spectra.SpectrumTools;
import de.gsi.math.spectra.fft.DoubleFFT_1D;
import java.util.Arrays;
import java.util.List;

public final class DataSetMath {
    private static final char INFINITY_SYMBOL = '\u221e';
    private static final char INTEGRAL_SYMBOL = '\u222b';
    private static final char DIFFERENTIAL_SYMBOL = '\u2202';
    private static final char MULTIPLICATION_SYMBOL = '\u00b7';
    private static final String DIFFERENTIAL = "\u2202/\u2202x";
    private static final TRandom random = new TRandom(System.currentTimeMillis());

    private DataSetMath() {
    }

    public static DataSet addFunction(DataSet function1, DataSet function2) {
        return DataSetMath.mathFunction(function1, function2, MathOp.ADD);
    }

    public static DataSet addFunction(DataSet function, double value) {
        return DataSetMath.mathFunction(function, value, MathOp.ADD);
    }

    public static DataSet addGaussianNoise(DataSet function, double sigma) {
        int nLength = function.getDataCount();
        DoubleErrorDataSet ret = new DoubleErrorDataSet(function.getName() + "noise(" + sigma + ")", nLength);
        for (int i = 0; i < nLength; ++i) {
            double x = function.get(0, i);
            double y = function.get(1, i) + random.Gaus(0.0, sigma);
            ret.add(x, y, sigma, sigma);
        }
        return ret;
    }

    public static DataSet averageDataSetsFIR(List<DataSet> dataSets, int nUpdates) {
        if (dataSets == null || dataSets.isEmpty()) {
            return null;
        }
        String functionName = "LP(" + dataSets.get(0).getName() + ", FIR)";
        if (dataSets.size() <= 1) {
            DataSet newFunction = dataSets.get(0);
            if (newFunction instanceof DataSetError) {
                return new DoubleErrorDataSet(functionName, DataSetMath.values(0, newFunction), DataSetMath.values(1, newFunction), DataSetMath.errors(newFunction, ErrType.EYN), DataSetMath.errors(newFunction, ErrType.EYP), newFunction.getDataCount(), true);
            }
            int ncount = newFunction.getDataCount();
            return new DoubleErrorDataSet(functionName, DataSetMath.values(0, newFunction), DataSetMath.values(1, newFunction), new double[ncount], new double[ncount], ncount, true);
        }
        int nAvg = Math.min(nUpdates, dataSets.size());
        DataSet newFunction = dataSets.get(dataSets.size() - 1);
        DoubleErrorDataSet retFunction = new DoubleErrorDataSet(functionName, newFunction.getDataCount() + 2);
        for (int i = 0; i < newFunction.getDataCount(); ++i) {
            double newX = newFunction.get(0, i);
            double mean = 0.0;
            double var = 0.0;
            double eyn = 0.0;
            double eyp = 0.0;
            int count = 0;
            for (int j = Math.max(0, dataSets.size() - nAvg); j < dataSets.size(); ++j) {
                DataSet oldFunction = dataSets.get(j);
                double oldX = oldFunction.get(0, i);
                double oldY = oldX == newX ? oldFunction.get(1, i) : oldFunction.getValue(0, newX);
                mean += oldY;
                var += oldY * oldY;
                boolean inter = oldX != newX;
                eyn += DataSetMath.error(oldFunction, ErrType.EYN, i, newX, inter);
                eyp += DataSetMath.error(oldFunction, ErrType.EYP, i, newX, inter);
                ++count;
            }
            if (count == 0) {
                retFunction.add(newX, Double.NaN, Double.NaN, Double.NaN);
                continue;
            }
            eyn /= (double)count;
            eyp /= (double)count;
            double mean2 = (mean /= (double)count) * mean;
            double diff = Math.abs((var /= (double)count) - mean2);
            eyn = Math.sqrt(eyn * eyn + diff);
            eyp = Math.sqrt(eyp * eyp + diff);
            retFunction.add(newX, mean, eyn, eyp);
        }
        return retFunction;
    }

    public static DataSet averageDataSetsIIR(DataSet prevAverage, DataSet prevAverage2, DataSet newDataSet, int nUpdates) {
        String functionName = "LP(" + newDataSet.getName() + ", IIR)";
        if (prevAverage == null || prevAverage2 == null || prevAverage.getDataCount() == 0 || prevAverage2.getDataCount() == 0) {
            double[] yValues = DataSetMath.values(1, newDataSet);
            double[] eyn = DataSetMath.errors(newDataSet, ErrType.EYN);
            double[] eyp = DataSetMath.errors(newDataSet, ErrType.EYP);
            if (prevAverage2 instanceof DoubleErrorDataSet) {
                ((DoubleErrorDataSet)prevAverage2).set(DataSetMath.values(0, newDataSet), ArrayMath.sqr(yValues), ArrayMath.sqr(eyn), ArrayMath.sqr(eyp));
            } else if (prevAverage2 instanceof DoubleDataSet) {
                ((DoubleDataSet)prevAverage2).set(DataSetMath.values(0, newDataSet), ArrayMath.sqr(yValues));
            }
            return new DoubleErrorDataSet(functionName, DataSetMath.values(0, newDataSet), yValues, eyn, eyp, newDataSet.getDataCount(), true);
        }
        int dataCount1 = prevAverage.getDataCount();
        int dataCount2 = prevAverage2.getDataCount();
        DoubleErrorDataSet retFunction = dataCount1 == 0 ? new DoubleErrorDataSet(functionName, DataSetMath.values(0, newDataSet), DataSetMath.values(1, newDataSet), DataSetMath.errors(newDataSet, ErrType.EYN), DataSetMath.errors(newDataSet, ErrType.EYP), newDataSet.getDataCount(), true) : new DoubleErrorDataSet(prevAverage.getName(), DataSetMath.values(0, prevAverage), DataSetMath.values(1, prevAverage), DataSetMath.errors(prevAverage, ErrType.EYN), DataSetMath.errors(prevAverage, ErrType.EYP), newDataSet.getDataCount(), true);
        double alpha = 1.0 / (1.0 + (double)nUpdates);
        boolean avg2Empty = dataCount2 == 0;
        for (int i = 0; i < dataCount1; ++i) {
            double oldX = prevAverage.get(0, i);
            double oldY = prevAverage.get(1, i);
            double oldY2 = avg2Empty ? oldY * oldY : prevAverage2.get(1, i);
            double newX = newDataSet.get(0, i);
            boolean inter = oldX != newX;
            double y = inter ? newDataSet.getValue(1, oldX) : newDataSet.get(1, i);
            double newY = (1.0 - alpha) * oldY + alpha * y;
            double newY2 = (1.0 - alpha) * oldY2 + alpha * (y * y);
            double eyn = DataSetMath.error(newDataSet, ErrType.EYN, i, newX, inter);
            double eyp = DataSetMath.error(newDataSet, ErrType.EYP, i, newX, inter);
            if (prevAverage2 instanceof DoubleErrorDataSet) {
                if (avg2Empty) {
                    ((DoubleErrorDataSet)prevAverage2).add(newX, newY2, eyn, eyp);
                } else {
                    ((DoubleErrorDataSet)prevAverage2).set(i, newX, newY2, eyn, eyp);
                }
            }
            double newEYN = Math.sqrt(Math.abs(newY2 - Math.pow(newY, 2.0)) + eyn * eyn);
            double newEYP = Math.sqrt(Math.abs(newY2 - Math.pow(newY, 2.0)) + eyp * eyp);
            retFunction.set(i, oldX, newY, newEYN, newEYP);
        }
        return retFunction;
    }

    private static double[] cropToLength(double[] in, int length) {
        if (in.length == length) {
            return in;
        }
        return Arrays.copyOf(in, length);
    }

    public static DataSet dbFunction(DataSet function) {
        return DataSetMath.mathFunction(function, 0.0, MathOp.DB);
    }

    public static DataSet dbFunction(DataSet function1, DataSet function2) {
        return DataSetMath.mathFunction(function1, function2, MathOp.DB);
    }

    public static DataSet derivativeFunction(DataSet function) {
        return DataSetMath.derivativeFunction(function, 1.0);
    }

    public static DataSet derivativeFunction(DataSet function, double sign) {
        double x0;
        int i;
        String signAdd = sign == 1.0 ? "" : Double.toString(sign) + "\u00b7";
        int ncount = function.getDataCount();
        DoubleErrorDataSet retFunction = new DoubleErrorDataSet(signAdd + "\u2202/\u2202x(" + function.getName() + ")", ncount);
        if (ncount <= 3) {
            return retFunction;
        }
        for (i = 0; i < 2; ++i) {
            x0 = function.get(0, i);
            retFunction.add(x0, 0.0, 0.0, 0.0);
        }
        for (i = 2; i < ncount - 2; ++i) {
            x0 = function.get(0, i);
            double stepL = x0 - function.get(0, i - 1);
            double stepR = function.get(0, i + 1) - x0;
            double valL = function.get(1, i - 1);
            double valC = function.get(1, i);
            double valR = function.get(1, i + 1);
            double yenL = DataSetMath.error(function, ErrType.EYN, i - 1);
            double yenC = DataSetMath.error(function, ErrType.EYN, i);
            double yenR = DataSetMath.error(function, ErrType.EYN, i + 1);
            double yen = Math.sqrt(TMathConstants.Sqr(yenL) + TMathConstants.Sqr(yenC) + TMathConstants.Sqr(yenR)) / 4.0;
            double yepL = DataSetMath.error(function, ErrType.EYP, i - 1);
            double yepC = DataSetMath.error(function, ErrType.EYP, i);
            double yepR = DataSetMath.error(function, ErrType.EYP, i + 1);
            double yep = Math.sqrt(TMathConstants.Sqr(yepL) + TMathConstants.Sqr(yepC) + TMathConstants.Sqr(yepR)) / 4.0;
            double derivative = 0.5 * ((valC - valL) / stepL + (valR - valC) / stepR);
            retFunction.add(x0, sign * derivative, yen, yep);
        }
        for (i = ncount - 2; i < ncount; ++i) {
            x0 = function.get(0, i);
            retFunction.add(x0, 0.0, 0.0, 0.0);
        }
        return retFunction;
    }

    public static DataSet divideFunction(DataSet function1, DataSet function2) {
        return DataSetMath.mathFunction(function1, function2, MathOp.DIVIDE);
    }

    public static DataSet divideFunction(DataSet function, double value) {
        return DataSetMath.mathFunction(function, value, MathOp.DIVIDE);
    }

    public static double error(DataSet dataSet, ErrType eType, double x) {
        return DataSetMath.error(dataSet, eType, -1, x, true);
    }

    public static double error(DataSet dataSet, ErrType eType, int index) {
        return DataSetMath.error(dataSet, eType, index, 0.0, false);
    }

    protected static double error(DataSet dataSet, ErrType eType, int index, double x, boolean interpolate) {
        if (!(dataSet instanceof DataSetError)) {
            return 0.0;
        }
        DataSetError ds = (DataSetError)dataSet;
        if (interpolate) {
            switch (eType) {
                case EXN: {
                    return ds.getErrorNegative(0, x);
                }
                case EXP: {
                    return ds.getErrorPositive(0, x);
                }
                case EYN: {
                    return ds.getErrorNegative(1, x);
                }
                case EYP: {
                    return ds.getErrorPositive(1, x);
                }
            }
        } else {
            switch (eType) {
                case EXN: {
                    return ds.getErrorNegative(0, index);
                }
                case EXP: {
                    return ds.getErrorPositive(0, index);
                }
                case EYN: {
                    return ds.getErrorNegative(1, index);
                }
                case EYP: {
                    return ds.getErrorPositive(1, index);
                }
            }
        }
        return 0.0;
    }

    public static double[] errors(DataSet dataSet, ErrType eType) {
        int nDim = dataSet.getDataCount();
        if (!(dataSet instanceof DataSetError)) {
            return new double[nDim];
        }
        DataSetError ds = (DataSetError)dataSet;
        switch (eType) {
            case EXN: {
                return DataSetMath.cropToLength(ds.getErrorsNegative(0), nDim);
            }
            case EXP: {
                return DataSetMath.cropToLength(ds.getErrorsPositive(0), nDim);
            }
            case EYN: {
                return DataSetMath.cropToLength(ds.getErrorsNegative(1), nDim);
            }
        }
        return DataSetMath.cropToLength(ds.getErrorsPositive(1), nDim);
    }

    public static DataSet filterFunction(DataSet function, double width, Filter filterType) {
        int n = function.getDataCount();
        DoubleErrorDataSet filteredFunction = new DoubleErrorDataSet(filterType.getTag() + "(" + function.getName() + "," + Double.toString(width) + ")", n);
        double[] subArrayY = new double[n];
        double[] subArrayYn = new double[n];
        double[] subArrayYp = new double[n];
        double[] xValues = DataSetMath.values(0, function);
        double[] yValues = DataSetMath.values(1, function);
        double[] yen = DataSetMath.errors(function, ErrType.EYN);
        double[] yep = DataSetMath.errors(function, ErrType.EYN);
        block8: for (int i = 0; i < n; ++i) {
            double time0 = xValues[i];
            int count = 0;
            for (int j = 0; j < n; ++j) {
                double time = xValues[j];
                if (!(Math.abs(time0 - time) <= width)) continue;
                subArrayY[count] = yValues[j];
                subArrayYn[count] = yen[j];
                subArrayYp[count] = yep[j];
                ++count;
            }
            double norm = count > 0 ? 1.0 / Math.sqrt(count) : 0.0;
            switch (filterType) {
                case MEDIAN: {
                    filteredFunction.add(time0, TMath.Median(subArrayY, count), TMath.Median(subArrayYn, count), TMath.Median(subArrayYp, count));
                    continue block8;
                }
                case MIN: {
                    filteredFunction.add(time0, TMath.Minimum(subArrayY, count), TMath.Minimum(subArrayYn, count), TMath.Minimum(subArrayYp, count));
                    continue block8;
                }
                case MAX: {
                    filteredFunction.add(time0, TMath.Maximum(subArrayY, count), TMath.Maximum(subArrayYn, count), TMath.Maximum(subArrayYp, count));
                    continue block8;
                }
                case P2P: {
                    filteredFunction.add(time0, TMath.PeakToPeak(subArrayY, count), TMath.PeakToPeak(subArrayYn, count), TMath.PeakToPeak(subArrayYp, count));
                    continue block8;
                }
                case RMS: {
                    filteredFunction.add(time0, TMath.RMS(subArrayY, count), TMath.RMS(subArrayYn, count), TMath.RMS(subArrayYp, count));
                    continue block8;
                }
                case GEOMMEAN: {
                    filteredFunction.add(time0, TMath.GeometricMean(subArrayY, count), TMath.GeometricMean(subArrayYn, count), TMath.GeometricMean(subArrayYp, count));
                    continue block8;
                }
                default: {
                    filteredFunction.add(time0, TMath.Mean(subArrayY, count), TMath.Mean(subArrayYn, count) * norm, TMath.Mean(subArrayYp, count) * norm);
                }
            }
        }
        return filteredFunction;
    }

    public static DataSet geometricMeanFilteredFunction(DataSet function, double width) {
        return DataSetMath.filterFunction(function, width, Filter.GEOMMEAN);
    }

    public static DataSet getSubRange(DataSet function, double xMin, double xMax) {
        int nLength = function.getDataCount();
        DoubleErrorDataSet ret = new DoubleErrorDataSet(function.getName() + "subRange(" + xMin + ", " + xMax + ")", nLength);
        for (int i = 0; i < nLength; ++i) {
            double x = function.get(0, i);
            double y = function.get(1, i);
            double ex = DataSetMath.error(function, ErrType.EXP, i);
            double ey = DataSetMath.error(function, ErrType.EYP, i);
            if (!(x >= xMin) || !(x <= xMax)) continue;
            ret.add(x, y, ex, ey);
        }
        return ret;
    }

    public static DataSet iirLowPassFilterFunction(DataSet function, double width) {
        double y;
        double x1;
        double x0;
        int i;
        int n = function.getDataCount();
        DoubleErrorDataSet filteredFunction = new DoubleErrorDataSet("iir" + Filter.MEAN.getTag() + "(" + function.getName() + "," + Double.toString(width) + ")", n);
        if (n <= 1) {
            int index;
            if (function instanceof DataSet2D) {
                filteredFunction.set((DataSet2D)function);
                return filteredFunction;
            }
            filteredFunction.set(DataSetMath.values(0, function), DataSetMath.values(1, function), DataSetMath.errors(function, ErrType.EYN), DataSetMath.errors(function, ErrType.EYP));
            for (index = 0; index < function.getDataCount(); ++index) {
                String label = function.getDataLabel(index);
                if (label == null || label.isEmpty()) continue;
                filteredFunction.addDataLabel(index, label);
            }
            for (index = 0; index < function.getDataCount(); ++index) {
                String style = function.getStyle(index);
                if (style == null || style.isEmpty()) continue;
                filteredFunction.addDataStyle(index, style);
            }
            filteredFunction.setStyle(function.getStyle());
            return filteredFunction;
        }
        double[] xValues = DataSetMath.values(0, function);
        double[] yValues = DataSetMath.values(1, function);
        double[] yen = DataSetMath.errors(function, ErrType.EYN);
        double[] yep = DataSetMath.errors(function, ErrType.EYN);
        double[] yUp = new double[n];
        double[] yDown = new double[n];
        double[] ye1 = new double[n];
        double[] ye2 = new double[n];
        double smoothing = 0.5 * width;
        double smoothed = yValues[0];
        double smoothed2 = smoothed * smoothed;
        for (i = 1; i < n; ++i) {
            x0 = xValues[i - 1];
            x1 = xValues[i];
            y = yValues[i];
            smoothed += (x1 - x0) * (y - smoothed) / smoothing;
            smoothed2 += (x1 - x0) * (y * y - smoothed2) / smoothing;
            yUp[i] = smoothed;
            ye1[i] = smoothed2;
        }
        smoothed = yValues[n - 1];
        smoothed2 = smoothed * smoothed;
        for (i = n - 2; i >= 0; --i) {
            x0 = xValues[i];
            x1 = xValues[i + 1];
            y = yValues[i];
            smoothed += (x1 - x0) * (y - smoothed) / smoothing;
            smoothed2 += (x1 - x0) * (y * y - smoothed2) / smoothing;
            yDown[i] = smoothed;
            ye2[i] = smoothed2;
        }
        filteredFunction.add(xValues[0], yValues[0], yen[0], yep[0]);
        for (i = 1; i < n; ++i) {
            double x12 = xValues[i];
            double y2 = 0.5 * (yUp[i] + yDown[i]);
            double mean2 = y2 * y2;
            double y22 = 0.5 * Math.pow(ye1[i] + ye2[i], 1.0);
            double avgError2 = Math.abs(y22 - mean2);
            double newEYN = Math.sqrt(avgError2 + yen[i] * yen[i]);
            double newEYP = Math.sqrt(avgError2 + yep[i] * yep[i]);
            filteredFunction.add(x12, y2, newEYN, newEYP);
        }
        return filteredFunction;
    }

    public static DoublePointError integral(DataSet function) {
        DataSet integratedFunction = DataSetMath.integrateFunction(function);
        int lastPoint = integratedFunction.getDataCount() - 1;
        if (lastPoint <= 0) {
            return new DoublePointError(0.0, 0.0, 0.0, 0.0);
        }
        double x = integratedFunction.get(0, lastPoint);
        double y = integratedFunction.get(1, lastPoint);
        double yen = DataSetMath.error(integratedFunction, ErrType.EYN, lastPoint);
        double yep = DataSetMath.error(integratedFunction, ErrType.EYP, lastPoint);
        double ye = 0.5 * (yen + yep);
        return new DoublePointError(x, y, 0.0, ye);
    }

    public static DoublePointError integral(DataSet function, double xMin, double xMax) {
        DataSet integratedFunction = DataSetMath.integrateFunction(function, xMin, xMax);
        int lastPoint = integratedFunction.getDataCount() - 1;
        double yen = DataSetMath.error(integratedFunction, ErrType.EYN, lastPoint);
        double yep = DataSetMath.error(integratedFunction, ErrType.EYP, lastPoint);
        double ye = 0.5 * (yen + yep);
        return new DoublePointError(integratedFunction.get(0, lastPoint), integratedFunction.get(1, lastPoint), 0.0, ye);
    }

    public static double integralSimple(DataSet function) {
        double integral1 = 0.0;
        double integral2 = 0.0;
        int nCount = function.getDataCount();
        if (nCount <= 1) {
            return 0.0;
        }
        for (int i = 1; i < nCount; ++i) {
            double step = function.get(0, i) - function.get(0, i - 1);
            double val1 = function.get(1, i - 1);
            double val2 = function.get(1, i);
            integral1 += step * val1;
            integral2 += step * val2;
        }
        return 0.5 * (integral1 + integral2);
    }

    public static DataSet integrateFunction(DataSet function) {
        return DataSetMath.integrateFunction(function, Double.NaN, Double.NaN);
    }

    public static DataSet integrateFunction(DataSet function, double xMin, double xMax) {
        double ep1;
        double en1;
        double step;
        double val2;
        double x1;
        double val1;
        int nLength = function.getDataCount();
        String functionName = function.getName();
        String newName = "\u222b(" + functionName + ")dyn";
        if (nLength <= 0) {
            if (function instanceof DataSet2D) {
                int ncount = function.getDataCount();
                double[] emptyVector = new double[ncount];
                return new DoubleErrorDataSet(functionName, DataSetMath.values(0, function), emptyVector, emptyVector, emptyVector, ncount, true);
            }
            throw new IllegalStateException("not yet implemented -- not a DataSet2D");
        }
        if (!function.getAxisDescription(0).isDefined()) {
            function.recomputeLimits(0);
        }
        double xMinLocal = function.getAxisDescription(0).getMin();
        double xMaxLocal = function.getAxisDescription(0).getMax();
        double sign = 1.0;
        if (Double.isFinite(xMin) && Double.isFinite(xMax)) {
            xMinLocal = Math.min(xMin, xMax);
            xMaxLocal = Math.max(xMin, xMax);
            if (xMin > xMax) {
                sign = -1.0;
            }
            newName = "\u222b(" + functionName + ")dyn|_{" + xMinLocal + "}^{" + xMaxLocal + "}";
        } else if (Double.isFinite(xMin)) {
            xMinLocal = xMin;
            newName = "\u222b(" + functionName + ")dyn|_{" + xMinLocal + "}^{+\u221e}";
        } else if (Double.isFinite(xMax)) {
            xMaxLocal = xMax;
            newName = "\u222b(" + functionName + ")dyn|_{-\u221e}^{" + xMaxLocal + "}";
        }
        DoubleErrorDataSet retFunction = new DoubleErrorDataSet(newName, nLength);
        if (nLength <= 1) {
            retFunction.add(function.get(0, 0), 0.0, 0.0, 0.0);
            return retFunction;
        }
        double integral = 0.0;
        double integralEN = 0.0;
        double integralEP = 0.0;
        if (Double.isFinite(xMin) && xMin <= function.get(0, 0)) {
            double x0 = xMin;
            val1 = function.getValue(0, xMin);
            x1 = function.get(0, 0);
            val2 = function.get(1, 0);
            step = x1 - x0;
            en1 = DataSetMath.error(function, ErrType.EYN, 0);
            ep1 = DataSetMath.error(function, ErrType.EYP, 0);
            integralEN = Math.hypot(integralEN, step * en1);
            integralEP = Math.hypot(integralEP, step * ep1);
            retFunction.add(x0, integral += sign * 0.5 * step * (val1 + val2), 0.0, 0.0);
        }
        retFunction.add(function.get(0, 0), integral, integralEN, integralEP);
        for (int i = 1; i < nLength; ++i) {
            double x0 = function.get(0, i - 1);
            double x12 = function.get(0, i);
            double step2 = x12 - x0;
            double y0 = function.get(1, i - 1);
            double en12 = DataSetMath.error(function, ErrType.EYN, i - 1);
            double ep12 = DataSetMath.error(function, ErrType.EYP, i - 1);
            double y1 = function.get(1, i);
            double en2 = DataSetMath.error(function, ErrType.EYN, i);
            double ep2 = DataSetMath.error(function, ErrType.EYP, i);
            if (x0 >= xMinLocal && x12 <= xMaxLocal) {
                integral += sign * 0.5 * step2 * (y0 + y1);
                integralEN = Math.hypot(integralEN, 0.5 * step2 * (en12 + en2));
                integralEP = Math.hypot(integralEP, 0.5 * step2 * (ep12 + ep2));
            } else if (!(x12 < xMinLocal) || !(x0 < xMinLocal)) {
                if (x0 < xMinLocal && x12 > xMinLocal) {
                    retFunction.add(xMin, integral, integralEN, integralEP);
                    step2 = x12 - xMinLocal;
                    integral += sign * 0.5 * step2 * (function.getValue(0, xMinLocal) + y1);
                    integralEN = Math.hypot(integralEN, 0.5 * step2 * (en12 + en2));
                    integralEP = Math.hypot(integralEP, 0.5 * step2 * (ep12 + ep2));
                } else if (x0 < xMaxLocal && x12 > xMaxLocal) {
                    step2 = xMaxLocal - x0;
                    double yAtMax = function.getValue(0, xMaxLocal);
                    integralEN = Math.hypot(integralEN, 0.5 * step2 * (en12 + en2));
                    integralEP = Math.hypot(integralEP, 0.5 * step2 * (ep12 + ep2));
                    retFunction.add(xMaxLocal, integral += sign * 0.5 * step2 * (y0 + yAtMax), integralEN, integralEP);
                }
            }
            retFunction.add(x12, integral, integralEN, integralEP);
        }
        if (Double.isFinite(xMax) && xMax > function.get(0, nLength - 1)) {
            double x0 = function.get(0, nLength - 1);
            val1 = function.get(1, 0);
            x1 = xMax;
            val2 = function.getValue(0, xMax);
            step = x1 - x0;
            en1 = DataSetMath.error(function, ErrType.EYN, nLength - 1);
            ep1 = DataSetMath.error(function, ErrType.EYP, nLength - 1);
            integralEN = Math.hypot(integralEN, step * en1);
            integralEP = Math.hypot(integralEP, step * ep1);
            retFunction.add(xMax, integral += 0.5 * step * (val1 + val2), integralEN, integralEP);
        }
        return retFunction;
    }

    public static DataSet log10Function(DataSet function) {
        return DataSetMath.mathFunction(function, 0.0, MathOp.LOG10);
    }

    public static DataSet log10Function(DataSet function1, DataSet function2) {
        return DataSetMath.mathFunction(function1, function2, MathOp.LOG10);
    }

    public static DataSet lowPassFilterFunction(DataSet function, double width) {
        return DataSetMath.filterFunction(function, width, Filter.MEAN);
    }

    public static DataSet magnitudeSpectrum(DataSet function) {
        return DataSetMath.magnitudeSpectrum(function, Apodization.Hann, false, false);
    }

    public static DataSet magnitudeSpectrum(DataSet function, Apodization apodization, boolean dbScale, boolean normalisedFrequency) {
        int n = function.getDataCount();
        DoubleFFT_1D fastFourierTrafo = new DoubleFFT_1D(n);
        double[] fftSpectra = new double[n];
        for (int i = 0; i < n; ++i) {
            double window = apodization.getIndex(i, n);
            fftSpectra[i] = function.get(1, i) * window;
        }
        fastFourierTrafo.realForward(fftSpectra);
        double[] mag = dbScale ? SpectrumTools.computeMagnitudeSpectrum_dB(fftSpectra, true) : SpectrumTools.computeMagnitudeSpectrum(fftSpectra, true);
        double dt = function.get(0, function.getDataCount() - 1) - function.get(0, 0);
        double fsampling = normalisedFrequency || dt <= 0.0 ? 0.5 / (double)mag.length : 1.0 / dt;
        String functionName = "Mag" + (dbScale ? "[dB]" : "") + "(" + function.getName() + ")";
        DoubleErrorDataSet ret = new DoubleErrorDataSet(functionName, mag.length);
        for (int i = 0; i < mag.length; ++i) {
            ret.add((double)i * fsampling, mag[i], 0.0, 0.0);
        }
        return ret;
    }

    public static DataSet magnitudeSpectrumDecibel(DataSet function) {
        return DataSetMath.magnitudeSpectrum(function, Apodization.Hann, true, false);
    }

    public static DataSet mathFunction(DataSet function1, DataSet function2, MathOp op) {
        DoubleErrorDataSet ret = new DoubleErrorDataSet(function1.getName() + op.getTag() + function2.getName(), function1.getDataCount());
        for (int i = 0; i < function1.getDataCount(); ++i) {
            double nEYP;
            double nEYN;
            double newY;
            double X2;
            double X1 = function1.get(0, i);
            boolean inter = X1 != (X2 = function1.get(0, i));
            double Y1 = function1.get(1, i);
            double Y2 = inter ? function2.get(1, i) : function2.getValue(1, X1);
            double eyn1 = DataSetMath.error(function1, ErrType.EYN, i);
            double eyp1 = DataSetMath.error(function1, ErrType.EYP, i);
            double eyn2 = DataSetMath.error(function2, ErrType.EYN, i, X1, inter);
            double eyp2 = DataSetMath.error(function2, ErrType.EYP, i, X1, inter);
            switch (op) {
                case ADD: {
                    newY = Y1 + Y2;
                    nEYN = Math.hypot(eyn1, eyn2);
                    nEYP = Math.hypot(eyp1, eyp2);
                    break;
                }
                case SUBTRACT: {
                    newY = Y1 - Y2;
                    nEYN = Math.hypot(eyn1, eyn2);
                    nEYP = Math.hypot(eyp1, eyp2);
                    break;
                }
                case MULTIPLY: {
                    newY = Y1 * Y2;
                    nEYN = Math.hypot(Y2 * eyn1, Y1 * eyn2);
                    nEYP = Math.hypot(Y2 * eyp1, Y1 * eyp2);
                    break;
                }
                case DIVIDE: {
                    newY = Y1 / Y2;
                    nEYN = Math.hypot(eyn1 / Y2, newY * eyn2 / Y2);
                    nEYP = Math.hypot(eyp1 / Y2, newY * eyp2 / Y2);
                    break;
                }
                case SQR: {
                    newY = TMathConstants.Sqr(Y1 + Y2);
                    nEYN = 2.0 * Math.abs(Y1 + Y2) * Math.hypot(eyn1, eyn2);
                    nEYP = 2.0 * Math.abs(Y1 + Y2) * Math.hypot(eyp1, eyp2);
                    break;
                }
                case SQRT: {
                    newY = TMathConstants.Sqrt(Y1 + Y2);
                    nEYN = Math.sqrt(Math.abs(Y1 + Y2)) * Math.hypot(eyn1, eyn2);
                    nEYP = Math.sqrt(Math.abs(Y1 + Y2)) * Math.hypot(eyp1, eyp2);
                    break;
                }
                case LOG10: {
                    double norm = 1.0 / Math.log(10.0);
                    newY = TMathConstants.Log10(Y1 + Y2);
                    nEYN = Y1 + Y2 > 0.0 ? norm / Math.abs(Y1 + Y2) * Math.hypot(eyn1, eyn2) : Double.NaN;
                    nEYP = Y1 + Y2 > 0.0 ? norm / Math.abs(Y1 + Y2) * Math.hypot(eyp1, eyp2) : Double.NaN;
                    break;
                }
                case DB: {
                    double norm = 20.0 / Math.log(10.0);
                    newY = 20.0 * TMathConstants.Log10(Y1 + Y2);
                    nEYN = Y1 + Y2 > 0.0 ? norm / Math.abs(Y1 + Y2) * Math.hypot(eyn1, eyn2) : Double.NaN;
                    nEYP = Y1 + Y2 > 0.0 ? norm / Math.abs(Y1 + Y2) * Math.hypot(eyp1, eyp2) : Double.NaN;
                    break;
                }
                default: {
                    newY = Y1;
                    nEYN = eyn1;
                    nEYP = eyp1;
                }
            }
            ret.add(X1, newY, nEYN, nEYP);
        }
        return ret;
    }

    public static DataSet mathFunction(DataSet function, double value, MathOp op) {
        String functionName = op.getTag() + "(" + function.getName() + ")";
        double[] y = DataSetMath.values(1, function);
        double[] eyn = DataSetMath.errors(function, ErrType.EYN);
        double[] eyp = DataSetMath.errors(function, ErrType.EYP);
        int ncount = function.getDataCount();
        switch (op) {
            case ADD: {
                return new DoubleErrorDataSet(functionName, DataSetMath.values(0, function), ArrayMath.add(y, value), eyn, eyp, ncount, true);
            }
            case SUBTRACT: {
                return new DoubleErrorDataSet(functionName, DataSetMath.values(0, function), ArrayMath.subtract(y, value), eyn, eyp, ncount, true);
            }
            case MULTIPLY: {
                return new DoubleErrorDataSet(functionName, DataSetMath.values(0, function), ArrayMath.multiply(y, value), ArrayMath.multiply(eyn, value), ArrayMath.multiply(eyp, value), ncount, true);
            }
            case DIVIDE: {
                return new DoubleErrorDataSet(functionName, DataSetMath.values(0, function), ArrayMath.divide(y, value), ArrayMath.divide(eyn, value), ArrayMath.divide(eyp, value), ncount, true);
            }
            case SQR: {
                for (int i = 0; i < eyn.length; ++i) {
                    eyn[i] = 2.0 * Math.abs(y[i]) * eyn[i];
                    eyp[i] = 2.0 * Math.abs(y[i]) * eyp[i];
                }
                return new DoubleErrorDataSet(functionName, DataSetMath.values(0, function), ArrayMath.sqr(y), eyn, eyp, ncount, true);
            }
            case SQRT: {
                for (int i = 0; i < eyn.length; ++i) {
                    eyn[i] = Math.sqrt(Math.abs(y[i])) * eyn[i];
                    eyp[i] = Math.sqrt(Math.abs(y[i])) * eyp[i];
                }
                return new DoubleErrorDataSet(functionName, DataSetMath.values(0, function), ArrayMath.sqrt(y), eyn, eyp, ncount, true);
            }
            case LOG10: {
                double norm = 1.0 / Math.log(10.0);
                for (int i = 0; i < eyn.length; ++i) {
                    eyn[i] = y[i] > 0.0 ? norm / Math.abs(y[i]) * eyn[i] : Double.NaN;
                    eyp[i] = y[i] > 0.0 ? norm / Math.abs(y[i]) * eyp[i] : Double.NaN;
                }
                return new DoubleErrorDataSet(functionName, DataSetMath.values(0, function), ArrayMath.tenLog10(y), eyn, eyp, ncount, true);
            }
            case DB: {
                double norm = 20.0 / Math.log(10.0);
                for (int i = 0; i < eyn.length; ++i) {
                    eyn[i] = y[i] > 0.0 ? norm / Math.abs(y[i]) * eyn[i] : Double.NaN;
                    eyp[i] = y[i] > 0.0 ? norm / Math.abs(y[i]) * eyp[i] : Double.NaN;
                }
                return new DoubleErrorDataSet(functionName, DataSetMath.values(0, function), ArrayMath.decibel(y), eyn, eyp, ncount, true);
            }
        }
        return new DoubleErrorDataSet(functionName, DataSetMath.values(0, function), DataSetMath.values(1, function), DataSetMath.errors(function, ErrType.EYN), DataSetMath.errors(function, ErrType.EYP), ncount, true);
    }

    public static DataSet maxFilteredFunction(DataSet function, double width) {
        return DataSetMath.filterFunction(function, width, Filter.MAX);
    }

    public static DataSet medianFilteredFunction(DataSet function, double width) {
        return DataSetMath.filterFunction(function, width, Filter.MEDIAN);
    }

    public static DataSet minFilteredFunction(DataSet function, double width) {
        return DataSetMath.filterFunction(function, width, Filter.MIN);
    }

    public static DataSet multiplyFunction(DataSet function1, DataSet function2) {
        return DataSetMath.mathFunction(function1, function2, MathOp.MULTIPLY);
    }

    public static DataSet multiplyFunction(DataSet function, double value) {
        return DataSetMath.mathFunction(function, value, MathOp.MULTIPLY);
    }

    public static DataSet normalisedFunction(DataSet function) {
        return DataSetMath.normalisedFunction(function, 1.0);
    }

    public static DataSet normalisedFunction(DataSet function, double requiredIntegral) {
        DoublePointError complexInt = DataSetMath.integral(function);
        double integral = complexInt.getY() / requiredIntegral;
        int ncount = function.getDataCount();
        if (integral == 0.0) {
            return new DoubleErrorDataSet(function.getName(), DataSetMath.values(0, function), new double[ncount], new double[ncount], new double[ncount], ncount, true);
        }
        double[] xValues = DataSetMath.values(0, function);
        double[] yValues = ArrayMath.divide(DataSetMath.values(1, function), integral);
        double[] eyp = ArrayMath.divide(DataSetMath.errors(function, ErrType.EYN), integral);
        double[] eyn = ArrayMath.divide(DataSetMath.errors(function, ErrType.EYP), integral);
        return new DoubleErrorDataSet(function.getName(), xValues, yValues, eyp, eyn, ncount, true);
    }

    public static DataSet normalisedMagnitudeSpectrumDecibel(DataSet function) {
        return DataSetMath.magnitudeSpectrum(function, Apodization.Hann, true, true);
    }

    public static DataSet peakToPeakFilteredFunction(DataSet function, double width) {
        return DataSetMath.filterFunction(function, width, Filter.P2P);
    }

    public static DataSet rmsFilteredFunction(DataSet function, double width) {
        return DataSetMath.filterFunction(function, width, Filter.RMS);
    }

    public static EditableDataSet setFunction(EditableDataSet function, double value, double xMin, double xMax) {
        int nLength = function.getDataCount();
        double xMinLocal = function.get(0, 0);
        double xMaxLocal = function.get(0, nLength - 1);
        if (Double.isFinite(xMin) && Double.isFinite(xMax)) {
            xMinLocal = Math.min(xMin, xMax);
            xMaxLocal = Math.max(xMin, xMax);
        } else if (Double.isFinite(xMin)) {
            xMinLocal = xMin;
        } else if (Double.isFinite(xMax)) {
            xMaxLocal = xMax;
        }
        boolean oldState = function.autoNotification().getAndSet(false);
        for (int i = 0; i < nLength; ++i) {
            double x = function.get(0, i);
            if (!(x >= xMinLocal) || !(x <= xMaxLocal)) continue;
            function.set(i, new double[]{x, value});
        }
        function.autoNotification().set(oldState);
        return function;
    }

    public static DataSet sqrFunction(DataSet function) {
        return DataSetMath.mathFunction(function, 0.0, MathOp.SQR);
    }

    public static DataSet sqrFunction(DataSet function1, DataSet function2) {
        return DataSetMath.mathFunction(function1, function2, MathOp.SQR);
    }

    public static DataSet sqrtFunction(DataSet function) {
        return DataSetMath.mathFunction(function, 0.0, MathOp.SQRT);
    }

    public static DataSet sqrtFunction(DataSet function1, DataSet function2) {
        return DataSetMath.mathFunction(function1, function2, MathOp.SQRT);
    }

    public static DataSet subtractFunction(DataSet function1, DataSet function2) {
        return DataSetMath.mathFunction(function1, function2, MathOp.SUBTRACT);
    }

    public static DataSet subtractFunction(DataSet function, double value) {
        return DataSetMath.mathFunction(function, value, MathOp.SUBTRACT);
    }

    public static final double[] values(int dimIndex, DataSet dataSet) {
        if (dataSet instanceof DoubleDataSet) {
            return ((DoubleDataSet)dataSet).getValues(dimIndex);
        }
        if (dataSet instanceof DoubleErrorDataSet) {
            return ((DoubleErrorDataSet)dataSet).getValues(dimIndex);
        }
        if (dataSet instanceof DataSet2D) {
            return ((DataSet2D)dataSet).getValues(dimIndex);
        }
        return (double[])dataSet.lock().readLockGuard(() -> {
            int count = dataSet.getDataCount(dimIndex);
            double[] retValues = new double[count];
            for (int index = 0; index < count; ++index) {
                retValues[index] = dataSet.get(dimIndex, index);
            }
            return retValues;
        });
    }

    public static enum MathOp {
        ADD("+"),
        SUBTRACT("-"),
        MULTIPLY("*"),
        DIVIDE("*"),
        SQR("SQR"),
        SQRT("SQRT"),
        LOG10("Log10"),
        DB("dB");

        private String tag;

        private MathOp(String tag) {
            this.tag = tag;
        }

        String getTag() {
            return this.tag;
        }
    }

    public static enum Filter {
        MEAN("LowPass"),
        MEDIAN("Median"),
        MIN("Min"),
        MAX("Max"),
        P2P("PeakToPeak"),
        RMS("RMS"),
        GEOMMEAN("GeometricMean");

        private String tag;

        private Filter(String tag) {
            this.tag = tag;
        }

        String getTag() {
            return this.tag;
        }
    }

    public static enum ErrType {
        EXN,
        EXP,
        EYN,
        EYP;

    }
}

