/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math;

import de.gsi.dataset.utils.AssertUtils;

public final class ArrayUtils {
    private static final String ARRAY = "array";

    private ArrayUtils() {
    }

    public static double[] convertToDouble(float[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public static double[] convertToDouble(float[] array, double scale) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = (double)array[i] * scale;
        }
        return a;
    }

    public static double[] convertToDouble(int[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public static double[] convertToDouble(int[] array, double scale) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = (double)array[i] * scale;
        }
        return a;
    }

    public static double[] convertToDouble(long[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public static double[] convertToDouble(long[] array, double scale) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = (double)array[i] * scale;
        }
        return a;
    }

    public static double[] convertToDouble(short[] array) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    public static double[] convertToDouble(short[] array, double scale) {
        double[] a = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            a[i] = (double)array[i] * scale;
        }
        return a;
    }

    public static double[] createArray(double offset, double scale, int size) {
        double[] a = new double[size];
        for (int i = 0; i < size; ++i) {
            a[i] = (double)i * scale + offset;
        }
        return a;
    }

    public static void fillArray(boolean[] array, boolean value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void fillArray(byte[] array, byte value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void fillArray(double[] array, double value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        ArrayUtils.fillArray(array, 0, len, value);
    }

    public static void fillArray(double[] array, int indexStart, int indexStop, double value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = indexStop - indexStart;
        if (len > 0) {
            array[indexStart] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, indexStart, array, i, len - i < i ? len - i : i);
        }
    }

    public static void fillArray(int[] array, int value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static void fillArray(long[] array, long value) {
        AssertUtils.notNull((String)ARRAY, (Object)array);
        int len = array.length;
        if (len > 0) {
            array[0] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, 0, array, i, len - i < i ? len - i : i);
        }
    }

    public static <T> void fillArray(T[] array, int indexStart, int indexStop, T value) {
        AssertUtils.notNull((String)ARRAY, array);
        int len = indexStop - indexStart;
        if (len > 0) {
            array[indexStart] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, indexStart, array, i, len - i < i ? len - i : i);
        }
    }

    public static <T> void fillArray(T[] array, T value) {
        AssertUtils.notNull((String)ARRAY, array);
        int len = array.length;
        ArrayUtils.fillArray(array, 0, len, value);
    }
}

