/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.testdata.spi;

import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.testdata.TestDataSet;

public abstract class AbstractTestFunction<D extends AbstractTestFunction<D>>
extends AbstractErrorDataSet<D>
implements DataSet2D,
TestDataSet<D> {
    private static final long serialVersionUID = 3145097895719258628L;
    private double[] data;

    public AbstractTestFunction(String name, int count) {
        super(name, 2, DataSetError.ErrorType.SYMMETRIC, DataSetError.ErrorType.SYMMETRIC);
        this.data = this.generateY(count);
    }

    @Override
    public double[] generateX(int count) {
        double[] retVal = new double[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = i;
        }
        return retVal;
    }

    @Override
    public double get(int dimIndex, int index) {
        return dimIndex == 0 ? (double)index : this.data[index];
    }

    @Override
    public int getDataCount(int dimIndex) {
        return this.data.length;
    }

    @Override
    public final double getErrorNegative(int dimIndex, int index) {
        return dimIndex == 0 ? AbstractTestFunction.getXError() : AbstractTestFunction.getYError();
    }

    @Override
    public final double getErrorPositive(int dimIndex, int index) {
        return dimIndex == 0 ? AbstractTestFunction.getXError() : AbstractTestFunction.getYError();
    }

    @Override
    public DataSetError.ErrorType getErrorType(int dimIndex) {
        switch (dimIndex) {
            case 0: 
            case 1: {
                return DataSetError.ErrorType.SYMMETRIC;
            }
        }
        throw new IndexOutOfBoundsException("DataSet only has 2 dimensions");
    }

    @Override
    public final String getStyle(int index) {
        return null;
    }

    @Override
    public double getX(int index) {
        return index;
    }

    @Override
    public double getY(int index) {
        if (index < 0 || index >= this.getDataCount()) {
            return Double.NaN;
        }
        return this.data[index];
    }

    @Override
    public D update() {
        this.lock().writeLockGuard(() -> {
            this.data = this.generateY(this.data.length);
            this.recomputeLimits(0);
            this.recomputeLimits(1);
        });
        return (D)((AbstractTestFunction)this.fireInvalidated(new UpdatedDataEvent(this)));
    }

    private static double getXError() {
        return 0.1;
    }

    private static double getYError() {
        return 0.1;
    }
}

