/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

public class MathUtils {
    public static boolean nearlyEqual(double a, double b) {
        return MathUtils.nearlyEqual(a, b, 1.0E-14);
    }

    public static boolean nearlyEqual(double a, double b, double epsilon) {
        double absA = Math.abs(a);
        double absB = Math.abs(b);
        double diff = Math.abs(a - b);
        if (a == b) {
            return true;
        }
        if (a == 0.0 || b == 0.0 || absA + absB < Double.MIN_NORMAL) {
            return diff < epsilon * Double.MIN_NORMAL;
        }
        return diff / Math.min(absA + absB, Double.MAX_VALUE) < epsilon;
    }

    public static boolean nearlyEqual(float a, float b) {
        return MathUtils.nearlyEqual(a, b, 1.0E-5f);
    }

    public static boolean nearlyEqual(float a, float b, float epsilon) {
        float absA = Math.abs(a);
        float absB = Math.abs(b);
        float diff = Math.abs(a - b);
        if (a == b) {
            return true;
        }
        if (a == 0.0f || b == 0.0f || absA + absB < Float.MIN_NORMAL) {
            return diff < epsilon * Float.MIN_NORMAL;
        }
        return diff / Math.min(absA + absB, Float.MAX_VALUE) < epsilon;
    }

    public static double relativeEpsilon(double a, double b) {
        return Math.max(Math.ulp(a), Math.ulp(b));
    }

    public static float relativeEpsilon(float a, float b) {
        return Math.max(Math.ulp(a), Math.ulp(b));
    }
}

