/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.spi.utils.DoublePointError;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Deprecated
public class ListErrorDataSet
extends AbstractErrorDataSet<ListErrorDataSet>
implements DataSet2D,
DataSetError {
    private static final long serialVersionUID = -7853762711615967319L;
    protected Map<Integer, String> dataLabels = new ConcurrentHashMap<Integer, String>();
    protected Map<Integer, String> dataStyles = new ConcurrentHashMap<Integer, String>();
    protected ArrayList<DoublePointError> data = new ArrayList();

    public ListErrorDataSet(String name) {
        super(name, 2, DataSetError.ErrorType.SYMMETRIC, DataSetError.ErrorType.SYMMETRIC);
    }

    public ListErrorDataSet(String name, double[] yValues) {
        this(name);
        AssertUtils.notNull("Y data", yValues);
        for (int i = 0; i < yValues.length; ++i) {
            this.data.add(new DoublePointError(i, yValues[i], 0.0, 0.0));
        }
    }

    public ListErrorDataSet(String name, double[] xValues, double[] yValues) {
        this(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        for (int i = 0; i < yValues.length; ++i) {
            this.data.add(new DoublePointError(xValues[i], yValues[i], 0.0, 0.0));
        }
    }

    public ListErrorDataSet(String name, double[] xValues, double[] yValues, double[] yErrors) {
        this(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("Y error data", yErrors);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        AssertUtils.equalDoubleArrays(xValues, yErrors);
        for (int i = 0; i < yValues.length; ++i) {
            this.data.add(new DoublePointError(xValues[i], yValues[i], 0.0, yErrors[i]));
        }
    }

    public ListErrorDataSet(String name, double[] xValues, double[] yValues, double[] xErrors, double[] yErrors) {
        super(name, 2, DataSetError.ErrorType.SYMMETRIC, DataSetError.ErrorType.SYMMETRIC);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("X error data", xErrors);
        AssertUtils.notNull("Y error data", yErrors);
        AssertUtils.equalDoubleArrays(xValues, yValues);
        AssertUtils.equalDoubleArrays(xValues, xErrors);
        AssertUtils.equalDoubleArrays(xValues, yErrors);
        for (int i = 0; i < yValues.length; ++i) {
            this.data.add(new DoublePointError(xValues[i], yValues[i], xErrors[i], yErrors[i]));
        }
    }

    public ListErrorDataSet add(double x, double y) {
        return this.add(x, y, 0.0, 0.0);
    }

    public ListErrorDataSet add(double x, double y, double ex, double ey) {
        this.lock().writeLockGuard(() -> {
            this.data.add(new DoublePointError(x, y, ex, ey));
            this.getAxisDescription(0).add(x - ex);
            this.getAxisDescription(0).add(x + ex);
            this.getAxisDescription(1).add(y - ey);
            this.getAxisDescription(1).add(y + ey);
        });
        return (ListErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    public ListErrorDataSet add(double[] xValues, double[] yValues) {
        return this.add(xValues, yValues, new double[yValues.length], new double[yValues.length]);
    }

    public ListErrorDataSet add(double[] xValues, double[] yValues, double[] xErrors, double[] yErrors) {
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("X error data", xErrors);
        AssertUtils.notNull("Y data", yValues);
        AssertUtils.notNull("Y error data", yValues);
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < xValues.length; ++i) {
                double x = xValues[i];
                double y = yValues[i];
                double ex = xErrors[i];
                double ey = yErrors[i];
                this.data.add(new DoublePointError(x, y, ex, ey));
                this.getAxisDescription(0).add(x - ex);
                this.getAxisDescription(0).add(x + ex);
                this.getAxisDescription(1).add(y - ey);
                this.getAxisDescription(1).add(y + ey);
            }
        });
        return (ListErrorDataSet)this.fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public String addDataLabel(int index, String label) {
        String retVal = this.lock().writeLockGuard(() -> this.dataLabels.put(index, label));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added label"));
        return retVal;
    }

    @Override
    public String addDataStyle(int index, String style) {
        String retVal = this.lock().writeLockGuard(() -> this.dataStyles.put(index, style));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added style"));
        return retVal;
    }

    public ListErrorDataSet clearData() {
        this.lock().writeLockGuard(() -> {
            this.data.clear();
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (ListErrorDataSet)this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    public List<DoublePointError> getData() {
        return this.data;
    }

    @Override
    public int getDataCount(int dimIndex) {
        return this.data.size();
    }

    @Override
    public String getDataLabel(int index) {
        String dataLabel = this.lock().readLockGuard(() -> this.dataLabels.get(index));
        if (dataLabel != null) {
            return dataLabel;
        }
        return this.lock().readLockGuard(() -> super.getDataLabel(index));
    }

    @Override
    public double getErrorNegative(int dimIndex, int index) {
        return dimIndex == 0 ? this.data.get(index).getErrorX() : this.data.get(index).getErrorY();
    }

    @Override
    public double getErrorPositive(int dimIndex, int index) {
        return dimIndex == 0 ? this.data.get(index).getErrorX() : this.data.get(index).getErrorY();
    }

    @Override
    public String getStyle(int index) {
        return this.lock().readLockGuard(() -> this.dataStyles.get(index));
    }

    @Override
    public double get(int dimIndex, int i) {
        return dimIndex == 0 ? this.data.get(i).getX() : this.data.get(i).getY();
    }

    public ListErrorDataSet remove(int fromIndex, int toIndex) {
        this.lock().writeLockGuard(() -> {
            AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
            AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
            AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
            this.data.subList(fromIndex, toIndex).clear();
            this.getAxisDescription(0).add(Double.NaN);
            this.getAxisDescription(1).add(Double.NaN);
        });
        return (ListErrorDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    public ListErrorDataSet remove(int[] indices) {
        AssertUtils.notNull("Indices array", indices);
        if (indices.length == 0) {
            return (ListErrorDataSet)this.getThis();
        }
        this.lock().writeLockGuard(() -> {
            ArrayList<DoublePointError> tupleTobeRemovedReferences = new ArrayList<DoublePointError>();
            for (int indexToRemove : indices) {
                tupleTobeRemovedReferences.add(this.data.get(indexToRemove));
            }
            this.data.removeAll(tupleTobeRemovedReferences);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        return (ListErrorDataSet)this.fireInvalidated(new RemovedDataEvent(this));
    }

    @Override
    public String removeDataLabel(int index) {
        String retVal = this.lock().writeLockGuard(() -> this.dataLabels.remove(index));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed label"));
        return retVal;
    }

    @Override
    public String removeStyle(int index) {
        String retVal = this.lock().writeLockGuard(() -> this.dataStyles.remove(index));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed style"));
        return retVal;
    }

    public ListErrorDataSet set(double[] xValues, double[] yValues) {
        int ndim = xValues.length;
        return this.set(xValues, yValues, new double[ndim], new double[ndim], ndim);
    }

    public ListErrorDataSet set(double[] xValues, double[] yValues, double[] xErrors, double[] yErrors, int count) {
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        if (xValues.length < count || yValues.length < count || xErrors.length < count || yErrors.length < count) {
            throw new IllegalArgumentException("Arrays with coordinates must have length >= count!");
        }
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < xValues.length; ++i) {
                double x = xValues[i];
                double y = yValues[i];
                double dx = xErrors[i];
                double dy = yValues[i];
                this.getAxisDescription(0).add(x - dx);
                this.getAxisDescription(0).add(x + dx);
                this.getAxisDescription(1).add(y - dy);
                this.getAxisDescription(1).add(y + dy);
                this.data.add(new DoublePointError(x, y, dx, dy));
            }
        });
        return (ListErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public ListErrorDataSet set(double[] xValues, double[] yValues, double[] yErrors, int count) {
        return this.set(xValues, yValues, new double[count], yErrors, count);
    }

    public ListErrorDataSet set(double[] xValues, double[] yValues, int count) {
        return this.set(xValues, yValues, new double[count], new double[count], count);
    }

    public ListErrorDataSet set(int index, double x, double y) {
        return this.set(index, x, y, 0.0, 0.0);
    }

    public ListErrorDataSet set(int index, double x, double y, double dx, double dy) {
        this.lock().writeLockGuard(() -> {
            this.data.get(index).set(x, y, dy, dy);
            this.getAxisDescription(0).add(x - dx);
            this.getAxisDescription(0).add(x + dx);
            this.getAxisDescription(1).add(y - dy);
            this.getAxisDescription(1).add(y + dy);
        });
        return (ListErrorDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }
}

