/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DoubleDataSet;
import java.util.ArrayDeque;

public class AveragingDataSet
extends AbstractDataSet<AveragingDataSet>
implements DataSet2D {
    private static final long serialVersionUID = 1L;
    private int averageSize = 1;
    private int fuzzyCount = 0;
    private InternalDataSet dataset;
    private final ArrayDeque<DataSet2D> deque = new ArrayDeque();

    public AveragingDataSet(String name) {
        super(name, 2);
    }

    public AveragingDataSet(String name, int fuzzyCount) {
        super(name, 2);
        this.fuzzyCount = fuzzyCount;
    }

    public void add(DataSet2D ds) {
        if (this.averageSize == 1) {
            this.dataset = new InternalDataSet(ds);
        } else if (this.dataset == null || this.deque.isEmpty()) {
            this.dataset = new InternalDataSet(ds);
            this.deque.clear();
            this.deque.add(new InternalDataSet(ds));
        } else if (this.deque.size() < this.averageSize) {
            this.dataset.opScale(this.deque.size());
            this.dataset.opAdd(ds);
            this.deque.add(new InternalDataSet(ds));
            this.dataset.opScale(1.0 / (double)this.deque.size());
        } else {
            this.dataset.opScale(this.deque.size());
            this.dataset.opSub(this.deque.pop());
            this.dataset.opAdd(ds);
            this.deque.add(new InternalDataSet(ds));
            this.dataset.opScale(1.0 / (double)this.deque.size());
        }
        this.dataset.recomputeLimits(0);
        this.dataset.recomputeLimits(1);
        this.fireInvalidated(new AddedDataEvent(this));
    }

    public void clear() {
        this.deque.clear();
        this.dataset = null;
    }

    public int getAverageCount() {
        if (this.averageSize == 1) {
            return this.dataset == null ? 0 : 1;
        }
        return this.deque.size();
    }

    public int getAverageSize() {
        return this.averageSize;
    }

    @Override
    public int getDataCount(int dimIndex) {
        if (this.dataset == null) {
            return 0;
        }
        return this.dataset.getDataCount(dimIndex);
    }

    public int getFuzzyCount() {
        return this.fuzzyCount;
    }

    @Override
    public String getStyle(int index) {
        if (this.dataset == null) {
            return "";
        }
        return this.dataset.getStyle(index);
    }

    @Override
    public final double get(int dimIndex, int index) {
        if (this.dataset == null) {
            return Double.NaN;
        }
        return dimIndex == 0 ? this.dataset.getX(index) : this.dataset.getY(index);
    }

    @Override
    public int getXIndex(double x) {
        if (this.dataset == null) {
            return 0;
        }
        return this.dataset.getXIndex(x);
    }

    @Override
    public double[] getYValues() {
        if (this.dataset == null) {
            return new double[0];
        }
        return this.dataset.getYValues();
    }

    public void setAverageSize(int avgCount) {
        if (avgCount < 1) {
            return;
        }
        if (this.averageSize != avgCount) {
            this.deque.clear();
            this.dataset = null;
        }
        this.averageSize = avgCount;
    }

    public void setFuzzyCount(int fuzzyCount) {
        this.fuzzyCount = fuzzyCount;
    }

    private class InternalDataSet
    extends DoubleDataSet {
        private static final long serialVersionUID = 1L;

        public InternalDataSet(DataSet2D ds) {
            super(ds.getName(), ds.getValues(0), ds.getValues(1), ds.getDataCount(), true);
        }

        public boolean isCompatible(DataSet2D d) {
            return Math.abs(super.getDataCount() - d.getDataCount()) <= AveragingDataSet.this.fuzzyCount;
        }

        public void opAdd(DataSet2D d) {
            if (!this.isCompatible(d)) {
                throw new IllegalArgumentException("Datasets do not match");
            }
            this.yValues.size(d.getDataCount());
            for (int i = 0; i < this.yValues.size(); ++i) {
                double[] dArray = this.yValues.elements();
                int n = i;
                dArray[n] = dArray[n] + d.getY(i);
            }
        }

        public void opScale(double f) {
            int i = 0;
            while (i < this.yValues.size()) {
                double[] dArray = this.yValues.elements();
                int n = i++;
                dArray[n] = dArray[n] * f;
            }
        }

        public void opSub(DataSet2D d) {
            if (!this.isCompatible(d)) {
                throw new IllegalArgumentException("Datasets do not match");
            }
            this.yValues.size(d.getDataCount());
            for (int i = 0; i < this.yValues.size(); ++i) {
                double[] dArray = this.yValues.elements();
                int n = i;
                dArray[n] = dArray[n] - d.getY(i);
            }
        }
    }
}

