/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi.iobuffer;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.serializer.DataType;
import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.serializer.spi.BinarySerialiser;
import de.gsi.dataset.serializer.spi.FieldHeader;
import de.gsi.dataset.spi.DataSetBuilder;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.DataSetUtilsHelper;
import java.util.Arrays;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetSerialiser
extends DataSetUtilsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetSerialiser.class);
    private static final String DATA_SET_NAME = "dataSetName";
    private static final String Y_ARRAY_NAME = "y";
    private static final String X_ARRAY_NAME = "x";
    private static final String XEN = "xen";
    private static final String XEP = "xep";
    private static final String YEP = "yep";
    private static final String YEN = "yen";
    private static final String AXIS = "axis";
    private static final String NAME = "name";
    private static final String UNIT = "unit";
    private static final String MIN = "Min";
    private static final String MAX = "Max";
    private static final String META_INFO = "metaInfo";
    private static final String ERROR_LIST = "errorList";
    private static final String WARNING_LIST = "warningList";
    private static final String INFO_LIST = "infoList";
    private static final String DATA_STYLES = "dataStyles";
    private static final String DATA_LABELS = "dataLabels";
    private static final String VAL_RMS = "rms";
    private static final String VAL_MEAN = "mean";
    private static final String VAL_INTEGRAL = "integral";
    private static boolean transmitDataLabels = true;
    private static boolean transmitMetaData = true;

    protected DataSetSerialiser() {
    }

    protected static Optional<FieldHeader> checkFieldCompatibility(IoBuffer buffer, List<FieldHeader> fieldHeaderList, String fieldName, DataType ... requireDataTypes) {
        Optional<FieldHeader> fieldHeader = FieldHeader.findHeaderFor(fieldHeaderList, fieldName);
        if (!fieldHeader.isPresent()) {
            return Optional.empty();
        }
        if (fieldHeader.get().getFieldName().equals(fieldName)) {
            boolean foundMatchingDataType = false;
            for (DataType dataType : requireDataTypes) {
                if (!fieldHeader.get().getDataType().equals((Object)dataType)) continue;
                foundMatchingDataType = true;
                break;
            }
            if (!foundMatchingDataType) {
                throw new InputMismatchException(fieldName + " is type " + (Object)((Object)fieldHeader.get().getDataType()) + " vs. required type " + Arrays.asList(requireDataTypes).toString());
            }
            long dataPosition = fieldHeader.get().getDataBufferPosition();
            buffer.position(dataPosition);
            return fieldHeader;
        }
        return Optional.empty();
    }

    public static boolean isDataLablesSerialised() {
        return transmitDataLabels;
    }

    public static boolean isMetaDataSerialised() {
        return transmitMetaData;
    }

    protected static void parseDataLabels(IoBuffer readBuffer, DataSetBuilder builder, List<FieldHeader> fieldHeaderList) {
        ConcurrentHashMap<Integer, String> map;
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, DATA_LABELS, DataType.MAP).isPresent()) {
            map = new ConcurrentHashMap();
            map = BinarySerialiser.getMap(readBuffer, map);
            builder.setDataLabelMap(map);
        }
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, DATA_STYLES, DataType.MAP).isPresent()) {
            map = new ConcurrentHashMap();
            map = BinarySerialiser.getMap(readBuffer, map);
            builder.setDataStyleMap(map);
        }
    }

    protected static void parseHeader(IoBuffer readBuffer, DataSetBuilder builder, List<FieldHeader> fieldHeaderList) {
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, DATA_SET_NAME, DataType.STRING).isPresent()) {
            builder.setName(BinarySerialiser.getString(readBuffer));
        }
        for (FieldHeader fieldHeader : fieldHeaderList) {
            int dimension;
            String[] parsed;
            String fieldName = fieldHeader.getFieldName();
            if (fieldName == null || !fieldName.startsWith(AXIS) || (parsed = fieldName.split("\\.")).length <= 1) continue;
            try {
                dimension = Integer.parseInt(parsed[0].substring(AXIS.length()));
            }
            catch (NumberFormatException e) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)parsed[0]).addArgument((Object)fieldName).log("could not parse sub-string {} of {} for integer");
                continue;
            }
            readBuffer.position(fieldHeader.getDataBufferPosition());
            if (parsed[1].equals(MIN)) {
                builder.setAxisMin(dimension, BinarySerialiser.getDouble(readBuffer));
                continue;
            }
            if (parsed[1].equals(MAX)) {
                builder.setAxisMax(dimension, BinarySerialiser.getDouble(readBuffer));
                continue;
            }
            if (parsed[1].equals(NAME)) {
                builder.setAxisName(dimension, BinarySerialiser.getString(readBuffer));
                continue;
            }
            if (!parsed[1].equals(UNIT)) continue;
            builder.setAxisUnit(dimension, BinarySerialiser.getString(readBuffer));
        }
    }

    protected static void parseMetaData(IoBuffer readBuffer, DataSetBuilder builder, List<FieldHeader> fieldHeaderList) {
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, INFO_LIST, DataType.STRING_ARRAY).isPresent()) {
            builder.setMetaInfoList(BinarySerialiser.getStringArray(readBuffer));
        }
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, WARNING_LIST, DataType.STRING_ARRAY).isPresent()) {
            builder.setMetaWarningList(BinarySerialiser.getStringArray(readBuffer));
        }
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, ERROR_LIST, DataType.STRING_ARRAY).isPresent()) {
            builder.setMetaErrorList(BinarySerialiser.getStringArray(readBuffer));
        }
        if (DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, META_INFO, DataType.MAP).isPresent()) {
            ConcurrentHashMap<String, String> map = new ConcurrentHashMap();
            map = BinarySerialiser.getMap(readBuffer, map);
            builder.setMetaInfoMap(map);
        }
    }

    protected static void parseNumericData(IoBuffer readBuffer, DataSetBuilder builder, List<FieldHeader> fieldHeaderList) {
        Optional<FieldHeader> header = DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, X_ARRAY_NAME, DataType.DOUBLE_ARRAY, DataType.FLOAT_ARRAY);
        if (header.isPresent()) {
            builder.setXValues(BinarySerialiser.getDoubleArray(readBuffer, header.get().getDataType()));
        }
        if ((header = DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, Y_ARRAY_NAME, DataType.DOUBLE_ARRAY, DataType.FLOAT_ARRAY)).isPresent()) {
            builder.setYValues(BinarySerialiser.getDoubleArray(readBuffer, header.get().getDataType()));
        }
        if ((header = DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, XEN, DataType.DOUBLE_ARRAY, DataType.FLOAT_ARRAY)).isPresent()) {
            builder.setXNegErrorNoCopy(BinarySerialiser.getDoubleArray(readBuffer, header.get().getDataType()));
        }
        if ((header = DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, XEP, DataType.DOUBLE_ARRAY, DataType.FLOAT_ARRAY)).isPresent()) {
            builder.setXPosErrorNoCopy(BinarySerialiser.getDoubleArray(readBuffer, header.get().getDataType()));
        }
        if ((header = DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, YEN, DataType.DOUBLE_ARRAY, DataType.FLOAT_ARRAY)).isPresent()) {
            builder.setYNegErrorNoCopy(BinarySerialiser.getDoubleArray(readBuffer, header.get().getDataType()));
        }
        if ((header = DataSetSerialiser.checkFieldCompatibility(readBuffer, fieldHeaderList, YEP, DataType.DOUBLE_ARRAY, DataType.FLOAT_ARRAY)).isPresent()) {
            builder.setYPosErrorNoCopy(BinarySerialiser.getDoubleArray(readBuffer, header.get().getDataType()));
        }
    }

    public static DataSet readDataSetFromByteArray(IoBuffer readBuffer) {
        DataSetBuilder builder = new DataSetBuilder();
        BinarySerialiser.HeaderInfo bufferHeader = BinarySerialiser.checkHeaderInfo(readBuffer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)bufferHeader).log("read header = {}");
        }
        FieldHeader fieldRoot = BinarySerialiser.parseIoStream(readBuffer);
        DataSetSerialiser.parseHeader(readBuffer, builder, fieldRoot.getChildren());
        if (DataSetSerialiser.isMetaDataSerialised()) {
            DataSetSerialiser.parseMetaData(readBuffer, builder, fieldRoot.getChildren());
        }
        if (DataSetSerialiser.isDataLablesSerialised()) {
            DataSetSerialiser.parseDataLabels(readBuffer, builder, fieldRoot.getChildren());
        }
        DataSetSerialiser.parseNumericData(readBuffer, builder, fieldRoot.getChildren());
        return builder.build();
    }

    public static void setDataLablesSerialised(boolean state) {
        transmitDataLabels = state;
    }

    public static void setMetaDataSerialised(boolean state) {
        transmitMetaData = state;
    }

    private static float[] toFloats(double[] input) {
        float[] floatArray = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            floatArray[i] = (float)input[i];
        }
        return floatArray;
    }

    protected static void writeDataLabelsToStream(IoBuffer buffer, DataSet dataSet) {
        int dataCount = dataSet.getDataCount(0);
        ConcurrentHashMap<Integer, String> labelMap = new ConcurrentHashMap<Integer, String>();
        for (int index = 0; index < dataCount; ++index) {
            String label = dataSet.getDataLabel(index);
            if (label == null || label.isEmpty()) continue;
            labelMap.put(index, label);
        }
        if (!labelMap.isEmpty()) {
            BinarySerialiser.put(buffer, DATA_LABELS, labelMap);
        }
        ConcurrentHashMap<Integer, String> styleMap = new ConcurrentHashMap<Integer, String>();
        for (int index = 0; index < dataCount; ++index) {
            String style = dataSet.getStyle(index);
            if (style == null || style.isEmpty()) continue;
            styleMap.put(index, style);
        }
        if (!styleMap.isEmpty()) {
            BinarySerialiser.put(buffer, DATA_STYLES, styleMap);
        }
    }

    public static void writeDataSetToByteArray(DataSet dataSet, IoBuffer buffer, boolean asFloat) {
        AssertUtils.notNull("dataSet", dataSet);
        AssertUtils.notNull("buffer", buffer);
        dataSet.lock();
        BinarySerialiser.putHeaderInfo(buffer);
        DataSetSerialiser.writeHeaderDataToStream(buffer, dataSet);
        if (DataSetSerialiser.isMetaDataSerialised()) {
            DataSetSerialiser.writeMetaDataToStream(buffer, dataSet);
        }
        if (DataSetSerialiser.isDataLablesSerialised()) {
            DataSetSerialiser.writeDataLabelsToStream(buffer, dataSet);
        }
        DataSetSerialiser.writeNumericBinaryDataToBuffer(buffer, dataSet, asFloat);
        BinarySerialiser.putEndMarker(buffer, "OBJ_ROOT_END");
    }

    protected static void writeHeaderDataToStream(IoBuffer buffer, DataSet dataSet) {
        BinarySerialiser.put(buffer, DATA_SET_NAME, dataSet.getName());
        List<AxisDescription> axisDescriptions = dataSet.getAxisDescriptions();
        StringBuilder builder = new StringBuilder(60);
        for (int i = 0; i < axisDescriptions.size(); ++i) {
            builder.setLength(0);
            String prefix = builder.append(AXIS).append(Integer.toString(i)).append('.').toString();
            builder.setLength(0);
            String name = builder.append(prefix).append(NAME).toString();
            builder.setLength(0);
            String unit = builder.append(prefix).append(UNIT).toString();
            builder.setLength(0);
            String minName = builder.append(prefix).append(MIN).toString();
            builder.setLength(0);
            String maxName = builder.append(prefix).append(MAX).toString();
            BinarySerialiser.put(buffer, name, dataSet.getAxisDescription(i).getName());
            BinarySerialiser.put(buffer, unit, dataSet.getAxisDescription(i).getUnit());
            BinarySerialiser.put(buffer, minName, dataSet.getAxisDescription(i).getMin());
            BinarySerialiser.put(buffer, maxName, dataSet.getAxisDescription(i).getMax());
        }
        BinarySerialiser.put(buffer, VAL_INTEGRAL, DataSetSerialiser.integralSimple(dataSet));
        BinarySerialiser.put(buffer, VAL_MEAN, DataSetSerialiser.mean(dataSet.getValues(1)));
        BinarySerialiser.put(buffer, VAL_RMS, DataSetSerialiser.rootMeanSquare(dataSet.getValues(1)));
    }

    protected static void writeMetaDataToStream(IoBuffer buffer, DataSet dataSet) {
        if (!(dataSet instanceof DataSetMetaData)) {
            return;
        }
        DataSetMetaData metaDataSet = (DataSetMetaData)((Object)dataSet);
        BinarySerialiser.put(buffer, INFO_LIST, metaDataSet.getInfoList().toArray(new String[0]));
        BinarySerialiser.put(buffer, WARNING_LIST, metaDataSet.getWarningList().toArray(new String[0]));
        BinarySerialiser.put(buffer, ERROR_LIST, metaDataSet.getErrorList().toArray(new String[0]));
        BinarySerialiser.put(buffer, META_INFO, metaDataSet.getMetaInfo());
    }

    protected static void writeNumericBinaryDataToBuffer(IoBuffer buffer, DataSet dataSet, boolean asFloat) {
        int nsamples = dataSet.getDataCount(0);
        if (asFloat) {
            BinarySerialiser.put(buffer, X_ARRAY_NAME, DataSetSerialiser.toFloats(dataSet.getValues(0)), new int[]{nsamples});
            BinarySerialiser.put(buffer, Y_ARRAY_NAME, DataSetSerialiser.toFloats(dataSet.getValues(1)), new int[]{nsamples});
            if (!(dataSet instanceof DataSetError)) {
                return;
            }
            DataSetError ds = (DataSetError)dataSet;
            block7: for (int dimIndex = 0; dimIndex < 2; ++dimIndex) {
                switch (ds.getErrorType(dimIndex)) {
                    default: {
                        continue block7;
                    }
                    case SYMMETRIC: {
                        BinarySerialiser.put(buffer, dimIndex == 0 ? XEP : YEP, DataSetSerialiser.toFloats(ds.getErrorsPositive(dimIndex)), new int[]{nsamples});
                        continue block7;
                    }
                    case ASYMMETRIC: {
                        BinarySerialiser.put(buffer, dimIndex == 0 ? XEN : YEN, DataSetSerialiser.toFloats(ds.getErrorsNegative(dimIndex)), new int[]{nsamples});
                        BinarySerialiser.put(buffer, dimIndex == 0 ? XEP : YEP, DataSetSerialiser.toFloats(ds.getErrorsPositive(dimIndex)), new int[]{nsamples});
                    }
                }
            }
        } else {
            BinarySerialiser.put(buffer, X_ARRAY_NAME, dataSet.getValues(0), new int[]{nsamples});
            BinarySerialiser.put(buffer, Y_ARRAY_NAME, dataSet.getValues(1), new int[]{nsamples});
            if (!(dataSet instanceof DataSetError)) {
                return;
            }
            DataSetError ds = (DataSetError)dataSet;
            block8: for (int dimIndex = 0; dimIndex < 2; ++dimIndex) {
                switch (ds.getErrorType(dimIndex)) {
                    default: {
                        BinarySerialiser.put(buffer, dimIndex == 0 ? XEP : YEP, ds.getErrorsPositive(dimIndex), new int[]{nsamples});
                        continue block8;
                    }
                    case ASYMMETRIC: {
                        BinarySerialiser.put(buffer, dimIndex == 0 ? XEN : YEN, ds.getErrorsNegative(dimIndex), new int[]{nsamples});
                        BinarySerialiser.put(buffer, dimIndex == 0 ? XEP : YEP, ds.getErrorsPositive(dimIndex), new int[]{nsamples});
                    }
                }
            }
        }
    }
}

