/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.locks;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.locks.DataSetLock;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;

public class DefaultDataSetLock<D extends DataSet>
implements DataSetLock<D> {
    private static final long serialVersionUID = 1L;
    private final transient StampedLock stampedLock = new StampedLock();
    private transient long lastReadStamp;
    private transient long lastWriteStamp;
    private transient Thread writeLockedByThread;
    private final transient AtomicInteger readerCount = new AtomicInteger(0);
    private final transient AtomicInteger writerCount = new AtomicInteger(0);
    private final transient AtomicBoolean autoNotifyState = new AtomicBoolean(true);
    private final transient D dataSet;

    public DefaultDataSetLock(D dataSet) {
        this.dataSet = dataSet;
        if (dataSet == null) {
            throw new IllegalArgumentException("dataSet must not be null");
        }
    }

    @Deprecated
    public D downGradeWriteLock() {
        if (!this.stampedLock.isWriteLocked()) {
            throw new IllegalStateException("cannot downconvert lock - lock is not write locked");
        }
        if (this.getWriterCount() > 1) {
            throw new IllegalStateException("cannot downconvert lock - holding n writelocks = " + this.getWriterCount());
        }
        long result = this.stampedLock.tryConvertToReadLock(this.lastWriteStamp);
        if (result == 0L) {
            throw new IllegalStateException("cannot downconvert lock - tryConvertToReadLock return '0'");
        }
        this.readerCount.getAndIncrement();
        this.writerCount.getAndDecrement();
        if (this.lastReadStamp == 0L && this.stampedLock.isReadLocked() && this.getReaderCount() > 1) {
            this.stampedLock.unlockRead(this.lastReadStamp);
        }
        this.lastReadStamp = result;
        return this.dataSet;
    }

    public long getLastReadStamp() {
        return this.lastReadStamp;
    }

    public boolean getLastStoredAutoNotificationState() {
        return this.autoNotifyState.get();
    }

    public long getLastWriteStamp() {
        return this.lastWriteStamp;
    }

    public StampedLock getLockObject() {
        return this.stampedLock;
    }

    public int getReaderCount() {
        return this.readerCount.get();
    }

    public int getWriterCount() {
        return this.writerCount.get();
    }

    @Override
    public D readLock() {
        if (this.readerCount.getAndIncrement() == 0) {
            this.lastReadStamp = this.stampedLock.readLock();
        }
        return this.dataSet;
    }

    @Override
    public D readLockGuard(Runnable reading) {
        this.readLock();
        try {
            reading.run();
        }
        finally {
            this.readUnLock();
        }
        return this.dataSet;
    }

    @Override
    public <R> R readLockGuard(Supplier<R> reading) {
        R result;
        this.readLock();
        try {
            result = reading.get();
        }
        finally {
            this.readUnLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D readLockGuardOptimistic(Runnable reading) {
        long stamp = this.stampedLock.tryOptimisticRead();
        reading.run();
        if (!this.stampedLock.validate(stamp)) {
            this.readLock();
            try {
                reading.run();
            }
            finally {
                this.readUnLock();
            }
        }
        return this.dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R readLockGuardOptimistic(Supplier<R> reading) {
        long stamp = this.stampedLock.tryOptimisticRead();
        R result = reading.get();
        if (!this.stampedLock.validate(stamp)) {
            this.readLock();
            try {
                result = reading.get();
            }
            finally {
                this.readUnLock();
            }
        }
        return result;
    }

    @Override
    public D readUnLock() {
        if (this.readerCount.decrementAndGet() == 0) {
            this.stampedLock.unlockRead(this.lastReadStamp);
            this.lastReadStamp = 0L;
        } else if (this.readerCount.get() < 0) {
            throw new IllegalStateException("read lock alread unlocked");
        }
        return this.dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D writeLock() {
        Thread callingThread = Thread.currentThread();
        while (this.threadsAreUnequal(callingThread, this.writeLockedByThread)) {
            this.lastWriteStamp = this.stampedLock.writeLock();
            StampedLock stampedLock = this.stampedLock;
            synchronized (stampedLock) {
                this.writeLockedByThread = callingThread;
                this.autoNotifyState.set(this.dataSet.autoNotification().getAndSet(false));
            }
        }
        this.writerCount.incrementAndGet();
        return this.dataSet;
    }

    @Override
    public D writeLockGuard(Runnable writing) {
        this.writeLock();
        boolean oldAutoNotificationState = this.dataSet.autoNotification().getAndSet(false);
        try {
            writing.run();
        }
        finally {
            this.dataSet.autoNotification().set(oldAutoNotificationState);
            this.writeUnLock();
        }
        return this.dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R writeLockGuard(Supplier<R> writing) {
        R result;
        this.writeLock();
        boolean oldAutoNotificationState = this.dataSet.autoNotification().getAndSet(false);
        try {
            result = writing.get();
        }
        finally {
            this.dataSet.autoNotification().set(oldAutoNotificationState);
            this.writeUnLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public D writeUnLock() {
        if (this.writerCount.decrementAndGet() == 0) {
            StampedLock stampedLock = this.stampedLock;
            synchronized (stampedLock) {
                long temp = this.lastWriteStamp;
                this.lastWriteStamp = 0L;
                this.dataSet.autoNotification().set(this.autoNotifyState.get());
                this.writeLockedByThread = null;
                this.stampedLock.unlockWrite(temp);
            }
        } else if (this.writerCount.get() < 0) {
            throw new IllegalStateException("write lock alread unlocked");
        }
        return this.dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean threadsAreUnequal(Thread thread1, Thread thread2) {
        StampedLock stampedLock = this.stampedLock;
        synchronized (stampedLock) {
            return thread1 != thread2;
        }
    }
}

