/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet2D;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.spi.AbstractErrorDataSet;
import de.gsi.dataset.spi.DoubleErrorDataSet;
import de.gsi.dataset.spi.utils.DoublePointError;
import java.util.ArrayList;

public class FifoDoubleErrorDataSet
extends AbstractErrorDataSet<DoubleErrorDataSet>
implements DataSet2D,
DataSetError {
    private static final long serialVersionUID = -7153702141838930486L;
    protected LimitedQueue<DataBlob> data;
    protected double maxDistance = Double.MAX_VALUE;

    public FifoDoubleErrorDataSet(String name, int initalSize) {
        this(name, initalSize, Double.MAX_VALUE);
    }

    public FifoDoubleErrorDataSet(String name, int initalSize, double maxDistance) {
        super(name, 2, DataSetError.ErrorType.SYMMETRIC, DataSetError.ErrorType.SYMMETRIC);
        if (initalSize <= 0) {
            throw new IllegalArgumentException("negative or zero initalSize = " + initalSize);
        }
        if (maxDistance <= 0.0) {
            throw new IllegalArgumentException("negative or zero maxDistance = " + maxDistance);
        }
        this.maxDistance = maxDistance;
        this.data = new LimitedQueue(initalSize);
    }

    public FifoDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos) {
        return this.add(x, y, yErrorNeg, yErrorPos, null);
    }

    public FifoDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String tag) {
        return this.add(x, y, yErrorNeg, yErrorPos, tag, null);
    }

    public FifoDoubleErrorDataSet add(double x, double y, double yErrorNeg, double yErrorPos, String tag, String style) {
        this.lock().writeLockGuard(() -> {
            this.data.add(new DataBlob(x, y, yErrorNeg, yErrorPos, tag, style));
            this.expire(x);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
        });
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public FifoDoubleErrorDataSet add(double[] xValues, double[] yValues, double[] yErrorsNeg, double[] yErrorsPos) {
        this.lock().writeLockGuard(() -> {
            for (int i = 0; i < xValues.length; ++i) {
                this.add(xValues[i], yValues[i], yErrorsNeg[i], yErrorsPos[i]);
            }
        });
        this.fireInvalidated(new AddedDataEvent(this));
        return this;
    }

    public int expire(double now) {
        int dataPointsToRemove = this.lock().writeLockGuard(() -> {
            this.getAxisDescriptions().forEach(AxisDescription::clear);
            ArrayList<DataBlob> toRemoveList = new ArrayList<DataBlob>();
            for (DataBlob blob : this.data) {
                double x = blob.getX();
                double y = blob.getX();
                if (Double.isFinite(x) && Double.isFinite(y)) {
                    if (Math.abs(now - x) > this.maxDistance) {
                        toRemoveList.add(blob);
                        continue;
                    }
                    this.getAxisDescription(0).add(x + blob.getErrorX());
                    this.getAxisDescription(0).add(x - blob.getErrorX());
                    this.getAxisDescription(1).add(y + blob.getErrorY());
                    this.getAxisDescription(1).add(y - blob.getErrorY());
                    continue;
                }
                toRemoveList.add(blob);
            }
            this.data.removeAll(toRemoveList);
            this.getAxisDescriptions().forEach(AxisDescription::clear);
            return toRemoveList.size();
        });
        if (dataPointsToRemove != 0) {
            this.fireInvalidated(new RemovedDataEvent(this, "expired data"));
        }
        return dataPointsToRemove;
    }

    @Override
    public int getDataCount(int dimIndex) {
        return this.data.size();
    }

    @Override
    public String getDataLabel(int index) {
        return ((DataBlob)this.data.get(index)).getDataLabel();
    }

    @Override
    public double getErrorNegative(int dimIndex, int index) {
        return dimIndex == 0 ? ((DataBlob)this.data.get(index)).getErrorX() : ((DataBlob)this.data.get(index)).getErrorY();
    }

    @Override
    public double getErrorPositive(int dimIndex, int index) {
        return dimIndex == 0 ? ((DataBlob)this.data.get(index)).getErrorX() : ((DataBlob)this.data.get(index)).getErrorY();
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public String getStyle(int index) {
        return ((DataBlob)this.data.get(index)).getStyle();
    }

    @Override
    public final double get(int dimIndex, int index) {
        return dimIndex == 0 ? ((DataBlob)this.data.get(index)).getX() : ((DataBlob)this.data.get(index)).getY();
    }

    public void reset() {
        this.data.clear();
        this.fireInvalidated(new RemovedDataEvent(this, "reset"));
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    public class LimitedQueue<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = -5751322669709687363L;
        private final int limit;

        public LimitedQueue(int limit) {
            this.limit = limit;
            if (limit < 1) {
                throw new IllegalArgumentException("Queue limit must be greater than 0");
            }
        }

        @Override
        public boolean add(E o) {
            boolean r = super.add(o);
            if (this.size() > this.limit) {
                super.remove(0);
            }
            return r;
        }
    }

    protected class DataBlob
    extends DoublePointError {
        protected String style;
        protected String tag;

        protected DataBlob(double x, double y, double errorX, double errorY) {
            this(x, y, errorX, errorY, null, null);
        }

        protected DataBlob(double x, double y, double errorX, double errorY, String tag, String style) {
            super(x, y, errorX, errorY);
            this.tag = tag;
            this.style = style;
        }

        public String getDataLabel() {
            return this.tag;
        }

        public String getStyle() {
            return this.style;
        }
    }
}

