/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.AxisDescription;
import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.EditConstraints;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.event.UpdatedMetaDataEvent;
import de.gsi.dataset.locks.DataSetLock;
import de.gsi.dataset.locks.DefaultDataSetLock;
import de.gsi.dataset.spi.AbstractStylable;
import de.gsi.dataset.spi.DefaultAxisDescription;
import de.gsi.dataset.spi.utils.MathUtils;
import de.gsi.dataset.spi.utils.StringHashMapList;
import de.gsi.dataset.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSet<D extends AbstractStylable<D>>
extends AbstractStylable<D>
implements DataSet,
DataSetMetaData {
    private static final long serialVersionUID = -7612136495756923417L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataSet.class);
    private static final String[] DEFAULT_AXES_NAME = new String[]{"x-Axis", "y-Axis", "z-Axis"};
    private final transient AtomicBoolean autoNotification = new AtomicBoolean(true);
    private String name;
    private int dimension;
    private final List<AxisDescription> axesDescriptions = new ArrayList<AxisDescription>();
    private final transient List<EventListener> updateListeners = Collections.synchronizedList(new LinkedList());
    private final transient DataSetLock<? extends DataSet> lock = new DefaultDataSetLock<AbstractDataSet>(this);
    private StringHashMapList dataLabels = new StringHashMapList();
    private StringHashMapList dataStyles = new StringHashMapList();
    private List<String> infoList = new ArrayList<String>();
    private List<String> warningList = new ArrayList<String>();
    private List<String> errorList = new ArrayList<String>();
    private EditConstraints editConstraints;
    private final Map<String, String> metaInfoMap = new ConcurrentHashMap<String, String>();

    public AbstractDataSet(String name, int dimension) {
        AssertUtils.gtThanZero("dimension", dimension);
        this.name = name;
        this.dimension = dimension;
        for (int i = 0; i < this.dimension; ++i) {
            String axisName = i < DEFAULT_AXES_NAME.length ? DEFAULT_AXES_NAME[i] : "dim" + (i + 1) + "-Axis";
            this.axesDescriptions.add(new DefaultAxisDescription((DataSet)this, axisName, "a.u."));
        }
    }

    public String addDataLabel(int index, String label) {
        String retVal = this.lock().writeLockGuard(() -> this.dataLabels.put(index, label));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added label"));
        return retVal;
    }

    public String addDataStyle(int index, String style) {
        String retVal = this.lock().writeLockGuard(() -> this.dataStyles.put(index, style));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "added style"));
        return retVal;
    }

    @Override
    public AtomicBoolean autoNotification() {
        return this.autoNotification;
    }

    protected int binarySearch(int dimIndex, double search, int indexMin, int indexMax) {
        if (indexMin == indexMax) {
            return indexMin;
        }
        if (indexMax - indexMin == 1) {
            if (Math.abs(this.get(dimIndex, indexMin) - search) < Math.abs(this.get(dimIndex, indexMax) - search)) {
                return indexMin;
            }
            return indexMax;
        }
        int middle = (indexMax + indexMin) / 2;
        double valMiddle = this.get(dimIndex, middle);
        if (valMiddle == search) {
            return middle;
        }
        if (search < valMiddle) {
            return this.binarySearch(dimIndex, search, indexMin, middle);
        }
        return this.binarySearch(dimIndex, search, middle, indexMax);
    }

    public D clearMetaInfo() {
        this.infoList.clear();
        this.warningList.clear();
        this.errorList.clear();
        return this.fireInvalidated(new UpdatedMetaDataEvent(this, "cleared meta data"));
    }

    protected boolean equalDataLabels(DataSet other) {
        if (other instanceof AbstractDataSet) {
            AbstractDataSet otherAbsDs = (AbstractDataSet)other;
            if (!this.getDataLabelMap().equals(otherAbsDs.getDataLabelMap())) {
                return false;
            }
        } else {
            for (int index = 0; index < this.getDataCount(); ++index) {
                String label2;
                String label1 = this.getDataLabel(index);
                if (label1 == (label2 = other.getDataLabel(index))) continue;
                if (label1 == null && label2 != null) {
                    return false;
                }
                if (label1 != null && label1.equals(label2)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean equalEditConstraints(DataSet other) {
        if (other instanceof EditableDataSet) {
            EditableDataSet otherEditDs = (EditableDataSet)other;
            if (this.editConstraints != null && otherEditDs.getEditConstraints() == null) {
                return false;
            }
            if (this.editConstraints != null && !this.editConstraints.equals(otherEditDs.getEditConstraints())) {
                return false;
            }
        }
        return true;
    }

    protected boolean equalErrorValues(DataSet other, double epsilon) {
        if (!(this instanceof DataSetError) || !(other instanceof DataSetError)) {
            return true;
        }
        DataSetError thisErrorDs = (DataSetError)((Object)this);
        DataSetError otherErrorDs = (DataSetError)other;
        if (!thisErrorDs.getErrorType(0).equals((Object)otherErrorDs.getErrorType(0))) {
            return false;
        }
        if (!thisErrorDs.getErrorType(1).equals((Object)otherErrorDs.getErrorType(1))) {
            return false;
        }
        if (epsilon <= 0.0) {
            for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                for (int index = 0; index < this.getDataCount(dimIndex); ++index) {
                    if (thisErrorDs.getErrorNegative(dimIndex, index) != otherErrorDs.getErrorNegative(dimIndex, index)) {
                        return false;
                    }
                    if (thisErrorDs.getErrorPositive(dimIndex, index) == otherErrorDs.getErrorPositive(dimIndex, index)) continue;
                    return false;
                }
            }
        } else {
            for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                for (int index = 0; index < this.getDataCount(dimIndex); ++index) {
                    if (!MathUtils.nearlyEqual(thisErrorDs.getErrorNegative(dimIndex, index), otherErrorDs.getErrorNegative(dimIndex, index), epsilon)) {
                        return false;
                    }
                    if (MathUtils.nearlyEqual(thisErrorDs.getErrorPositive(dimIndex, index), otherErrorDs.getErrorPositive(dimIndex, index), epsilon)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean equalMetaData(DataSet other) {
        if (other instanceof DataSetMetaData) {
            DataSetMetaData otherMetaDs = (DataSetMetaData)((Object)other);
            if (!this.getErrorList().equals(otherMetaDs.getErrorList())) {
                return false;
            }
            if (!this.getWarningList().equals(otherMetaDs.getWarningList())) {
                return false;
            }
            if (!this.getInfoList().equals(otherMetaDs.getInfoList())) {
                return false;
            }
            if (!this.getMetaInfo().equals(otherMetaDs.getMetaInfo())) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, -1.0);
    }

    public boolean equals(Object obj, double epsilon) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet)obj;
        if (this.getDimension() != other.getDimension()) {
            return false;
        }
        if (this.getDataCount() != other.getDataCount()) {
            return false;
        }
        for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
            if (this.getDataCount(dimIndex) == other.getDataCount(dimIndex)) continue;
            return false;
        }
        String name1 = this.getName();
        String name2 = other.getName();
        if (!(name1 != null ? name1.equals(name2) : name2 == null)) {
            return false;
        }
        if (this.getAxisDescriptions().isEmpty() && !other.getAxisDescriptions().isEmpty()) {
            return false;
        }
        if (!this.getAxisDescriptions().equals(other.getAxisDescriptions())) {
            return false;
        }
        if (!this.equalDataLabels(other)) {
            return false;
        }
        if (!this.equalEditConstraints(other)) {
            return false;
        }
        if (!this.equalMetaData(other)) {
            return false;
        }
        if (!this.equalValues(other, epsilon)) {
            return false;
        }
        return this.equalErrorValues(other, epsilon);
    }

    protected boolean equalValues(DataSet other, double epsilon) {
        if (epsilon <= 0.0) {
            for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                for (int index = 0; index < this.getDataCount(dimIndex); ++index) {
                    if (this.get(dimIndex, index) == other.get(dimIndex, index)) continue;
                    return false;
                }
            }
        } else {
            for (int dimIndex = 0; dimIndex < this.getDimension(); ++dimIndex) {
                for (int index = 0; index < this.getDataCount(dimIndex); ++index) {
                    if (MathUtils.nearlyEqual(this.get(dimIndex, index), other.get(dimIndex, index), epsilon)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public D fireInvalidated(UpdateEvent event) {
        this.invokeListener(event);
        return (D)this.getThis();
    }

    @Override
    public List<AxisDescription> getAxisDescriptions() {
        return this.axesDescriptions;
    }

    @Override
    public String getDataLabel(int index) {
        return (String)this.dataLabels.get(index);
    }

    public StringHashMapList getDataLabelMap() {
        return this.dataLabels;
    }

    public StringHashMapList getDataStyleMap() {
        return this.dataStyles;
    }

    @Override
    public final int getDimension() {
        return this.dimension;
    }

    public EditConstraints getEditConstraints() {
        return this.editConstraints;
    }

    @Override
    public List<String> getErrorList() {
        return this.errorList;
    }

    @Override
    public List<String> getInfoList() {
        return this.infoList;
    }

    @Override
    public Map<String, String> getMetaInfo() {
        return this.metaInfoMap;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getStyle(int index) {
        return (String)this.dataStyles.get(index);
    }

    @Override
    protected D getThis() {
        return (D)this;
    }

    @Override
    public List<String> getWarningList() {
        return this.warningList;
    }

    @Override
    public int getIndex(int dimIndex, double x) {
        if (this.getDataCount() == 0) {
            return 0;
        }
        if (!Double.isFinite(x)) {
            return 0;
        }
        if (x < this.getAxisDescription(dimIndex).getMin()) {
            return 0;
        }
        int lastIndex = this.getDataCount(dimIndex) - 1;
        if (x > this.getAxisDescription(dimIndex).getMax()) {
            return lastIndex;
        }
        return this.binarySearch(dimIndex, x, 0, lastIndex);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.axesDescriptions.hashCode();
        result = 31 * result + (this.dataLabels == null ? 0 : this.dataLabels.hashCode());
        result = 31 * result + this.dimension;
        result = 31 * result + (this.editConstraints == null ? 0 : this.editConstraints.hashCode());
        result = 31 * result + (this.errorList == null ? 0 : this.errorList.hashCode());
        result = 31 * result + (this.infoList == null ? 0 : this.infoList.hashCode());
        result = 31 * result + this.metaInfoMap.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.warningList == null ? 0 : this.warningList.hashCode());
        return result;
    }

    public DataSetLock<? extends DataSet> lock() {
        return this.lock;
    }

    protected int minNeigbourSearchX(double search, int indexMin, int indexMax) {
        double b;
        double minAbsDiff = Double.MAX_VALUE;
        int searchIndex = indexMin;
        double a = this.get(0, indexMin);
        String eq = a < (b = this.get(0, indexMax)) ? " < " : " > ";
        LOGGER.error("- new searchIndex  getX(indexMin)= " + a + eq + " getX(indexMax)= " + b);
        for (int i = indexMin; i <= indexMax; ++i) {
            double valX = this.get(0, i);
            if (!Double.isFinite(valX)) {
                LOGGER.error("non-finite value - autsch = " + valX + " index = " + i);
                throw new IllegalStateException("check");
            }
            double absDiff = Math.abs(search - valX);
            if (!Double.isFinite(absDiff) || !(absDiff < minAbsDiff)) continue;
            searchIndex = i;
            minAbsDiff = absDiff;
        }
        LOGGER.error("- new searchIndex Range = " + indexMin + " for " + indexMax);
        LOGGER.error("- new searchIndex = " + searchIndex + " for " + minAbsDiff);
        return searchIndex;
    }

    public D recomputeLimits(int dimIndex) {
        this.getAxisDescription(dimIndex).clear();
        int dataCount = this.getDataCount(dimIndex);
        for (int i = 0; i < dataCount; ++i) {
            this.getAxisDescription(dimIndex).add(this.get(dimIndex, i));
        }
        return (D)this.getThis();
    }

    public String removeDataLabel(int index) {
        String retVal = this.lock().writeLockGuard(() -> (String)this.dataLabels.remove(index));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed label"));
        return retVal;
    }

    public String removeStyle(int index) {
        String retVal = this.lock().writeLockGuard(() -> (String)this.dataStyles.remove(index));
        this.fireInvalidated(new UpdatedMetaDataEvent(this, "removed style"));
        return retVal;
    }

    public D setEditConstraints(EditConstraints constraints) {
        this.lock().writeLockGuard(() -> {
            this.editConstraints = constraints;
            return this.editConstraints;
        });
        return this.fireInvalidated(new UpdatedMetaDataEvent(this, "new edit constraints"));
    }

    public D setName(String name) {
        this.name = name;
        return (D)this.getThis();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append(" [dim=").append(this.getDimension()).append(',');
        for (int i = 0; i < this.getDimension(); ++i) {
            AxisDescription desc = this.getAxisDescription(i);
            boolean isDefined = desc.isDefined();
            builder.append(" dataCount(").append(i).append(")=").append(this.getDataCount(i)).append(',').append(" axisName ='").append(desc.getName()).append("',").append(" axisUnit = '").append(desc.getUnit()).append("',").append(" axisRange = ").append(" [min=").append(isDefined ? Double.valueOf(desc.getMin()) : "NotDefined").append(", max=").append(isDefined ? Double.valueOf(desc.getMax()) : "NotDefined").append("],");
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public synchronized List<EventListener> updateEventListener() {
        return this.updateListeners;
    }
}

