/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi.iobuffer;

import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.serializer.spi.AbstractSerialiser;
import de.gsi.dataset.serializer.spi.BinarySerialiser;
import de.gsi.dataset.serializer.spi.iobuffer.IoBufferFieldSerialiser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldPrimitiveValueHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldPrimitiveValueHelper.class);

    private FieldPrimitiveValueHelper() {
    }

    public static void register(AbstractSerialiser serialiser, IoBuffer ioBuffer) {
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().setBoolean(obj, ioBuffer.getBoolean()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), field.getField().getBoolean(obj)), Boolean.TYPE, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().setByte(obj, ioBuffer.getByte()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), field.getField().getByte(obj)), Byte.TYPE, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().setShort(obj, ioBuffer.getShort()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), field.getField().getShort(obj)), Short.TYPE, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().setInt(obj, ioBuffer.getInt()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), field.getField().getInt(obj)), Integer.TYPE, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().setLong(obj, ioBuffer.getLong()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), field.getField().getLong(obj)), Long.TYPE, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().setFloat(obj, ioBuffer.getFloat()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), field.getField().getFloat(obj)), Float.TYPE, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().setDouble(obj, ioBuffer.getDouble()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), field.getField().getDouble(obj)), Double.TYPE, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, ioBuffer.getString()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), (String)field.getField().get(obj)), String.class, new Class[0]));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)serialiser).addArgument((Object)ioBuffer).log("initialised({}, {}");
        }
    }
}

