/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi.iobuffer;

import de.gsi.dataset.serializer.IoBuffer;
import de.gsi.dataset.serializer.spi.AbstractSerialiser;
import de.gsi.dataset.serializer.spi.BinarySerialiser;
import de.gsi.dataset.serializer.spi.iobuffer.IoBufferFieldSerialiser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldBoxedValueHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldBoxedValueHelper.class);

    private FieldBoxedValueHelper() {
    }

    public static void register(AbstractSerialiser serialiser, IoBuffer ioBuffer) {
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, ioBuffer.getBoolean()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), (Boolean)field.getField().get(obj)), Boolean.class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, ioBuffer.getByte()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), (Byte)field.getField().get(obj)), Byte.class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, ioBuffer.getShort()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), (Short)field.getField().get(obj)), Short.class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, ioBuffer.getInt()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), (Integer)field.getField().get(obj)), Integer.class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, ioBuffer.getLong()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), (Long)field.getField().get(obj)), Long.class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, Float.valueOf(ioBuffer.getFloat())), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), ((Float)field.getField().get(obj)).floatValue()), Float.class, new Class[0]));
        serialiser.addClassDefinition(new IoBufferFieldSerialiser(ioBuffer, (obj, field) -> field.getField().set(obj, ioBuffer.getDouble()), (obj, field) -> BinarySerialiser.put(ioBuffer, field.getFieldName(), (Double)field.getField().get(obj)), Double.class, new Class[0]));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.atDebug().addArgument((Object)serialiser).addArgument((Object)ioBuffer).log("initialised({}, {}");
        }
    }
}

