/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.serializer.spi;

import de.gsi.dataset.serializer.spi.ClassFieldDescription;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassDescriptions {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassDescriptions.class);
    public static int indentationNumerOfSpace = 4;
    private static final Map<Integer, ClassFieldDescription> CLASS_FIELD_DESCRIPTION_MAP = new ConcurrentHashMap<Integer, ClassFieldDescription>();
    private static final Map<String, Class<?>> CLASS_STRING_MAP = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Method>> CLASS_METHOD_MAP = new ConcurrentHashMap();

    private ClassDescriptions() {
    }

    @SafeVarargs
    private static int computeHashCode(Class<?> classPrototype, Class<? extends Object> ... classArguments) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (classPrototype == null ? 0 : classPrototype.getName().hashCode());
        if (classArguments == null || classArguments.length <= 0) {
            return result;
        }
        for (Class<? extends Object> clazz : Arrays.asList(classArguments)) {
            result = 31 * result + clazz.hashCode();
        }
        return result;
    }

    @SafeVarargs
    public static ClassFieldDescription get(Class<? extends Object> clazz, Class<? extends Object> ... classArguments) {
        if (clazz == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        return CLASS_FIELD_DESCRIPTION_MAP.computeIfAbsent(ClassDescriptions.computeHashCode(clazz, classArguments), key -> new ClassFieldDescription(clazz, false));
    }

    public static Class<?> getClassByName(String name) {
        return CLASS_STRING_MAP.computeIfAbsent(name, key -> {
            try {
                return Class.forName(key);
            }
            catch (ClassNotFoundException | SecurityException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.atError().setCause((Throwable)e).addArgument((Object)name).log("exception while getting class {}");
                }
                return null;
            }
        });
    }

    public static Class<?> getClassByNameNonVerboseError(String name) {
        return CLASS_STRING_MAP.computeIfAbsent(name, key -> {
            try {
                return Class.forName(key);
            }
            catch (ClassNotFoundException | SecurityException e) {
                return Object.class;
            }
        });
    }

    public static Map<Integer, ClassFieldDescription> getClassDescriptions() {
        return CLASS_FIELD_DESCRIPTION_MAP;
    }

    public static Collection<ClassFieldDescription> getKnownClasses() {
        return CLASS_FIELD_DESCRIPTION_MAP.values();
    }

    public static Map<Class<?>, Map<String, Method>> getKnownMethods() {
        return CLASS_METHOD_MAP;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        return CLASS_METHOD_MAP.computeIfAbsent(clazz, c -> new ConcurrentHashMap()).computeIfAbsent(methodName, name -> {
            try {
                return clazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static void initNullMemberFields(Object rootObject) {
        ClassDescriptions.initNullMemberFields(rootObject, ClassDescriptions.get(rootObject.getClass(), new Class[0]));
    }

    public static void initNullMemberFields(Object rootObject, ClassFieldDescription fieldRoot) {
        if (rootObject == null) {
            throw new IllegalArgumentException("rootObject must not be null");
        }
        Object localRoot = rootObject;
        for (ClassFieldDescription field : fieldRoot.getChildren()) {
            block6: {
                if (!field.getType().isMemberClass()) continue;
                try {
                    localRoot = field.getField().get(rootObject);
                    if (localRoot == null) {
                        Constructor<?> constr = field.getType().getDeclaredConstructor(rootObject.getClass());
                        constr.setAccessible(true);
                        localRoot = constr.newInstance(rootObject);
                        field.getField().set(rootObject, localRoot);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    if (!LOGGER.isErrorEnabled()) break block6;
                    LOGGER.atError().setCause((Throwable)e).log("could not initialise inner class:" + field.toString());
                }
            }
            if (localRoot == null) {
                throw new IllegalArgumentException("could not allocate localRoot object");
            }
            ClassDescriptions.initNullMemberFields(localRoot, field);
        }
    }

    public static void printClassStructure(ClassFieldDescription field) {
        ClassDescriptions.printClassStructure(field, false, 0);
    }

    public static void printClassStructure(ClassFieldDescription field, boolean fullView, int recursionLevel) {
        String enumOrClass;
        String string = enumOrClass = field.isEnum() ? "Enum " : "class ";
        String typeCategorgy = field.isInterface() ? "interface " : (field.isPrimitive() ? "" : enumOrClass);
        String typeName = field.getTypeName() + field.getGenericFieldTypeString();
        String mspace = ClassDescriptions.spaces((recursionLevel + 1) * indentationNumerOfSpace);
        boolean isSerialisable = field.isSerializable();
        if (isSerialisable || fullView) {
            LOGGER.atInfo().addArgument((Object)mspace).addArgument((Object)(isSerialisable ? "  " : "//")).addArgument((Object)field.getModifierString()).addArgument((Object)typeCategorgy).addArgument((Object)typeName).addArgument((Object)field.getFieldNameRelative()).log("{} {} {} {}{} {}");
            field.getChildren().stream().forEach(f -> ClassDescriptions.printClassStructure(f, fullView, recursionLevel + 1));
        }
    }

    public static void printFullClassStructure(ClassFieldDescription field) {
        ClassDescriptions.printClassStructure(field, true, 0);
    }

    private static String spaces(int spaces) {
        return CharBuffer.allocate(spaces).toString().replace('\u0000', ' ');
    }

    public static String translateClassName(String name) {
        String retName = name;
        if (retName.startsWith("[Z")) {
            return boolean[].class.getName();
        }
        if (retName.startsWith("[B")) {
            return byte[].class.getName();
        }
        if (retName.startsWith("[S")) {
            return short[].class.getName();
        }
        if (retName.startsWith("[I")) {
            return int[].class.getName();
        }
        if (retName.startsWith("[J")) {
            return long[].class.getName();
        }
        if (retName.startsWith("[F")) {
            return float[].class.getName();
        }
        if (retName.startsWith("[D")) {
            return double[].class.getName();
        }
        if (retName.startsWith("[L")) {
            return retName.substring(2, retName.length() - 1) + "[]";
        }
        return retName;
    }
}

