/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils.serializer;

import de.gsi.dataset.utils.AssertUtils;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class FastByteBuffer {
    private static final int DEFAULT_INITIAL_CAPACITY = 1000;
    public static final long SIZE_OF_BOOLEAN = 1L;
    public static final long SIZE_OF_BYTE = 1L;
    public static final long SIZE_OF_SHORT = 2L;
    public static final long SIZE_OF_INT = 4L;
    public static final long SIZE_OF_LONG = 8L;
    public static final long SIZE_OF_FLOAT = 4L;
    public static final long SIZE_OF_DOUBLE = 8L;
    private static final Unsafe unsafe;
    private long pos;
    private byte[] buffer;

    public static void copyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        unsafe.copyMemory(srcBase, srcOffset, destBase, destOffset, bytes);
    }

    public FastByteBuffer() {
        this(1000);
    }

    public FastByteBuffer(int size) {
        AssertUtils.gtEqThanZero("size", size);
        this.buffer = new byte[size];
        this.pos = 0L;
    }

    public FastByteBuffer(byte[] buffer, int size) {
        AssertUtils.notNull("buffer", buffer);
        AssertUtils.checkArrayDimension("buffer", buffer, Math.min(size, buffer.length));
        this.buffer = buffer;
        this.pos = size;
    }

    public static FastByteBuffer wrap(byte[] byteArray, int length) {
        return new FastByteBuffer(byteArray, length);
    }

    public static FastByteBuffer wrap(byte[] byteArray) {
        return new FastByteBuffer(byteArray, byteArray.length);
    }

    public byte[] elements() {
        return this.buffer;
    }

    public long getPosition() {
        return this.pos;
    }

    public int getCapacity() {
        return this.buffer.length;
    }

    public void reset() {
        this.pos = 0L;
    }

    public boolean verifySize() {
        return this.getPosition() <= (long)this.getCapacity();
    }

    public void forceCapacity(int length, int preserve) {
        if (length == this.getCapacity()) {
            return;
        }
        byte[] newBuffer = new byte[length];
        long bytesToCopy = (long)preserve * 1L;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, newBuffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, bytesToCopy);
        this.pos = this.pos < (long)newBuffer.length ? this.pos : (long)(newBuffer.length - 1);
        this.buffer = newBuffer;
    }

    public void ensureCapacity(int capacity) {
        if (capacity <= this.getCapacity()) {
            return;
        }
        this.forceCapacity(capacity, this.getCapacity());
    }

    public void ensureAdditionalCapacity(long capacity) {
        if (this.getPosition() + capacity <= (long)this.getCapacity()) {
            return;
        }
        this.forceCapacity(this.getCapacity() + (int)capacity, this.getCapacity());
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int requestedCapacity) {
        if (requestedCapacity >= this.getCapacity() || this.getPosition() == (long)this.getCapacity()) {
            return;
        }
        long bytesToCopy = (long)Math.max(requestedCapacity, this.getCapacity()) * 1L;
        byte[] newBuffer = new byte[(int)bytesToCopy];
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, newBuffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, bytesToCopy);
        this.buffer = newBuffer;
    }

    public void putBoolean(boolean value) {
        unsafe.putBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, value);
        ++this.pos;
    }

    public boolean getBoolean() {
        boolean value = unsafe.getBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos);
        ++this.pos;
        return value;
    }

    public void putByte(byte value) {
        unsafe.putByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, value);
        ++this.pos;
    }

    public byte getByte() {
        byte value = unsafe.getByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos);
        ++this.pos;
        return value;
    }

    public void putShort(short value) {
        unsafe.putShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, value);
        this.pos += 2L;
    }

    public short getShort() {
        short value = unsafe.getShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos);
        this.pos += 2L;
        return value;
    }

    public void putInt(int value) {
        unsafe.putInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, value);
        this.pos += 4L;
    }

    public int getInt() {
        int value = unsafe.getInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos);
        this.pos += 4L;
        return value;
    }

    public void putLong(long value) {
        unsafe.putLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, value);
        this.pos += 8L;
    }

    public long getLong() {
        long value = unsafe.getLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos);
        this.pos += 8L;
        return value;
    }

    public void putFloat(float value) {
        unsafe.putFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, value);
        this.pos += 4L;
    }

    public float getFloat() {
        float value = unsafe.getFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos);
        this.pos += 4L;
        return value;
    }

    public void putDouble(double value) {
        unsafe.putDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, value);
        this.pos += 8L;
    }

    public double getDouble() {
        double value = unsafe.getDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos);
        this.pos += 8L;
        return value;
    }

    public void putBooleanArray(boolean[] values) {
        this.putBooleanArray(values, values.length);
    }

    public void putBooleanArray(boolean[] values, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long bytesToCopy = nElements;
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, bytesToCopy);
        this.pos += bytesToCopy;
    }

    public boolean[] getBooleanArray() {
        int arraySize = this.getInt();
        boolean[] values = new boolean[arraySize];
        long bytesToCopy = values.length;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, values, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, bytesToCopy);
        this.pos += bytesToCopy;
        return values;
    }

    public void putByteArray(byte[] values) {
        this.putByteArray(values, values.length);
    }

    public void putByteArray(byte[] values, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long bytesToCopy = nElements;
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_BYTE_BASE_OFFSET, this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, bytesToCopy);
        this.pos += bytesToCopy;
    }

    public byte[] getByteArray() {
        int arraySize = this.getInt();
        byte[] values = new byte[arraySize];
        long bytesToCopy = values.length;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, values, Unsafe.ARRAY_BYTE_BASE_OFFSET, bytesToCopy);
        this.pos += bytesToCopy;
        return values;
    }

    public void putShortArray(short[] values) {
        this.putShortArray(values, values.length);
    }

    public void putShortArray(short[] values, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long bytesToCopy = (long)nElements * 2L;
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_SHORT_BASE_OFFSET, this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, bytesToCopy);
        this.pos += bytesToCopy;
    }

    public short[] getShortArray() {
        int arraySize = this.getInt();
        short[] values = new short[arraySize];
        long bytesToCopy = (long)values.length * 2L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, values, Unsafe.ARRAY_SHORT_BASE_OFFSET, bytesToCopy);
        this.pos += bytesToCopy;
        return values;
    }

    public void putIntArray(int[] values) {
        this.putIntArray(values, values.length);
    }

    public void putIntArray(int[] values, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long bytesToCopy = (long)nElements * 4L;
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_INT_BASE_OFFSET, this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, bytesToCopy);
        this.pos += bytesToCopy;
    }

    public int[] getIntArray() {
        int arraySize = this.getInt();
        int[] values = new int[arraySize];
        long bytesToCopy = (long)values.length * 4L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, values, Unsafe.ARRAY_INT_BASE_OFFSET, bytesToCopy);
        this.pos += bytesToCopy;
        return values;
    }

    public void putLongArray(long[] values) {
        this.putLongArray(values, values.length);
    }

    public void putLongArray(long[] values, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long bytesToCopy = (long)nElements * 8L;
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_LONG_BASE_OFFSET, this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, bytesToCopy);
        this.pos += bytesToCopy;
    }

    public long[] getLongArray() {
        int arraySize = this.getInt();
        long[] values = new long[arraySize];
        long bytesToCopy = (long)values.length * 8L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, values, Unsafe.ARRAY_LONG_BASE_OFFSET, bytesToCopy);
        this.pos += bytesToCopy;
        return values;
    }

    public void putFloatArray(float[] values) {
        this.putFloatArray(values, values.length);
    }

    public void putFloatArray(float[] values, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long bytesToCopy = (long)nElements * 4L;
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_FLOAT_BASE_OFFSET, this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, bytesToCopy);
        this.pos += bytesToCopy;
    }

    public float[] getFloatArray() {
        int arraySize = this.getInt();
        float[] values = new float[arraySize];
        long bytesToCopy = (long)values.length * 4L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, values, Unsafe.ARRAY_FLOAT_BASE_OFFSET, bytesToCopy);
        this.pos += bytesToCopy;
        return values;
    }

    public void putDoubleArray(double[] values) {
        this.putDoubleArray(values, values.length);
    }

    public void putDoubleArray(double[] values, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        long bytesToCopy = (long)nElements * 8L;
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_DOUBLE_BASE_OFFSET, this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, bytesToCopy);
        this.pos += bytesToCopy;
    }

    public double[] getDoubleArray() {
        int arraySize = this.getInt();
        double[] values = new double[arraySize];
        long bytesToCopy = (long)values.length * 8L;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, values, Unsafe.ARRAY_DOUBLE_BASE_OFFSET, bytesToCopy);
        this.pos += bytesToCopy;
        return values;
    }

    public void putString(String string) {
        int strLength = string == null ? 0 : string.length();
        this.putInt(strLength + 1);
        for (int i = 0; i < strLength; ++i) {
            this.putByte((byte)string.charAt(i));
        }
        this.putByte((byte)0);
    }

    public String getString() {
        int arraySize = this.getInt() - 1;
        byte[] values = new byte[arraySize];
        long bytesToCopy = values.length;
        FastByteBuffer.copyMemory(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + this.pos, values, Unsafe.ARRAY_BYTE_BASE_OFFSET, bytesToCopy);
        this.pos += bytesToCopy + 1L;
        return new String(values);
    }

    public void putStringArray(String[] values) {
        this.putStringArray(values, values.length);
    }

    public void putStringArray(String[] values, int nToCopy) {
        int nElements = nToCopy > 0 ? Math.min(nToCopy, values.length) : values.length;
        this.putInt(nElements);
        for (int k = 0; k < nElements; ++k) {
            this.putString(values[k]);
        }
    }

    public String[] getStringArray() {
        int stringArraySize = this.getInt();
        String[] ret = new String[stringArraySize];
        for (int k = 0; k < stringArraySize; ++k) {
            ret[k] = this.getString();
        }
        return ret;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }
}

