/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils.serializer;

import java.util.Map;

public enum DataType {
    BOOL(0, "bool", 1L, Boolean.class, true),
    BYTE(1, "byte", 1L, Byte.class, true),
    SHORT(2, "short", 2L, Short.class, true),
    INT(3, "int", 4L, Integer.class, true),
    LONG(4, "long", 8L, Long.class, true),
    FLOAT(5, "float", 4L, Float.class, true),
    DOUBLE(6, "double", 8L, Double.class, true),
    STRING(7, "string", 1L, String.class, true),
    BOOL_ARRAY(100, "bool_array", 1L, Boolean[].class, false),
    BYTE_ARRAY(101, "byte_array", 1L, Byte[].class, false),
    SHORT_ARRAY(102, "short_array", 2L, Short[].class, false),
    INT_ARRAY(103, "int_array", 4L, Integer[].class, false),
    LONG_ARRAY(104, "long_array", 8L, Long[].class, false),
    FLOAT_ARRAY(105, "float_array", 4L, Float[].class, false),
    DOUBLE_ARRAY(106, "double_array", 8L, Double[].class, false),
    STRING_ARRAY(107, "string_array", 1L, String[].class, false),
    MAP(200, "map", 1L, Map.class, false),
    END_MARKER(254, "end_marker", 1L, Byte.class, false);

    private final byte byteValue;
    private final long primitiveSize;
    private final String stringValue;
    private final Class<?> classType;
    private final boolean scalar;

    private DataType(int byteValue, String stringValue, long primitiveSize, Class<?> classType, boolean isScalar) {
        this.byteValue = (byte)byteValue;
        this.stringValue = stringValue;
        this.primitiveSize = primitiveSize;
        this.classType = classType;
        this.scalar = isScalar;
    }

    public byte getAsByte() {
        return this.byteValue;
    }

    public long getPrimitiveSize() {
        return this.primitiveSize;
    }

    public Class<?> getClassType() {
        return this.classType;
    }

    public boolean isScalar() {
        return this.scalar;
    }

    public String getAsString() {
        return this.stringValue;
    }

    public String toString() {
        return this.stringValue;
    }

    public static DataType fromString(String str) {
        for (DataType type : DataType.values()) {
            if (!type.stringValue.equals(str)) continue;
            return type;
        }
        throw new IllegalArgumentException("Entry type '" + str + "' is not supported");
    }

    public static DataType fromByte(byte value) {
        for (DataType type : DataType.values()) {
            if (type.byteValue != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Entry type '" + value + "' is not supported");
    }

    public static DataType fromClassType(Class<?> classType) {
        for (DataType type : DataType.values()) {
            if (type.getClassType() != classType) continue;
            return type;
        }
        throw new IllegalArgumentException("data type not implemented " + classType.getSimpleName());
    }
}

