/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi.utils;

import java.util.concurrent.ConcurrentHashMap;

public class StringHashMapList
extends ConcurrentHashMap<Integer, String> {
    private static final long serialVersionUID = 4588196035279167053L;
    private static final long PARALLELISM_THRESHOLD = 1000L;

    public void shiftKeys(int fromIndex, int toIndex) {
        for (int i = toIndex; i >= fromIndex; --i) {
            String oldData = (String)this.remove(i);
            if (oldData == null) continue;
            this.put(i + 1, oldData);
        }
    }

    public void addValueAndShiftKeys(int fromIndex, int toIndex, String label) {
        for (int i = toIndex; i >= fromIndex; --i) {
            String oldData = (String)this.remove(i);
            if (oldData == null) continue;
            this.put(i + 1, oldData);
        }
        if (label != null && !label.isEmpty()) {
            this.put(fromIndex, label);
        }
    }

    public void remove(int fromIndex, int toIndex) {
        int diffLength = toIndex - fromIndex;
        for (int i = 0; i < diffLength; ++i) {
            this.remove(toIndex + i);
        }
    }

    public void setAll(StringHashMapList other) {
        this.clear();
        other.forEachEntry(1000L, kv -> {
            String label = (String)kv.getValue();
            if (label != null && !label.isEmpty()) {
                this.put(kv.getKey(), label);
            }
        });
    }
}

