/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.EditableDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.utils.AssertUtils;
import it.unimi.dsi.fastutil.floats.FloatArrayList;

public class FloatDataSet
extends AbstractDataSet<FloatDataSet>
implements EditableDataSet {
    protected FloatArrayList xValues;
    protected FloatArrayList yValues;

    public FloatDataSet(String name) {
        this(name, 0);
    }

    public FloatDataSet(DataSet another) {
        super(another.getName());
        this.set(another);
    }

    public FloatDataSet(String name, int initalSize) {
        super(name);
        AssertUtils.gtEqThanZero("initalSize", initalSize);
        this.xValues = new FloatArrayList(initalSize);
        this.yValues = new FloatArrayList(initalSize);
    }

    public FloatDataSet(String name, float[] xValues, float[] yValues, int initalSize, boolean deepCopy) {
        this(name);
        AssertUtils.notNull("X data", xValues);
        AssertUtils.notNull("Y data", yValues);
        int dataMaxIndex = Math.min(xValues.length, Math.min(yValues.length, initalSize));
        AssertUtils.equalFloatArrays(xValues, yValues, initalSize);
        if (deepCopy) {
            this.xValues = new FloatArrayList(dataMaxIndex);
            this.yValues = new FloatArrayList(dataMaxIndex);
            System.arraycopy(xValues, 0, this.xValues.elements(), 0, Math.min(dataMaxIndex, initalSize));
            System.arraycopy(yValues, 0, this.yValues.elements(), 0, Math.min(dataMaxIndex, initalSize));
        } else {
            this.xValues = FloatArrayList.wrap((float[])xValues);
            this.yValues = FloatArrayList.wrap((float[])yValues);
        }
    }

    @Override
    public double[] getXValues() {
        return FloatDataSet.toDoubles(this.xValues.elements());
    }

    @Override
    public double[] getYValues() {
        return FloatDataSet.toDoubles(this.yValues.elements());
    }

    public float[] getXFloatValues() {
        return this.xValues.elements();
    }

    public float[] getYFloatValues() {
        return this.yValues.elements();
    }

    @Override
    public int getDataCount() {
        return Math.min(this.xValues.size(), this.yValues.size());
    }

    public FloatDataSet clearData() {
        this.lock();
        this.xValues.clear();
        this.yValues.clear();
        this.dataLabels.clear();
        this.dataStyles.clear();
        this.clearMetaInfo();
        this.xRange.empty();
        this.yRange.empty();
        return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this, "clearData()"));
    }

    public int getCapacity() {
        return Math.min(this.xValues.elements().length, this.yValues.elements().length);
    }

    public FloatDataSet increaseCapacity(int amount) {
        this.lock();
        int size = this.getDataCount();
        boolean auto = this.isAutoNotification();
        this.setAutoNotifaction(false);
        this.resize(this.getCapacity() + amount);
        this.resize(size);
        this.setAutoNotifaction(auto);
        return (FloatDataSet)this.unlock();
    }

    public FloatDataSet resize(int size) {
        this.lock();
        this.xValues.size(size);
        this.yValues.size(size);
        return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    public FloatDataSet trim() {
        this.lock();
        this.xValues.trim(0);
        this.yValues.trim(0);
        return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this, "increaseCapacity()"));
    }

    @Override
    public double getX(int index) {
        return this.xValues.elements()[index];
    }

    @Override
    public double getY(int index) {
        return this.yValues.elements()[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatDataSet set(int index, double x, double y) {
        this.lock();
        try {
            int dataCount = Math.max(index + 1, this.getDataCount());
            this.xValues.size(dataCount);
            this.yValues.size(dataCount);
            this.xValues.elements()[index] = (float)x;
            this.yValues.elements()[index] = (float)y;
            this.xRange.empty();
            this.yRange.empty();
        }
        finally {
            this.unlock();
        }
        return (FloatDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FloatDataSet set(int index, double[] x, double[] y) {
        this.lock();
        try {
            this.xValues.size(index + x.length);
            System.arraycopy(x, 0, this.xValues.elements(), index, x.length);
            this.yValues.size(index + y.length);
            System.arraycopy(y, 0, this.yValues.elements(), index, y.length);
            this.xRange.empty();
            this.yRange.empty();
        }
        finally {
            this.unlock();
        }
        return (FloatDataSet)this.fireInvalidated(new UpdatedDataEvent(this));
    }

    public FloatDataSet add(float x, float y) {
        return this.add(this.getDataCount(), x, y, null);
    }

    public FloatDataSet add(float x, float y, String label) {
        this.lock();
        this.xValues.add(x);
        this.yValues.add(y);
        if (label != null && !label.isEmpty()) {
            this.addDataLabel(this.xValues.size() - 1, label);
        }
        this.xRange.add(x);
        this.yRange.add(y);
        return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    @Override
    public FloatDataSet add(int index, double x, double y) {
        return this.add(index, (float)x, (float)y, null);
    }

    public FloatDataSet add(int index, float x, float y, String label) {
        this.lock();
        int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
        this.xValues.add(indexAt, x);
        this.yValues.add(indexAt, y);
        this.dataLabels.addValueAndShiftKeys(indexAt, this.xValues.size(), label);
        this.dataStyles.shiftKeys(indexAt, this.xValues.size());
        this.xRange.add(x);
        this.yRange.add(y);
        return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public FloatDataSet add(int index, float[] x, float[] y) {
        this.lock();
        AssertUtils.notNull("X coordinates", x);
        AssertUtils.notNull("Y coordinates", y);
        int min = Math.min(x.length, y.length);
        AssertUtils.equalFloatArrays(x, y, min);
        int indexAt = Math.max(0, Math.min(index, this.getDataCount() + 1));
        this.xValues.addElements(indexAt, x, 0, min);
        this.yValues.addElements(indexAt, y, 0, min);
        for (int i = 0; i < min; ++i) {
            this.xRange.add(x[i]);
            this.yRange.add(y[i]);
        }
        this.dataLabels.shiftKeys(indexAt, this.xValues.size());
        this.dataStyles.shiftKeys(indexAt, this.xValues.size());
        return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public FloatDataSet remove(int fromIndex, int toIndex) {
        this.lock();
        AssertUtils.indexInBounds(fromIndex, this.getDataCount(), "fromIndex");
        AssertUtils.indexInBounds(toIndex, this.getDataCount(), "toIndex");
        AssertUtils.indexOrder(fromIndex, "fromIndex", toIndex, "toIndex");
        this.xValues.removeElements(fromIndex, toIndex);
        this.yValues.removeElements(fromIndex, toIndex);
        this.dataLabels.remove(fromIndex, toIndex);
        this.dataLabels.remove(fromIndex, toIndex);
        this.xRange.empty();
        this.yRange.empty();
        return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new RemovedDataEvent(this));
    }

    @Override
    public EditableDataSet remove(int index) {
        return this.remove(index, index + 1);
    }

    public FloatDataSet add(float[] xValuesNew, float[] yValuesNew) {
        int i;
        this.lock();
        AssertUtils.notNull("X coordinates", xValuesNew);
        AssertUtils.notNull("Y coordinates", yValuesNew);
        AssertUtils.equalFloatArrays(xValuesNew, yValuesNew);
        this.xValues.addElements(this.xValues.size(), xValuesNew);
        this.yValues.addElements(this.yValues.size(), yValuesNew);
        for (i = 0; i < xValuesNew.length; ++i) {
            this.xRange.add(xValuesNew[i]);
        }
        for (i = 0; i < yValuesNew.length; ++i) {
            this.yRange.add(yValuesNew[i]);
        }
        return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new AddedDataEvent(this));
    }

    public FloatDataSet set(float[] xValues, float[] yValues, boolean copy) {
        this.lock();
        AssertUtils.notNull("X coordinates", xValues);
        AssertUtils.notNull("Y coordinates", yValues);
        AssertUtils.equalFloatArrays(xValues, yValues);
        if (!copy) {
            this.dataLabels.clear();
            this.dataStyles.clear();
            this.xValues = FloatArrayList.wrap((float[])xValues);
            this.yValues = FloatArrayList.wrap((float[])yValues);
            this.computeLimits();
            return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
        }
        this.xValues.size(0);
        this.xValues.addElements(0, xValues);
        this.yValues.size(0);
        this.yValues.addElements(0, yValues);
        this.computeLimits();
        return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public FloatDataSet set(float[] xValues, float[] yValues) {
        return this.set(xValues, yValues, true);
    }

    public FloatDataSet set(DataSet other) {
        int index;
        this.lock();
        other.lock();
        boolean oldAuto = this.isAutoNotification();
        this.setAutoNotifaction(false);
        this.dataLabels.clear();
        for (index = 0; index < other.getDataCount(); ++index) {
            String label = other.getDataLabel(index);
            if (label == null || label.isEmpty()) continue;
            this.addDataLabel(index, label);
        }
        this.dataStyles.clear();
        for (index = 0; index < other.getDataCount(); ++index) {
            String style = other.getStyle(index);
            if (style == null || style.isEmpty()) continue;
            this.addDataStyle(index, style);
        }
        this.setStyle(other.getStyle());
        this.set(FloatDataSet.toFloats(other.getXValues()), FloatDataSet.toFloats(other.getYValues()), true);
        this.setAutoNotifaction(oldAuto);
        other.unlock();
        return (FloatDataSet)((FloatDataSet)this.unlock()).fireInvalidated(new UpdatedDataEvent(this));
    }

    public static float[] toFloats(double[] input) {
        float[] floatArray = new float[input.length];
        for (int i = 0; i < input.length; ++i) {
            floatArray[i] = (float)input[i];
        }
        return floatArray;
    }

    public static double[] toDoubles(float[] input) {
        double[] doubleArray = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            doubleArray[i] = input[i];
        }
        return doubleArray;
    }
}

