/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.event.RemovedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet3D;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public class DoubleDataSet3D
extends AbstractDataSet3D<DoubleDataSet3D> {
    private double[] xValues;
    private double[] yValues;
    private double[][] zValues;

    public DoubleDataSet3D(String name) {
        super(name);
        this.xValues = new double[0];
        this.yValues = new double[0];
        this.zValues = new double[0][0];
    }

    public DoubleDataSet3D(String name, int dimX, int dimY) {
        super(name);
        this.zValues = new double[dimY][dimX];
        this.yValues = new double[this.zValues.length];
        for (int y = 0; y < this.yValues.length; ++y) {
            this.yValues[y] = y;
        }
        if (this.yValues.length > 0) {
            this.xValues = new double[this.zValues[0].length];
            for (int x = 0; x < this.xValues.length; ++x) {
                this.xValues[x] = x;
            }
        } else {
            this.xValues = new double[0];
        }
    }

    public DoubleDataSet3D(String name, double[][] zValues) {
        super(name);
        this.yValues = new double[zValues.length];
        for (int y = 0; y < this.yValues.length; ++y) {
            this.yValues[y] = y;
        }
        if (this.yValues.length > 0) {
            this.xValues = new double[zValues[0].length];
            for (int x = 0; x < this.xValues.length; ++x) {
                this.xValues[x] = x;
            }
        } else {
            this.xValues = new double[0];
        }
        this.zValues = zValues;
    }

    public DoubleDataSet3D(String name, double[] xValues, double[] yValues, double[][] zValues) {
        super(name);
        DoubleDataSet3D.checkDimensionConsistency(xValues, yValues, zValues);
        this.xValues = xValues;
        this.yValues = yValues;
        this.zValues = zValues;
    }

    public void set(double[] xValues, double[] yValues, double[][] zValues) {
        DoubleDataSet3D.checkDimensionConsistency(xValues, yValues, zValues);
        this.xValues = xValues;
        this.yValues = yValues;
        this.zValues = zValues;
    }

    private static void checkDimensionConsistency(double[] xValues, double[] yValues, double[][] zValues) {
        if (xValues == null) {
            throw new IllegalArgumentException("xValues array is null");
        }
        if (xValues.length == 0) {
            throw new IllegalArgumentException("xValues array length is '0'");
        }
        if (yValues == null) {
            throw new IllegalArgumentException("yValues array is null");
        }
        if (yValues.length == 0) {
            throw new IllegalArgumentException("yValues array length is '0'");
        }
        if (zValues == null) {
            throw new IllegalArgumentException("zValues array is null");
        }
        if (zValues.length == 0) {
            throw new IllegalArgumentException("zValues array length is '0'");
        }
        if (zValues.length != yValues.length) {
            String msg = String.format("array dimension mismatch: zValues.length = %d != yValues.length = %d", zValues.length, yValues.length);
            throw new IllegalArgumentException(msg);
        }
        if (zValues[0].length != xValues.length) {
            String msg = String.format("array dimension mismatch: zValues[0].length = %d != xValues.length = %d", zValues.length, xValues.length);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public double getZ(int xIndex, int yIndex) {
        return this.zValues[yIndex][xIndex];
    }

    protected static void fillArray(double[] array, int indexStart, int indexStop, double value) {
        AssertUtils.notNull("array", array);
        int len = indexStop - indexStart;
        if (len > 0) {
            array[indexStart] = value;
        }
        for (int i = 1; i < len; i += i) {
            System.arraycopy(array, indexStart, array, i, len - i < i ? len - i : i);
        }
    }

    public DoubleDataSet3D clearData() {
        this.lock();
        for (int i = 0; i < this.zValues.length; ++i) {
            DoubleDataSet3D.fillArray(this.zValues[i], 0, this.zValues[i].length, 0.0);
        }
        this.unlock();
        this.fireInvalidated(new RemovedDataEvent(this, "clearData()"));
        return this;
    }

    @Override
    public void set(int xIndex, int yIndex, double x, double y, double z) {
        this.xValues[xIndex] = x;
        this.yValues[yIndex] = y;
        this.zValues[yIndex][xIndex] = z;
    }

    public void setX(int xIndex, double x) {
        this.xValues[xIndex] = x;
    }

    public void setY(int yIndex, double y) {
        this.yValues[yIndex] = y;
    }

    public void set(int xIndex, int yIndex, double z) {
        this.zValues[yIndex][xIndex] = z;
    }

    @Override
    public int getXDataCount() {
        return this.xValues.length;
    }

    @Override
    public int getYDataCount() {
        return this.yValues.length;
    }

    @Override
    public double getX(int i) {
        return this.xValues[i];
    }

    @Override
    public double[] getXValues() {
        return Arrays.copyOf(this.xValues, this.xValues.length);
    }

    @Override
    public double getY(int i) {
        return this.yValues[i];
    }

    @Override
    public double[] getYValues() {
        return Arrays.copyOf(this.yValues, this.yValues.length);
    }

    @Override
    public String getStyle(int index) {
        return null;
    }

    public double[][] getZValues() {
        return this.zValues;
    }
}

