/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger logger = LoggerFactory.getLogger(StreamUtils.class);
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String ZIP_PREFIX = "zip:";

    public static InputStream getInputStream(String source) throws FileNotFoundException {
        InputStream is;
        block12: {
            if (source.startsWith(CLASSPATH_PREFIX)) {
                String resource = source.substring(CLASSPATH_PREFIX.length());
                is = StreamUtils.class.getClassLoader().getResourceAsStream(resource);
            } else {
                if (source.startsWith(ZIP_PREFIX)) {
                    int zipSuffixIdx;
                    String resource = source.substring(ZIP_PREFIX.length());
                    String resourceInZip = resource.substring(zipSuffixIdx = resource.toLowerCase().indexOf(".zip") + 4);
                    if (resourceInZip.startsWith("/")) {
                        resourceInZip = resourceInZip.substring(1);
                    }
                    resource = resource.substring(0, zipSuffixIdx);
                    try (ZipFile zipFile = new ZipFile(resource);){
                        is = zipFile.getInputStream(zipFile.getEntry(resourceInZip));
                        break block12;
                    }
                    catch (IOException e) {
                        throw new FileNotFoundException("Zip resource not found for " + source + " IOException=" + e.getMessage());
                    }
                }
                is = new FileInputStream(new File(source));
            }
        }
        if (is == null) {
            logger.error("The resource is not found: " + source);
        }
        return is;
    }
}

