/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.GridDataSet;
import de.gsi.dataset.event.AddedDataEvent;
import de.gsi.dataset.event.EventListener;
import de.gsi.dataset.event.UpdateEvent;
import de.gsi.dataset.spi.DoubleDataSet;

public class DimReductionDataSet
extends DoubleDataSet
implements EventListener {
    private static final long serialVersionUID = 1L;
    private final Option reductionOption;
    private final GridDataSet source;
    private final int dimIndex;
    private int minIndex;
    private int maxIndex;
    private double minValue;
    private double maxValue;

    public DimReductionDataSet(GridDataSet source, int dimIndex, Option reductionOption) {
        super(source.getName() + "-" + reductionOption + "-dim" + dimIndex);
        this.source = source;
        this.dimIndex = dimIndex;
        this.reductionOption = reductionOption;
        this.source.addListener(this);
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public Option getReductionOption() {
        return this.reductionOption;
    }

    public DataSet getSourceDataSet() {
        return this.source;
    }

    @Override
    public void handle(UpdateEvent event) {
        this.lock().writeLockGuard(() -> this.source.lock().readLockGuard(() -> {
            this.getWarningList().clear();
            if (this.source instanceof DataSetMetaData) {
                this.getWarningList().addAll(((DataSetMetaData)((Object)this.source)).getWarningList());
            }
            if (this.source.getDimension() != 3 || this.source.getNGrid() != 2) {
                this.getWarningList().add("input data set not 3 dim grid data set");
                return;
            }
            boolean oldValue = this.source.autoNotification().getAndSet(false);
            this.minIndex = this.source.getGridIndex(this.dimIndex == 0 ? 1 : 0, this.minValue);
            this.maxIndex = this.source.getGridIndex(this.dimIndex == 0 ? 1 : 0, this.maxValue);
            this.source.autoNotification().set(oldValue);
            switch (this.reductionOption) {
                case MIN: {
                    this.updateMinMax(true);
                    break;
                }
                case MAX: {
                    this.updateMinMax(false);
                    break;
                }
                case MEAN: {
                    this.updateMeanIntegral(true);
                    break;
                }
                case INTEGRAL: {
                    this.updateMeanIntegral(false);
                    break;
                }
                default: {
                    this.updateSlice();
                }
            }
        }));
        this.fireInvalidated(new AddedDataEvent(this, "updated " + DimReductionDataSet.class.getSimpleName() + " name = " + this.getName()));
    }

    public void setMaxValue(double val) {
        this.lock().writeLockGuard(() -> {
            this.maxValue = val;
            return this.maxValue;
        });
        this.handle(new UpdateEvent(this, "changed indexMax"));
    }

    public void setMinValue(double val) {
        this.lock().writeLockGuard(() -> {
            this.minValue = val;
            return this.minValue;
        });
        this.handle(new UpdateEvent(this, "changed indexMin"));
    }

    public void setRange(double min, double max) {
        this.lock().writeLockGuard(() -> {
            this.minValue = min;
            this.maxValue = max;
        });
        this.handle(new UpdateEvent(this, "changed indexMin indexMax"));
    }

    protected void updateMeanIntegral(boolean isMean) {
        int min = Math.min(this.minIndex, this.maxIndex);
        int max = Math.max(Math.max(this.minIndex, this.maxIndex), min + 1);
        this.clearData();
        int nDataCount = this.source.getShape(this.dimIndex);
        for (int index = 0; index < nDataCount; ++index) {
            double x = this.source.getGrid(this.dimIndex, index);
            double integral = 0.0;
            double nSlices = 0.0;
            for (int i = min; i <= Math.min(max, nDataCount - 1); ++i) {
                integral = this.dimIndex == 1 ? (integral += this.source.get(2, i, index)) : (integral += this.source.get(2, index, i));
                nSlices += 1.0;
            }
            if (isMean) {
                this.add(x, nSlices == 0.0 ? Double.NaN : integral / nSlices);
                continue;
            }
            this.add(x, integral);
        }
    }

    protected void updateMinMax(boolean isMin) {
        int min = Math.min(this.minIndex, this.maxIndex);
        int max = Math.max(Math.max(this.minIndex, this.maxIndex), min + 1);
        this.clearData();
        int nDataCount = this.source.getShape(this.dimIndex);
        for (int index = 0; index < nDataCount; ++index) {
            double x = this.source.get(this.dimIndex, index);
            double ret = this.dimIndex == 1 ? this.source.get(2, min, index) : this.source.get(2, index, min);
            for (int i = min + 1; i <= Math.min(max, nDataCount - 1); ++i) {
                double val = this.dimIndex == 1 ? this.source.get(2, i, index) : this.source.get(2, index, i);
                ret = isMin ? Math.min(val, ret) : Math.max(val, ret);
            }
            this.add(x, ret);
        }
    }

    protected void updateSlice() {
        this.clearData();
        int nDataCount = this.source.getShape(this.dimIndex);
        for (int index = 0; index < nDataCount; ++index) {
            double x = this.source.getGrid(this.dimIndex, index);
            double y = this.dimIndex == 1 ? this.source.get(2, this.minIndex, index) : this.source.get(2, index, this.minIndex);
            this.add(x, y);
        }
    }

    public static enum Option {
        MIN,
        MEAN,
        MAX,
        INTEGRAL,
        SLICE;

    }
}

