/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.spi;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.Histogram;
import de.gsi.dataset.event.UpdatedDataEvent;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DataRange;
import de.gsi.dataset.utils.AssertUtils;
import java.util.Arrays;

public abstract class AbstractHistogram
extends AbstractDataSet<AbstractHistogram>
implements Histogram {
    private static final long serialVersionUID = -6455271782865323112L;
    protected final double[] data;
    protected final double[][] axisBins;
    private final boolean equidistant;
    private final HistogramOuterBounds boundsType;

    public AbstractHistogram(String name, double[] xBins) {
        super(name, 2);
        this.equidistant = false;
        this.boundsType = HistogramOuterBounds.BINS_ALIGNED_WITH_BOUNDARY;
        int nBins = xBins.length - 1;
        int nAxisBins = nBins + 2;
        this.data = new double[nAxisBins];
        this.axisBins = new double[][]{new double[nAxisBins], new double[0]};
        this.axisBins[0][0] = -1.7976931348623157E308;
        this.axisBins[0][nAxisBins - 1] = Double.MAX_VALUE;
        double[] xBinsSorted = Arrays.copyOf(xBins, xBins.length);
        Arrays.sort(xBinsSorted);
        System.arraycopy(xBinsSorted, 0, this.axisBins[0], 1, xBinsSorted.length);
        this.getAxisDescription(0).set(this.axisBins[0][1], this.axisBins[0][nBins + 1]);
        this.getAxisDescription(1).clear();
    }

    public AbstractHistogram(String name, int nBins, double minX, double maxX, HistogramOuterBounds boundsType) {
        super(name, 2);
        this.equidistant = true;
        this.boundsType = boundsType;
        int nAxisBins = nBins + 2;
        this.data = new double[nAxisBins];
        this.axisBins = new double[][]{new double[nAxisBins], new double[0]};
        this.fillEquidistantAxisBinning(this.axisBins[0], minX, maxX, this.boundsType);
        this.getAxisDescription(0).set(this.axisBins[0][1], this.axisBins[0][nAxisBins - 1]);
        this.getAxisDescription(1).clear();
    }

    protected void fillEquidistantAxisBinning(double[] bins, double min, double max, HistogramOuterBounds boundsType) {
        double halfBinShift = boundsType == HistogramOuterBounds.BINS_ALIGNED_WITH_BOUNDARY ? 0.0 : (max - min) / (double)((bins.length - 3) * 2);
        double binDelta = (max - min + 2.0 * halfBinShift) / (double)(bins.length - 2);
        double binMin = min - halfBinShift;
        bins[0] = -1.7976931348623157E308;
        bins[bins.length - 1] = Double.MAX_VALUE;
        for (int i = 0; i < bins.length - 1; ++i) {
            bins[i + 1] = binMin + binDelta * (double)i;
        }
    }

    public AbstractHistogram(String name, int nBinsX, double minX, double maxX, int nBinsY, double minY, double maxY, HistogramOuterBounds boundsType) {
        super(name, 3);
        this.equidistant = true;
        this.boundsType = boundsType;
        int nAxisBinsX = nBinsX + 2;
        int nAxisBinsY = nBinsY + 2;
        this.axisBins = new double[][]{new double[nAxisBinsX], new double[nAxisBinsY], new double[0]};
        this.fillEquidistantAxisBinning(this.axisBins[0], minX, maxX, this.boundsType);
        this.fillEquidistantAxisBinning(this.axisBins[1], minY, maxY, this.boundsType);
        this.data = new double[nAxisBinsX * nAxisBinsY];
        this.getAxisDescription(0).set(this.axisBins[0][1], this.axisBins[0][nAxisBinsX - 1]);
        this.getAxisDescription(1).set(this.axisBins[1][1], this.axisBins[1][nAxisBinsY - 1]);
        this.getAxisDescription(2).clear();
    }

    @Override
    public void addBinContent(int bin) {
        this.addBinContent(bin, 1.0);
    }

    @Override
    public void addBinContent(int bin, double w) {
        this.lock().writeLockGuard(() -> {
            this.data[bin] = this.data[bin] + w;
            this.getAxisDescription(this.getDimension() - 1).add(this.data[bin]);
        });
        this.fireInvalidated(new UpdatedDataEvent(this, "addBinContent()"));
    }

    @Override
    public int findBin(double x, double y) {
        int indexX = this.findBin(0, x);
        int indexY = this.findBin(1, y);
        return this.getDataCount() * indexY + indexX;
    }

    @Override
    public int findBin(double x, double y, double z) {
        int indexX = this.findBin(0, x);
        int indexY = this.findBin(1, y);
        int indexZ = this.findBin(2, z);
        return this.getDataCount() * (indexY + this.getDataCount() * indexZ) + indexX;
    }

    @Override
    public int findBin(int dimIndex, double val) {
        if (this.getAxisDescription(dimIndex).getLength() == 0.0) {
            return 0;
        }
        if (!this.getAxisDescription(dimIndex).contains(val)) {
            if (val < this.axisBins[dimIndex][1]) {
                return 0;
            }
            return this.axisBins[dimIndex].length - 1;
        }
        return this.findNextLargerIndex(this.axisBins[dimIndex], val);
    }

    protected int findNextLargerIndex(double[] bin, double value) {
        for (int i = 1; i < bin.length; ++i) {
            if (!(value < bin[i])) continue;
            return i - 1;
        }
        return bin.length - 1;
    }

    @Override
    public double getBinCenter(int dimIndex, int binIndex) {
        if (this.getAxisDescription(dimIndex).getLength() == 0.0) {
            return this.axisBins[dimIndex][1];
        }
        if (binIndex == 0 || binIndex == this.axisBins[dimIndex].length - 1) {
            return Double.NaN;
        }
        return 0.5 * (this.getBinLimits(dimIndex, Histogram.Boundary.LOWER, binIndex) + this.getBinLimits(dimIndex, Histogram.Boundary.UPPER, binIndex));
    }

    @Override
    public int getBinCount(int dimIndex) {
        return this.axisBins[dimIndex].length;
    }

    @Override
    public double getBinContent(int bin) {
        return this.data[bin];
    }

    @Override
    public int getDataCount() {
        return Math.max(this.axisBins[0].length, this.axisBins[1].length) - 2;
    }

    @Override
    public boolean isEquiDistant() {
        return this.equidistant;
    }

    @Override
    public DataSet recomputeLimits(int dimIndex) {
        if (dimIndex < this.getDimension()) {
            return this;
        }
        DataRange newRange = new DataRange();
        int dataCount = this.getDataCount();
        for (int i = 0; i < dataCount; ++i) {
            newRange.add(this.getBinContent(i + 1));
        }
        this.getAxisDescription(dimIndex).set(newRange.getMin(), newRange.getMax());
        return this;
    }

    @Override
    public double getBinLimits(int dimIndex, Histogram.Boundary boundary, int binIndex) {
        if (binIndex <= 0 && boundary == Histogram.Boundary.LOWER) {
            return Double.NEGATIVE_INFINITY;
        }
        if (binIndex >= this.axisBins[dimIndex].length - 1 && boundary == Histogram.Boundary.UPPER) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.getAxisDescription(dimIndex).getLength() == 0.0) {
            return this.axisBins[dimIndex][1];
        }
        return boundary == Histogram.Boundary.UPPER ? this.axisBins[dimIndex][binIndex + 1] : this.axisBins[dimIndex][binIndex];
    }

    public HistogramOuterBounds getBoundsType() {
        return this.boundsType;
    }

    @Override
    public double getValue(int dimIndex, double ... x) {
        int nDim = this.getDimension() - 1;
        AssertUtils.checkArrayDimension("x", x, nDim);
        switch (nDim) {
            case 3: {
                return this.getBinContent(this.findBin(x[0], x[1], x[2]));
            }
            case 2: {
                return this.getBinContent(this.findBin(x[0], x[1]));
            }
        }
        return this.getBinContent(this.findBin(0, x[0]));
    }

    @Override
    public void reset() {
        Arrays.fill(this.data, 0.0);
        this.getDataStyleMap().clear();
        this.getDataLabelMap().clear();
        this.getAxisDescription(this.getDimension() - 1).clear();
    }

    protected static <T> void swap(T[] arr, int i, int j) {
        T t = arr[i];
        arr[i] = arr[j];
        arr[j] = t;
    }

    public static enum HistogramOuterBounds {
        BINS_CENTERED_ON_BOUNDARY,
        BINS_ALIGNED_WITH_BOUNDARY;

    }
}

