/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.dataset.utils;

import de.gsi.dataset.utils.CacheCollection;
import java.lang.ref.Reference;
import java.util.List;

public class DoubleArrayCache
extends CacheCollection<double[]> {
    private static final DoubleArrayCache SELF = new DoubleArrayCache();

    public double[] getArray(int requiredSize) {
        return this.getArray(requiredSize, false);
    }

    public double[] getArrayExact(int requiredSize) {
        return this.getArray(requiredSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getArray(int requiredSize, boolean exact) {
        List list = this.contents;
        synchronized (list) {
            double[] bestFit = null;
            int bestFitSize = Integer.MAX_VALUE;
            for (Reference candidate : this.contents) {
                double[] localRef = (double[])candidate.get();
                if (localRef == null) continue;
                int sizeDiff = localRef.length - requiredSize;
                if (sizeDiff == 0) {
                    bestFit = localRef;
                    break;
                }
                if (sizeDiff <= 0 || sizeDiff >= bestFitSize || exact) continue;
                bestFitSize = sizeDiff;
                bestFit = localRef;
            }
            if (bestFit == null) {
                bestFit = new double[requiredSize];
                return bestFit;
            }
            this.remove(bestFit);
            return bestFit;
        }
    }

    public static DoubleArrayCache getInstance() {
        return SELF;
    }
}

